/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.PrettyPrint;
import edu.jas.poly.ExpVector;
import edu.jas.poly.ExpVectorPair;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TableRelation;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RingElem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class RelationTable<C extends RingElem<C>>
implements Serializable {
    public final Map<List<Integer>, List> table;
    public final GenSolvablePolynomialRing<C> ring;
    public final boolean coeffTable;
    private static final Logger logger = Logger.getLogger(RelationTable.class);
    private final boolean debug = logger.isDebugEnabled();

    public RelationTable(GenSolvablePolynomialRing<C> r) {
        this(r, false);
    }

    public RelationTable(GenSolvablePolynomialRing<C> r, boolean coeffTable) {
        this.table = new HashMap<List<Integer>, List>();
        this.ring = r;
        if (this.ring == null) {
            throw new IllegalArgumentException("RelationTable no ring");
        }
        this.coeffTable = coeffTable;
    }

    public boolean equals(Object p) {
        if (p == null) {
            return false;
        }
        if (!(p instanceof RelationTable)) {
            logger.info((Object)"no RelationTable");
            return false;
        }
        RelationTable tab = (RelationTable)p;
        if (!this.table.keySet().equals(tab.table.keySet())) {
            logger.info((Object)("keySet != :  a = " + this.table.keySet() + ", b = " + tab.table.keySet()));
            return false;
        }
        for (List<Integer> k : this.table.keySet()) {
            Map<ExpVectorPair, GenPolynomial<C>> t2ex;
            List a = this.table.get(k);
            List b = tab.table.get(k);
            Map<ExpVectorPair, GenPolynomial<C>> t1ex = this.fromListDeg2(a);
            if (this.equalMaps(t1ex, t2ex = this.fromListDeg2(b))) continue;
            return false;
        }
        return true;
    }

    Map<ExpVectorPair, GenPolynomial<C>> fromListDeg2(List a) {
        HashMap<ExpVectorPair, GenPolynomial<C>> tex = new HashMap<ExpVectorPair, GenPolynomial<C>>();
        Iterator ait = a.iterator();
        while (ait.hasNext()) {
            ExpVectorPair ae = (ExpVectorPair)ait.next();
            if (!ait.hasNext()) break;
            GenPolynomial p = (GenPolynomial)ait.next();
            if (ae.totalDeg() != 2L) continue;
            tex.put(ae, p);
        }
        return tex;
    }

    boolean equalMaps(Map<ExpVectorPair, GenPolynomial<C>> m1, Map<ExpVectorPair, GenPolynomial<C>> m2) {
        if (!m1.keySet().equals(m2.keySet())) {
            return false;
        }
        for (Map.Entry<ExpVectorPair, GenPolynomial<C>> me : m1.entrySet()) {
            ExpVectorPair ep;
            GenPolynomial<C> p2;
            GenPolynomial<C> p1 = me.getValue();
            if (p1.compareTo(p2 = m2.get(ep = me.getKey())) == 0) continue;
            logger.info((Object)("ep = " + ep + ", p1 = " + p1 + ", p2 = " + p2));
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = this.ring.hashCode();
        h = 31 * h + this.table.hashCode();
        return h;
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public String toString() {
        StringBuffer s = new StringBuffer("RelationTable[");
        boolean first = true;
        for (List<Integer> k : this.table.keySet()) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            s.append(k.toString());
            List v = this.table.get(k);
            s.append("=");
            s.append(v.toString());
        }
        s.append("]");
        return s.toString();
    }

    public String toString(String[] vars) {
        if (vars == null) {
            return this.toString();
        }
        StringBuffer s = new StringBuffer("");
        String[] cvars = null;
        if (this.coeffTable) {
            if (this.ring.coFac instanceof GenPolynomialRing) {
                cvars = ((GenPolynomialRing)this.ring.coFac).getVars();
            }
            s.append("Coefficient ");
        }
        s.append("RelationTable\n(");
        if (PrettyPrint.isTrue()) {
            boolean first = true;
            for (List<Integer> k : this.table.keySet()) {
                if (first) {
                    first = false;
                    s.append("\n");
                } else {
                    s.append(",\n");
                }
                List v = this.table.get(k);
                Iterator jt = v.iterator();
                while (jt.hasNext()) {
                    ExpVectorPair ep = (ExpVectorPair)jt.next();
                    GenSolvablePolynomial p = (GenSolvablePolynomial)jt.next();
                    if (ep.totalDeg() != 2L) continue;
                    s.append("( " + ep.getFirst().toString(vars) + " ), ");
                    if (cvars == null) {
                        s.append("( " + ep.getSecond().toString(vars) + " ), ");
                    } else {
                        s.append("( " + ep.getSecond().toString(cvars) + " ), ");
                    }
                    s.append("( " + p.toString(vars) + " )");
                    if (!jt.hasNext()) continue;
                    s.append(",\n");
                }
            }
        } else {
            boolean first = true;
            for (List<Integer> k : this.table.keySet()) {
                if (first) {
                    first = false;
                } else {
                    s.append(",\n");
                }
                List v = this.table.get(k);
                Iterator jt = v.iterator();
                while (jt.hasNext()) {
                    ExpVectorPair ep = (ExpVectorPair)jt.next();
                    s.append("( " + ep.getFirst().toString(vars) + " ), ");
                    if (cvars == null) {
                        s.append("( " + ep.getSecond().toString(vars) + " ), ");
                    } else {
                        s.append("( " + ep.getSecond().toString(cvars) + " ), ");
                    }
                    GenSolvablePolynomial p = (GenSolvablePolynomial)jt.next();
                    s.append(" " + p.toString(vars));
                    if (!jt.hasNext()) continue;
                    s.append(",\n");
                }
            }
        }
        s.append("\n)\n");
        return s.toString();
    }

    public String toScript() {
        String[] vars = this.ring.vars;
        String[] cvars = null;
        if (this.coeffTable) {
            cvars = ((GenPolynomialRing)this.ring.coFac).vars;
        }
        StringBuffer s = new StringBuffer("[");
        boolean first = true;
        for (List<Integer> k : this.table.keySet()) {
            if (first) {
                first = false;
                s.append("");
            } else {
                s.append(", ");
            }
            List v = this.table.get(k);
            Iterator jt = v.iterator();
            while (jt.hasNext()) {
                ExpVectorPair ep = (ExpVectorPair)jt.next();
                GenPolynomial p = (GenPolynomial)jt.next();
                if (ep.totalDeg() != 2L) continue;
                s.append("" + ep.getFirst().toScript(vars) + ", ");
                if (this.coeffTable) {
                    s.append("" + ep.getSecond().toScript(cvars) + ", ");
                } else {
                    s.append("" + ep.getSecond().toScript(vars) + ", ");
                }
                s.append(" " + p.toScript());
                if (!jt.hasNext()) continue;
                s.append(", ");
            }
        }
        s.append("]");
        return s.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update(ExpVector e, ExpVector f, GenSolvablePolynomial<C> p) {
        LinkedList<Serializable> part;
        if (this.debug) {
            if (p != null && p.ring.vars != null) {
                logger.info((Object)("new relation = " + e.toString(p.ring.vars) + " .*. " + f.toString(p.ring.vars) + " = " + p));
            } else {
                logger.info((Object)("new relation = " + e + " .*. " + f + " = " + p));
            }
        }
        if (p == null || e == null || f == null) {
            throw new IllegalArgumentException("RelationTable update e|f|p == null");
        }
        if (this.debug && e.totalDeg() == 1L && f.totalDeg() == 1L) {
            int[] de = e.dependencyOnVariables();
            int[] df = f.dependencyOnVariables();
            logger.debug((Object)("update e ? f " + de[0] + " " + df[0]));
            if (de[0] == df[0]) {
                throw new IllegalArgumentException("RelationTable update e==f");
            }
            if (de[0] > df[0]) {
                logger.error((Object)("warning: update e > f " + e + " " + f + " changed"));
                ExpVector tmp = e;
                e = f;
                f = tmp;
                Map.Entry m = p.leadingMonomial();
                AbelianGroupElem<GenPolynomial<RingElem>> r = p.subtract((RingElem)m.getValue(), m.getKey());
                r = ((GenPolynomial)r).negate();
                p = (GenSolvablePolynomial)((GenPolynomial)r).sum((GenPolynomial<RingElem>)((RingElem)m.getValue()), m.getKey());
            }
        }
        if (!this.coeffTable) {
            ExpVector lp;
            ExpVector ef = e.sum(f);
            if (!ef.equals(lp = p.leadingExpVector())) {
                logger.error((Object)("relation term order = " + this.ring.tord));
                throw new IllegalArgumentException("RelationTable update e*f != lt(p): " + ef + ", lp = " + lp);
            }
        } else {
            ExpVector lp = p.leadingExpVector();
            if (!e.equals(lp)) {
                logger.error((Object)("relation term order = " + this.ring.tord));
                throw new IllegalArgumentException("Coefficient RelationTable update e != lt(p): " + e + ", lp = " + lp);
            }
            if (p.leadingBaseCoefficient() instanceof GenPolynomial && !f.equals(lp = ((GenPolynomial)p.leadingBaseCoefficient()).leadingExpVector())) {
                logger.error((Object)("relation term order = " + this.ring.tord));
                logger.error((Object)("Coefficient RelationTable update f != lt(lfcd(p)): " + e + ", f = " + f + ", p = " + p));
                throw new IllegalArgumentException("Coefficient RelationTable update f != lt(lfcd(p)): " + e + ", f = " + f + ", p = " + p);
            }
        }
        List<Integer> key = this.makeKey(e, f);
        ExpVectorPair evp = new ExpVectorPair(e, f);
        if (key.size() != 2) {
            logger.warn((Object)("key = " + key + ", evp = " + evp));
        }
        if ((part = this.table.get(key)) == null) {
            part = new LinkedList<Serializable>();
            part.add(evp);
            part.add(p);
            this.table.put(key, part);
            return;
        }
        int index = -1;
        LinkedList<Serializable> linkedList = part;
        synchronized (linkedList) {
            ListIterator it = part.listIterator();
            while (it.hasNext()) {
                ExpVectorPair look = (ExpVectorPair)it.next();
                Object skip = it.next();
                if (!look.isMultiple(evp)) continue;
                index = it.nextIndex();
            }
            if (index < 0) {
                index = 0;
            }
            part.add(index, evp);
            part.add(index + 1, p);
        }
    }

    public void update(GenPolynomial<C> E2, GenPolynomial<C> F2, GenSolvablePolynomial<C> p) {
        if (E2.isZERO() || F2.isZERO()) {
            throw new IllegalArgumentException("polynomials may not be zero: " + E2 + ", " + F2);
        }
        C ce = E2.leadingBaseCoefficient();
        C cf = F2.leadingBaseCoefficient();
        if (!ce.isONE()) {
            throw new IllegalArgumentException("lbcf of polynomials must be one: " + ce + ", " + cf + ", p = " + p);
        }
        ExpVector e = E2.leadingExpVector();
        ExpVector f = F2.leadingExpVector();
        if (this.coeffTable && f.isZERO() && cf instanceof GenPolynomial) {
            f = ((GenPolynomial)cf).leadingExpVector();
        }
        this.update(e, f, p);
    }

    public void update(GenPolynomial<C> E2, GenPolynomial<C> F2, GenPolynomial<C> p) {
        if (p.isZERO()) {
            throw new IllegalArgumentException("polynomial may not be zero: " + p);
        }
        if (p.isONE()) {
            throw new IllegalArgumentException("product of polynomials may not be one: " + p);
        }
        GenSolvablePolynomial<C> sp = new GenSolvablePolynomial<C>(this.ring, p.val);
        this.update(E2, F2, sp);
    }

    public void update(ExpVector e, ExpVector f, GenPolynomial<C> p) {
        if (p.isZERO()) {
            throw new IllegalArgumentException("polynomial may not be zero: " + p);
        }
        if (p.isONE()) {
            throw new IllegalArgumentException("product of polynomials may not be one: " + p);
        }
        GenSolvablePolynomial<C> sp = new GenSolvablePolynomial<C>(this.ring, p.val);
        this.update(e, f, sp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableRelation<C> lookup(ExpVector e, ExpVector f) {
        List<Integer> key = this.makeKey(e, f);
        List part = this.table.get(key);
        if (part == null) {
            GenSolvablePolynomial<Object> p = null;
            if (!this.coeffTable) {
                ExpVector ef = e.sum(f);
                p = new GenSolvablePolynomial<C>(this.ring, this.ring.getONECoefficient(), ef);
            } else if (this.ring.coFac instanceof GenPolynomialRing) {
                GenPolynomialRing cofac = (GenPolynomialRing)this.ring.coFac;
                GenPolynomial pc = ((GenPolynomial)cofac.getZERO()).sum(cofac.getONECoefficient(), f);
                RingElem c = pc;
                p = new GenSolvablePolynomial<RingElem>(this.ring, c, e);
            }
            return new TableRelation(null, null, p);
        }
        ExpVectorPair evp = new ExpVectorPair(e, f);
        ExpVector ep = null;
        ExpVector fp = null;
        ExpVectorPair look = null;
        GenSolvablePolynomial p = null;
        List list = part;
        synchronized (list) {
            Iterator it = part.iterator();
            while (it.hasNext()) {
                look = (ExpVectorPair)it.next();
                p = (GenSolvablePolynomial)it.next();
                if (!evp.isMultiple(look)) continue;
                ep = e.subtract(look.getFirst());
                fp = f.subtract(look.getSecond());
                if (ep.isZERO()) {
                    ep = null;
                }
                if (fp.isZERO()) {
                    fp = null;
                }
                if (this.debug) {
                    if (p != null && p.ring.vars != null) {
                        logger.info((Object)("found relation = " + e.toString(p.ring.vars) + " .*. " + f.toString(p.ring.vars) + " = " + p));
                    } else {
                        logger.info((Object)("found relation = " + e + " .*. " + f + " = " + p));
                    }
                }
                return new TableRelation(ep, fp, p);
            }
        }
        throw new RuntimeException("no entry found in relation table for " + evp);
    }

    protected List<Integer> makeKey(ExpVector e, ExpVector f) {
        int i;
        int[] de = e.dependencyOnVariables();
        int[] df = f.dependencyOnVariables();
        ArrayList<Integer> key = new ArrayList<Integer>(de.length + df.length);
        for (i = 0; i < de.length; ++i) {
            key.add(de[i]);
        }
        for (i = 0; i < df.length; ++i) {
            key.add(df[i]);
        }
        return key;
    }

    public int size() {
        int s = 0;
        if (this.table == null) {
            return s;
        }
        for (List list : this.table.values()) {
            s += list.size() / 2;
        }
        return s;
    }

    public void extend(RelationTable<C> tab) {
        if (tab.table.size() == 0) {
            return;
        }
        int i = this.ring.nvar - tab.ring.nvar;
        int j = 0;
        long k = 0L;
        for (List<Integer> key : tab.table.keySet()) {
            List val = tab.table.get(key);
            Iterator jt = val.iterator();
            while (jt.hasNext()) {
                ExpVectorPair ep = (ExpVectorPair)jt.next();
                ExpVector e = ep.getFirst();
                ExpVector f = ep.getSecond();
                GenSolvablePolynomial p = (GenSolvablePolynomial)jt.next();
                ExpVector ex = e.extend(i, j, k);
                ExpVector fx = this.coeffTable ? f : f.extend(i, j, k);
                GenSolvablePolynomial px = (GenSolvablePolynomial)p.extend(this.ring, j, k);
                this.update(ex, fx, px);
            }
        }
    }

    public void contract(RelationTable<C> tab) {
        if (tab.table.size() == 0) {
            return;
        }
        int i = tab.ring.nvar - this.ring.nvar;
        for (List<Integer> key : tab.table.keySet()) {
            List val = tab.table.get(key);
            Iterator jt = val.iterator();
            while (jt.hasNext()) {
                Map<ExpVector, GenPolynomial<C>> mc;
                ExpVectorPair ep = (ExpVectorPair)jt.next();
                ExpVector e = ep.getFirst();
                ExpVector f = ep.getSecond();
                GenSolvablePolynomial p = (GenSolvablePolynomial)jt.next();
                ExpVector ec = e.contract(i, e.length() - i);
                ExpVector fc = this.coeffTable ? f : f.contract(i, f.length() - i);
                if (ec.isZERO() || (mc = p.contract(this.ring)).size() != 1) continue;
                GenPolynomial<C> pc = mc.values().iterator().next();
                this.update(ec, fc, pc);
            }
        }
    }

    public void recursive(RelationTable tab) {
        if (tab.table.size() == 0) {
            return;
        }
        GenPolynomialRing cring = (GenPolynomialRing)this.ring.coFac;
        int i = this.ring.nvar;
        Iterator<List<Integer>> i$ = tab.table.keySet().iterator();
        while (i$.hasNext()) {
            List<Integer> okey;
            List<Integer> key = okey = i$.next();
            List val = tab.table.get(key);
            Iterator jt = val.iterator();
            while (jt.hasNext()) {
                ExpVectorPair ep = (ExpVectorPair)jt.next();
                ExpVector e = ep.getFirst();
                ExpVector f = ep.getSecond();
                GenSolvablePolynomial p = (GenSolvablePolynomial)jt.next();
                ExpVector ec = e.contract(0, i);
                ExpVector fc = this.coeffTable ? f : f.contract(0, i);
                if (ec.isZERO()) continue;
                Map mc = p.contract(cring);
                if (mc.size() == 1) {
                    GenSolvablePolynomial pc = (GenSolvablePolynomial)mc.values().iterator().next();
                    this.update(ec, fc, pc);
                    continue;
                }
                GenPolynomial qr = this.ring.getZERO();
                for (Map.Entry mce : mc.entrySet()) {
                    ExpVector g = mce.getKey();
                    GenPolynomial q = mce.getValue();
                    RingElem cq = q;
                    GenSolvablePolynomial<RingElem> qp = new GenSolvablePolynomial<RingElem>(this.ring, cq, g);
                    qr = (GenSolvablePolynomial)qr.sum(qp);
                }
                if (this.coeffTable) {
                    fc = ((GenPolynomial)qr.leadingBaseCoefficient()).leadingExpVector();
                }
                if (fc.isZERO()) continue;
                if (this.coeffTable) {
                    logger.info((Object)("coeffTable: adding " + qr));
                } else {
                    logger.info((Object)("no coeffTable: adding " + qr));
                }
                this.update(ec, fc, (GenSolvablePolynomial<C>)qr);
            }
        }
    }

    public void reverse(RelationTable<C> tab) {
        if (tab.table.size() == 0) {
            return;
        }
        if (this.table.size() != 0) {
            logger.error((Object)"reverse table not empty");
        }
        int k = -1;
        if (this.ring.tord.getEvord2() != 0 && this.ring.partial) {
            k = this.ring.tord.getSplit();
        }
        logger.debug((Object)("k split = " + k));
        for (List<Integer> key : tab.table.keySet()) {
            List val = tab.table.get(key);
            Iterator jt = val.iterator();
            while (jt.hasNext()) {
                ExpVector fx;
                ExpVector ex;
                ExpVectorPair ep = (ExpVectorPair)jt.next();
                ExpVector e = ep.getFirst();
                ExpVector f = ep.getSecond();
                GenSolvablePolynomial p = (GenSolvablePolynomial)jt.next();
                boolean change = true;
                if (k >= 0) {
                    ex = e.reverse(k);
                    fx = this.coeffTable ? f : f.reverse(k);
                    int[] ed = ex.dependencyOnVariables();
                    if (ed.length == 0 || ed[0] >= k) {
                        change = false;
                    }
                } else {
                    ex = e.reverse();
                    fx = this.coeffTable ? f : f.reverse();
                }
                GenSolvablePolynomial px = (GenSolvablePolynomial)p.reverse(this.ring);
                if (!change) {
                    this.update(e, f, px);
                    continue;
                }
                if (this.coeffTable) {
                    this.update(ex, fx, px);
                    continue;
                }
                this.update(fx, ex, px);
            }
        }
    }

    public List<GenSolvablePolynomial<C>> relationList() {
        ArrayList<GenSolvablePolynomial<C>> rels = new ArrayList<GenSolvablePolynomial<C>>();
        Object one = this.ring.getONECoefficient();
        GenPolynomialRing cofac = null;
        if (this.coeffTable) {
            cofac = (GenPolynomialRing)this.ring.coFac;
        }
        for (List<Integer> k : this.table.keySet()) {
            List v = this.table.get(k);
            Iterator jt = v.iterator();
            while (jt.hasNext()) {
                ExpVectorPair ep = (ExpVectorPair)jt.next();
                ExpVector e = ep.getFirst();
                GenSolvablePolynomial<C> pe = new GenSolvablePolynomial<C>(this.ring, one, e);
                ExpVector f = ep.getSecond();
                GenSolvablePolynomial<Object> pf = null;
                if (this.coeffTable) {
                    GenPolynomial cpf = ((GenPolynomial)cofac.getONE()).multiply(f);
                    RingElem cf = cpf;
                    pf = new GenSolvablePolynomial<RingElem>(this.ring, cf);
                } else {
                    pf = new GenSolvablePolynomial<C>(this.ring, one, f);
                }
                GenSolvablePolynomial p = (GenSolvablePolynomial)jt.next();
                rels.add(pe);
                rels.add(pf);
                rels.add(p);
            }
        }
        return rels;
    }

    public void addSolvRelations(List<GenSolvablePolynomial<C>> rel) {
        PolynomialList<C> Prel = new PolynomialList<C>(this.ring, rel);
        this.addRelations(Prel.getList());
    }

    public void addRelations(List<GenPolynomial<C>> rel) {
        if (rel == null || rel.isEmpty()) {
            return;
        }
        Iterator<GenPolynomial<C>> relit = rel.iterator();
        while (relit.hasNext()) {
            GenPolynomial<C> E2 = relit.next();
            if (!relit.hasNext()) {
                throw new IllegalArgumentException("F and poly part missing");
            }
            GenPolynomial F2 = relit.next();
            if (!relit.hasNext()) {
                throw new IllegalArgumentException("poly part missing");
            }
            GenPolynomial<C> P = relit.next();
            if (this.coeffTable && F2.isConstant()) {
                F2 = (GenPolynomial)F2.leadingBaseCoefficient();
            }
            this.update(E2, F2, P);
        }
    }
}

