/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.PrettyPrint;
import edu.jas.kern.Scripting;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class RecSolvablePolynomialRing<C extends RingElem<C>>
extends GenSolvablePolynomialRing<GenPolynomial<C>> {
    public final RelationTable<GenPolynomial<C>> coeffTable;
    public final RecSolvablePolynomial<C> ZERO;
    public final RecSolvablePolynomial<C> ONE;
    private static final Logger logger = Logger.getLogger(RecSolvablePolynomialRing.class);
    private final boolean debug = logger.isDebugEnabled();

    public RecSolvablePolynomialRing(RingFactory<GenPolynomial<C>> cf, int n) {
        this(cf, n, new TermOrder(), (String[])null, (RelationTable<GenPolynomial<C>>)null);
    }

    public RecSolvablePolynomialRing(RingFactory<GenPolynomial<C>> cf, int n, RelationTable<GenPolynomial<C>> rt) {
        this(cf, n, new TermOrder(), (String[])null, rt);
    }

    public RecSolvablePolynomialRing(RingFactory<GenPolynomial<C>> cf, int n, TermOrder t) {
        this(cf, n, t, (String[])null, (RelationTable<GenPolynomial<C>>)null);
    }

    public RecSolvablePolynomialRing(RingFactory<GenPolynomial<C>> cf, int n, TermOrder t, RelationTable<GenPolynomial<C>> rt) {
        this(cf, n, t, (String[])null, rt);
    }

    public RecSolvablePolynomialRing(RingFactory<GenPolynomial<C>> cf, int n, TermOrder t, String[] v) {
        this(cf, n, t, v, (RelationTable<GenPolynomial<C>>)null);
    }

    public RecSolvablePolynomialRing(RingFactory<GenPolynomial<C>> cf, TermOrder t, String[] v) {
        this(cf, v.length, t, v, (RelationTable<GenPolynomial<C>>)null);
    }

    public RecSolvablePolynomialRing(RingFactory<GenPolynomial<C>> cf, String[] v) {
        this(cf, v.length, new TermOrder(), v, (RelationTable<GenPolynomial<C>>)null);
    }

    public RecSolvablePolynomialRing(RingFactory<GenPolynomial<C>> cf, int n, TermOrder t, String[] v, RelationTable<GenPolynomial<C>> rt) {
        super(cf, n, t, v, rt);
        this.coeffTable = new RelationTable(this, true);
        this.ZERO = new RecSolvablePolynomial(this);
        GenPolynomial coeff = (GenPolynomial)this.coFac.getONE();
        this.ONE = new RecSolvablePolynomial(this, coeff, this.evzero);
    }

    public RecSolvablePolynomialRing(RingFactory<GenPolynomial<C>> cf, RecSolvablePolynomialRing o) {
        this(cf, o.nvar, o.tord, o.getVars(), (RelationTable<GenPolynomial<C>>)null);
    }

    @Override
    public String toString() {
        String res = super.toString();
        res = PrettyPrint.isTrue() ? res + "\n" + this.coeffTable.toString(this.vars) : res + ", #rel = " + this.table.size() + " + " + this.coeffTable.size();
        return res;
    }

    @Override
    public String toScript() {
        String rel;
        StringBuffer s = new StringBuffer();
        switch (Scripting.getLang()) {
            case Ruby: {
                s.append("SolvPolyRing.new(");
                break;
            }
            default: {
                s.append("SolvPolyRing(");
            }
        }
        if (this.coFac instanceof RingElem) {
            s.append(((RingElem)((Object)this.coFac)).toScriptFactory());
        } else {
            s.append(this.coFac.toScript().trim());
        }
        s.append(",\"" + this.varsToString() + "\",");
        String to = this.tord.toString();
        if (this.tord.getEvord() == 2) {
            to = "PolyRing.lex";
        }
        if (this.tord.getEvord() == 4) {
            to = "PolyRing.grad";
        }
        s.append(to);
        if (this.table.size() > 0) {
            rel = this.table.toScript();
            s.append(",rel=");
            s.append(rel);
        }
        if (this.coeffTable.size() > 0) {
            rel = this.coeffTable.toScript();
            s.append(",coeffrel=");
            s.append(rel);
        }
        s.append(")");
        return s.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof RecSolvablePolynomialRing)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        RecSolvablePolynomialRing oring = (RecSolvablePolynomialRing)other;
        return this.coeffTable.equals(oring.coeffTable);
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        h = 37 * h + this.table.hashCode();
        h = 37 * h + this.coeffTable.hashCode();
        return h;
    }

    @Override
    public RecSolvablePolynomial<C> getZERO() {
        return this.ZERO;
    }

    @Override
    public RecSolvablePolynomial<C> getONE() {
        return this.ONE;
    }

    @Override
    public boolean isCommutative() {
        if (this.coeffTable.isEmpty()) {
            return super.isCommutative();
        }
        return false;
    }

    @Override
    public boolean isAssociative() {
        List gens = this.generators();
        int ngen = gens.size();
        for (int i = 0; i < ngen; ++i) {
            RecSolvablePolynomial Xi = (RecSolvablePolynomial)gens.get(i);
            for (int j = i + 1; j < ngen; ++j) {
                RecSolvablePolynomial Xj = (RecSolvablePolynomial)gens.get(j);
                for (int k = j + 1; k < ngen; ++k) {
                    RecSolvablePolynomial q;
                    RecSolvablePolynomial Xk = (RecSolvablePolynomial)gens.get(k);
                    RecSolvablePolynomial p = Xk.multiply(Xj).multiply(Xi);
                    if (p.equals(q = Xk.multiply(Xj.multiply(Xi)))) continue;
                    logger.info((Object)("Xk = " + Xk + ", Xj = " + Xj + ", Xi = " + Xi));
                    logger.info((Object)("p = ( Xk * Xj ) * Xi = " + p));
                    logger.info((Object)("q = Xk * ( Xj * Xi ) = " + q));
                    return false;
                }
            }
        }
        return this.coFac.isAssociative();
    }

    @Override
    public RecSolvablePolynomial<C> fromInteger(long a) {
        return new RecSolvablePolynomial(this, (GenPolynomial)this.coFac.fromInteger(a), this.evzero);
    }

    @Override
    public RecSolvablePolynomial<C> fromInteger(BigInteger a) {
        return new RecSolvablePolynomial(this, (GenPolynomial)this.coFac.fromInteger(a), this.evzero);
    }

    @Override
    public RecSolvablePolynomial<C> random(int n) {
        return this.random(n, random);
    }

    @Override
    public RecSolvablePolynomial<C> random(int n, Random rnd) {
        if (this.nvar == 1) {
            return this.random(5, n, n, 0.7f, rnd);
        }
        return this.random(5, n, 3, 0.3f, rnd);
    }

    @Override
    public RecSolvablePolynomial<C> random(int k, int l, int d, float q) {
        return this.random(k, l, d, q, random);
    }

    @Override
    public RecSolvablePolynomial<C> random(int k, int l, int d, float q, Random rnd) {
        GenSolvablePolynomial r = this.getZERO();
        for (int i = 0; i < l; ++i) {
            ExpVector e = ExpVector.EVRAND(this.nvar, d, q, rnd);
            GenPolynomial a = (GenPolynomial)this.coFac.random(k, rnd);
            r = (RecSolvablePolynomial)r.sum(a, e);
        }
        return r;
    }

    @Override
    public RecSolvablePolynomial<C> copy(RecSolvablePolynomial<C> c) {
        return new RecSolvablePolynomial(this, c.val);
    }

    @Override
    public RecSolvablePolynomial<C> parse(String s) {
        return this.parse(new StringReader(s));
    }

    @Override
    public RecSolvablePolynomial<C> parse(Reader r) {
        GenPolynomialTokenizer pt = new GenPolynomialTokenizer(this, r);
        RecSolvablePolynomial p = null;
        try {
            GenSolvablePolynomial s = pt.nextSolvablePolynomial();
            p = new RecSolvablePolynomial(this, s);
        }
        catch (IOException e) {
            logger.error((Object)(e.toString() + " parse " + this));
            p = this.ZERO;
        }
        return p;
    }

    @Override
    public RecSolvablePolynomial<C> univariate(int i) {
        return (RecSolvablePolynomial)super.univariate(i);
    }

    @Override
    public RecSolvablePolynomial<C> univariate(int i, long e) {
        return (RecSolvablePolynomial)super.univariate(i, e);
    }

    @Override
    public RecSolvablePolynomial<C> univariate(int modv, int i, long e) {
        return (RecSolvablePolynomial)super.univariate(modv, i, e);
    }

    public List<RecSolvablePolynomial<C>> recUnivariateList() {
        return this.univariateList(0, 1L);
    }

    public List<RecSolvablePolynomial<C>> recUnivariateList(int modv) {
        return this.univariateList(modv, 1L);
    }

    public List<RecSolvablePolynomial<C>> recUnivariateList(int modv, long e) {
        ArrayList<RecSolvablePolynomial<C>> pols = new ArrayList<RecSolvablePolynomial<C>>(this.nvar);
        int nm = this.nvar - modv;
        for (int i = 0; i < nm; ++i) {
            GenSolvablePolynomial p = this.univariate(modv, nm - 1 - i, e);
            pols.add((RecSolvablePolynomial<C>)p);
        }
        return pols;
    }

    @Override
    public RecSolvablePolynomialRing<C> extend(int i) {
        GenPolynomialRing pfac = super.extend(i);
        RecSolvablePolynomialRing<C> spfac = new RecSolvablePolynomialRing<C>(((GenSolvablePolynomialRing)pfac).coFac, ((GenSolvablePolynomialRing)pfac).nvar, ((GenSolvablePolynomialRing)pfac).tord, ((GenSolvablePolynomialRing)pfac).vars, ((GenSolvablePolynomialRing)pfac).table);
        spfac.coeffTable.extend(this.coeffTable);
        return spfac;
    }

    @Override
    public RecSolvablePolynomialRing<C> extend(String[] vs) {
        GenPolynomialRing pfac = super.extend(vs);
        RecSolvablePolynomialRing<C> spfac = new RecSolvablePolynomialRing<C>(((GenSolvablePolynomialRing)pfac).coFac, ((GenSolvablePolynomialRing)pfac).nvar, ((GenSolvablePolynomialRing)pfac).tord, ((GenSolvablePolynomialRing)pfac).vars, ((GenSolvablePolynomialRing)pfac).table);
        spfac.coeffTable.extend(this.coeffTable);
        return spfac;
    }

    @Override
    public RecSolvablePolynomialRing<C> contract(int i) {
        GenPolynomialRing pfac = super.contract(i);
        RecSolvablePolynomialRing<C> spfac = new RecSolvablePolynomialRing<C>(pfac.coFac, pfac.nvar, pfac.tord, pfac.vars);
        spfac.table.contract(this.table);
        spfac.coeffTable.contract(this.coeffTable);
        return spfac;
    }

    @Override
    public RecSolvablePolynomialRing<C> reverse() {
        return this.reverse(false);
    }

    @Override
    public RecSolvablePolynomialRing<C> reverse(boolean partial) {
        GenPolynomialRing pfac = super.reverse(partial);
        RecSolvablePolynomialRing<C> spfac = new RecSolvablePolynomialRing<C>(pfac.coFac, pfac.nvar, pfac.tord, pfac.vars);
        spfac.partial = partial;
        spfac.table.reverse(this.table);
        spfac.coeffTable.reverse(this.coeffTable);
        return spfac;
    }

    public static <C extends RingElem<C>> GenSolvablePolynomialRing<C> distribute(RecSolvablePolynomialRing<C> rf) {
        RecSolvablePolynomialRing<C> fring = rf;
        GenPolynomialRing pfd = fring.distribute();
        List<GenPolynomial<GenPolynomial<C>>> rl = PolynomialList.castToList(rf.coeffTable.relationList());
        List<GenPolynomial<C>> rld = PolyUtil.distribute(pfd, rl);
        ((GenSolvablePolynomialRing)pfd).table.addRelations(rld);
        return pfd;
    }
}

