/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.Scripting;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.ModuleList;
import edu.jas.poly.OrderedPolynomialList;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RingElem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PolynomialList<C extends RingElem<C>>
implements Comparable<PolynomialList<C>>,
Serializable {
    public final GenPolynomialRing<C> ring;
    public final List<GenPolynomial<C>> list;
    private static final Logger logger = Logger.getLogger(PolynomialList.class);

    public PolynomialList(GenPolynomialRing<C> r, List<GenPolynomial<C>> l) {
        this.ring = r;
        this.list = l;
    }

    public PolynomialList(GenSolvablePolynomialRing<C> r, List<GenSolvablePolynomial<C>> l) {
        this((GenPolynomialRing<C>)r, PolynomialList.castToList(l));
    }

    public PolynomialList<C> copy() {
        return new PolynomialList<C>(this.ring, new ArrayList<GenPolynomial<C>>(this.list));
    }

    public boolean equals(Object p) {
        if (p == null) {
            return false;
        }
        if (!(p instanceof PolynomialList)) {
            System.out.println("no PolynomialList");
            return false;
        }
        PolynomialList pl = (PolynomialList)p;
        if (!this.ring.equals(pl.ring)) {
            System.out.println("not same Ring " + this.ring.toScript() + ", " + pl.ring.toScript());
            return false;
        }
        return this.compareTo(pl) == 0;
    }

    @Override
    public int compareTo(PolynomialList<C> L) {
        int si = L.list.size();
        if (this.list.size() < si) {
            si = this.list.size();
        }
        int s = 0;
        List<GenPolynomial<C>> l1 = OrderedPolynomialList.sort(this.ring, this.list);
        List<GenPolynomial<C>> l2 = OrderedPolynomialList.sort(this.ring, L.list);
        for (int i = 0; i < si; ++i) {
            GenPolynomial<C> b;
            GenPolynomial<C> a = l1.get(i);
            s = a.compareTo(b = l2.get(i));
            if (s == 0) continue;
            return s;
        }
        if (this.list.size() > si) {
            return 1;
        }
        if (L.list.size() > si) {
            return -1;
        }
        return s;
    }

    public int hashCode() {
        int h = this.ring.hashCode();
        h = 37 * h + (this.list == null ? 0 : this.list.hashCode());
        return h;
    }

    public String toString() {
        StringBuffer erg = new StringBuffer();
        String[] vars = null;
        if (this.ring != null) {
            erg.append(this.ring.toString());
            vars = this.ring.getVars();
        }
        boolean first = true;
        erg.append("\n(\n");
        String sa = null;
        for (GenPolynomial<C> oa : this.list) {
            sa = vars != null ? oa.toString(vars) : oa.toString();
            if (first) {
                first = false;
            } else {
                erg.append(", ");
                if (sa.length() > 10) {
                    erg.append("\n");
                }
            }
            erg.append("( " + sa + " )");
        }
        erg.append("\n)");
        return erg.toString();
    }

    public String toScript() {
        StringBuffer s = new StringBuffer();
        if (this.ring instanceof GenSolvablePolynomialRing) {
            switch (Scripting.getLang()) {
                case Ruby: {
                    s.append("SolvIdeal.new(");
                    break;
                }
                default: {
                    s.append("SolvableIdeal(");
                    break;
                }
            }
        } else {
            switch (Scripting.getLang()) {
                case Ruby: {
                    s.append("SimIdeal.new(");
                    break;
                }
                default: {
                    s.append("Ideal(");
                }
            }
        }
        if (this.ring != null) {
            s.append(this.ring.toScript());
        }
        if (this.list == null) {
            s.append(")");
            return s.toString();
        }
        switch (Scripting.getLang()) {
            case Ruby: {
                s.append(",\"\",[");
                break;
            }
            default: {
                s.append(",list=[");
            }
        }
        boolean first = true;
        String sa = null;
        for (GenPolynomial<C> oa : this.list) {
            sa = oa.toScript();
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            s.append(sa);
        }
        s.append("])");
        return s.toString();
    }

    public ModuleList<C> getModuleList(int i) {
        GenPolynomialRing<C> pfac = this.ring.contract(i);
        logger.debug((Object)("contracted ring = " + pfac));
        ArrayList vecs = null;
        if (this.list == null) {
            return new ModuleList<C>(pfac, vecs);
        }
        int rows = this.list.size();
        vecs = new ArrayList(rows);
        if (rows == 0) {
            return new ModuleList<C>(pfac, vecs);
        }
        ArrayList<AbelianGroupElem> zr = new ArrayList<AbelianGroupElem>(i - 1);
        AbelianGroupElem zero = pfac.getZERO();
        for (int j = 0; j < i; ++j) {
            zr.add(j, zero);
        }
        for (GenPolynomial<C> p : this.list) {
            if (p == null) continue;
            Map<ExpVector, GenPolynomial<C>> r = p.contract(pfac);
            ArrayList<GenPolynomial<C>> row = new ArrayList<GenPolynomial<C>>(zr);
            for (Map.Entry<ExpVector, GenPolynomial<C>> me : r.entrySet()) {
                ExpVector e = me.getKey();
                int[] dov = e.dependencyOnVariables();
                int ix = 0;
                if (dov.length > 1) {
                    throw new IllegalArgumentException("wrong dependencyOnVariables " + e);
                }
                if (dov.length == 1) {
                    ix = dov[0];
                }
                GenPolynomial<C> vi = me.getValue();
                row.set(ix, vi);
            }
            vecs.add(row);
        }
        return new ModuleList<C>(pfac, vecs);
    }

    public List<GenPolynomial<C>> getList() {
        return this.list;
    }

    public List<GenSolvablePolynomial<C>> castToSolvableList() {
        return PolynomialList.castToSolvableList(this.list);
    }

    public List<GenSolvablePolynomial<C>> getSolvableList() {
        return PolynomialList.castToSolvableList(this.list);
    }

    public GenSolvablePolynomialRing<C> getSolvableRing() {
        return (GenSolvablePolynomialRing)this.ring;
    }

    public static <C extends RingElem<C>> List<GenSolvablePolynomial<C>> castToSolvableList(List<GenPolynomial<C>> list) {
        ArrayList<GenSolvablePolynomial<C>> slist = null;
        if (list == null) {
            return slist;
        }
        slist = new ArrayList<GenSolvablePolynomial<C>>(list.size());
        for (GenPolynomial<C> p : list) {
            if (!(p instanceof GenSolvablePolynomial)) {
                throw new IllegalArgumentException("no solvable polynomial " + p);
            }
            GenSolvablePolynomial s = (GenSolvablePolynomial)p;
            slist.add(s);
        }
        return slist;
    }

    public static <C extends RingElem<C>> List<List<GenSolvablePolynomial<C>>> castToSolvableMatrix(List<List<GenPolynomial<C>>> list) {
        ArrayList<List<GenSolvablePolynomial<C>>> slist = null;
        if (list == null) {
            return slist;
        }
        slist = new ArrayList<List<GenSolvablePolynomial<C>>>(list.size());
        for (List<GenPolynomial<C>> p : list) {
            List<GenSolvablePolynomial<C>> s = PolynomialList.castToSolvableList(p);
            slist.add(s);
        }
        return slist;
    }

    public static <C extends RingElem<C>> List<GenPolynomial<C>> castToList(List<? extends GenPolynomial<C>> slist) {
        logger.debug((Object)"warn: can lead to wrong method dispatch");
        ArrayList<GenPolynomial<C>> list = null;
        if (slist == null) {
            return list;
        }
        list = new ArrayList<GenPolynomial<C>>(slist.size());
        for (GenPolynomial<C> p : slist) {
            list.add(p);
        }
        return list;
    }

    public static <C extends RingElem<C>> List<List<GenPolynomial<C>>> castToMatrix(List<List<? extends GenPolynomial<C>>> slist) {
        logger.debug((Object)"warn: can lead to wrong method dispatch");
        ArrayList<List<GenPolynomial<C>>> list = null;
        if (slist == null) {
            return list;
        }
        list = new ArrayList<List<GenPolynomial<C>>>(slist.size());
        for (List<GenPolynomial<C>> list2 : slist) {
            list.add(PolynomialList.castToList(list2));
        }
        return list;
    }

    public boolean isZERO() {
        if (this.list == null) {
            return true;
        }
        for (GenPolynomial<C> p : this.list) {
            if (p == null || p.isZERO()) continue;
            return false;
        }
        return true;
    }

    public boolean isONE() {
        if (this.list == null) {
            return false;
        }
        for (GenPolynomial<C> p : this.list) {
            if (p == null || !p.isONE()) continue;
            return true;
        }
        return false;
    }

    public PolynomialList<C> homogenize() {
        GenPolynomialRing<C> pfac = this.ring.extend(1);
        ArrayList<GenPolynomial<C>> hom = new ArrayList<GenPolynomial<C>>(this.list.size());
        for (GenPolynomial<C> p : this.list) {
            GenPolynomial<C> h = p.homogenize(pfac);
            hom.add(h);
        }
        return new PolynomialList<C>(pfac, hom);
    }

    public PolynomialList<C> deHomogenize() {
        GenPolynomialRing<C> pfac = this.ring.contract(1);
        ArrayList<GenPolynomial<C>> dehom = new ArrayList<GenPolynomial<C>>(this.list.size());
        for (GenPolynomial<C> p : this.list) {
            GenPolynomial<C> h = p.deHomogenize(pfac);
            dehom.add(h);
        }
        return new PolynomialList<C>(pfac, dehom);
    }

    public boolean isHomogeneous() {
        if (this.list == null) {
            return true;
        }
        for (GenPolynomial<C> p : this.list) {
            if (p == null || p.isHomogeneous()) continue;
            return false;
        }
        return true;
    }
}

