/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.Local;
import edu.jas.structure.QuotPairFactory;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class LocalRing<C extends RingElem<C>>
implements RingFactory<Local<C>>,
QuotPairFactory<C, Local<C>> {
    private static final Logger logger = Logger.getLogger(LocalRing.class);
    protected final C ideal;
    protected final RingFactory<C> ring;
    protected int isField = -1;

    public LocalRing(RingFactory<C> r, C i) {
        this.ring = r;
        if (i == null) {
            throw new IllegalArgumentException("ideal may not be null");
        }
        this.ideal = i;
        if (this.ideal.isONE()) {
            throw new IllegalArgumentException("ideal may not be 1");
        }
    }

    @Override
    public RingFactory<C> pairFactory() {
        return this.ring;
    }

    @Override
    public Local<C> create(C n) {
        return new Local<C>(this, n);
    }

    @Override
    public Local<C> create(C n, C d) {
        return new Local<C>(this, n, d);
    }

    @Override
    public boolean isFinite() {
        return this.ring.isFinite();
    }

    @Override
    public Local<C> copy(Local<C> c) {
        return new Local(c.ring, c.num, c.den, true);
    }

    @Override
    public Local<C> getZERO() {
        return new Local<RingElem>(this, (RingElem)this.ring.getZERO());
    }

    @Override
    public Local<C> getONE() {
        return new Local<RingElem>(this, (RingElem)this.ring.getONE());
    }

    @Override
    public List<Local<C>> generators() {
        List rgens = this.ring.generators();
        ArrayList<Local<C>> gens = new ArrayList<Local<C>>(rgens.size() - 1);
        for (RingElem c : rgens) {
            if (c.isONE()) continue;
            gens.add(new Local<RingElem>(this, c));
        }
        return gens;
    }

    @Override
    public boolean isCommutative() {
        return this.ring.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.ring.isAssociative();
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        return false;
    }

    @Override
    public BigInteger characteristic() {
        return this.ring.characteristic();
    }

    @Override
    public Local<C> fromInteger(BigInteger a) {
        return new Local<RingElem>(this, (RingElem)this.ring.fromInteger(a));
    }

    @Override
    public Local<C> fromInteger(long a) {
        return new Local<RingElem>(this, (RingElem)this.ring.fromInteger(a));
    }

    public String toString() {
        return "Local[ " + this.ideal.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "LocalRing(" + this.ideal.toScript() + ")";
    }

    public boolean equals(Object b) {
        if (b == null) {
            return false;
        }
        if (!(b instanceof LocalRing)) {
            return false;
        }
        LocalRing a = (LocalRing)b;
        if (!this.ring.equals(a.ring)) {
            return false;
        }
        return this.ideal.equals(a.ideal);
    }

    public int hashCode() {
        int h = this.ring.hashCode();
        h = 37 * h + this.ideal.hashCode();
        return h;
    }

    @Override
    public Local<C> random(int n) {
        RingElem r = (RingElem)this.ring.random(n);
        RingElem s = (RingElem)this.ring.random(n);
        s = (RingElem)s.remainder(this.ideal);
        while (s.isZERO()) {
            logger.debug((Object)"zero was in ideal");
            s = (RingElem)this.ring.random(n);
            s = (RingElem)s.remainder(this.ideal);
        }
        return new Local<RingElem>(this, r, s, false);
    }

    @Override
    public Local<C> random(int n, Random rnd) {
        RingElem r = (RingElem)this.ring.random(n, rnd);
        RingElem s = (RingElem)this.ring.random(n, rnd);
        s = (RingElem)s.remainder(this.ideal);
        while (s.isZERO()) {
            logger.debug((Object)"zero was in ideal");
            s = (RingElem)this.ring.random(n, rnd);
            s = (RingElem)s.remainder(this.ideal);
        }
        return new Local<RingElem>(this, r, s, false);
    }

    @Override
    public Local<C> parse(String s) {
        RingElem x = (RingElem)this.ring.parse(s);
        return new Local<RingElem>(this, x);
    }

    @Override
    public Local<C> parse(Reader r) {
        RingElem x = (RingElem)this.ring.parse(r);
        return new Local<RingElem>(this, x);
    }
}

