/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.LocalRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPair;
import edu.jas.structure.RingElem;
import org.apache.log4j.Logger;

public class Local<C extends RingElem<C>>
implements RingElem<Local<C>>,
QuotPair<C> {
    private static final Logger logger = Logger.getLogger(Local.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final LocalRing<C> ring;
    protected final C num;
    protected final C den;
    protected int isunit = -1;

    public Local(LocalRing<C> r) {
        this(r, (RingElem)r.ring.getZERO());
    }

    public Local(LocalRing<C> r, C n) {
        this((LocalRing<RingElem>)r, (RingElem)n, (RingElem)r.ring.getONE(), true);
    }

    public Local(LocalRing<C> r, C n, C d) {
        this(r, n, d, false);
    }

    protected Local(LocalRing<C> r, C n, C d, boolean isred) {
        if (d == null || d.isZERO()) {
            throw new IllegalArgumentException("denominator may not be zero");
        }
        this.ring = r;
        if (d.signum() < 0) {
            n = (RingElem)n.negate();
            d = (RingElem)d.negate();
        }
        if (isred) {
            this.num = n;
            this.den = d;
            return;
        }
        RingElem p = (RingElem)d.remainder(this.ring.ideal);
        if (p == null || p.isZERO()) {
            throw new IllegalArgumentException("denominator may not be in ideal");
        }
        if (n instanceof GcdRingElem && d instanceof GcdRingElem) {
            GcdRingElem ng = (GcdRingElem)n;
            GcdRingElem dg = (GcdRingElem)d;
            GcdRingElem gcd = ng.gcd(dg);
            if (this.debug) {
                logger.info((Object)("gcd = " + gcd));
            }
            if (gcd.isONE()) {
                this.num = n;
                this.den = d;
            } else {
                this.num = n.divide((GcdRingElem)gcd);
                this.den = d.divide((GcdRingElem)gcd);
            }
        } else {
            logger.warn((Object)"gcd = ????");
            this.num = n;
            this.den = d;
        }
    }

    @Override
    public LocalRing<C> factory() {
        return this.ring;
    }

    @Override
    public C numerator() {
        return this.num;
    }

    @Override
    public C denominator() {
        return this.den;
    }

    @Override
    public boolean isConstant() {
        throw new UnsupportedOperationException("isConstant not implemented");
    }

    @Override
    public Local<C> copy() {
        return new Local<C>(this.ring, this.num, this.den, true);
    }

    @Override
    public boolean isZERO() {
        return this.num.isZERO();
    }

    @Override
    public boolean isONE() {
        return this.num.equals(this.den);
    }

    @Override
    public boolean isUnit() {
        if (this.isunit > 0) {
            return true;
        }
        if (this.isunit == 0) {
            return false;
        }
        if (this.num.isZERO()) {
            this.isunit = 0;
            return false;
        }
        RingElem p = (RingElem)this.num.remainder(this.ring.ideal);
        boolean u = p != null && !p.isZERO();
        this.isunit = u ? 1 : 0;
        return u;
    }

    public String toString() {
        return "Local[ " + this.num.toString() + " / " + this.den.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "Local( " + this.num.toScript() + " , " + this.den.toScript() + " )";
    }

    @Override
    public String toScriptFactory() {
        return ((LocalRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(Local<C> b) {
        if (b == null || b.isZERO()) {
            return this.signum();
        }
        RingElem r = (RingElem)this.num.multiply(b.den);
        RingElem s = (RingElem)this.den.multiply(b.num);
        RingElem x = r.subtract(s);
        return x.signum();
    }

    @Override
    public boolean equals(Object b) {
        if (b == null) {
            return false;
        }
        if (!(b instanceof Local)) {
            return false;
        }
        Local a = (Local)b;
        return 0 == this.compareTo(a);
    }

    @Override
    public int hashCode() {
        int h = this.ring.hashCode();
        h = 37 * h + this.num.hashCode();
        h = 37 * h + this.den.hashCode();
        return h;
    }

    @Override
    public Local<C> abs() {
        return new Local<RingElem>((LocalRing<RingElem>)this.ring, (RingElem)this.num.abs(), (RingElem)this.den, true);
    }

    @Override
    public Local<C> sum(Local<C> S) {
        if (S == null || S.isZERO()) {
            return this;
        }
        RingElem n = (RingElem)this.num.multiply(S.den);
        n = (RingElem)n.sum((AbelianGroupElem)this.den.multiply(S.num));
        RingElem d = (RingElem)this.den.multiply(S.den);
        return new Local<RingElem>(this.ring, n, d, false);
    }

    @Override
    public Local<C> negate() {
        return new Local<RingElem>((LocalRing<RingElem>)this.ring, (RingElem)this.num.negate(), (RingElem)this.den, true);
    }

    @Override
    public int signum() {
        return this.num.signum();
    }

    @Override
    public Local<C> subtract(Local<C> S) {
        if (S == null || S.isZERO()) {
            return this;
        }
        RingElem n = (RingElem)this.num.multiply(S.den);
        n = (RingElem)n.subtract((AbelianGroupElem)this.den.multiply(S.num));
        RingElem d = (RingElem)this.den.multiply(S.den);
        return new Local<RingElem>(this.ring, n, d, false);
    }

    @Override
    public Local<C> divide(Local<C> S) {
        return this.multiply((Local<C>)S.inverse());
    }

    @Override
    public Local<C> inverse() {
        if (this.isONE()) {
            return this;
        }
        if (this.isUnit()) {
            return new Local<C>(this.ring, this.den, this.num, true);
        }
        throw new ArithmeticException("element not invertible " + this);
    }

    @Override
    public Local<C> remainder(Local<C> S) {
        if (this.num.isZERO()) {
            throw new ArithmeticException("element not invertible " + this);
        }
        if (S.isUnit()) {
            return this.ring.getZERO();
        }
        throw new UnsupportedOperationException("remainder not implemented" + S);
    }

    public Local<C>[] quotientRemainder(Local<C> S) {
        return new Local[]{this.divide(S), this.remainder(S)};
    }

    @Override
    public Local<C> multiply(Local<C> S) {
        if (S == null || S.isZERO()) {
            return S;
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (S.isONE()) {
            return this;
        }
        if (this.isONE()) {
            return S;
        }
        RingElem n = (RingElem)this.num.multiply(S.num);
        RingElem d = (RingElem)this.den.multiply(S.den);
        return new Local<RingElem>(this.ring, n, d, false);
    }

    @Override
    public Local<C> gcd(Local<C> b) {
        throw new UnsupportedOperationException("gcd not implemented " + this.getClass().getName());
    }

    public Local<C>[] egcd(Local<C> b) {
        throw new UnsupportedOperationException("egcd not implemented " + this.getClass().getName());
    }
}

