/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.PreemptingException;
import edu.jas.poly.GenWordPolynomialRing;
import edu.jas.poly.Word;
import edu.jas.poly.WordFactory;
import edu.jas.poly.WordMonomial;
import edu.jas.poly.WordPolyIterator;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.RingElem;
import edu.jas.structure.UnaryFunctor;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public final class GenWordPolynomial<C extends RingElem<C>>
implements RingElem<GenWordPolynomial<C>>,
Iterable<WordMonomial<C>> {
    public final GenWordPolynomialRing<C> ring;
    final SortedMap<Word, C> val;
    private static final Logger logger = Logger.getLogger(GenWordPolynomial.class);
    private final boolean debug = logger.isDebugEnabled();

    private GenWordPolynomial(GenWordPolynomialRing<C> r, TreeMap<Word, C> t) {
        this.ring = r;
        this.val = t;
        if (this.ring.checkPreempt && Thread.currentThread().isInterrupted()) {
            logger.debug((Object)"throw PreemptingException");
            throw new PreemptingException();
        }
    }

    public GenWordPolynomial(GenWordPolynomialRing<C> r) {
        this(r, (C)new TreeMap(r.alphabet.getDescendComparator()));
    }

    public GenWordPolynomial(GenWordPolynomialRing<C> r, C c, Word e) {
        this(r);
        if (!c.isZERO()) {
            this.val.put(e, c);
        }
    }

    public GenWordPolynomial(GenWordPolynomialRing<C> r, C c) {
        this(r, c, r.wone);
    }

    public GenWordPolynomial(GenWordPolynomialRing<C> r, Word e) {
        this(r, (RingElem)r.coFac.getONE(), e);
    }

    protected GenWordPolynomial(GenWordPolynomialRing<C> r, SortedMap<Word, C> v) {
        this(r);
        this.val.putAll(v);
    }

    @Override
    public GenWordPolynomialRing<C> factory() {
        return this.ring;
    }

    @Override
    public GenWordPolynomial<C> copy() {
        return new GenWordPolynomial<C>(this.ring, this.val);
    }

    public int length() {
        return this.val.size();
    }

    public SortedMap<Word, C> getMap() {
        return Collections.unmodifiableSortedMap(this.val);
    }

    public void doPutToMap(Word e, C c) {
        RingElem a;
        if (this.debug && (a = (RingElem)this.val.get(e)) != null) {
            logger.error((Object)("map entry exists " + e + " to " + a + " new " + c));
        }
        if (!c.isZERO()) {
            this.val.put(e, c);
        }
    }

    public void doPutToMap(SortedMap<Word, C> vals) {
        for (Map.Entry<Word, C> me : vals.entrySet()) {
            RingElem c;
            RingElem a;
            Word e = me.getKey();
            if (this.debug && (a = (RingElem)this.val.get(e)) != null) {
                logger.error((Object)("map entry exists " + e + " to " + a + " new " + me.getValue()));
            }
            if ((c = (RingElem)me.getValue()).isZERO()) continue;
            this.val.put(e, c);
        }
    }

    public String toString() {
        if (this.isZERO()) {
            return "0";
        }
        if (this.isONE()) {
            return "1";
        }
        StringBuffer s = new StringBuffer();
        if (this.val.size() > 1) {
            s.append("( ");
        }
        boolean parenthesis = false;
        boolean first = true;
        for (Map.Entry<Word, C> m : this.val.entrySet()) {
            RingElem c = (RingElem)m.getValue();
            if (first) {
                first = false;
            } else if (c.signum() < 0) {
                s.append(" - ");
                c = (RingElem)c.negate();
            } else {
                s.append(" + ");
            }
            Word e = m.getKey();
            if (!c.isONE() || e.isONE()) {
                if (parenthesis) {
                    s.append("( ");
                }
                s.append(c.toString());
                if (parenthesis) {
                    s.append(" )");
                }
                if (!e.isONE()) {
                    s.append(" ");
                }
            }
            s.append(e.toString());
        }
        if (this.val.size() > 1) {
            s.append(" )");
        }
        return s.toString();
    }

    @Override
    public String toScript() {
        if (this.isZERO()) {
            return "0";
        }
        if (this.isONE()) {
            return "1";
        }
        StringBuffer s = new StringBuffer();
        if (this.val.size() > 1) {
            s.append("( ");
        }
        boolean parenthesis = false;
        boolean first = true;
        for (Map.Entry<Word, C> m : this.val.entrySet()) {
            RingElem c = (RingElem)m.getValue();
            if (first) {
                first = false;
            } else if (c.signum() < 0) {
                s.append(" - ");
                c = (RingElem)c.negate();
            } else {
                s.append(" + ");
            }
            Word e = m.getKey();
            if (!c.isONE() || e.isONE()) {
                s.append(c.toScript());
                if (!e.isONE()) {
                    s.append(" * ");
                }
            }
            s.append(e.toScript());
        }
        if (this.val.size() > 1) {
            s.append(" )");
        }
        return s.toString();
    }

    @Override
    public String toScriptFactory() {
        return ((GenWordPolynomialRing)this.factory()).toScript();
    }

    @Override
    public boolean isZERO() {
        return this.val.size() == 0;
    }

    @Override
    public boolean isONE() {
        if (this.val.size() != 1) {
            return false;
        }
        RingElem c = (RingElem)this.val.get(this.ring.wone);
        if (c == null) {
            return false;
        }
        return c.isONE();
    }

    @Override
    public boolean isUnit() {
        if (this.val.size() != 1) {
            return false;
        }
        RingElem c = (RingElem)this.val.get(this.ring.wone);
        if (c == null) {
            return false;
        }
        return c.isUnit();
    }

    public boolean isConstant() {
        if (this.val.size() != 1) {
            return false;
        }
        RingElem c = (RingElem)this.val.get(this.ring.wone);
        return c != null;
    }

    public boolean isHomogeneous() {
        if (this.val.size() <= 1) {
            return true;
        }
        long deg = -1L;
        for (Word e : this.val.keySet()) {
            if (deg < 0L) {
                deg = e.degree();
                continue;
            }
            if (deg == e.degree()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object B) {
        if (B == null) {
            return false;
        }
        if (!(B instanceof GenWordPolynomial)) {
            return false;
        }
        GenWordPolynomial a = (GenWordPolynomial)B;
        return this.compareTo(a) == 0;
    }

    @Override
    public int hashCode() {
        int h = this.ring.hashCode() << 27;
        return h += this.val.hashCode();
    }

    @Override
    public int compareTo(GenWordPolynomial<C> b) {
        if (b == null) {
            return 1;
        }
        SortedMap<Word, C> av = this.val;
        SortedMap<Word, C> bv = b.val;
        Iterator<Map.Entry<Word, C>> ai = av.entrySet().iterator();
        Iterator<Map.Entry<Word, C>> bi = bv.entrySet().iterator();
        int s = 0;
        int c = 0;
        while (ai.hasNext() && bi.hasNext()) {
            Word be;
            Map.Entry<Word, C> aie = ai.next();
            Map.Entry<Word, C> bie = bi.next();
            Word ae = aie.getKey();
            s = ae.compareTo(be = bie.getKey());
            if (s != 0) {
                return s;
            }
            if (c != 0) continue;
            RingElem ac = (RingElem)aie.getValue();
            RingElem bc = (RingElem)bie.getValue();
            c = ac.compareTo(bc);
        }
        if (ai.hasNext()) {
            return 1;
        }
        if (bi.hasNext()) {
            return -1;
        }
        return c;
    }

    @Override
    public int signum() {
        if (this.isZERO()) {
            return 0;
        }
        Word t = this.val.firstKey();
        RingElem c = (RingElem)this.val.get(t);
        return c.signum();
    }

    public int numberOfVariables() {
        return this.ring.alphabet.length();
    }

    public Map.Entry<Word, C> leadingMonomial() {
        if (this.val.size() == 0) {
            return null;
        }
        Iterator<Map.Entry<Word, C>> ai = this.val.entrySet().iterator();
        return ai.next();
    }

    public Word leadingWord() {
        if (this.val.size() == 0) {
            return this.ring.wone;
        }
        return this.val.firstKey();
    }

    public Word trailingWord() {
        if (this.val.size() == 0) {
            return this.ring.wone;
        }
        return this.val.lastKey();
    }

    public C leadingBaseCoefficient() {
        if (this.val.size() == 0) {
            return (C)((RingElem)this.ring.coFac.getZERO());
        }
        return (C)((RingElem)this.val.get(this.val.firstKey()));
    }

    public C trailingBaseCoefficient() {
        RingElem c = (RingElem)this.val.get(this.ring.wone);
        if (c == null) {
            return (C)((RingElem)this.ring.coFac.getZERO());
        }
        return (C)c;
    }

    public C coefficient(Word e) {
        RingElem c = (RingElem)this.val.get(e);
        if (c == null) {
            c = (RingElem)this.ring.coFac.getZERO();
        }
        return (C)c;
    }

    public GenWordPolynomial<C> reductum() {
        if (this.val.size() <= 1) {
            return this.ring.getZERO();
        }
        Iterator<Word> ai = this.val.keySet().iterator();
        Word lt = ai.next();
        lt = ai.next();
        SortedMap<Word, C> red = this.val.tailMap(lt);
        return new GenWordPolynomial<C>(this.ring, red);
    }

    public long degree() {
        if (this.val.size() == 0) {
            return 0L;
        }
        long deg = 0L;
        for (Word e : this.val.keySet()) {
            long d = e.degree();
            if (d <= deg) continue;
            deg = d;
        }
        return deg;
    }

    public C maxNorm() {
        RingElem n = this.ring.getZEROCoefficient();
        for (RingElem c : this.val.values()) {
            RingElem x = (RingElem)c.abs();
            if (n.compareTo((RingElem)x) >= 0) continue;
            n = x;
        }
        return (C)n;
    }

    public C sumNorm() {
        RingElem n = this.ring.getZEROCoefficient();
        for (RingElem c : this.val.values()) {
            RingElem x = (RingElem)c.abs();
            n = n.sum((RingElem)x);
        }
        return (C)n;
    }

    @Override
    public GenWordPolynomial<C> sum(GenWordPolynomial<C> S) {
        if (S == null) {
            return this;
        }
        if (S.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S;
        }
        assert (this.ring.alphabet == S.ring.alphabet);
        Element n = this.copy();
        SortedMap<Word, C> nv = ((GenWordPolynomial)n).val;
        SortedMap<Word, C> sv = S.val;
        for (Map.Entry<Word, C> me : sv.entrySet()) {
            Word e = me.getKey();
            RingElem y = (RingElem)me.getValue();
            RingElem x = (RingElem)nv.get(e);
            if (x != null) {
                if (!(x = x.sum(y)).isZERO()) {
                    nv.put(e, x);
                    continue;
                }
                nv.remove(e);
                continue;
            }
            nv.put(e, y);
        }
        return n;
    }

    public GenWordPolynomial<C> sum(C a, Word e) {
        if (a == null) {
            return this;
        }
        if (a.isZERO()) {
            return this;
        }
        Element n = this.copy();
        SortedMap<Word, C> nv = ((GenWordPolynomial)n).val;
        RingElem x = (RingElem)nv.get(e);
        if (x != null) {
            if (!(x = (RingElem)x.sum(a)).isZERO()) {
                nv.put(e, x);
            } else {
                nv.remove(e);
            }
        } else {
            nv.put(e, a);
        }
        return n;
    }

    @Override
    public GenWordPolynomial<C> sum(C a) {
        return this.sum(a, this.ring.wone);
    }

    @Override
    public GenWordPolynomial<C> subtract(GenWordPolynomial<C> S) {
        if (S == null) {
            return this;
        }
        if (S.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S.negate();
        }
        assert (this.ring.alphabet == S.ring.alphabet);
        Element n = this.copy();
        SortedMap<Word, C> nv = ((GenWordPolynomial)n).val;
        SortedMap<Word, C> sv = S.val;
        for (Map.Entry<Word, C> me : sv.entrySet()) {
            Word e = me.getKey();
            RingElem y = (RingElem)me.getValue();
            RingElem x = (RingElem)nv.get(e);
            if (x != null) {
                if (!(x = x.subtract(y)).isZERO()) {
                    nv.put(e, x);
                    continue;
                }
                nv.remove(e);
                continue;
            }
            nv.put(e, y.negate());
        }
        return n;
    }

    public GenWordPolynomial<C> subtract(C a, Word e) {
        if (a == null) {
            return this;
        }
        if (a.isZERO()) {
            return this;
        }
        Element n = this.copy();
        SortedMap<Word, C> nv = ((GenWordPolynomial)n).val;
        RingElem x = (RingElem)nv.get(e);
        if (x != null) {
            if (!(x = (RingElem)x.subtract(a)).isZERO()) {
                nv.put(e, x);
            } else {
                nv.remove(e);
            }
        } else {
            nv.put(e, a.negate());
        }
        return n;
    }

    @Override
    public GenWordPolynomial<C> subtract(C a) {
        return this.subtract(a, this.ring.wone);
    }

    @Override
    public GenWordPolynomial<C> negate() {
        Element n = ((GenWordPolynomial)this.ring.getZERO()).copy();
        SortedMap<Word, C> v = ((GenWordPolynomial)n).val;
        for (Map.Entry<Word, C> m : this.val.entrySet()) {
            RingElem x = (RingElem)m.getValue();
            v.put(m.getKey(), x.negate());
        }
        return n;
    }

    @Override
    public GenWordPolynomial<C> abs() {
        if (this.leadingBaseCoefficient().signum() < 0) {
            return this.negate();
        }
        return this;
    }

    @Override
    public GenWordPolynomial<C> multiply(GenWordPolynomial<C> S) {
        if (S == null) {
            return this.ring.getZERO();
        }
        if (S.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        assert (this.ring.alphabet == S.ring.alphabet);
        Element p = ((GenWordPolynomial)this.ring.getZERO()).copy();
        SortedMap<Word, C> pv = ((GenWordPolynomial)p).val;
        for (Map.Entry<Word, C> m1 : this.val.entrySet()) {
            RingElem c1 = (RingElem)m1.getValue();
            Word e1 = m1.getKey();
            for (Map.Entry<Word, C> m2 : S.val.entrySet()) {
                RingElem c2 = (RingElem)m2.getValue();
                Word e2 = m2.getKey();
                RingElem c = c1.multiply(c2);
                if (c.isZERO()) continue;
                Word e = e1.multiply(e2);
                RingElem c0 = (RingElem)pv.get(e);
                if (c0 == null) {
                    pv.put(e, c);
                    continue;
                }
                if (!(c0 = c0.sum(c)).isZERO()) {
                    pv.put(e, c0);
                    continue;
                }
                pv.remove(e);
            }
        }
        return p;
    }

    public GenWordPolynomial<C> multiply(GenWordPolynomial<C> S, GenWordPolynomial<C> T) {
        if (S.isZERO() || T.isZERO()) {
            return this.ring.getZERO();
        }
        if (S.isONE()) {
            return this.multiply((C)T);
        }
        if (T.isONE()) {
            return S.multiply(this);
        }
        return S.multiply(this).multiply(T);
    }

    @Override
    public GenWordPolynomial<C> multiply(C s) {
        if (s == null) {
            return this.ring.getZERO();
        }
        if (s.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        Element p = ((GenWordPolynomial)this.ring.getZERO()).copy();
        SortedMap<Word, C> pv = ((GenWordPolynomial)p).val;
        for (Map.Entry<Word, C> m1 : this.val.entrySet()) {
            RingElem c1 = (RingElem)m1.getValue();
            Word e1 = m1.getKey();
            RingElem c = (RingElem)c1.multiply(s);
            if (c.isZERO()) continue;
            pv.put(e1, c);
        }
        return p;
    }

    public GenWordPolynomial<C> multiply(C s, C t) {
        if (s == null || t == null) {
            return this.ring.getZERO();
        }
        if (s.isZERO() || t.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        Element p = ((GenWordPolynomial)this.ring.getZERO()).copy();
        SortedMap<Word, C> pv = ((GenWordPolynomial)p).val;
        for (Map.Entry<Word, C> m1 : this.val.entrySet()) {
            RingElem c1 = (RingElem)m1.getValue();
            Word e = m1.getKey();
            RingElem c = (RingElem)s.multiply((RingElem)c1).multiply(t);
            if (c.isZERO()) continue;
            pv.put(e, c);
        }
        return p;
    }

    public GenWordPolynomial<C> monic() {
        if (this.isZERO()) {
            return this;
        }
        C lc = this.leadingBaseCoefficient();
        if (!lc.isUnit()) {
            return this;
        }
        RingElem lm = (RingElem)lc.inverse();
        return this.multiply((C)lm);
    }

    public GenWordPolynomial<C> multiply(C s, Word e) {
        if (s == null) {
            return this.ring.getZERO();
        }
        if (s.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        Element p = ((GenWordPolynomial)this.ring.getZERO()).copy();
        SortedMap<Word, C> pv = ((GenWordPolynomial)p).val;
        for (Map.Entry<Word, C> m1 : this.val.entrySet()) {
            RingElem c1 = (RingElem)m1.getValue();
            Word e1 = m1.getKey();
            RingElem c = (RingElem)c1.multiply(s);
            if (c.isZERO()) continue;
            Word e2 = e1.multiply(e);
            pv.put(e2, c);
        }
        return p;
    }

    public GenWordPolynomial<C> multiply(Word e, Word f) {
        if (this.isZERO()) {
            return this;
        }
        if (e.isONE()) {
            return this.multiply(f);
        }
        Element p = ((GenWordPolynomial)this.ring.getZERO()).copy();
        SortedMap<Word, C> pv = ((GenWordPolynomial)p).val;
        for (Map.Entry<Word, C> m1 : this.val.entrySet()) {
            RingElem c = (RingElem)m1.getValue();
            Word e1 = m1.getKey();
            Word e2 = e.multiply(e1.multiply(f));
            pv.put(e2, c);
        }
        return p;
    }

    public GenWordPolynomial<C> multiply(C s, Word e, Word f) {
        if (s == null) {
            return this.ring.getZERO();
        }
        if (s.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        if (e.isONE()) {
            return this.multiply(s, f);
        }
        RingElem c = (RingElem)this.ring.coFac.getONE();
        return this.multiply(c, e, s, f);
    }

    public GenWordPolynomial<C> multiply(C s, Word e, C t, Word f) {
        if (s == null) {
            return this.ring.getZERO();
        }
        if (s.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        Element p = ((GenWordPolynomial)this.ring.getZERO()).copy();
        SortedMap<Word, C> pv = ((GenWordPolynomial)p).val;
        for (Map.Entry<Word, C> m1 : this.val.entrySet()) {
            RingElem c1 = (RingElem)m1.getValue();
            RingElem c = (RingElem)s.multiply((RingElem)c1).multiply(t);
            if (c.isZERO()) continue;
            Word e1 = m1.getKey();
            Word e2 = e.multiply(e1).multiply(f);
            pv.put(e2, c);
        }
        return p;
    }

    @Override
    public GenWordPolynomial<C> multiply(Word e) {
        if (this.isZERO()) {
            return this;
        }
        Element p = ((GenWordPolynomial)this.ring.getZERO()).copy();
        SortedMap<Word, C> pv = ((GenWordPolynomial)p).val;
        for (Map.Entry<Word, C> m1 : this.val.entrySet()) {
            RingElem c1 = (RingElem)m1.getValue();
            Word e1 = m1.getKey();
            Word e2 = e1.multiply(e);
            pv.put(e2, c1);
        }
        return p;
    }

    @Override
    public GenWordPolynomial<C> multiply(Map.Entry<Word, C> m) {
        if (m == null) {
            return this.ring.getZERO();
        }
        return this.multiply((C)((RingElem)m.getValue()), m.getKey());
    }

    @Override
    public GenWordPolynomial<C> divide(C s) {
        if (s == null || s.isZERO()) {
            throw new ArithmeticException(this.getClass().getName() + " division by zero");
        }
        if (this.isZERO()) {
            return this;
        }
        Element p = ((GenWordPolynomial)this.ring.getZERO()).copy();
        SortedMap<Word, C> pv = ((GenWordPolynomial)p).val;
        for (Map.Entry<Word, C> m : this.val.entrySet()) {
            RingElem x;
            Word e = m.getKey();
            RingElem c1 = (RingElem)m.getValue();
            RingElem c = (RingElem)c1.divide(s);
            if (this.debug && !(x = (RingElem)c1.remainder(s)).isZERO()) {
                logger.info((Object)("divide x = " + x));
                throw new ArithmeticException(this.getClass().getName() + " no exact division: " + c1 + "/" + s);
            }
            if (c.isZERO()) {
                throw new ArithmeticException(this.getClass().getName() + " no exact division: " + c1 + "/" + s + ", in " + this);
            }
            pv.put(e, c);
        }
        return p;
    }

    public GenWordPolynomial<C>[] quotientRemainder(GenWordPolynomial<C> S) {
        Word f;
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(this.getClass().getName() + " division by zero");
        }
        C c = S.leadingBaseCoefficient();
        if (!c.isUnit()) {
            throw new ArithmeticException(this.getClass().getName() + " lbcf not invertible " + c);
        }
        RingElem ci = (RingElem)c.inverse();
        RingElem one = (RingElem)this.ring.coFac.getONE();
        assert (this.ring.alphabet == S.ring.alphabet);
        WordFactory.WordComparator cmp = this.ring.alphabet.getDescendComparator();
        Word e = S.leadingWord();
        GenWordPolynomial<C> q = ((GenWordPolynomial)this.ring.getZERO()).copy();
        GenWordPolynomial<GenWordPolynomial<RingElem>> r = this.copy();
        while (!r.isZERO() && (f = r.leadingWord()).multipleOf(e)) {
            RingElem a = r.leadingBaseCoefficient();
            Word[] g = f.divideWord(e);
            a = a.multiply((RingElem)ci);
            q = q.sum(a, g[0].multiply(g[1]));
            GenWordPolynomial<RingElem> h = S.multiply(a, g[0], one, g[1]);
            Word fr = (r = r.subtract(h)).leadingWord();
            if (cmp.compare(f, fr) <= 0) continue;
            throw new RuntimeException("possible infinite loop: f = " + f + ", fr = " + fr);
        }
        GenWordPolynomial[] ret = new GenWordPolynomial[]{q, r};
        return ret;
    }

    @Override
    public GenWordPolynomial<C> divide(GenWordPolynomial<C> S) {
        return this.quotientRemainder(S)[0];
    }

    @Override
    public GenWordPolynomial<C> remainder(GenWordPolynomial<C> S) {
        Word f;
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(this.getClass().getName() + " division by zero");
        }
        C c = S.leadingBaseCoefficient();
        if (!c.isUnit()) {
            throw new ArithmeticException(this.getClass().getName() + " lbc not invertible " + c);
        }
        RingElem ci = (RingElem)c.inverse();
        RingElem one = (RingElem)this.ring.coFac.getONE();
        assert (this.ring.alphabet == S.ring.alphabet);
        WordFactory.WordComparator cmp = this.ring.alphabet.getDescendComparator();
        Word e = S.leadingWord();
        GenWordPolynomial<GenWordPolynomial<RingElem>> r = this.copy();
        while (!r.isZERO() && (f = r.leadingWord()).multipleOf(e)) {
            RingElem a = r.leadingBaseCoefficient();
            Word[] g = f.divideWord(e);
            GenWordPolynomial<RingElem> h = S.multiply(a = a.multiply((RingElem)ci), g[0], one, g[1]);
            Word fr = (r = r.subtract(h)).leadingWord();
            if (cmp.compare(f, fr) <= 0) continue;
            throw new RuntimeException("possible infinite loop: f = " + f + ", fr = " + fr);
        }
        return r;
    }

    @Override
    public GenWordPolynomial<C> gcd(GenWordPolynomial<C> S) {
        if (S == null || S.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S;
        }
        if (this.ring.alphabet.length() != 1) {
            throw new IllegalArgumentException("no univariate polynomial " + this.ring);
        }
        GenWordPolynomial<C> q = this;
        GenWordPolynomial<C> r = S;
        while (!r.isZERO()) {
            GenWordPolynomial<C> x = q.remainder(r);
            q = r;
            r = x;
        }
        return q.monic();
    }

    public GenWordPolynomial<C>[] egcd(GenWordPolynomial<C> S) {
        GenWordPolynomial[] ret = new GenWordPolynomial[]{null, null, null};
        if (S == null || S.isZERO()) {
            ret[0] = this;
            ret[1] = this.ring.getONE();
            ret[2] = this.ring.getZERO();
            return ret;
        }
        if (this.isZERO()) {
            ret[0] = S;
            ret[1] = this.ring.getZERO();
            ret[2] = this.ring.getONE();
            return ret;
        }
        if (this.ring.alphabet.length() != 1) {
            throw new IllegalArgumentException("no univariate polynomial " + this.ring);
        }
        if (this.isConstant() && S.isConstant()) {
            C t = this.leadingBaseCoefficient();
            C s = S.leadingBaseCoefficient();
            RingElem[] gg = t.egcd(s);
            AbelianGroupElem z = this.ring.getZERO();
            ret[0] = ((GenWordPolynomial)z).sum((C)gg[0]);
            ret[1] = ((GenWordPolynomial)z).sum((C)gg[1]);
            ret[2] = ((GenWordPolynomial)z).sum((C)gg[2]);
            return ret;
        }
        GenWordPolynomial q = this;
        GenWordPolynomial<C> r = S;
        GenWordPolynomial<RingElem<Object>> c1 = ((GenWordPolynomial)this.ring.getONE()).copy();
        GenWordPolynomial<GenWordPolynomial<Element>> d1 = ((GenWordPolynomial)this.ring.getZERO()).copy();
        GenWordPolynomial<RingElem<Object>> c2 = ((GenWordPolynomial)this.ring.getZERO()).copy();
        GenWordPolynomial<GenWordPolynomial<Element>> d2 = ((GenWordPolynomial)this.ring.getONE()).copy();
        while (!r.isZERO()) {
            GenWordPolynomial<C>[] qr = q.quotientRemainder(r);
            q = qr[0];
            GenWordPolynomial<GenWordPolynomial<Element>> x1 = c1.subtract((RingElem<Object>)q.multiply((C)d1));
            GenWordPolynomial<GenWordPolynomial<Element>> x2 = c2.subtract((RingElem<Object>)q.multiply((C)d2));
            c1 = d1;
            c2 = d2;
            d1 = x1;
            d2 = x2;
            q = r;
            r = qr[1];
        }
        C g = q.leadingBaseCoefficient();
        if (g.isUnit()) {
            RingElem h = (RingElem)g.inverse();
            q = q.multiply((C)h);
            c1 = c1.multiply(h);
            c2 = c2.multiply(h);
        }
        ret[0] = q;
        ret[1] = c1;
        ret[2] = c2;
        return ret;
    }

    public GenWordPolynomial<C>[] hegcd(GenWordPolynomial<C> S) {
        GenWordPolynomial[] ret = new GenWordPolynomial[]{null, null};
        if (S == null || S.isZERO()) {
            ret[0] = this;
            ret[1] = this.ring.getONE();
            return ret;
        }
        if (this.isZERO()) {
            ret[0] = S;
            return ret;
        }
        if (this.ring.alphabet.length() != 1) {
            throw new IllegalArgumentException("no univariate polynomial " + this.ring);
        }
        GenWordPolynomial<RingElem> q = this;
        GenWordPolynomial<C> r = S;
        GenWordPolynomial<RingElem> c1 = ((GenWordPolynomial)this.ring.getONE()).copy();
        GenWordPolynomial<GenWordPolynomial<Element>> d1 = ((GenWordPolynomial)this.ring.getZERO()).copy();
        while (!r.isZERO()) {
            GenWordPolynomial<C>[] qr = q.quotientRemainder(r);
            q = qr[0];
            GenWordPolynomial<GenWordPolynomial<Element>> x1 = c1.subtract(q.multiply(d1));
            c1 = d1;
            d1 = x1;
            q = r;
            r = qr[1];
        }
        C g = q.leadingBaseCoefficient();
        if (g.isUnit()) {
            RingElem h = (RingElem)g.inverse();
            q = q.multiply(h);
            c1 = c1.multiply(h);
        }
        ret[0] = q;
        ret[1] = c1;
        return ret;
    }

    @Override
    public GenWordPolynomial<C> inverse() {
        if (this.isUnit()) {
            RingElem c = (RingElem)this.leadingBaseCoefficient().inverse();
            return ((GenWordPolynomial)this.ring.getONE()).multiply((C)c);
        }
        throw new NotInvertibleException("element not invertible " + this + " :: " + this.ring);
    }

    public GenWordPolynomial<C> modInverse(GenWordPolynomial<C> m) {
        if (this.isZERO()) {
            throw new NotInvertibleException("zero is not invertible");
        }
        GenWordPolynomial<C>[] hegcd = this.hegcd(m);
        GenWordPolynomial<C> a = hegcd[0];
        if (!a.isUnit()) {
            throw new NotInvertibleException("element not invertible, gcd != 1");
        }
        GenWordPolynomial<C> b = hegcd[1];
        if (b.isZERO()) {
            throw new NotInvertibleException("element not invertible, divisible by modul");
        }
        return b;
    }

    public Iterator<C> coefficientIterator() {
        return this.val.values().iterator();
    }

    public Iterator<Word> wordIterator() {
        return this.val.keySet().iterator();
    }

    @Override
    public Iterator<WordMonomial<C>> iterator() {
        return new WordPolyIterator<C>(this.val);
    }

    public GenWordPolynomial<C> map(UnaryFunctor<? super C, C> f) {
        Element n = ((GenWordPolynomial)this.ring.getZERO()).copy();
        SortedMap<Word, C> nv = ((GenWordPolynomial)n).val;
        for (WordMonomial<C> m : this) {
            RingElem c = (RingElem)f.eval(m.c);
            if (c == null || c.isZERO()) continue;
            nv.put(m.e, c);
        }
        return n;
    }
}

