/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.PrettyPrint;
import edu.jas.kern.Scripting;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.poly.RelationGenerator;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class GenSolvablePolynomialRing<C extends RingElem<C>>
extends GenPolynomialRing<C> {
    public final RelationTable<C> table;
    public final GenSolvablePolynomial<C> ZERO;
    public final GenSolvablePolynomial<C> ONE;
    private static final Logger logger = Logger.getLogger(GenSolvablePolynomialRing.class);
    private final boolean debug = logger.isDebugEnabled();

    public GenSolvablePolynomialRing(RingFactory<C> cf, int n) {
        this(cf, n, new TermOrder(), null, null);
    }

    public GenSolvablePolynomialRing(RingFactory<C> cf, int n, RelationTable<C> rt) {
        this(cf, n, new TermOrder(), null, rt);
    }

    public GenSolvablePolynomialRing(RingFactory<C> cf, int n, TermOrder t) {
        this(cf, n, t, null, null);
    }

    public GenSolvablePolynomialRing(RingFactory<C> cf, int n, TermOrder t, RelationTable<C> rt) {
        this(cf, n, t, null, rt);
    }

    public GenSolvablePolynomialRing(RingFactory<C> cf, int n, TermOrder t, String[] v) {
        this(cf, n, t, v, null);
    }

    public GenSolvablePolynomialRing(RingFactory<C> cf, TermOrder t, String[] v) {
        this(cf, v.length, t, v, null);
    }

    public GenSolvablePolynomialRing(RingFactory<C> cf, String[] v) {
        this(cf, v.length, new TermOrder(), v, null);
    }

    public GenSolvablePolynomialRing(RingFactory<C> cf, int n, TermOrder t, String[] v, RelationTable<C> rt) {
        super(cf, n, t, v);
        this.table = rt == null ? new RelationTable(this) : rt;
        this.ZERO = new GenSolvablePolynomial(this);
        RingElem coeff = (RingElem)this.coFac.getONE();
        this.ONE = new GenSolvablePolynomial<RingElem>(this, coeff, this.evzero);
    }

    public GenSolvablePolynomialRing(RingFactory<C> cf, GenSolvablePolynomialRing o) {
        this(cf, o.nvar, o.tord, o.getVars(), null);
    }

    public void addRelations(RelationGenerator<C> rg) {
        rg.generate(this);
    }

    public void addRelations(List<GenPolynomial<C>> rel) {
        this.table.addRelations(rel);
    }

    public void addSolvRelations(List<GenSolvablePolynomial<C>> rel) {
        this.table.addSolvRelations(rel);
    }

    @Override
    public String toString() {
        String res = super.toString();
        res = PrettyPrint.isTrue() ? res + "\n" + this.table.toString(this.vars) : res + ", #rel = " + this.table.size();
        return res;
    }

    @Override
    public String toScript() {
        StringBuffer s = new StringBuffer();
        switch (Scripting.getLang()) {
            case Ruby: {
                s.append("SolvPolyRing.new(");
                break;
            }
            default: {
                s.append("SolvPolyRing(");
            }
        }
        if (this.coFac instanceof RingElem) {
            s.append(((RingElem)((Object)this.coFac)).toScriptFactory());
        } else {
            s.append(this.coFac.toScript().trim());
        }
        s.append(",\"" + this.varsToString() + "\",");
        String to = this.tord.toString();
        if (this.tord.getEvord() == 2) {
            to = "PolyRing.lex";
        }
        if (this.tord.getEvord() == 4) {
            to = "PolyRing.grad";
        }
        s.append(to);
        if (this.table.size() > 0) {
            String rel = this.table.toScript();
            s.append(",rel=");
            s.append(rel);
        }
        s.append(")");
        return s.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof GenSolvablePolynomialRing)) {
            return false;
        }
        GenSolvablePolynomialRing oring = (GenSolvablePolynomialRing)other;
        if (!super.equals(other)) {
            return false;
        }
        return this.table.equals(oring.table);
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        h = 37 * h + this.table.hashCode();
        return h;
    }

    @Override
    public GenSolvablePolynomial<C> getZERO() {
        return this.ZERO;
    }

    @Override
    public GenSolvablePolynomial<C> getONE() {
        return this.ONE;
    }

    @Override
    public boolean isCommutative() {
        if (this.table.isEmpty()) {
            return super.isCommutative();
        }
        return false;
    }

    @Override
    public boolean isAssociative() {
        for (int i = 0; i < this.nvar; ++i) {
            GenPolynomial Xi = this.univariate(i);
            for (int j = i + 1; j < this.nvar; ++j) {
                GenPolynomial Xj = this.univariate(j);
                for (int k = j + 1; k < this.nvar; ++k) {
                    GenSolvablePolynomial<GenSolvablePolynomial<GenPolynomial>> q;
                    GenPolynomial Xk = this.univariate(k);
                    GenSolvablePolynomial<GenPolynomial> p = ((GenSolvablePolynomial)Xk).multiply(Xj).multiply(Xi);
                    if (p.equals(q = ((GenSolvablePolynomial)Xk).multiply(((GenSolvablePolynomial)Xj).multiply(Xi)))) continue;
                    logger.info((Object)("Xi = " + Xi + ", Xj = " + Xj + ", Xk = " + Xk));
                    logger.info((Object)("p = ( Xk * Xj ) * Xi = " + p));
                    logger.info((Object)("q = Xk * ( Xj * Xi ) = " + q));
                    return false;
                }
            }
        }
        return this.coFac.isAssociative();
    }

    @Override
    public GenSolvablePolynomial<C> fromInteger(long a) {
        return new GenSolvablePolynomial<RingElem>(this, (RingElem)this.coFac.fromInteger(a), this.evzero);
    }

    @Override
    public GenSolvablePolynomial<C> fromInteger(BigInteger a) {
        return new GenSolvablePolynomial<RingElem>(this, (RingElem)this.coFac.fromInteger(a), this.evzero);
    }

    @Override
    public GenSolvablePolynomial<C> random(int n) {
        return this.random(n, random);
    }

    @Override
    public GenSolvablePolynomial<C> random(int n, Random rnd) {
        if (this.nvar == 1) {
            return this.random(5, n, n, 0.7f, rnd);
        }
        return this.random(5, n, 3, 0.3f, rnd);
    }

    @Override
    public GenSolvablePolynomial<C> random(int k, int l, int d, float q) {
        return this.random(k, l, d, q, random);
    }

    @Override
    public GenSolvablePolynomial<C> random(int k, int l, int d, float q, Random rnd) {
        GenPolynomial r = this.getZERO();
        for (int i = 0; i < l; ++i) {
            ExpVector e = ExpVector.EVRAND(this.nvar, d, q, rnd);
            RingElem a = (RingElem)this.coFac.random(k, rnd);
            r = (GenSolvablePolynomial)r.sum(a, e);
        }
        return r;
    }

    @Override
    public GenSolvablePolynomial<C> copy(GenSolvablePolynomial<C> c) {
        return new GenSolvablePolynomial(this, c.val);
    }

    @Override
    public GenSolvablePolynomial<C> parse(String s) {
        return this.parse(new StringReader(s));
    }

    @Override
    public GenSolvablePolynomial<C> parse(Reader r) {
        GenPolynomialTokenizer pt = new GenPolynomialTokenizer(this, r);
        GenSolvablePolynomial<C> p = null;
        try {
            p = pt.nextSolvablePolynomial();
        }
        catch (IOException e) {
            logger.error((Object)(e.toString() + " parse " + this));
            p = this.ZERO;
        }
        return p;
    }

    @Override
    public GenSolvablePolynomial<C> univariate(int i) {
        return (GenSolvablePolynomial)super.univariate(i);
    }

    @Override
    public GenSolvablePolynomial<C> univariate(int i, long e) {
        return (GenSolvablePolynomial)super.univariate(i, e);
    }

    @Override
    public GenSolvablePolynomial<C> univariate(int modv, int i, long e) {
        return (GenSolvablePolynomial)super.univariate(modv, i, e);
    }

    @Override
    public List<GenSolvablePolynomial<C>> univariateList() {
        return this.univariateList(0, 1L);
    }

    @Override
    public List<GenSolvablePolynomial<C>> univariateList(int modv) {
        return this.univariateList(modv, 1L);
    }

    @Override
    public List<GenSolvablePolynomial<C>> univariateList(int modv, long e) {
        ArrayList<GenSolvablePolynomial<C>> pols = new ArrayList<GenSolvablePolynomial<C>>(this.nvar);
        int nm = this.nvar - modv;
        for (int i = 0; i < nm; ++i) {
            GenPolynomial p = this.univariate(modv, nm - 1 - i, e);
            pols.add((GenSolvablePolynomial<C>)p);
        }
        return pols;
    }

    @Override
    public GenSolvablePolynomialRing<C> extend(int i) {
        GenPolynomialRing pfac = super.extend(i);
        GenSolvablePolynomialRing spfac = new GenSolvablePolynomialRing(pfac.coFac, pfac.nvar, pfac.tord, pfac.vars);
        spfac.table.extend(this.table);
        return spfac;
    }

    @Override
    public GenSolvablePolynomialRing<C> extend(String[] vn) {
        GenPolynomialRing pfac = super.extend(vn);
        GenSolvablePolynomialRing spfac = new GenSolvablePolynomialRing(pfac.coFac, pfac.nvar, pfac.tord, pfac.vars);
        spfac.table.extend(this.table);
        return spfac;
    }

    @Override
    public GenSolvablePolynomialRing<C> contract(int i) {
        GenPolynomialRing pfac = super.contract(i);
        GenSolvablePolynomialRing spfac = new GenSolvablePolynomialRing(pfac.coFac, pfac.nvar, pfac.tord, pfac.vars);
        spfac.table.contract(this.table);
        return spfac;
    }

    @Override
    public GenSolvablePolynomialRing<C> reverse() {
        return this.reverse(false);
    }

    @Override
    public GenSolvablePolynomialRing<C> reverse(boolean partial) {
        GenPolynomialRing pfac = super.reverse(partial);
        GenSolvablePolynomialRing spfac = new GenSolvablePolynomialRing(pfac.coFac, pfac.nvar, pfac.tord, pfac.vars);
        spfac.partial = partial;
        spfac.table.reverse(this.table);
        return spfac;
    }

    @Override
    public GenSolvablePolynomialRing<GenPolynomial<C>> recursive(int i) {
        if (i <= 0 || i >= this.nvar) {
            throw new IllegalArgumentException("wrong: 0 < " + i + " < " + this.nvar);
        }
        GenPolynomialRing cfac = this.contract(i);
        String[] v = null;
        if (this.vars != null) {
            v = new String[i];
            int k = 0;
            for (int j = this.nvar - i; j < this.nvar; ++j) {
                v[k++] = this.vars[j];
            }
        }
        TermOrder to = this.tord.contract(0, i);
        RecSolvablePolynomialRing pfac = new RecSolvablePolynomialRing(cfac, i, to, v);
        pfac.table.recursive(this.table);
        pfac.coeffTable.recursive(this.table);
        return pfac;
    }

    @Override
    public GenSolvablePolynomialRing<C> distribute() {
        RingFactory cf;
        if (!(this.coFac instanceof GenPolynomialRing)) {
            return this;
        }
        RingFactory cfp = cf = this.coFac;
        GenPolynomialRing cr = (GenPolynomialRing)cfp;
        GenPolynomialRing fac = cr.vars != null ? cr.extend(this.vars) : cr.extend(this.nvar);
        GenSolvablePolynomialRing pfac = new GenSolvablePolynomialRing(fac.coFac, fac.nvar, this.tord, fac.vars);
        if (fac instanceof GenSolvablePolynomialRing) {
            GenSolvablePolynomialRing sfac = (GenSolvablePolynomialRing)fac;
            List<GenSolvablePolynomial<C>> rlc = sfac.table.relationList();
            pfac.table.addSolvRelations(rlc);
        }
        List rl = PolynomialList.castToList(this.table.relationList());
        List rld = PolyUtil.distribute(pfac, rl);
        pfac.table.addRelations(rld);
        return pfac;
    }
}

