/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.ModIntegerRing;
import edu.jas.kern.PreemptStatus;
import edu.jas.kern.PrettyPrint;
import edu.jas.kern.Scripting;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialIterator;
import edu.jas.poly.GenPolynomialMonomialIterator;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolynomialComparator;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.log4j.Logger;

public class GenPolynomialRing<C extends RingElem<C>>
implements RingFactory<GenPolynomial<C>>,
Iterable<GenPolynomial<C>> {
    public final RingFactory<C> coFac;
    public final int nvar;
    public final TermOrder tord;
    protected boolean partial;
    protected String[] vars;
    private static Set<String> knownVars = new HashSet<String>();
    public final GenPolynomial<C> ZERO;
    public final GenPolynomial<C> ONE;
    public final ExpVector evzero;
    protected static final Random random = new Random();
    protected int isField = -1;
    private static final Logger logger = Logger.getLogger(GenPolynomialRing.class);
    final boolean checkPreempt = PreemptStatus.isAllowed();

    public GenPolynomialRing(RingFactory<C> cf, int n) {
        this(cf, n, new TermOrder(), null);
    }

    public GenPolynomialRing(RingFactory<C> cf, int n, TermOrder t) {
        this(cf, n, t, null);
    }

    public GenPolynomialRing(RingFactory<C> cf, String[] v) {
        this(cf, v.length, v);
    }

    public GenPolynomialRing(RingFactory<C> cf, int n, String[] v) {
        this(cf, n, new TermOrder(), v);
    }

    public GenPolynomialRing(RingFactory<C> cf, TermOrder t, String[] v) {
        this(cf, v.length, t, v);
    }

    public GenPolynomialRing(RingFactory<C> cf, String[] v, TermOrder t) {
        this(cf, v.length, t, v);
    }

    public GenPolynomialRing(RingFactory<C> cf, int n, TermOrder t, String[] v) {
        this.coFac = cf;
        this.nvar = n;
        this.tord = t;
        this.partial = false;
        this.vars = v == null ? null : Arrays.copyOf(v, v.length);
        this.ZERO = new GenPolynomial(this);
        RingElem coeff = (RingElem)this.coFac.getONE();
        this.evzero = ExpVector.create(this.nvar);
        this.ONE = new GenPolynomial<RingElem>(this, coeff, this.evzero);
        if (this.vars == null) {
            if (PrettyPrint.isTrue()) {
                this.vars = GenPolynomialRing.newVars("x", this.nvar);
            }
        } else {
            if (this.vars.length != this.nvar) {
                throw new IllegalArgumentException("incompatible variable size " + this.vars.length + ", " + this.nvar);
            }
            GenPolynomialRing.addVars(this.vars);
        }
    }

    public GenPolynomialRing(RingFactory<C> cf, GenPolynomialRing o) {
        this(cf, o.nvar, o.tord, o.vars);
    }

    public GenPolynomialRing(GenPolynomialRing<C> o, TermOrder to) {
        this(o.coFac, o.nvar, to, o.vars);
    }

    public GenPolynomialRing<C> copy() {
        return new GenPolynomialRing<C>(this.coFac, this);
    }

    public String toString() {
        String res = null;
        if (PrettyPrint.isTrue()) {
            String scf = this.coFac.getClass().getSimpleName();
            if (this.coFac instanceof AlgebraicNumberRing) {
                AlgebraicNumberRing an = (AlgebraicNumberRing)this.coFac;
                res = "AN[ (" + an.ring.varsToString() + ") (" + an.toString() + ") ]";
            }
            if (this.coFac instanceof GenPolynomialRing) {
                GenPolynomialRing rf = (GenPolynomialRing)this.coFac;
                res = "IntFunc( " + rf.toString() + " )";
            }
            if (this.coFac instanceof ModIntegerRing) {
                ModIntegerRing mn = (ModIntegerRing)this.coFac;
                res = "Mod " + mn.getModul() + " ";
            }
            if (res == null && (res = this.coFac.toString()).matches("[0-9].*")) {
                res = scf;
            }
            res = res + "( " + this.varsToString() + " ) " + this.tord.toString() + " ";
        } else {
            res = this.getClass().getSimpleName() + "[ " + this.coFac.toString() + " ";
            if (this.coFac instanceof AlgebraicNumberRing) {
                AlgebraicNumberRing an = (AlgebraicNumberRing)this.coFac;
                res = "AN[ (" + an.ring.varsToString() + ") (" + an.modul + ") ]";
            }
            if (this.coFac instanceof GenPolynomialRing) {
                GenPolynomialRing rf = (GenPolynomialRing)this.coFac;
                res = "IntFunc( " + rf.toString() + " )";
            }
            if (this.coFac instanceof ModIntegerRing) {
                ModIntegerRing mn = (ModIntegerRing)this.coFac;
                res = "Mod " + mn.getModul() + " ";
            }
            res = res + "( " + this.varsToString() + " ) " + this.tord.toString() + " ]";
        }
        return res;
    }

    @Override
    public String toScript() {
        StringBuffer s = new StringBuffer();
        switch (Scripting.getLang()) {
            case Ruby: {
                s.append("PolyRing.new(");
                break;
            }
            default: {
                s.append("PolyRing(");
            }
        }
        if (this.coFac instanceof RingElem) {
            s.append(((RingElem)((Object)this.coFac)).toScriptFactory());
        } else {
            s.append(this.coFac.toScript().trim());
        }
        s.append(",\"" + this.varsToString() + "\"");
        String to = this.tord.toString();
        if (this.tord.getEvord() == 2) {
            to = ",PolyRing.lex";
        }
        if (this.tord.getEvord() == 4) {
            to = ",PolyRing.grad";
        }
        s.append(to);
        s.append(")");
        return s.toString();
    }

    public String toScript(ExpVector e) {
        if (this.vars != null) {
            return e.toScript(this.vars);
        }
        return e.toScript();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof GenPolynomialRing)) {
            return false;
        }
        GenPolynomialRing oring = (GenPolynomialRing)other;
        if (this.nvar != oring.nvar) {
            return false;
        }
        if (!this.coFac.equals(oring.coFac)) {
            return false;
        }
        if (!this.tord.equals(oring.tord)) {
            return false;
        }
        return Arrays.equals(this.vars, oring.vars);
    }

    public int hashCode() {
        int h = this.nvar << 27;
        h += this.coFac.hashCode() << 11;
        return h += this.tord.hashCode();
    }

    public String[] getVars() {
        return Arrays.copyOf(this.vars, this.vars.length);
    }

    public String[] setVars(String[] v) {
        if (v.length != this.nvar) {
            throw new IllegalArgumentException("v not matching number of variables: " + Arrays.toString(v) + ", nvar " + this.nvar);
        }
        String[] t = this.vars;
        this.vars = Arrays.copyOf(v, v.length);
        return t;
    }

    public String varsToString() {
        if (this.vars == null) {
            return "#" + this.nvar;
        }
        return ExpVector.varsToString(this.vars);
    }

    public C getZEROCoefficient() {
        return (C)((RingElem)this.coFac.getZERO());
    }

    public C getONECoefficient() {
        return (C)((RingElem)this.coFac.getONE());
    }

    @Override
    public GenPolynomial<C> getZERO() {
        return this.ZERO;
    }

    @Override
    public GenPolynomial<C> getONE() {
        return this.ONE;
    }

    @Override
    public boolean isCommutative() {
        return this.coFac.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.coFac.isAssociative();
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        if (this.coFac.isField() && this.nvar == 0) {
            this.isField = 1;
            return true;
        }
        this.isField = 0;
        return false;
    }

    @Override
    public BigInteger characteristic() {
        return this.coFac.characteristic();
    }

    public GenPolynomial<C> valueOf(C a) {
        return new GenPolynomial<C>(this, a);
    }

    public GenPolynomial<C> valueOf(ExpVector e) {
        return new GenPolynomial<RingElem>(this, (RingElem)this.coFac.getONE(), e);
    }

    public GenPolynomial<C> valueOf(C a, ExpVector e) {
        return new GenPolynomial<C>(this, a, e);
    }

    @Override
    public GenPolynomial<C> fromInteger(long a) {
        return new GenPolynomial<RingElem>(this, (RingElem)this.coFac.fromInteger(a), this.evzero);
    }

    @Override
    public GenPolynomial<C> fromInteger(BigInteger a) {
        return new GenPolynomial<RingElem>(this, (RingElem)this.coFac.fromInteger(a), this.evzero);
    }

    @Override
    public GenPolynomial<C> random(int n) {
        return this.random(n, random);
    }

    @Override
    public GenPolynomial<C> random(int n, Random rnd) {
        if (this.nvar == 1) {
            return this.random(3, n, n, 0.7f, rnd);
        }
        return this.random(5, n, 3, 0.3f, rnd);
    }

    public GenPolynomial<C> random(int k, int l, int d, float q) {
        return this.random(k, l, d, q, random);
    }

    public GenPolynomial<C> random(int k, int l, int d, float q, Random rnd) {
        GenPolynomial<RingElem> r = this.getZERO();
        for (int i = 0; i < l; ++i) {
            ExpVector e = ExpVector.EVRAND(this.nvar, d, q, rnd);
            RingElem a = (RingElem)this.coFac.random(k, rnd);
            r = r.sum(a, e);
        }
        return r;
    }

    @Override
    public GenPolynomial<C> copy(GenPolynomial<C> c) {
        return new GenPolynomial(this, c.val);
    }

    @Override
    public GenPolynomial<C> parse(String s) {
        String val = s;
        if (!s.contains("|")) {
            val = val.replace("{", "").replace("}", "");
        }
        return this.parse(new StringReader(val));
    }

    @Override
    public GenPolynomial<C> parse(Reader r) {
        GenPolynomialTokenizer pt = new GenPolynomialTokenizer(this, r);
        GenPolynomial<C> p = null;
        try {
            p = pt.nextPolynomial();
        }
        catch (IOException e) {
            logger.error((Object)(e.toString() + " parse " + this));
            p = this.ZERO;
        }
        return p;
    }

    public GenPolynomial<C> univariate(int i) {
        return this.univariate(0, i, 1L);
    }

    public GenPolynomial<C> univariate(int i, long e) {
        return this.univariate(0, i, e);
    }

    public GenPolynomial<C> univariate(int modv, int i, long e) {
        GenPolynomial<RingElem> p = this.getZERO();
        int r = this.nvar - modv;
        if (0 <= i && i < r) {
            RingElem one = (RingElem)this.coFac.getONE();
            ExpVector f = ExpVector.create(r, i, e);
            if (modv > 0) {
                f = f.extend(modv, 0, 0L);
            }
            p = p.sum(one, f);
        }
        return p;
    }

    public List<GenPolynomial<C>> getGenerators() {
        List<GenPolynomial<C>> univs = this.univariateList();
        ArrayList<GenPolynomial<C>> gens = new ArrayList<GenPolynomial<C>>(univs.size() + 1);
        gens.add((GenPolynomial<C>)this.getONE());
        gens.addAll(univs);
        return gens;
    }

    @Override
    public List<GenPolynomial<C>> generators() {
        List cogens = this.coFac.generators();
        List<GenPolynomial<C>> univs = this.univariateList();
        ArrayList<GenPolynomial<C>> gens = new ArrayList<GenPolynomial<C>>(univs.size() + cogens.size());
        for (RingElem c : cogens) {
            gens.add(((GenPolynomial)this.getONE()).multiply(c));
        }
        gens.addAll(univs);
        return gens;
    }

    @Override
    public boolean isFinite() {
        return this.nvar == 0 && this.coFac.isFinite();
    }

    public List<? extends GenPolynomial<C>> univariateList() {
        return this.univariateList(0, 1L);
    }

    public List<? extends GenPolynomial<C>> univariateList(int modv) {
        return this.univariateList(modv, 1L);
    }

    public List<? extends GenPolynomial<C>> univariateList(int modv, long e) {
        ArrayList<GenPolynomial<C>> pols = new ArrayList<GenPolynomial<C>>(this.nvar);
        int nm = this.nvar - modv;
        for (int i = 0; i < nm; ++i) {
            GenPolynomial<C> p = this.univariate(modv, nm - 1 - i, e);
            pols.add(p);
        }
        return pols;
    }

    public GenPolynomialRing<C> extend(int i) {
        String[] v = GenPolynomialRing.newVars("e", i);
        return this.extend(v);
    }

    public GenPolynomialRing<C> extend(String[] vn) {
        int k;
        if (vn == null || this.vars == null) {
            throw new IllegalArgumentException("vn and vars may not be null");
        }
        int i = vn.length;
        String[] v = new String[this.vars.length + i];
        for (k = 0; k < this.vars.length; ++k) {
            v[k] = this.vars[k];
        }
        for (k = 0; k < vn.length; ++k) {
            v[this.vars.length + k] = vn[k];
        }
        TermOrder to = this.tord.extend(this.nvar, i);
        GenPolynomialRing<C> pfac = new GenPolynomialRing<C>(this.coFac, this.nvar + i, to, v);
        return pfac;
    }

    public GenPolynomialRing<C> extendLower(int i) {
        String[] v = GenPolynomialRing.newVars("e", i);
        return this.extendLower(v);
    }

    public GenPolynomialRing<C> extendLower(String[] vn) {
        int k;
        if (vn == null || this.vars == null) {
            throw new IllegalArgumentException("vn and vars may not be null");
        }
        int i = vn.length;
        String[] v = new String[this.vars.length + i];
        for (k = 0; k < vn.length; ++k) {
            v[k] = vn[k];
        }
        for (k = 0; k < this.vars.length; ++k) {
            v[vn.length + k] = this.vars[k];
        }
        TermOrder to = this.tord.extendLower(this.nvar, i);
        GenPolynomialRing<C> pfac = new GenPolynomialRing<C>(this.coFac, this.nvar + i, to, v);
        return pfac;
    }

    public GenPolynomialRing<C> contract(int i) {
        String[] v = null;
        if (this.vars != null) {
            v = new String[this.vars.length - i];
            for (int j = 0; j < this.vars.length - i; ++j) {
                v[j] = this.vars[j];
            }
        }
        TermOrder to = this.tord.contract(i, this.nvar - i);
        GenPolynomialRing<C> pfac = new GenPolynomialRing<C>(this.coFac, this.nvar - i, to, v);
        return pfac;
    }

    public GenPolynomialRing<GenPolynomial<C>> recursive(int i) {
        if (i <= 0 || i >= this.nvar) {
            throw new IllegalArgumentException("wrong: 0 < " + i + " < " + this.nvar);
        }
        GenPolynomialRing<C> cfac = this.contract(i);
        String[] v = null;
        if (this.vars != null) {
            v = new String[i];
            int k = 0;
            for (int j = this.nvar - i; j < this.nvar; ++j) {
                v[k++] = this.vars[j];
            }
        }
        TermOrder to = this.tord.contract(0, i);
        GenPolynomialRing<GenPolynomial<C>> pfac = new GenPolynomialRing<GenPolynomial<C>>(cfac, i, to, v);
        return pfac;
    }

    public GenPolynomialRing<C> distribute() {
        RingFactory<C> cf;
        if (!(this.coFac instanceof GenPolynomialRing)) {
            return this;
        }
        RingFactory<C> cfp = cf = this.coFac;
        GenPolynomialRing cr = (GenPolynomialRing)cfp;
        GenPolynomialRing<C> pfac = cr.vars != null ? this.extend(cr.vars) : this.extend(cr.nvar);
        return pfac;
    }

    public GenPolynomialRing<C> reverse() {
        return this.reverse(false);
    }

    public GenPolynomialRing<C> reverse(boolean partial) {
        String[] v = null;
        if (this.vars != null) {
            int j;
            v = new String[this.vars.length];
            int k = this.tord.getSplit();
            if (partial && k < this.vars.length) {
                for (j = 0; j < k; ++j) {
                    v[this.vars.length - k + j] = this.vars[this.vars.length - 1 - j];
                }
                for (j = 0; j < this.vars.length - k; ++j) {
                    v[j] = this.vars[j];
                }
            } else {
                for (j = 0; j < this.vars.length; ++j) {
                    v[j] = this.vars[this.vars.length - 1 - j];
                }
            }
        }
        TermOrder to = this.tord.reverse(partial);
        GenPolynomialRing<C> pfac = new GenPolynomialRing<C>(this.coFac, this.nvar, to, v);
        pfac.partial = partial;
        return pfac;
    }

    public PolynomialComparator<C> getComparator() {
        return new PolynomialComparator(this.tord, false);
    }

    public PolynomialComparator<C> getComparator(boolean rev) {
        return new PolynomialComparator(this.tord, rev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] newVars(String prefix, int n) {
        String[] vars = new String[n];
        Set<String> set = knownVars;
        synchronized (set) {
            int m = knownVars.size();
            String name = prefix + m;
            for (int i = 0; i < n; ++i) {
                while (knownVars.contains(name)) {
                    name = prefix + ++m;
                }
                vars[i] = name;
                knownVars.add(name);
                name = prefix + ++m;
            }
        }
        return vars;
    }

    public String[] newVars(String prefix) {
        return GenPolynomialRing.newVars(prefix, this.nvar);
    }

    public static String[] newVars(int n) {
        return GenPolynomialRing.newVars("x", n);
    }

    public String[] newVars() {
        return GenPolynomialRing.newVars(this.nvar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addVars(String[] vars) {
        if (vars == null) {
            return;
        }
        Set<String> set = knownVars;
        synchronized (set) {
            for (int i = 0; i < vars.length; ++i) {
                knownVars.add(vars[i]);
            }
        }
    }

    @Override
    public Iterator<GenPolynomial<C>> iterator() {
        if (this.coFac.isFinite()) {
            return new GenPolynomialIterator(this);
        }
        logger.warn((Object)("ring of coefficients " + this.coFac + " is infinite, constructing iterator only over monomials"));
        return new GenPolynomialMonomialIterator(this);
    }
}

