/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.PrettyPrint;
import edu.jas.poly.AlgebraicNotInvertibleException;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.RingElem;

public class AlgebraicNumber<C extends RingElem<C>>
implements GcdRingElem<AlgebraicNumber<C>> {
    public final AlgebraicNumberRing<C> ring;
    public final GenPolynomial<C> val;
    protected int isunit = -1;

    public AlgebraicNumber(AlgebraicNumberRing<C> r, GenPolynomial<C> a) {
        this.ring = r;
        this.val = a.remainder(this.ring.modul);
        if (this.val.isZERO()) {
            this.isunit = 0;
        }
        if (this.ring.isField()) {
            this.isunit = 1;
        }
    }

    public AlgebraicNumber(AlgebraicNumberRing<C> r) {
        this(r, (GenPolynomial<C>)r.ring.getZERO());
    }

    public GenPolynomial<C> getVal() {
        return this.val;
    }

    @Override
    public AlgebraicNumberRing<C> factory() {
        return this.ring;
    }

    @Override
    public AlgebraicNumber<C> copy() {
        return new AlgebraicNumber<C>(this.ring, this.val);
    }

    @Override
    public boolean isZERO() {
        return this.val.equals(this.ring.ring.getZERO());
    }

    @Override
    public boolean isONE() {
        return this.val.equals(this.ring.ring.getONE());
    }

    @Override
    public boolean isUnit() {
        if (this.isunit > 0) {
            return true;
        }
        if (this.isunit == 0) {
            return false;
        }
        if (this.val.isZERO()) {
            this.isunit = 0;
            return false;
        }
        if (this.ring.isField()) {
            this.isunit = 1;
            return true;
        }
        boolean u = this.val.gcd(this.ring.modul).isUnit();
        this.isunit = u ? 1 : 0;
        return u;
    }

    public String toString() {
        if (PrettyPrint.isTrue()) {
            return this.val.toString(this.ring.ring.vars);
        }
        return "AlgebraicNumber[ " + this.val.toString() + " ]";
    }

    @Override
    public String toScript() {
        return this.val.toScript();
    }

    @Override
    public String toScriptFactory() {
        return ((AlgebraicNumberRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(AlgebraicNumber<C> b) {
        int s = 0;
        if (this.ring.modul != b.ring.modul) {
            s = this.ring.modul.compareTo(b.ring.modul);
        }
        if (s != 0) {
            return s;
        }
        return this.val.compareTo(b.val);
    }

    @Override
    public boolean equals(Object b) {
        if (b == null) {
            return false;
        }
        if (!(b instanceof AlgebraicNumber)) {
            return false;
        }
        AlgebraicNumber a = (AlgebraicNumber)b;
        if (!this.ring.equals(a.ring)) {
            return false;
        }
        return 0 == this.compareTo(a);
    }

    @Override
    public int hashCode() {
        return 37 * this.val.hashCode() + this.ring.hashCode();
    }

    @Override
    public AlgebraicNumber<C> abs() {
        return new AlgebraicNumber<C>(this.ring, this.val.abs());
    }

    @Override
    public AlgebraicNumber<C> sum(AlgebraicNumber<C> S) {
        return new AlgebraicNumber<GenPolynomial<C>>(this.ring, this.val.sum(S.val));
    }

    @Override
    public AlgebraicNumber<C> sum(GenPolynomial<C> c) {
        return new AlgebraicNumber<GenPolynomial<C>>(this.ring, this.val.sum(c));
    }

    @Override
    public AlgebraicNumber<C> sum(C c) {
        return new AlgebraicNumber<C>(this.ring, this.val.sum(c));
    }

    @Override
    public AlgebraicNumber<C> negate() {
        return new AlgebraicNumber<C>(this.ring, this.val.negate());
    }

    @Override
    public int signum() {
        return this.val.signum();
    }

    @Override
    public AlgebraicNumber<C> subtract(AlgebraicNumber<C> S) {
        return new AlgebraicNumber<GenPolynomial<C>>(this.ring, this.val.subtract(S.val));
    }

    @Override
    public AlgebraicNumber<C> divide(AlgebraicNumber<C> S) {
        return this.multiply((C)S.inverse());
    }

    @Override
    public AlgebraicNumber<C> inverse() {
        try {
            return new AlgebraicNumber<C>(this.ring, this.val.modInverse(this.ring.modul));
        }
        catch (AlgebraicNotInvertibleException e) {
            throw e;
        }
        catch (NotInvertibleException e) {
            throw new AlgebraicNotInvertibleException(e + ", val = " + this.val + ", modul = " + this.ring.modul + ", gcd = " + this.val.gcd(this.ring.modul), e);
        }
    }

    @Override
    public AlgebraicNumber<C> remainder(AlgebraicNumber<C> S) {
        if (S == null || S.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        if (S.isONE()) {
            return this.ring.getZERO();
        }
        if (S.isUnit()) {
            return this.ring.getZERO();
        }
        GenPolynomial<C> x = this.val.remainder(S.val);
        return new AlgebraicNumber<C>(this.ring, x);
    }

    public AlgebraicNumber<C>[] quotientRemainder(AlgebraicNumber<C> S) {
        return new AlgebraicNumber[]{this.divide(S), this.remainder(S)};
    }

    @Override
    public AlgebraicNumber<C> multiply(AlgebraicNumber<C> S) {
        GenPolynomial<GenPolynomial<C>> x = this.val.multiply(S.val);
        return new AlgebraicNumber<GenPolynomial<C>>(this.ring, x);
    }

    @Override
    public AlgebraicNumber<C> multiply(C c) {
        GenPolynomial<C> x = this.val.multiply(c);
        return new AlgebraicNumber<C>(this.ring, x);
    }

    @Override
    public AlgebraicNumber<C> multiply(GenPolynomial<C> c) {
        GenPolynomial<GenPolynomial<C>> x = this.val.multiply(c);
        return new AlgebraicNumber<GenPolynomial<C>>(this.ring, x);
    }

    public AlgebraicNumber<C> monic() {
        return new AlgebraicNumber<C>(this.ring, this.val.monic());
    }

    @Override
    public AlgebraicNumber<C> gcd(AlgebraicNumber<C> S) {
        if (S.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S;
        }
        if (this.isUnit() || S.isUnit()) {
            return this.ring.getONE();
        }
        return new AlgebraicNumber<C>(this.ring, this.val.gcd(S.val));
    }

    public AlgebraicNumber<C>[] egcd(AlgebraicNumber<C> S) {
        AlgebraicNumber[] ret = new AlgebraicNumber[]{null, null, null};
        if (S == null || S.isZERO()) {
            ret[0] = this;
            return ret;
        }
        if (this.isZERO()) {
            ret[0] = S;
            return ret;
        }
        if (this.isUnit() || S.isUnit()) {
            ret[0] = this.ring.getONE();
            if (this.isUnit() && S.isUnit()) {
                MonoidElem half = ((AlgebraicNumber)this.ring.fromInteger(2L)).inverse();
                ret[1] = ((AlgebraicNumber)this.inverse()).multiply((C)half);
                ret[2] = ((AlgebraicNumber)S.inverse()).multiply((C)half);
                return ret;
            }
            if (this.isUnit()) {
                ret[1] = this.inverse();
                ret[2] = this.ring.getZERO();
                return ret;
            }
            ret[1] = this.ring.getZERO();
            ret[2] = S.inverse();
            return ret;
        }
        GenPolynomial<C> q = this.val;
        GenPolynomial<C> r = S.val;
        MonoidElem<Object> c1 = this.ring.ring.getONE();
        GenPolynomial<GenPolynomial<AbelianGroupElem>> d1 = this.ring.ring.getZERO();
        AbelianGroupElem<Object> c2 = this.ring.ring.getZERO();
        GenPolynomial<GenPolynomial<MonoidElem>> d2 = this.ring.ring.getONE();
        while (!r.isZERO()) {
            GenPolynomial<C>[] qr = q.quotientRemainder(r);
            q = qr[0];
            GenPolynomial<GenPolynomial<AbelianGroupElem>> x1 = ((GenPolynomial)c1).subtract(q.multiply((C)d1));
            GenPolynomial<GenPolynomial<MonoidElem>> x2 = ((GenPolynomial)c2).subtract(q.multiply((C)d2));
            c1 = d1;
            c2 = d2;
            d1 = x1;
            d2 = x2;
            q = r;
            r = qr[1];
        }
        ret[0] = new AlgebraicNumber<C>(this.ring, q);
        ret[1] = new AlgebraicNumber<C>(this.ring, c1);
        ret[2] = new AlgebraicNumber<C>(this.ring, c2);
        return ret;
    }
}

