/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.Pair;
import edu.jas.gbufd.OrderedRPairlist;
import edu.jas.gbufd.RReduction;
import edu.jas.gbufd.RReductionSeq;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RegularRingElem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class RGroebnerBaseSeq<C extends RegularRingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = Logger.getLogger(RGroebnerBaseSeq.class);
    private final boolean debug = logger.isDebugEnabled();
    protected RReduction<C> rred;

    public RGroebnerBaseSeq() {
        this(new RReductionSeq());
    }

    public RGroebnerBaseSeq(RReduction<C> rred) {
        super(rred);
        this.rred = rred;
        assert (this.red == this.rred);
    }

    @Override
    public boolean isGB(int modv, List<GenPolynomial<C>> F2) {
        if (F2 == null) {
            return true;
        }
        if (!this.rred.isBooleanClosed(F2)) {
            if (this.debug) {
                logger.debug((Object)"not boolean closed");
            }
            return false;
        }
        for (int i = 0; i < F2.size(); ++i) {
            GenPolynomial<C> pi = F2.get(i);
            for (int j = i + 1; j < F2.size(); ++j) {
                GenPolynomial<C> s;
                GenPolynomial<C> pj = F2.get(j);
                if (!this.red.moduleCriterion(modv, pi, pj) || (s = this.red.SPolynomial(pi, pj)).isZERO() || (s = this.red.normalform(F2, s)).isZERO()) continue;
                if (this.debug) {
                    logger.debug((Object)("p" + i + " = " + pi));
                    logger.debug((Object)("p" + j + " = " + pj));
                    logger.debug((Object)("s-pol = " + this.red.SPolynomial(pi, pj)));
                    logger.debug((Object)("s-pol(" + i + "," + j + ") != 0: " + s));
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public List<GenPolynomial<C>> GB(int modv, List<GenPolynomial<C>> F2) {
        List<GenPolynomial<C>> bcF = this.rred.reducedBooleanClosure(F2);
        logger.info((Object)("#bcF-#F = " + (bcF.size() - F2.size())));
        F2 = bcF;
        List<GenPolynomial<C>> G = new ArrayList<GenPolynomial<C>>();
        OrderedRPairlist<C> pairlist = null;
        for (GenPolynomial<C> p : F2) {
            if (p.isZERO()) continue;
            if ((p = p.monic()).isONE()) {
                G.clear();
                G.add(p);
                return G;
            }
            G.add(p);
            if (pairlist == null) {
                pairlist = new OrderedRPairlist<C>(modv, p.ring);
            }
            pairlist.put(p);
        }
        if (G.size() <= 1) {
            return G;
        }
        while (pairlist.hasNext()) {
            GenPolynomial<C> H;
            Pair pair = pairlist.removeNext();
            if (pair == null) continue;
            GenPolynomial pi = pair.pi;
            GenPolynomial pj = pair.pj;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("pi    = " + pi));
                logger.debug((Object)("pj    = " + pj));
            }
            if (!this.red.moduleCriterion(modv, pi, pj)) continue;
            GenPolynomial S = this.red.SPolynomial(pi, pj);
            if (S.isZERO()) {
                pair.setZero();
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ht(S) = " + S.leadingExpVector()));
            }
            if ((H = this.red.normalform(G, S)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ht(H) = " + H.leadingExpVector()));
            }
            if (H.isONE()) {
                G.clear();
                G.add(H);
                return G;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("H = " + H));
            }
            if (H.isZERO()) continue;
            logger.info((Object)("Sred = " + H));
            List<GenPolynomial<C>> bcH = this.rred.reducedBooleanClosure(G, H);
            logger.info((Object)("#bcH = " + bcH.size()));
            for (GenPolynomial<C> h : bcH) {
                h = h.monic();
                G.add(h);
                pairlist.put(h);
            }
            if (!this.debug || pair.getUseCriterion3() && pair.getUseCriterion4()) continue;
            logger.info((Object)("H != 0 but: " + pair));
        }
        logger.debug((Object)("#sequential list = " + G.size()));
        G = this.minimalGB(G);
        logger.info((Object)("" + pairlist));
        return G;
    }

    @Override
    public List<GenPolynomial<C>> minimalGB(List<GenPolynomial<C>> Gp) {
        List<GenPolynomial<Object>> bcH;
        GenPolynomial b;
        AbelianGroupElem<GenPolynomial<GenPolynomial>> a;
        if (Gp == null || Gp.size() <= 1) {
            return Gp;
        }
        ArrayList<GenPolynomial<C>> G = new ArrayList(Gp.size());
        for (GenPolynomial<C> a2 : Gp) {
            if (a2 == null || a2.isZERO()) continue;
            G.add(a2);
        }
        ArrayList<GenPolynomial<Object>> F2 = new ArrayList(G.size());
        while (G.size() > 0) {
            a = (GenPolynomial)G.remove(0);
            b = a;
            if (this.red.isTopReducible(G, a) || this.red.isTopReducible(F2, a)) {
                if (!logger.isInfoEnabled()) continue;
                ArrayList ff = new ArrayList(G);
                ff.addAll(F2);
                if (((GenPolynomial)(a = this.red.normalform(ff, a))).isZERO()) continue;
                logger.info((Object)("minGB not zero " + a));
                bcH = this.rred.reducedBooleanClosure(G, a);
                if (bcH.size() > 1) {
                    System.out.println("minGB not bc: bcH size = " + bcH.size());
                    F2.add(b);
                    continue;
                }
                F2.addAll(bcH);
                continue;
            }
            F2.add((GenPolynomial<Object>)a);
        }
        G = F2;
        Collections.reverse(G);
        int len = G.size();
        for (int el = 0; el < len; ++el) {
            a = (GenPolynomial)G.remove(0);
            b = a;
            bcH = this.rred.reducedBooleanClosure((List<GenPolynomial<C>>)G, (GenPolynomial<C>)(a = this.red.normalform(G, a)));
            if (bcH.size() > 1) {
                System.out.println("minGB not bc: bcH size = " + bcH.size());
                G.add(b);
                continue;
            }
            G.addAll(bcH);
        }
        F2 = new ArrayList(G.size());
        for (GenPolynomial genPolynomial : G) {
            a = genPolynomial.monic().abs();
            if (genPolynomial.length() != ((GenPolynomial)a).length()) {
                System.out.println("minGB not bc: #p != #a: a = " + a + ", p = " + genPolynomial);
                a = genPolynomial;
            }
            F2.add((GenPolynomial<Object>)a);
        }
        G = F2;
        F2 = new ArrayList(G.size());
        for (int i = 0; i < G.size(); ++i) {
            a = (GenPolynomial)G.get(i);
            if (a == null || ((GenPolynomial)a).isZERO()) continue;
            ExpVector e = ((GenPolynomial)a).leadingExpVector();
            for (int j = i + 1; j < G.size(); ++j) {
                ExpVector expVector;
                b = (GenPolynomial)G.get(j);
                if (b == null || b.isZERO() || !e.equals(expVector = b.leadingExpVector())) continue;
                a = ((GenPolynomial)a).sum(b);
                G.set(j, null);
            }
            F2.add((GenPolynomial<Object>)a);
        }
        G = F2;
        return G;
    }
}

