/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class MultiplicativeSet<C extends GcdRingElem<C>>
implements Serializable {
    private static final Logger logger = Logger.getLogger(MultiplicativeSet.class);
    public final List<GenPolynomial<C>> mset;
    public final GenPolynomialRing<C> ring;

    public MultiplicativeSet(GenPolynomialRing<C> ring) {
        this(ring, new ArrayList<GenPolynomial<C>>());
        if (ring == null) {
            throw new IllegalArgumentException("only for non null rings");
        }
    }

    protected MultiplicativeSet(GenPolynomialRing<C> ring, List<GenPolynomial<C>> ms) {
        if (ms == null || ring == null) {
            throw new IllegalArgumentException("only for non null parts");
        }
        this.ring = ring;
        this.mset = ms;
    }

    public String toString() {
        return "MultiplicativeSet" + this.mset;
    }

    public boolean equals(Object ob) {
        MultiplicativeSet c = null;
        try {
            c = (MultiplicativeSet)ob;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (c == null) {
            return false;
        }
        if (!this.ring.equals(c.ring)) {
            return false;
        }
        return this.mset.equals(c.mset);
    }

    public int hashCode() {
        int h = this.ring.hashCode();
        h <<= 17;
        return h += this.mset.hashCode();
    }

    public boolean isEmpty() {
        return this.mset.size() == 0;
    }

    public boolean contains(GenPolynomial<C> c) {
        if (c == null || c.isZERO()) {
            return false;
        }
        if (c.isConstant()) {
            return true;
        }
        if (this.mset.isEmpty()) {
            return false;
        }
        GenPolynomial<C> d = c;
        for (GenPolynomial<C> n : this.mset) {
            GenPolynomial<C> r;
            if (n.isONE()) continue;
            do {
                GenPolynomial<C>[] qr = d.quotientRemainder(n);
                GenPolynomial<C> q = qr[0];
                r = qr[1];
                if (!r.isZERO()) continue;
                if (q.isConstant()) {
                    return true;
                }
                d = q;
            } while (r.isZERO() && !d.isConstant());
        }
        return d.isConstant();
    }

    public boolean contains(List<GenPolynomial<C>> L) {
        if (L == null || L.size() == 0) {
            return true;
        }
        for (GenPolynomial<C> c : L) {
            if (this.contains(c)) continue;
            return false;
        }
        return true;
    }

    public MultiplicativeSet<C> add(GenPolynomial<C> cc) {
        if (cc == null || cc.isZERO() || cc.isConstant()) {
            return this;
        }
        if (this.ring.coFac.isField()) {
            cc = cc.monic();
        }
        if (this.mset.size() == 0) {
            ArrayList<GenPolynomial<C>> list = new ArrayList<GenPolynomial<C>>(1);
            list.add(cc);
            return new MultiplicativeSet<C>(this.ring, list);
        }
        GenPolynomial<C> c = this.removeFactors(cc);
        if (c.isConstant()) {
            logger.info((Object)("skipped unit or constant = " + c));
            return this;
        }
        if (this.ring.coFac.isField()) {
            c = c.monic();
        }
        if (this.mset.size() == 0) {
            logger.info((Object)("added to empty mset = " + c));
        } else {
            logger.info((Object)("added to mset = " + c));
        }
        ArrayList<GenPolynomial<C>> list = new ArrayList<GenPolynomial<C>>(this.mset);
        list.add(c);
        return new MultiplicativeSet<C>(this.ring, list);
    }

    public MultiplicativeSet<C> replace(List<GenPolynomial<C>> L) {
        MultiplicativeSet<C> ms = new MultiplicativeSet<C>(this.ring);
        if (L == null || L.size() == 0) {
            return ms;
        }
        for (GenPolynomial<C> p : L) {
            ms = ms.add(p);
        }
        return ms;
    }

    public GenPolynomial<C> removeFactors(GenPolynomial<C> cc) {
        if (cc == null || cc.isZERO() || cc.isConstant()) {
            return cc;
        }
        if (this.mset.size() == 0) {
            return cc;
        }
        GenPolynomial<C> c = cc;
        for (GenPolynomial<C> n : this.mset) {
            GenPolynomial<C> r;
            if (n.isConstant()) continue;
            do {
                GenPolynomial<C>[] qr = c.quotientRemainder(n);
                GenPolynomial<C> q = qr[0];
                r = qr[1];
                if (!r.isZERO()) continue;
                if (q.isConstant()) {
                    return q;
                }
                c = q;
            } while (r.isZERO() && !c.isConstant());
        }
        return c;
    }

    public List<GenPolynomial<C>> removeFactors(List<GenPolynomial<C>> L) {
        if (L == null || L.size() == 0) {
            return L;
        }
        if (this.mset.size() == 0) {
            return L;
        }
        ArrayList<GenPolynomial<C>> M = new ArrayList<GenPolynomial<C>>(L.size());
        for (GenPolynomial<C> p : L) {
            p = this.removeFactors(p);
            M.add(p);
        }
        return M;
    }
}

