/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gbufd.GroebnerBasePseudoRecSeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.PolyUfdUtil;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class GroebnerBaseSeqQuotient<C extends GcdRingElem<C>>
extends GroebnerBaseAbstract<Quotient<C>> {
    private static final Logger logger = Logger.getLogger(GroebnerBaseSeqQuotient.class);
    private final boolean debug = logger.isDebugEnabled();
    public final GroebnerBaseAbstract<GenPolynomial<C>> bba;

    public GroebnerBaseSeqQuotient(QuotientRing<C> rf) {
        this.bba = new GroebnerBasePseudoRecSeq(rf.ring);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.bba.toString() + ")";
    }

    @Override
    public List<GenPolynomial<Quotient<C>>> GB(int modv, List<GenPolynomial<Quotient<C>>> F2) {
        List<GenPolynomial<Quotient<C>>> G = F2;
        if (F2 == null || F2.isEmpty()) {
            return G;
        }
        GenPolynomialRing rring = F2.get((int)0).ring;
        QuotientRing cf = (QuotientRing)rring.coFac;
        GenPolynomialRing iring = new GenPolynomialRing(cf.ring, rring);
        List Fi = PolyUfdUtil.integralFromQuotientCoefficients(iring, F2);
        logger.info((Object)("#Fi = " + Fi.size()));
        List Gi = this.bba.GB(modv, Fi);
        logger.info((Object)("#Gi = " + Gi.size()));
        G = PolyUfdUtil.quotientFromIntegralCoefficients(rring, Gi);
        G = PolyUtil.monic(G);
        return G;
    }

    @Override
    public List<GenPolynomial<Quotient<C>>> minimalGB(List<GenPolynomial<Quotient<C>>> Gp) {
        if (Gp == null || Gp.size() <= 1) {
            return Gp;
        }
        List<GenPolynomial<Quotient<C>>> G = new ArrayList<GenPolynomial<Quotient<C>>>(Gp.size());
        for (GenPolynomial<Quotient<C>> a : Gp) {
            if (a == null || a.isZERO()) continue;
            G.add(a);
        }
        if (G.size() <= 1) {
            return G;
        }
        ArrayList F2 = new ArrayList(G.size());
        while (G.size() > 0) {
            GenPolynomial a = (GenPolynomial)G.remove(0);
            if (this.red.isTopReducible(G, a) || this.red.isTopReducible(F2, a)) {
                if (!this.debug) continue;
                System.out.println("dropped " + a);
                ArrayList ff = new ArrayList(G);
                ff.addAll(F2);
                if ((a = this.red.normalform(ff, a)).isZERO()) continue;
                System.out.println("error, nf(a) " + a);
                continue;
            }
            F2.add(a);
        }
        G = F2;
        if (G.size() <= 1) {
            return G;
        }
        GenPolynomialRing rring = ((GenPolynomial)G.get((int)0)).ring;
        QuotientRing cf = (QuotientRing)rring.coFac;
        GenPolynomialRing iring = new GenPolynomialRing(cf.ring, rring);
        List Fi = PolyUfdUtil.integralFromQuotientCoefficients(iring, F2);
        logger.info((Object)("#Fi = " + Fi.size()));
        List<GenPolynomial<GenPolynomial<C>>> Gi = this.bba.minimalGB(Fi);
        logger.info((Object)("#Gi = " + Gi.size()));
        G = PolyUfdUtil.quotientFromIntegralCoefficients(rring, Gi);
        G = PolyUtil.monic(G);
        return G;
    }

    @Override
    public void terminate() {
        this.bba.terminate();
    }

    @Override
    public int cancel() {
        return this.bba.cancel();
    }
}

