/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.gbufd.PseudoReduction;
import edu.jas.gbufd.PseudoReductionSeq;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class GroebnerBasePseudoRecSeq<C extends GcdRingElem<C>>
extends GroebnerBaseAbstract<GenPolynomial<C>> {
    private static final Logger logger = Logger.getLogger(GroebnerBasePseudoRecSeq.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final GreatestCommonDivisorAbstract<C> engine;
    protected final PseudoReduction<C> redRec;
    protected final PseudoReduction<GenPolynomial<C>> red;
    protected final RingFactory<GenPolynomial<C>> cofac;
    protected final RingFactory<C> baseCofac;

    public GroebnerBasePseudoRecSeq(RingFactory<GenPolynomial<C>> rf) {
        this(new PseudoReductionSeq<GenPolynomial<C>>(), rf, new OrderedPairlist<GenPolynomial<C>>(new GenPolynomialRing<GenPolynomial<C>>(rf, 1)));
    }

    public GroebnerBasePseudoRecSeq(RingFactory<GenPolynomial<C>> rf, PairList<GenPolynomial<C>> pl) {
        this(new PseudoReductionSeq<GenPolynomial<C>>(), rf, pl);
    }

    public GroebnerBasePseudoRecSeq(PseudoReduction<GenPolynomial<C>> red, RingFactory<GenPolynomial<C>> rf, PairList<GenPolynomial<C>> pl) {
        super(red, pl);
        this.red = red;
        this.redRec = red;
        this.cofac = rf;
        GenPolynomialRing rp = (GenPolynomialRing)this.cofac;
        this.baseCofac = rp.coFac;
        this.engine = GCDFactory.getProxy(this.baseCofac);
    }

    @Override
    public List<GenPolynomial<GenPolynomial<C>>> GB(int modv, List<GenPolynomial<GenPolynomial<C>>> F2) {
        List<GenPolynomial<GenPolynomial<C>>> G = this.normalizeZerosOnes(F2);
        if ((G = this.engine.recursivePrimitivePart(G)).size() <= 1) {
            return G;
        }
        GenPolynomialRing ring = G.get((int)0).ring;
        if (ring.coFac.isField()) {
            throw new IllegalArgumentException("coefficients from a field");
        }
        PairList<GenPolynomial<C>> pairlist = this.strategy.create(modv, ring);
        pairlist.put(G);
        while (pairlist.hasNext()) {
            AbelianGroupElem<GenPolynomial<C>> H;
            GenPolynomial S;
            Pair pair = pairlist.removeNext();
            if (pair == null) continue;
            GenPolynomial pi = pair.pi;
            GenPolynomial pj = pair.pj;
            if (this.debug) {
                logger.debug((Object)("pi    = " + pi));
                logger.debug((Object)("pj    = " + pj));
            }
            if ((S = this.red.SPolynomial(pi, pj)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (this.debug) {
                logger.info((Object)("ht(S) = " + S.leadingExpVector()));
            }
            if (((GenPolynomial)(H = this.redRec.normalformRecursive(G, S))).isZERO()) {
                pair.setZero();
                continue;
            }
            if (this.debug) {
                logger.info((Object)("ht(H) = " + ((GenPolynomial)H).leadingExpVector()));
            }
            H = this.engine.recursivePrimitivePart((GenPolynomial<GenPolynomial<C>>)H);
            if (((GenPolynomial)(H = ((GenPolynomial)H).abs())).isConstant()) {
                G.clear();
                G.add((GenPolynomial<GenPolynomial<C>>)H);
                return G;
            }
            if (this.debug) {
                logger.debug((Object)("H = " + H));
            }
            if (((GenPolynomial)H).length() <= 0) continue;
            G.add((GenPolynomial<GenPolynomial<C>>)H);
            pairlist.put((GenPolynomial<GenPolynomial<C>>)H);
        }
        logger.debug((Object)("#sequential list = " + G.size()));
        G = this.minimalGB(G);
        logger.info((Object)("" + pairlist));
        return G;
    }

    @Override
    public List<GenPolynomial<GenPolynomial<C>>> minimalGB(List<GenPolynomial<GenPolynomial<C>>> Gp) {
        AbelianGroupElem<GenPolynomial<C>> a;
        List<GenPolynomial<GenPolynomial<C>>> G = this.normalizeZerosOnes(Gp);
        if (G.size() <= 1) {
            return G;
        }
        ArrayList F2 = new ArrayList(G.size());
        while (G.size() > 0) {
            a = G.remove(0);
            if (this.red.isTopReducible((List<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>)G, (GenPolynomial<GenPolynomial<GenPolynomial<C>>>)a) || this.red.isTopReducible(F2, (GenPolynomial<GenPolynomial<GenPolynomial<C>>>)a)) {
                if (!this.debug) continue;
                System.out.println("dropped " + a);
                ArrayList<GenPolynomial<GenPolynomial<C>>> ff = new ArrayList<GenPolynomial<GenPolynomial<C>>>(G);
                ff.addAll(F2);
                if (((GenPolynomial)(a = this.redRec.normalformRecursive((List<GenPolynomial<GenPolynomial<C>>>)ff, (GenPolynomial<GenPolynomial<C>>)a))).isZERO()) continue;
                System.out.println("error, nf(a) " + a);
                continue;
            }
            F2.add(a);
        }
        G = F2;
        if (G.size() <= 1) {
            return G;
        }
        Collections.reverse(G);
        int len = G.size();
        for (int i = 0; i < len; ++i) {
            a = G.remove(0);
            a = this.redRec.normalformRecursive(G, (GenPolynomial<GenPolynomial<C>>)a);
            a = this.engine.recursivePrimitivePart((GenPolynomial<GenPolynomial<C>>)a);
            a = ((GenPolynomial)a).abs();
            G.add((GenPolynomial<GenPolynomial<C>>)a);
        }
        return G;
    }

    @Override
    public boolean isGBsimple(int modv, List<GenPolynomial<GenPolynomial<C>>> F2) {
        if (F2 == null || F2.isEmpty()) {
            return true;
        }
        for (int i = 0; i < F2.size(); ++i) {
            GenPolynomial<GenPolynomial<C>> pi = F2.get(i);
            ExpVector ei = pi.leadingExpVector();
            for (int j = i + 1; j < F2.size(); ++j) {
                GenPolynomial<GenPolynomial<C>> h;
                GenPolynomial<GenPolynomial<C>> s;
                ExpVector eij;
                GenPolynomial<GenPolynomial<C>> pj = F2.get(j);
                ExpVector ej = pj.leadingExpVector();
                if (!this.red.moduleCriterion(modv, ei, ej) || !this.red.criterion4(ei, ej, eij = ei.lcm(ej)) || (s = this.red.SPolynomial(pi, pj)).isZERO() || (h = this.redRec.normalformRecursive(F2, s)).isZERO()) continue;
                logger.info((Object)("no GB: pi = " + pi + ", pj = " + pj));
                logger.info((Object)("s  = " + s + ", h = " + h));
                return false;
            }
        }
        return true;
    }
}

