/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.PairList;
import edu.jas.gbufd.PseudoMiReducerRec;
import edu.jas.gbufd.PseudoReducerRec;
import edu.jas.gbufd.PseudoReduction;
import edu.jas.gbufd.PseudoReductionPar;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.util.Terminator;
import edu.jas.util.ThreadPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class GroebnerBasePseudoRecParallel<C extends GcdRingElem<C>>
extends GroebnerBaseAbstract<GenPolynomial<C>> {
    private static final Logger logger = Logger.getLogger(GroebnerBasePseudoRecParallel.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final int threads;
    protected final transient ThreadPool pool;
    protected final GreatestCommonDivisorAbstract<C> engine;
    protected final PseudoReduction<C> redRec;
    protected final PseudoReduction<GenPolynomial<C>> red;
    protected final RingFactory<GenPolynomial<C>> cofac;
    protected final RingFactory<C> baseCofac;

    public GroebnerBasePseudoRecParallel(int threads, RingFactory<GenPolynomial<C>> rf) {
        this(threads, rf, new PseudoReductionPar<GenPolynomial<C>>(), new ThreadPool(threads), new OrderedPairlist<GenPolynomial<C>>(new GenPolynomialRing<GenPolynomial<C>>(rf, 1)));
    }

    public GroebnerBasePseudoRecParallel(int threads, RingFactory<GenPolynomial<C>> rf, PseudoReduction<GenPolynomial<C>> red) {
        this(threads, rf, red, new ThreadPool(threads));
    }

    public GroebnerBasePseudoRecParallel(int threads, RingFactory<GenPolynomial<C>> rf, PseudoReduction<GenPolynomial<C>> red, ThreadPool pool) {
        this(threads, rf, red, pool, new OrderedPairlist<GenPolynomial<C>>(new GenPolynomialRing<GenPolynomial<C>>(rf, 1)));
    }

    public GroebnerBasePseudoRecParallel(int threads, RingFactory<GenPolynomial<C>> rf, PairList<GenPolynomial<C>> pl) {
        this(threads, rf, new PseudoReductionPar<GenPolynomial<C>>(), new ThreadPool(threads), pl);
    }

    public GroebnerBasePseudoRecParallel(int threads, RingFactory<GenPolynomial<C>> rf, PseudoReduction<GenPolynomial<C>> red, ThreadPool pool, PairList<GenPolynomial<C>> pl) {
        super(red, pl);
        if (!(red instanceof PseudoReductionPar)) {
            logger.warn((Object)"parallel GB should use parallel aware reduction");
        }
        this.red = red;
        this.redRec = red;
        this.cofac = rf;
        if (threads < 1) {
            threads = 1;
        }
        this.threads = threads;
        GenPolynomialRing rp = (GenPolynomialRing)this.cofac;
        this.baseCofac = rp.coFac;
        this.engine = GCDFactory.getProxy(this.baseCofac);
        this.pool = pool;
    }

    @Override
    public void terminate() {
        if (this.pool == null) {
            return;
        }
        this.pool.terminate();
    }

    @Override
    public int cancel() {
        if (this.pool == null) {
            return 0;
        }
        int s = this.pool.cancel();
        return s;
    }

    @Override
    public List<GenPolynomial<GenPolynomial<C>>> GB(int modv, List<GenPolynomial<GenPolynomial<C>>> F2) {
        List G = this.normalizeZerosOnes(F2);
        if ((G = this.engine.recursivePrimitivePart(G)).size() <= 1) {
            return G;
        }
        GenPolynomialRing ring = G.get((int)0).ring;
        if (ring.coFac.isField()) {
            throw new IllegalArgumentException("coefficients from a field");
        }
        PairList pairlist = this.strategy.create(modv, ring);
        pairlist.put(G);
        logger.info((Object)("start " + pairlist));
        Terminator fin = new Terminator(this.threads);
        for (int i = 0; i < this.threads; ++i) {
            PseudoReducerRec R = new PseudoReducerRec(fin, G, pairlist, this.engine);
            this.pool.addJob(R);
        }
        fin.waitDone();
        if (Thread.currentThread().isInterrupted()) {
            throw new RuntimeException("interrupt before minimalGB");
        }
        logger.debug((Object)("#parallel list = " + G.size()));
        G = this.minimalGB(G);
        logger.info((Object)("" + pairlist));
        return G;
    }

    @Override
    public List<GenPolynomial<GenPolynomial<C>>> minimalGB(List<GenPolynomial<GenPolynomial<C>>> Gp) {
        GenPolynomial<GenPolynomial<C>> a;
        List G = this.normalizeZerosOnes(Gp);
        if (G.size() <= 1) {
            return G;
        }
        ArrayList<GenPolynomial<GenPolynomial<C>>> F2 = new ArrayList(G.size());
        while (G.size() > 0) {
            a = G.remove(0);
            if (this.red.isTopReducible(G, a) || this.red.isTopReducible(F2, a)) {
                if (!this.debug) continue;
                System.out.println("dropped " + a);
                ArrayList ff = new ArrayList(G);
                ff.addAll(F2);
                if ((a = this.redRec.normalformRecursive(ff, a)).isZERO()) continue;
                System.out.println("error, nf(a) " + a);
                continue;
            }
            F2.add(a);
        }
        G = F2;
        if (G.size() <= 1) {
            return G;
        }
        Collections.reverse(G);
        PseudoMiReducerRec[] mirs = new PseudoMiReducerRec[G.size()];
        int i = 0;
        F2 = new ArrayList(G.size());
        while (G.size() > 0) {
            a = G.remove(0);
            ArrayList R = new ArrayList(G.size() + F2.size());
            R.addAll(G);
            R.addAll(F2);
            mirs[i] = new PseudoMiReducerRec(R, a, this.engine);
            this.pool.addJob(mirs[i]);
            ++i;
            F2.add(a);
        }
        G = F2;
        F2 = new ArrayList(G.size());
        for (i = 0; i < mirs.length; ++i) {
            a = mirs[i].getNF();
            F2.add(a);
        }
        return F2;
    }

    @Override
    public boolean isGBsimple(int modv, List<GenPolynomial<GenPolynomial<C>>> F2) {
        if (F2 == null || F2.isEmpty()) {
            return true;
        }
        for (int i = 0; i < F2.size(); ++i) {
            GenPolynomial<GenPolynomial<C>> pi = F2.get(i);
            ExpVector ei = pi.leadingExpVector();
            for (int j = i + 1; j < F2.size(); ++j) {
                GenPolynomial<GenPolynomial<C>> h;
                GenPolynomial<GenPolynomial<C>> s;
                ExpVector eij;
                GenPolynomial<GenPolynomial<C>> pj = F2.get(j);
                ExpVector ej = pj.leadingExpVector();
                if (!this.red.moduleCriterion(modv, ei, ej) || !this.red.criterion4(ei, ej, eij = ei.lcm(ej)) || (s = this.red.SPolynomial(pi, pj)).isZERO() || (h = this.redRec.normalformRecursive(F2, s)).isZERO()) continue;
                logger.info((Object)("no GB: pi = " + pi + ", pj = " + pj));
                logger.info((Object)("s  = " + s + ", h = " + h));
                return false;
            }
        }
        return true;
    }
}

