/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.gbufd.GroebnerBasePseudoRecSeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.OptimizedPolynomialList;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.poly.TermOrderOptimization;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class GroebnerBasePartial<C extends GcdRingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = Logger.getLogger(GroebnerBasePartial.class);
    protected GroebnerBaseAbstract<C> bb;
    protected GroebnerBaseAbstract<GenPolynomial<C>> rbb;

    public GroebnerBasePartial() {
        this(new GroebnerBaseSeq(), null);
    }

    public GroebnerBasePartial(RingFactory<GenPolynomial<C>> rf) {
        this(new GroebnerBaseSeq(), new GroebnerBasePseudoRecSeq<C>(rf));
    }

    public GroebnerBasePartial(GroebnerBaseAbstract<C> bb, GroebnerBaseAbstract<GenPolynomial<C>> rbb) {
        this.bb = bb;
        this.rbb = rbb;
    }

    @Override
    public List<GenPolynomial<C>> GB(int modv, List<GenPolynomial<C>> F2) {
        return this.bb.GB(modv, F2);
    }

    public boolean isGBrec(List<GenPolynomial<GenPolynomial<C>>> F2) {
        return this.isGBrec(0, F2);
    }

    public boolean isGBrec(int modv, List<GenPolynomial<GenPolynomial<C>>> F2) {
        if (F2 == null || F2.isEmpty()) {
            return true;
        }
        this.rbb = new GroebnerBasePseudoRecSeq(F2.get((int)0).ring.coFac);
        return this.rbb.isGB(modv, F2);
    }

    public static List<Integer> partialPermutation(String[] vars, String[] pvars) {
        return GroebnerBasePartial.partialPermutation(vars, pvars, null);
    }

    public static List<Integer> getPermutation(String[] aname, String[] ename) {
        int i;
        if (aname == null || ename == null) {
            throw new IllegalArgumentException("aname or ename may not be null");
        }
        ArrayList<Integer> perm = new ArrayList<Integer>(aname.length);
        for (i = 0; i < ename.length; ++i) {
            int j = GroebnerBasePartial.indexOf(ename[i], aname);
            if (j < 0) {
                throw new IllegalArgumentException("ename not contained in aname");
            }
            perm.add(j);
        }
        for (i = 0; i < aname.length; ++i) {
            if (perm.contains(i)) continue;
            perm.add(i);
        }
        int n1 = aname.length - 1;
        ArrayList<Integer> perm1 = new ArrayList<Integer>(aname.length);
        for (Integer k : perm) {
            perm1.add(n1 - k);
        }
        perm = perm1;
        Collections.reverse(perm);
        return perm;
    }

    public static int indexOf(String s, String[] A) {
        for (int i = 0; i < A.length; ++i) {
            if (!s.equals(A[i])) continue;
            return i;
        }
        return -1;
    }

    public static List<Integer> partialPermutation(String[] vars, String[] pvars, String[] rvars) {
        int i;
        if (vars == null || pvars == null) {
            throw new IllegalArgumentException("no variable names found");
        }
        ArrayList<String> variables = new ArrayList<String>(vars.length);
        ArrayList<String> pvariables = new ArrayList<String>(pvars.length);
        for (i = 0; i < vars.length; ++i) {
            variables.add(vars[i]);
        }
        for (i = 0; i < pvars.length; ++i) {
            pvariables.add(pvars[i]);
        }
        if (rvars == null) {
            rvars = GroebnerBasePartial.remainingVars(vars, pvars);
        }
        ArrayList<String> rvariables = new ArrayList<String>(rvars.length);
        for (int i2 = 0; i2 < rvars.length; ++i2) {
            rvariables.add(rvars[i2]);
        }
        if (rvars.length + pvars.length == vars.length) {
            return GroebnerBasePartial.getPermutation(vars, rvars);
        }
        logger.info((Object)("not implemented for " + variables + " != " + pvariables + " cup " + rvariables));
        throw new UnsupportedOperationException("not implemented");
    }

    public static List<Integer> partialPermutation(String[] vars, String[] evars, String[] pvars, String[] rvars) {
        String[] uvars;
        if (vars == null || evars == null || pvars == null) {
            throw new IllegalArgumentException("not all variable names given");
        }
        if (rvars != null) {
            int i;
            uvars = new String[pvars.length + rvars.length];
            for (i = 0; i < pvars.length; ++i) {
                uvars[i] = pvars[i];
            }
            for (i = 0; i < rvars.length; ++i) {
                uvars[pvars.length + i] = rvars[i];
            }
        } else {
            uvars = pvars;
        }
        List<Integer> perm = GroebnerBasePartial.partialPermutation(vars, evars, uvars);
        return perm;
    }

    public static String[] remainingVars(String[] vars, String[] pvars) {
        int i;
        if (vars == null || pvars == null) {
            throw new IllegalArgumentException("no variable names found");
        }
        ArrayList<String> variables = new ArrayList<String>(vars.length);
        ArrayList<String> pvariables = new ArrayList<String>(pvars.length);
        for (i = 0; i < vars.length; ++i) {
            variables.add(vars[i]);
        }
        for (i = 0; i < pvars.length; ++i) {
            pvariables.add(pvars[i]);
        }
        if (!variables.containsAll(pvariables)) {
            throw new IllegalArgumentException("partial variables not contained in all variables ");
        }
        ArrayList rvariables = new ArrayList(variables);
        for (String s : pvariables) {
            rvariables.remove(s);
        }
        int cl = vars.length - pvars.length;
        String[] rvars = new String[cl];
        int i2 = 0;
        for (String s : rvariables) {
            rvars[i2++] = s;
        }
        return rvars;
    }

    public OptimizedPolynomialList<GenPolynomial<C>> partialGBrec(List<GenPolynomial<C>> F2, String[] pvars) {
        if (F2 == null || F2.isEmpty()) {
            throw new IllegalArgumentException("empty F not allowed");
        }
        GenPolynomialRing fac = F2.get((int)0).ring;
        String[] vars = fac.getVars();
        if (vars == null || pvars == null) {
            throw new IllegalArgumentException("not all variable names found");
        }
        if (vars.length == pvars.length) {
            throw new IllegalArgumentException("use non recursive partialGB algorithm");
        }
        List<Integer> perm = GroebnerBasePartial.partialPermutation(vars, pvars);
        GenPolynomialRing pfac = TermOrderOptimization.permutation(perm, fac);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("pfac = " + pfac));
        }
        List ppolys = TermOrderOptimization.permutation(perm, pfac, F2);
        int cl = fac.nvar - pvars.length;
        int pl = pvars.length;
        String[] rvars = GroebnerBasePartial.remainingVars(vars, pvars);
        GenPolynomialRing cfac = new GenPolynomialRing(fac.coFac, cl, fac.tord, rvars);
        GenPolynomialRing rfac = new GenPolynomialRing(cfac, pl, fac.tord, pvars);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("rfac = " + rfac));
        }
        List Fr = PolyUtil.recursive(rfac, ppolys);
        this.rbb = new GroebnerBasePseudoRecSeq(cfac);
        List Gr = this.rbb.GB(Fr);
        OptimizedPolynomialList pgb = new OptimizedPolynomialList(perm, rfac, Gr);
        return pgb;
    }

    public OptimizedPolynomialList<C> partialGB(List<GenPolynomial<C>> F2, String[] pvars) {
        if (F2 == null || F2.isEmpty()) {
            throw new IllegalArgumentException("empty F not allowed");
        }
        GenPolynomialRing fac = F2.get((int)0).ring;
        String[] vars = fac.getVars();
        List<Integer> perm = GroebnerBasePartial.partialPermutation(vars, pvars);
        GenPolynomialRing pfac = TermOrderOptimization.permutation(perm, fac);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("pfac = " + pfac));
        }
        List ppolys = TermOrderOptimization.permutation(perm, pfac, F2);
        int cl = fac.nvar - pvars.length;
        if (cl == 0) {
            List<GenPolynomial<C>> G = this.bb.GB(ppolys);
            OptimizedPolynomialList pgb = new OptimizedPolynomialList(perm, pfac, G);
            return pgb;
        }
        int pl = pvars.length;
        String[] rvars = GroebnerBasePartial.remainingVars(vars, pvars);
        GenPolynomialRing cfac = new GenPolynomialRing(fac.coFac, cl, fac.tord, rvars);
        GenPolynomialRing rfac = new GenPolynomialRing(cfac, pl, fac.tord, pvars);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("rfac = " + rfac));
        }
        List Fr = PolyUtil.recursive(rfac, ppolys);
        this.rbb = new GroebnerBasePseudoRecSeq(cfac);
        List<GenPolynomial<GenPolynomial<C>>> Gr = this.rbb.GB(Fr);
        List G = PolyUtil.distribute(pfac, Gr);
        OptimizedPolynomialList pgb = new OptimizedPolynomialList(perm, pfac, G);
        return pgb;
    }

    public OptimizedPolynomialList<C> elimPartialGB(List<GenPolynomial<C>> F2, String[] evars, String[] pvars) {
        int i;
        if (F2 == null || F2.isEmpty()) {
            throw new IllegalArgumentException("empty F not allowed");
        }
        GenPolynomialRing fac = F2.get((int)0).ring;
        String[] vars = fac.getVars();
        List<Integer> perm = GroebnerBasePartial.partialPermutation(vars, evars, pvars);
        GenPolynomialRing pfac = TermOrderOptimization.permutation(perm, fac);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("pfac = " + pfac));
        }
        List ppolys = TermOrderOptimization.permutation(perm, pfac, F2);
        int cl = fac.nvar - evars.length - pvars.length;
        if (cl == 0) {
            TermOrder to = pfac.tord;
            int ev = to.getEvord();
            TermOrder split = new TermOrder(ev, ev, pfac.nvar, evars.length);
            pfac = new GenPolynomialRing(pfac.coFac, pfac.nvar, split, pfac.getVars());
            if (logger.isInfoEnabled()) {
                logger.info((Object)("pfac = " + pfac));
            }
            ArrayList Fs = new ArrayList(ppolys.size());
            for (GenPolynomial p : ppolys) {
                Fs.add(pfac.copy(p));
            }
            List<GenPolynomial<C>> G = this.bb.GB(Fs);
            OptimizedPolynomialList pgb = new OptimizedPolynomialList(perm, pfac, G);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("pgb = " + pgb));
            }
            return pgb;
        }
        logger.warn((Object)("not meaningful for elimination " + cl));
        int pl = pvars.length + pvars.length;
        String[] rvars = GroebnerBasePartial.remainingVars(vars, evars);
        rvars = GroebnerBasePartial.remainingVars(rvars, pvars);
        String[] uvars = new String[evars.length + pvars.length];
        for (i = 0; i < pvars.length; ++i) {
            uvars[i] = pvars[i];
        }
        for (i = 0; i < evars.length; ++i) {
            uvars[pvars.length + i] = evars[i];
        }
        GenPolynomialRing cfac = new GenPolynomialRing(fac.coFac, cl, fac.tord, rvars);
        TermOrder to = pfac.tord;
        int ev = to.getEvord();
        TermOrder split = new TermOrder(ev, ev, pl, evars.length);
        GenPolynomialRing rfac = new GenPolynomialRing(cfac, pl, split, uvars);
        List Fr = PolyUtil.recursive(rfac, ppolys);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("rfac = " + rfac));
            logger.info((Object)("Fr   = " + Fr));
        }
        this.rbb = new GroebnerBasePseudoRecSeq(cfac);
        List<GenPolynomial<GenPolynomial<C>>> Gr = this.rbb.GB(Fr);
        List G = PolyUtil.distribute(pfac, Gr);
        OptimizedPolynomialList pgb = new OptimizedPolynomialList(perm, pfac, G);
        return pgb;
    }
}

