/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.arith.Product;
import edu.jas.arith.ProductRing;
import edu.jas.gb.DGroebnerBaseSeq;
import edu.jas.gb.EGroebnerBaseSeq;
import edu.jas.gb.GBProxy;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.GroebnerBaseParallel;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.gb.OrderedMinPairlist;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.OrderedSyzPairlist;
import edu.jas.gb.PairList;
import edu.jas.gb.ReductionSeq;
import edu.jas.gbufd.GroebnerBasePseudoParallel;
import edu.jas.gbufd.GroebnerBasePseudoRecSeq;
import edu.jas.gbufd.GroebnerBasePseudoSeq;
import edu.jas.gbufd.GroebnerBaseQuotient;
import edu.jas.gbufd.GroebnerBaseRational;
import edu.jas.gbufd.RGroebnerBasePseudoSeq;
import edu.jas.gbufd.RGroebnerBaseSeq;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import org.apache.log4j.Logger;

public class GBFactory {
    private static final Logger logger = Logger.getLogger(GBFactory.class);

    protected GBFactory() {
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<C> getImplementation() {
        logger.warn((Object)"no coefficent factory given, assuming field coeffcients");
        GroebnerBaseSeq bba = new GroebnerBaseSeq();
        return bba;
    }

    public static GroebnerBaseAbstract<ModLong> getImplementation(ModLongRing fac) {
        return GBFactory.getImplementation(fac, new OrderedPairlist<ModLong>());
    }

    public static GroebnerBaseAbstract<ModLong> getImplementation(ModLongRing fac, PairList<ModLong> pl) {
        GroebnerBaseAbstract bba = fac.isField() ? new GroebnerBaseSeq<ModLong>(pl) : new GroebnerBasePseudoSeq<ModLong>(fac, pl);
        return bba;
    }

    public static GroebnerBaseAbstract<ModInteger> getImplementation(ModIntegerRing fac) {
        return GBFactory.getImplementation(fac, new OrderedPairlist<ModInteger>());
    }

    public static GroebnerBaseAbstract<ModInteger> getImplementation(ModIntegerRing fac, PairList<ModInteger> pl) {
        GroebnerBaseAbstract bba = fac.isField() ? new GroebnerBaseSeq<ModInteger>(pl) : new GroebnerBasePseudoSeq<ModInteger>(fac, pl);
        return bba;
    }

    public static GroebnerBaseAbstract<BigInteger> getImplementation(BigInteger fac) {
        return GBFactory.getImplementation(fac, Algo.igb);
    }

    public static GroebnerBaseAbstract<BigInteger> getImplementation(BigInteger fac, Algo a) {
        return GBFactory.getImplementation(fac, a, new OrderedPairlist<BigInteger>());
    }

    public static GroebnerBaseAbstract<BigInteger> getImplementation(BigInteger fac, PairList<BigInteger> pl) {
        return GBFactory.getImplementation(fac, Algo.igb, pl);
    }

    public static GroebnerBaseAbstract<BigInteger> getImplementation(BigInteger fac, Algo a, PairList<BigInteger> pl) {
        EGroebnerBaseSeq<BigInteger> bba;
        switch (a) {
            case igb: {
                bba = new GroebnerBasePseudoSeq<BigInteger>(fac, pl);
                break;
            }
            case egb: {
                bba = new EGroebnerBaseSeq();
                break;
            }
            case dgb: {
                bba = new DGroebnerBaseSeq();
                break;
            }
            default: {
                throw new IllegalArgumentException("algorithm not available for BigInteger " + (Object)((Object)a));
            }
        }
        return bba;
    }

    public static GroebnerBaseAbstract<BigRational> getImplementation(BigRational fac) {
        return GBFactory.getImplementation(fac, Algo.qgb);
    }

    public static GroebnerBaseAbstract<BigRational> getImplementation(BigRational fac, Algo a) {
        return GBFactory.getImplementation(fac, a, new OrderedPairlist<BigRational>());
    }

    public static GroebnerBaseAbstract<BigRational> getImplementation(BigRational fac, PairList<BigRational> pl) {
        return GBFactory.getImplementation(fac, Algo.qgb, pl);
    }

    public static GroebnerBaseAbstract<BigRational> getImplementation(BigRational fac, Algo a, PairList<BigRational> pl) {
        GroebnerBaseAbstract bba;
        switch (a) {
            case qgb: {
                bba = new GroebnerBaseSeq<BigRational>(pl);
                break;
            }
            case ffgb: {
                OrderedPairlist pli = pl instanceof OrderedMinPairlist ? new OrderedMinPairlist() : (pl instanceof OrderedSyzPairlist ? new OrderedSyzPairlist() : new OrderedPairlist());
                bba = new GroebnerBaseRational(pli);
                break;
            }
            default: {
                throw new IllegalArgumentException("algorithm not available for BigRational " + (Object)((Object)a));
            }
        }
        return bba;
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<Quotient<C>> getImplementation(QuotientRing<C> fac) {
        return GBFactory.getImplementation(fac, Algo.qgb);
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<Quotient<C>> getImplementation(QuotientRing<C> fac, Algo a) {
        return GBFactory.getImplementation(fac, a, new OrderedPairlist<Quotient<C>>());
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<Quotient<C>> getImplementation(QuotientRing<C> fac, PairList<Quotient<C>> pl) {
        return GBFactory.getImplementation(fac, Algo.qgb, pl);
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<Quotient<C>> getImplementation(QuotientRing<C> fac, Algo a, PairList<Quotient<C>> pl) {
        GroebnerBaseAbstract bba;
        switch (a) {
            case qgb: {
                bba = new GroebnerBaseSeq<Quotient<C>>(new ReductionSeq(), pl);
                break;
            }
            case ffgb: {
                OrderedPairlist pli = pl instanceof OrderedMinPairlist ? new OrderedMinPairlist() : (pl instanceof OrderedSyzPairlist ? new OrderedSyzPairlist() : new OrderedPairlist());
                bba = new GroebnerBaseQuotient<C>(fac, pli);
                break;
            }
            default: {
                throw new IllegalArgumentException("algorithm not available for Quotient " + (Object)((Object)a));
            }
        }
        return bba;
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<GenPolynomial<C>> getImplementation(GenPolynomialRing<C> fac) {
        return GBFactory.getImplementation(fac, Algo.igb);
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<GenPolynomial<C>> getImplementation(GenPolynomialRing<C> fac, Algo a) {
        return GBFactory.getImplementation(fac, a, new OrderedPairlist<GenPolynomial<C>>());
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<GenPolynomial<C>> getImplementation(GenPolynomialRing<C> fac, PairList<GenPolynomial<C>> pl) {
        return GBFactory.getImplementation(fac, Algo.igb, pl);
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<GenPolynomial<C>> getImplementation(GenPolynomialRing<C> fac, Algo a, PairList<GenPolynomial<C>> pl) {
        GroebnerBaseAbstract bba;
        switch (a) {
            case igb: {
                bba = new GroebnerBasePseudoRecSeq<C>(fac, pl);
                break;
            }
            case egb: {
                if (fac.nvar > 1 || !fac.coFac.isField()) {
                    throw new IllegalArgumentException("coefficients not univariate or not over a field" + fac);
                }
                bba = new EGroebnerBaseSeq();
                break;
            }
            case dgb: {
                if (fac.nvar > 1 || !fac.coFac.isField()) {
                    throw new IllegalArgumentException("coefficients not univariate or not over a field" + fac);
                }
                bba = new DGroebnerBaseSeq();
                break;
            }
            default: {
                throw new IllegalArgumentException("algorithm not available for GenPolynomial<C> " + (Object)((Object)a));
            }
        }
        return bba;
    }

    public static <C extends RingElem<C>> GroebnerBaseAbstract<Product<C>> getImplementation(ProductRing<C> fac) {
        RGroebnerBaseSeq<Product<C>> bba = fac.onlyFields() ? new RGroebnerBaseSeq<Product<C>>() : new RGroebnerBasePseudoSeq<C>(fac);
        return bba;
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<C> getImplementation(RingFactory<C> fac) {
        return GBFactory.getImplementation(fac, new OrderedPairlist());
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<C> getImplementation(RingFactory<C> fac, PairList<C> pl) {
        logger.debug((Object)("fac = " + fac.getClass().getName()));
        if (fac.isField()) {
            return new GroebnerBaseSeq<C>(pl);
        }
        GroebnerBaseAbstract bba = null;
        RingFactory<C> ofac = fac;
        if (ofac instanceof GenPolynomialRing) {
            OrderedPairlist pli = pl instanceof OrderedMinPairlist ? new OrderedMinPairlist() : (pl instanceof OrderedSyzPairlist ? new OrderedSyzPairlist() : new OrderedPairlist());
            GenPolynomialRing rofac = (GenPolynomialRing)ofac;
            GroebnerBasePseudoRecSeq bbr = new GroebnerBasePseudoRecSeq(rofac, pli);
            bba = bbr;
        } else {
            ProductRing pfac;
            bba = ofac instanceof ProductRing ? ((pfac = (ProductRing)ofac).onlyFields() ? new RGroebnerBaseSeq() : new RGroebnerBasePseudoSeq(pfac)) : new GroebnerBasePseudoSeq<C>(fac, pl);
        }
        logger.debug((Object)("bba = " + bba.getClass().getName()));
        return bba;
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<C> getProxy(RingFactory<C> fac) {
        return GBFactory.getProxy(fac, new OrderedPairlist());
    }

    public static <C extends GcdRingElem<C>> GroebnerBaseAbstract<C> getProxy(RingFactory<C> fac, PairList<C> pl) {
        int th;
        if (ComputerThreads.NO_THREADS) {
            return GBFactory.getImplementation(fac, pl);
        }
        logger.debug((Object)("fac = " + fac.getClass().getName()));
        int n = th = ComputerThreads.N_CPUS > 2 ? ComputerThreads.N_CPUS - 1 : 2;
        if (fac.isField()) {
            GroebnerBaseSeq<C> e1 = new GroebnerBaseSeq<C>(pl);
            GroebnerBaseParallel<C> e2 = new GroebnerBaseParallel<C>(th, pl);
            return new GBProxy<C>(e1, e2);
        }
        if (fac.characteristic().signum() == 0) {
            GroebnerBasePseudoSeq<C> e1 = new GroebnerBasePseudoSeq<C>(fac, pl);
            GroebnerBasePseudoParallel<C> e2 = new GroebnerBasePseudoParallel<C>(th, fac, pl);
            return new GBProxy<C>(e1, e2);
        }
        return GBFactory.getImplementation(fac, pl);
    }

    public static enum Algo {
        igb,
        egb,
        dgb,
        qgb,
        ffgb;

    }
}

