/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gbufd.CharacteristicSet;
import edu.jas.gbufd.PolyGBUtil;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.OrderedPolynomialList;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class CharacteristicSetSimple<C extends GcdRingElem<C>>
implements CharacteristicSet<C> {
    private static final Logger logger = Logger.getLogger(CharacteristicSetSimple.class);
    private static boolean debug = logger.isDebugEnabled();

    @Override
    public List<GenPolynomial<C>> characteristicSet(List<GenPolynomial<C>> A) {
        GenPolynomial fr;
        ArrayList<GenPolynomial<C>> S = new ArrayList<GenPolynomial<C>>();
        if (A == null || A.isEmpty()) {
            return S;
        }
        GenPolynomialRing pfac = A.get((int)0).ring;
        if (pfac.nvar <= 1) {
            GreatestCommonDivisorAbstract<C> ufd = GCDFactory.getImplementation(pfac.coFac);
            GenPolynomial g = ufd.gcd(A).monic();
            logger.info((Object)("charSet base gcd = " + g));
            S.add(g);
            return S;
        }
        GenPolynomialRing rfac = pfac.recursive(1);
        ArrayList positiveDeg = new ArrayList();
        ArrayList<GenPolynomial<C>> zeroDeg = new ArrayList<GenPolynomial<C>>();
        for (GenPolynomial<C> f : A) {
            if (f.isZERO()) continue;
            if ((f = f.monic()).isONE()) {
                S.add(f);
                return S;
            }
            fr = PolyUtil.recursive(rfac, f);
            if (fr.degree(0) == 0L) {
                zeroDeg.add(fr.leadingBaseCoefficient());
                continue;
            }
            positiveDeg.add(fr);
        }
        if (positiveDeg.isEmpty() && zeroDeg.isEmpty()) {
            return S;
        }
        OrderedPolynomialList opl = new OrderedPolynomialList(rfac, positiveDeg);
        List<GenPolynomial<Object>> pd = new ArrayList(opl.list);
        Collections.reverse(pd);
        if (debug) {
            logger.info((Object)("positive degrees: " + pd));
        }
        while (pd.size() > 1) {
            fr = (GenPolynomial)pd.remove(0);
            GenPolynomial qr = (GenPolynomial)pd.get(0);
            logger.info((Object)("pseudo remainder by deg = " + qr.degree() + " in variable " + rfac.getVars()[0]));
            GenPolynomial rr = PolyUtil.recursiveSparsePseudoRemainder(fr, qr);
            if (rr.isZERO()) {
                logger.warn((Object)"variety is reducible");
                continue;
            }
            if (rr.degree(0) == 0L) {
                zeroDeg.add(rr.leadingBaseCoefficient().monic());
                continue;
            }
            pd.add(rr);
            pd = OrderedPolynomialList.sort(rfac, pd);
            Collections.reverse(pd);
        }
        List<GenPolynomial<C>> Sp = this.characteristicSet(zeroDeg);
        for (GenPolynomial f : Sp) {
            GenPolynomial<C> fp = f.extend(pfac, 0, 0L);
            S.add(fp);
        }
        if (pd.isEmpty()) {
            return S;
        }
        GenPolynomial rr = (GenPolynomial)pd.get(0);
        GenPolynomial sr = PolyUtil.distribute(pfac, rr);
        sr = sr.monic();
        S.add(0, sr);
        return S;
    }

    @Override
    public boolean isCharacteristicSet(List<GenPolynomial<C>> A) {
        if (A == null || A.isEmpty()) {
            return true;
        }
        GenPolynomialRing pfac = A.get((int)0).ring;
        if (pfac.nvar <= 1) {
            return A.size() <= 1;
        }
        if (pfac.nvar < A.size()) {
            return false;
        }
        GenPolynomialRing rfac = pfac.recursive(1);
        ArrayList<GenPolynomial<C>> zeroDeg = new ArrayList<GenPolynomial<C>>();
        int positiveDeg = 0;
        for (GenPolynomial<C> f : A) {
            if (f.isZERO()) {
                return false;
            }
            GenPolynomial fr = PolyUtil.recursive(rfac, f);
            if (fr.degree(0) == 0L) {
                zeroDeg.add(fr.leadingBaseCoefficient());
                continue;
            }
            if (++positiveDeg <= 1) continue;
            return false;
        }
        return this.isCharacteristicSet(zeroDeg);
    }

    @Override
    public GenPolynomial<C> characteristicSetReduction(List<GenPolynomial<C>> A, GenPolynomial<C> P) {
        if (A == null || A.isEmpty()) {
            return P.monic();
        }
        if (P.isZERO()) {
            return P;
        }
        GenPolynomial<C> R = PolyGBUtil.topPseudoRemainder(A, P);
        R = R.monic();
        return R;
    }
}

