/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbmod;

import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionSeq;
import edu.jas.gb.SolvableExtendedGB;
import edu.jas.gb.SolvableGroebnerBase;
import edu.jas.gb.SolvableGroebnerBaseSeq;
import edu.jas.gb.SolvableReduction;
import edu.jas.gb.SolvableReductionSeq;
import edu.jas.gbmod.ModSolvableGroebnerBase;
import edu.jas.gbmod.ModSolvableGroebnerBaseAbstract;
import edu.jas.gbmod.SolvResPart;
import edu.jas.gbmod.SolvResPolPart;
import edu.jas.gbmod.SolvableSyzygy;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.ModuleList;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.RingElem;
import edu.jas.vector.BasicLinAlg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SolvableSyzygyAbstract<C extends RingElem<C>>
implements SolvableSyzygy<C> {
    private static final Logger logger = Logger.getLogger(SolvableSyzygyAbstract.class);
    private final boolean debug = logger.isDebugEnabled();
    public final SolvableReduction<C> sred;
    protected Reduction<C> red = new ReductionSeq();
    protected BasicLinAlg<GenPolynomial<C>> blas;
    protected SolvableGroebnerBase<C> sbb;
    protected ModSolvableGroebnerBase<C> msbb;

    public SolvableSyzygyAbstract() {
        this.sred = new SolvableReductionSeq();
        this.blas = new BasicLinAlg();
        this.sbb = new SolvableGroebnerBaseSeq();
        this.msbb = new ModSolvableGroebnerBaseAbstract();
    }

    @Override
    public List<List<GenSolvablePolynomial<C>>> leftZeroRelations(List<GenSolvablePolynomial<C>> F2) {
        return this.leftZeroRelations(0, F2);
    }

    @Override
    public List<List<GenSolvablePolynomial<C>>> leftZeroRelations(int modv, List<GenSolvablePolynomial<C>> F2) {
        ArrayList<List<GenSolvablePolynomial<C>>> Z = new ArrayList<List<GenSolvablePolynomial<C>>>();
        ArrayList<Object> S = new ArrayList<Object>(F2.size());
        for (int i = 0; i < F2.size(); ++i) {
            S.add(null);
        }
        GenPolynomial zero = null;
        for (int i = 0; i < F2.size(); ++i) {
            GenSolvablePolynomial<C> pi = F2.get(i);
            if (zero == null) {
                zero = pi.ring.getZERO();
            }
            for (int j = i + 1; j < F2.size(); ++j) {
                GenSolvablePolynomial<C> pj = F2.get(j);
                if (!this.red.moduleCriterion(modv, pi, pj)) continue;
                ArrayList row = new ArrayList(S);
                GenSolvablePolynomial<C> s = this.sred.leftSPolynomial(row, i, pi, j, pj);
                if (s.isZERO()) {
                    Z.add(row);
                    continue;
                }
                GenSolvablePolynomial<C> h = this.sred.leftNormalform(row, F2, s);
                if (!h.isZERO()) {
                    throw new ArithmeticException("Syzygy no leftGB");
                }
                if (logger.isDebugEnabled()) {
                    logger.info((Object)("row = " + row));
                }
                Z.add(row);
            }
        }
        for (List list : Z) {
            for (int j = 0; j < list.size(); ++j) {
                if (list.get(j) != null) continue;
                list.set(j, zero);
            }
        }
        return Z;
    }

    @Override
    public ModuleList<C> leftZeroRelations(ModuleList<C> M) {
        ModuleList N2 = null;
        if (M == null || M.list == null) {
            return N2;
        }
        if (M.rows == 0 || M.cols == 0) {
            return N2;
        }
        GenSolvablePolynomial zero = (GenSolvablePolynomial)M.ring.getZERO();
        PolynomialList<C> F2 = M.getPolynomialList();
        int modv = M.cols;
        logger.info((Object)("modv = " + modv));
        List<List<GenSolvablePolynomial<C>>> G = this.leftZeroRelations(modv, F2.castToSolvableList());
        ArrayList Z = new ArrayList();
        for (int i = 0; i < G.size(); ++i) {
            List<GenSolvablePolynomial<C>> Gi = G.get(i);
            ArrayList<GenSolvablePolynomial> Zi = new ArrayList<GenSolvablePolynomial>();
            for (int j = 0; j < Gi.size(); ++j) {
                GenSolvablePolynomial p = Gi.get(j);
                if (p == null) continue;
                Map r = p.contract(M.ring);
                if (r.size() == 0) {
                    Zi.add(zero);
                    continue;
                }
                if (r.size() == 1) {
                    GenSolvablePolynomial vi = (GenSolvablePolynomial)r.values().toArray()[0];
                    Zi.add(vi);
                    continue;
                }
                throw new RuntimeException("Map.size() > 1 = " + r.size());
            }
            Z.add(Zi);
        }
        N2 = new ModuleList((GenSolvablePolynomialRing)M.ring, Z);
        return N2;
    }

    @Override
    public boolean isLeftZeroRelation(List<List<GenSolvablePolynomial<C>>> Z, List<GenSolvablePolynomial<C>> F2) {
        List<GenPolynomial<C>> Fp = PolynomialList.castToList(F2);
        for (List<GenSolvablePolynomial<C>> row : Z) {
            GenPolynomial<C> p = this.blas.scalarProduct(PolynomialList.castToList(row), Fp);
            if (p == null || p.isZERO()) continue;
            logger.info((Object)("is not ZeroRelation = " + p));
            return false;
        }
        return true;
    }

    @Override
    public boolean isRightZeroRelation(List<List<GenSolvablePolynomial<C>>> Z, List<GenSolvablePolynomial<C>> F2) {
        List<GenPolynomial<C>> Fp = PolynomialList.castToList(F2);
        for (List<GenSolvablePolynomial<C>> row : Z) {
            List<GenPolynomial<C>> yrow = PolynomialList.castToList(row);
            GenPolynomial<C> p = this.blas.scalarProduct(Fp, yrow);
            if (p == null || p.isZERO()) continue;
            logger.info((Object)("is not ZeroRelation = " + p));
            return false;
        }
        return true;
    }

    @Override
    public boolean isLeftZeroRelation(ModuleList<C> Z, ModuleList<C> F2) {
        if (Z == null || Z.list == null) {
            return true;
        }
        for (List row : Z.list) {
            List zr = this.blas.leftScalarProduct(row, F2.list);
            if (this.blas.isZero(zr)) continue;
            logger.info((Object)("is not ZeroRelation (" + zr.size() + ") = " + zr));
            return false;
        }
        return true;
    }

    @Override
    public boolean isRightZeroRelation(ModuleList<C> Z, ModuleList<C> F2) {
        if (Z == null || Z.list == null) {
            return true;
        }
        for (List row : Z.list) {
            List zr = this.blas.rightScalarProduct(row, F2.list);
            if (this.blas.isZero(zr)) continue;
            logger.info((Object)("is not ZeroRelation (" + zr.size() + ") = " + zr));
            return false;
        }
        return true;
    }

    @Override
    public List<SolvResPart<C>> resolution(ModuleList<C> M) {
        ArrayList<SolvResPart<C>> R = new ArrayList<SolvResPart<C>>();
        ModuleList<C> MM = M;
        while (true) {
            ModuleList<C> GM = this.msbb.leftGB(MM);
            ModuleList<C> Z = this.leftZeroRelations(GM);
            R.add(new SolvResPart<C>(MM, GM, Z));
            if (Z == null || Z.list == null || Z.list.size() == 0) break;
            MM = Z;
        }
        return R;
    }

    @Override
    public List resolution(PolynomialList<C> F2) {
        List<GenSolvablePolynomial<C>> G = this.sbb.leftGB(F2.castToSolvableList());
        List<List<GenSolvablePolynomial<C>>> Z = this.leftZeroRelations(G);
        PolynomialList<C> Gl = new PolynomialList<C>((GenSolvablePolynomialRing)F2.ring, G);
        ModuleList<C> Zm = new ModuleList<C>((GenSolvablePolynomialRing)F2.ring, Z);
        List<SolvResPart<C>> R = this.resolution(Zm);
        R.add(0, (SolvResPart<C>)((Object)new SolvResPolPart<C>(F2, Gl, Zm)));
        return R;
    }

    @Override
    public List<SolvResPart<C>> resolutionArbitrary(ModuleList<C> M) {
        ArrayList<SolvResPart<C>> R = new ArrayList<SolvResPart<C>>();
        ModuleList<C> MM = M;
        ModuleList GM = null;
        while (true) {
            ModuleList<C> Z = this.leftZeroRelationsArbitrary(MM);
            R.add(new SolvResPart<C>(MM, GM, Z));
            if (Z == null || Z.list == null || Z.list.size() == 0) break;
            MM = Z;
        }
        return R;
    }

    @Override
    public List resolutionArbitrary(PolynomialList<C> F2) {
        PolynomialList Gl = null;
        List<List<GenSolvablePolynomial<C>>> Z = this.leftZeroRelationsArbitrary(F2.castToSolvableList());
        ModuleList<C> Zm = new ModuleList<C>((GenSolvablePolynomialRing)F2.ring, Z);
        List<SolvResPart<C>> R = this.resolutionArbitrary(Zm);
        R.add(0, (SolvResPart<C>)((Object)new SolvResPolPart<C>(F2, Gl, Zm)));
        return R;
    }

    @Override
    public List<List<GenSolvablePolynomial<C>>> leftZeroRelationsArbitrary(List<GenSolvablePolynomial<C>> F2) {
        return this.leftZeroRelationsArbitrary(0, F2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<List<GenSolvablePolynomial<C>>> leftZeroRelationsArbitrary(int modv, List<GenSolvablePolynomial<C>> F2) {
        if (F2 == null) {
            return null;
        }
        if (F2.size() <= 1) {
            return this.leftZeroRelations(modv, F2);
        }
        int lenf = F2.size();
        SolvableExtendedGB<C> exgb = this.sbb.extLeftGB(F2);
        if (this.debug) {
            logger.info((Object)("exgb = " + exgb));
        }
        if (!this.sbb.isLeftReductionMatrix(exgb)) {
            logger.error((Object)"is reduction matrix ? false");
        }
        List G = exgb.G;
        List G2F = exgb.G2F;
        List F2G = exgb.F2G;
        List sg = this.leftZeroRelations(modv, G);
        GenSolvablePolynomialRing ring = G.get((int)0).ring;
        ModuleList S = new ModuleList(ring, sg);
        if (this.debug) {
            logger.info((Object)("syz = " + S));
        }
        if (!this.isLeftZeroRelation(sg, G)) {
            logger.error((Object)"is syzygy ? false");
        }
        ArrayList<List<GenSolvablePolynomial<C>>> sf = new ArrayList<List<GenSolvablePolynomial<C>>>(sg.size());
        for (List r : sg) {
            void var17_20;
            Iterator it = r.iterator();
            Iterator jt = G2F.iterator();
            List rf = new ArrayList<GenPolynomial>(lenf);
            boolean bl = false;
            while (var17_20 < lenf) {
                rf.add(ring.getZERO());
                ++var17_20;
            }
            while (it.hasNext() && jt.hasNext()) {
                GenSolvablePolynomial genSolvablePolynomial = it.next();
                List ai = jt.next();
                if (genSolvablePolynomial == null || ai == null) continue;
                List pi = this.blas.scalarProduct(genSolvablePolynomial, PolynomialList.castToList(ai));
                rf = PolynomialList.castToSolvableList(this.blas.vectorAdd(PolynomialList.castToList(rf), pi));
            }
            if (it.hasNext() || jt.hasNext()) {
                logger.error((Object)"leftZeroRelationsArbitrary wrong sizes");
            }
            sf.add(rf);
        }
        if (!this.isLeftZeroRelation(sf, F2)) {
            logger.error((Object)"is partial syz sf ? false");
        }
        ArrayList<void> M = new ArrayList<void>(lenf);
        for (List r : F2G) {
            void var17_23;
            Iterator it = r.iterator();
            Iterator jt = G2F.iterator();
            ArrayList<GenPolynomial> arrayList = new ArrayList<GenPolynomial>(lenf);
            for (int m = 0; m < lenf; ++m) {
                arrayList.add(ring.getZERO());
            }
            while (it.hasNext() && jt.hasNext()) {
                GenSolvablePolynomial si = it.next();
                List ai = jt.next();
                if (si == null || ai == null) continue;
                List pi = this.blas.scalarProduct(si, PolynomialList.castToList(ai));
                List list = PolynomialList.castToSolvableList(this.blas.vectorAdd(PolynomialList.castToList(var17_23), pi));
            }
            if (it.hasNext() || jt.hasNext()) {
                logger.error((Object)"zeroRelationsArbitrary wrong sizes");
            }
            M.add(var17_23);
        }
        int sflen = sf.size();
        ArrayList M2 = new ArrayList(lenf);
        int i = 0;
        for (List list : M) {
            ArrayList<GenSolvablePolynomial> r2i = new ArrayList<GenSolvablePolynomial>(list.size());
            int j = 0;
            for (GenSolvablePolynomial rij : list) {
                GenSolvablePolynomial p = null;
                if (i == j) {
                    p = (GenSolvablePolynomial)ring.getONE().subtract(rij);
                } else if (rij != null) {
                    p = (GenSolvablePolynomial)rij.negate();
                }
                r2i.add(p);
                ++j;
            }
            M2.add(r2i);
            if (!this.blas.isZero(PolynomialList.castToList(r2i))) {
                sf.add(r2i);
            }
            ++i;
        }
        ModuleList M2L = new ModuleList(ring, M2);
        if (this.debug) {
            logger.debug((Object)("syz M2L = " + M2L));
        }
        if (this.debug) {
            ModuleList moduleList = new ModuleList(ring, sf);
            logger.debug((Object)("syz sf = " + moduleList));
            logger.debug((Object)("#syz " + sflen + ", " + sf.size()));
        }
        if (!this.isLeftZeroRelation(sf, F2)) {
            logger.error((Object)"is syz sf ? false");
        }
        return sf;
    }

    @Override
    public ModuleList<C> leftZeroRelationsArbitrary(ModuleList<C> M) {
        ModuleList N2 = null;
        if (M == null || M.list == null) {
            return N2;
        }
        if (M.rows == 0 || M.cols == 0) {
            return N2;
        }
        GenSolvablePolynomial zero = (GenSolvablePolynomial)M.ring.getZERO();
        PolynomialList<C> F2 = M.getPolynomialList();
        int modv = M.cols;
        logger.info((Object)("modv = " + modv));
        List<List<GenSolvablePolynomial<C>>> G = this.leftZeroRelationsArbitrary(modv, F2.castToSolvableList());
        if (G == null) {
            return N2;
        }
        ArrayList Z = new ArrayList();
        for (int i = 0; i < G.size(); ++i) {
            List<GenSolvablePolynomial<C>> Gi = G.get(i);
            ArrayList<GenSolvablePolynomial> Zi = new ArrayList<GenSolvablePolynomial>();
            for (int j = 0; j < Gi.size(); ++j) {
                GenSolvablePolynomial p = Gi.get(j);
                if (p == null) continue;
                Map r = p.contract(M.ring);
                if (r.size() == 0) {
                    Zi.add(zero);
                    continue;
                }
                if (r.size() == 1) {
                    GenSolvablePolynomial vi = (GenSolvablePolynomial)r.values().toArray()[0];
                    Zi.add(vi);
                    continue;
                }
                throw new RuntimeException("Map.size() > 1 = " + r.size());
            }
            Z.add(Zi);
        }
        N2 = new ModuleList((GenSolvablePolynomialRing)M.ring, Z);
        return N2;
    }

    @Override
    public List<List<GenSolvablePolynomial<C>>> rightZeroRelationsArbitrary(List<GenSolvablePolynomial<C>> F2) {
        return this.rightZeroRelationsArbitrary(0, F2);
    }

    @Override
    public List<List<GenSolvablePolynomial<C>>> rightZeroRelationsArbitrary(int modv, List<GenSolvablePolynomial<C>> F2) {
        GenSolvablePolynomial q;
        ArrayList<List<GenSolvablePolynomial<Object>>> Z;
        GenPolynomialRing ring = null;
        for (GenSolvablePolynomial<C> p : F2) {
            if (p == null) continue;
            ring = p.ring;
            break;
        }
        if (ring == null) {
            Z = new ArrayList<List<GenSolvablePolynomial<C>>>(1);
            Z.add(F2);
            return Z;
        }
        GenPolynomialRing rring = ((GenSolvablePolynomialRing)ring).reverse(true);
        ArrayList<GenSolvablePolynomial<C>> rF = new ArrayList<GenSolvablePolynomial<C>>(F2.size());
        for (GenSolvablePolynomial<C> p : F2) {
            if (p == null) continue;
            q = (GenSolvablePolynomial)p.reverse(rring);
            rF.add(q);
        }
        if (this.debug) {
            PolynomialList<C> pl = new PolynomialList<C>(rring, rF);
            logger.info((Object)("reversed problem = " + pl.toScript()));
        }
        List<List<GenSolvablePolynomial<C>>> rZ = this.leftZeroRelationsArbitrary(modv, rF);
        if (this.debug) {
            boolean isit = this.isLeftZeroRelation(rZ, rF);
            logger.debug((Object)("isLeftZeroRelation = " + isit));
        }
        GenPolynomialRing oring = ((GenSolvablePolynomialRing)rring).reverse(true);
        if (this.debug) {
            logger.debug((Object)("ring == oring: " + ((GenSolvablePolynomialRing)ring).equals(oring)));
        }
        ring = oring;
        Z = new ArrayList(rZ.size());
        for (List<GenSolvablePolynomial<C>> z : rZ) {
            if (z == null) continue;
            ArrayList<GenSolvablePolynomial> s = new ArrayList<GenSolvablePolynomial>(z.size());
            for (GenSolvablePolynomial<C> p : z) {
                if (p == null) continue;
                q = (GenSolvablePolynomial)p.reverse(ring);
                s.add(q);
            }
            Z.add(s);
        }
        return Z;
    }

    public boolean isLeftOreCond(GenSolvablePolynomial<C> a, GenSolvablePolynomial<C> b, GenSolvablePolynomial<C>[] oc) {
        GenSolvablePolynomial<GenSolvablePolynomial<C>> c = oc[0].multiply(a);
        GenSolvablePolynomial<GenSolvablePolynomial<C>> d = oc[1].multiply(b);
        return c.equals(d);
    }

    public boolean isRightOreCond(GenSolvablePolynomial<C> a, GenSolvablePolynomial<C> b, GenSolvablePolynomial<C>[] oc) {
        GenSolvablePolynomial<GenSolvablePolynomial<C>> c = a.multiply(oc[0]);
        GenSolvablePolynomial<GenSolvablePolynomial<C>> d = b.multiply(oc[1]);
        return c.equals(d);
    }

    public GenSolvablePolynomial<C>[] leftOreCond(GenSolvablePolynomial<C> a, GenSolvablePolynomial<C> b) {
        if (a == null || a.isZERO() || b == null || b.isZERO()) {
            throw new IllegalArgumentException("a and b must be non zero");
        }
        GenSolvablePolynomialRing pfac = a.ring;
        GenSolvablePolynomial[] oc = new GenSolvablePolynomial[2];
        if (a.equals(b)) {
            oc[0] = pfac.getONE();
            oc[1] = pfac.getONE();
            return oc;
        }
        if (a.isConstant()) {
            if (pfac.coFac.isCommutative()) {
                oc[0] = b;
                oc[1] = a;
                return oc;
            }
            oc[1] = pfac.getONE();
            RingElem c = (RingElem)a.leadingBaseCoefficient().inverse();
            oc[0] = b.multiply(c);
            return oc;
        }
        if (b.isConstant()) {
            if (pfac.coFac.isCommutative()) {
                oc[0] = b;
                oc[1] = a;
                return oc;
            }
            oc[0] = pfac.getONE();
            RingElem c = (RingElem)b.leadingBaseCoefficient().inverse();
            oc[1] = a.multiply(c);
            return oc;
        }
        logger.info((Object)("computing left Ore condition: " + a + ", " + b));
        ArrayList<GenSolvablePolynomial<C>> F2 = new ArrayList<GenSolvablePolynomial<C>>(2);
        F2.add(a);
        F2.add(b);
        List<List<GenSolvablePolynomial<C>>> Gz = this.leftZeroRelationsArbitrary(F2);
        if (Gz.size() < 0) {
            ModuleList M = new ModuleList(pfac, Gz);
            ModuleList<C> GM = this.msbb.leftGB(M);
            Gz = GM.castToSolvableList();
        }
        List<GenSolvablePolynomial<C>> G1 = null;
        GenSolvablePolynomial<C> g1 = null;
        for (List<GenSolvablePolynomial<C>> Gi : Gz) {
            if (Gi.get(0).isZERO()) continue;
            if (G1 == null) {
                G1 = Gi;
            }
            if (g1 == null) {
                g1 = G1.get(0);
                continue;
            }
            if (g1.compareTo(Gi.get(0)) <= 0) continue;
            G1 = Gi;
            g1 = G1.get(0);
        }
        oc[0] = g1;
        oc[1] = (GenSolvablePolynomial)((GenSolvablePolynomial)G1.get(1)).negate();
        return oc;
    }

    public GenSolvablePolynomial<C>[] rightOreCond(GenSolvablePolynomial<C> a, GenSolvablePolynomial<C> b) {
        if (a == null || a.isZERO() || b == null || b.isZERO()) {
            throw new IllegalArgumentException("a and b must be non zero");
        }
        GenSolvablePolynomialRing pfac = a.ring;
        GenSolvablePolynomial[] oc = new GenSolvablePolynomial[2];
        if (a.equals(b)) {
            oc[0] = pfac.getONE();
            oc[1] = pfac.getONE();
            return oc;
        }
        if (a.isConstant()) {
            if (pfac.coFac.isCommutative()) {
                oc[0] = b;
                oc[1] = a;
                return oc;
            }
            oc[1] = pfac.getONE();
            RingElem c = (RingElem)a.leadingBaseCoefficient().inverse();
            oc[0] = b.multiply(c);
            return oc;
        }
        if (b.isConstant()) {
            if (pfac.coFac.isCommutative()) {
                oc[0] = b;
                oc[1] = a;
                return oc;
            }
            oc[0] = pfac.getONE();
            RingElem c = (RingElem)b.leadingBaseCoefficient().inverse();
            oc[1] = a.multiply(c);
            return oc;
        }
        logger.info((Object)("computing right Ore condition: " + a + ", " + b));
        ArrayList<GenSolvablePolynomial<C>> F2 = new ArrayList<GenSolvablePolynomial<C>>(2);
        F2.add(a);
        F2.add(b);
        List<List<GenSolvablePolynomial<C>>> Gz = this.rightZeroRelationsArbitrary(F2);
        List<GenSolvablePolynomial<C>> G1 = null;
        GenSolvablePolynomial<C> g1 = null;
        for (List<GenSolvablePolynomial<C>> Gi : Gz) {
            if (Gi.get(0).isZERO()) continue;
            if (G1 == null) {
                G1 = Gi;
            }
            if (g1 == null) {
                g1 = G1.get(0);
                continue;
            }
            if (g1.compareTo(Gi.get(0)) <= 0) continue;
            G1 = Gi;
            g1 = G1.get(0);
        }
        oc[0] = (GenSolvablePolynomial)G1.get(0);
        oc[1] = (GenSolvablePolynomial)((GenSolvablePolynomial)G1.get(1)).negate();
        return oc;
    }

    public GenSolvablePolynomial<C>[] leftSimplifier(GenSolvablePolynomial<C> a, GenSolvablePolynomial<C> b) {
        int t;
        Object lc;
        if (a == null || a.isZERO() || b == null || b.isZERO()) {
            throw new IllegalArgumentException("a and b must be non zero");
        }
        Object[] oc = null;
        if (a.totalDegree() > 3L || b.totalDegree() > 3L) {
            logger.warn((Object)("skipping GB computation: degs = " + a.totalDegree() + ", " + b.totalDegree()));
            oc = new GenSolvablePolynomial[]{a, b};
            return oc;
        }
        oc = this.rightOreCond(a, b);
        logger.info((Object)("oc = " + Arrays.toString(oc)));
        ArrayList<GenSolvablePolynomial<C>> F2 = new ArrayList<GenSolvablePolynomial<C>>(oc.length);
        F2.add((GenSolvablePolynomial)((GenPolynomial)oc[1]).negate());
        F2.add((GenSolvablePolynomial<C>)oc[0]);
        List<List<GenSolvablePolynomial<C>>> Gz = this.leftZeroRelationsArbitrary(F2);
        ArrayList G1 = new ArrayList(Gz.size());
        ArrayList<GenSolvablePolynomial<C>> G2 = new ArrayList<GenSolvablePolynomial<C>>(Gz.size());
        for (List<GenSolvablePolynomial<C>> ll : Gz) {
            if (ll.get(0).isZERO()) continue;
            G1.add(ll.get(0));
            G2.add(ll.get(1));
        }
        logger.info((Object)("G1(den): " + G1 + ", G2(num): " + G2));
        SolvableExtendedGB<C> exgb = this.sbb.extLeftGB(G1);
        logger.info((Object)("exgb.F: " + exgb.F + ", exgb.G: " + exgb.G));
        List G = exgb.G;
        int m = 0;
        GenSolvablePolynomial min = null;
        for (int i = 0; i < G.size(); ++i) {
            if (min == null) {
                min = G.get(i);
                m = i;
                continue;
            }
            if (min.compareTo(G.get(i)) <= 0) continue;
            min = G.get(i);
            m = i;
        }
        GenSolvablePolynomial min2 = (GenSolvablePolynomial)this.blas.scalarProduct(PolynomialList.castToList(exgb.G2F.get(m)), PolynomialList.castToList(G2));
        logger.info((Object)("min(den): " + min + ", min(num): " + min2 + ", m = " + m + ", " + exgb.G2F.get(m)));
        GenSolvablePolynomial n = min2;
        GenSolvablePolynomial d = min;
        if (d.signum() < 0) {
            n = (GenSolvablePolynomial)n.negate();
            d = (GenSolvablePolynomial)d.negate();
        }
        if (!(lc = d.leadingBaseCoefficient()).isONE() && lc.isUnit()) {
            lc = (RingElem)lc.inverse();
            n = n.multiplyLeft(lc);
            d = d.multiplyLeft(lc);
        }
        if (this.debug && (t = this.compare(a, b, n, d)) != 0) {
            oc[0] = a;
            oc[1] = b;
            throw new RuntimeException("simp wrong, giving up: t = " + t);
        }
        oc[0] = n;
        oc[1] = d;
        return oc;
    }

    public int compare(GenSolvablePolynomial<C> num, GenSolvablePolynomial<C> den, GenSolvablePolynomial<C> n, GenSolvablePolynomial<C> d) {
        int s2;
        if (n == null || n.isZERO()) {
            return num.signum();
        }
        if (num.isZERO()) {
            return -n.signum();
        }
        int s1 = num.signum();
        int t = (s1 - (s2 = n.signum())) / 2;
        if (t != 0) {
            System.out.println("compareTo: t = " + t);
        }
        if (den.compareTo(d) == 0) {
            return num.compareTo(n);
        }
        GenSolvablePolynomial<C>[] oc = this.leftOreCond(den, d);
        if (this.debug) {
            System.out.println("oc[0] den =<>= oc[1] d: (" + oc[0] + ") (" + den + ") = (" + oc[1] + ") (" + d + ")");
        }
        GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>> r = oc[0].multiply(num);
        GenSolvablePolynomial<GenSolvablePolynomial<C>> s = oc[1].multiply(n);
        logger.info((Object)("compare: r = " + r + ", s = " + s));
        return r.compareTo((GenPolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>>)s);
    }
}

