/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbmod;

import edu.jas.gbmod.SolvableQuotient;
import edu.jas.gbmod.SolvableSyzygyAbstract;
import edu.jas.kern.StringUtil;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPairFactory;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class SolvableQuotientRing<C extends GcdRingElem<C>>
implements RingFactory<SolvableQuotient<C>>,
QuotPairFactory<GenPolynomial<C>, SolvableQuotient<C>> {
    private static final Logger logger = Logger.getLogger(SolvableQuotientRing.class);
    public final GenSolvablePolynomialRing<C> ring;
    public final SolvableSyzygyAbstract<C> engine;

    public SolvableQuotientRing(GenSolvablePolynomialRing<C> r) {
        this.ring = r;
        this.engine = new SolvableSyzygyAbstract();
        logger.debug((Object)"quotient ring constructed");
    }

    @Override
    public GenSolvablePolynomialRing<C> pairFactory() {
        return this.ring;
    }

    @Override
    public SolvableQuotient<C> create(GenPolynomial<C> n) {
        return new SolvableQuotient(this, (GenSolvablePolynomial)n);
    }

    @Override
    public SolvableQuotient<C> create(GenPolynomial<C> n, GenPolynomial<C> d) {
        return new SolvableQuotient(this, (GenSolvablePolynomial)n, (GenSolvablePolynomial)d);
    }

    @Override
    public boolean isFinite() {
        return this.ring.isFinite();
    }

    @Override
    public SolvableQuotient<C> copy(SolvableQuotient<C> c) {
        return new SolvableQuotient(c.ring, c.num, c.den, true);
    }

    @Override
    public SolvableQuotient<C> getZERO() {
        return new SolvableQuotient(this, this.ring.getZERO());
    }

    @Override
    public SolvableQuotient<C> getONE() {
        return new SolvableQuotient(this, this.ring.getONE());
    }

    @Override
    public List<SolvableQuotient<C>> generators() {
        List pgens = PolynomialList.castToSolvableList(this.ring.generators());
        ArrayList<SolvableQuotient<C>> gens = new ArrayList<SolvableQuotient<C>>(pgens.size() * 2 - 1);
        GenPolynomial one = this.ring.getONE();
        for (GenSolvablePolynomial p : pgens) {
            SolvableQuotient q = new SolvableQuotient(this, p);
            gens.add(q);
            if (p.isONE()) continue;
            q = new SolvableQuotient(this, one, p);
            gens.add(q);
        }
        return gens;
    }

    @Override
    public boolean isCommutative() {
        return this.ring.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        if (!this.ring.isAssociative()) {
            return false;
        }
        List<SolvableQuotient<C>> gens = this.generators();
        int ngen = gens.size();
        for (int i = 0; i < ngen; ++i) {
            SolvableQuotient<C> Xi = gens.get(i);
            for (int j = i + 1; j < ngen; ++j) {
                SolvableQuotient<SolvableQuotient<C>> Xj = gens.get(j);
                for (int k = j + 1; k < ngen; ++k) {
                    SolvableQuotient<SolvableQuotient<SolvableQuotient<C>>> q;
                    SolvableQuotient<SolvableQuotient<SolvableQuotient<C>>> Xk = gens.get(k);
                    SolvableQuotient<SolvableQuotient<C>> p = Xk.multiply(Xj).multiply((SolvableQuotient<SolvableQuotient<C>>)Xi);
                    if (p.equals(q = Xk.multiply(Xj.multiply(Xi)))) continue;
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Xk = " + Xk + ", Xj = " + Xj + ", Xi = " + Xi));
                        logger.info((Object)("p = ( Xk * Xj ) * Xi = " + p));
                        logger.info((Object)("q = Xk * ( Xj * Xi ) = " + q));
                    }
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public BigInteger characteristic() {
        return this.ring.characteristic();
    }

    @Override
    public SolvableQuotient<C> fromInteger(BigInteger a) {
        return new SolvableQuotient(this, this.ring.fromInteger(a));
    }

    @Override
    public SolvableQuotient<C> fromInteger(long a) {
        return new SolvableQuotient(this, this.ring.fromInteger(a));
    }

    public String toString() {
        String s = null;
        s = this.ring.coFac.characteristic().signum() == 0 ? "RatFunc" : "ModFunc";
        return s + "( " + this.ring.toString() + " )";
    }

    @Override
    public String toScript() {
        return "SRF(" + this.ring.toScript() + ")";
    }

    public boolean equals(Object b) {
        if (b == null) {
            return false;
        }
        if (!(b instanceof SolvableQuotientRing)) {
            return false;
        }
        SolvableQuotientRing a = (SolvableQuotientRing)b;
        return this.ring.equals(a.ring);
    }

    public int hashCode() {
        int h = this.ring.hashCode();
        return h;
    }

    @Override
    public SolvableQuotient<C> random(int n) {
        GenPolynomial s;
        GenPolynomial r = ((GenSolvablePolynomial)this.ring.random(n)).monic();
        while ((s = ((GenSolvablePolynomial)this.ring.random(n)).monic()).isZERO()) {
        }
        return new SolvableQuotient(this, r, s, false);
    }

    public SolvableQuotient<C> random(int k, int l, int d, float q) {
        GenPolynomial r = ((GenSolvablePolynomial)this.ring.random(k, l, d, q)).monic();
        GenPolynomial s = ((GenSolvablePolynomial)this.ring.random(k, l, d, q)).monic();
        while ((s = ((GenSolvablePolynomial)this.ring.random(k, l, d, q)).monic()).isZERO()) {
        }
        return new SolvableQuotient(this, r, s, false);
    }

    @Override
    public SolvableQuotient<C> random(int n, Random rnd) {
        GenPolynomial r = ((GenSolvablePolynomial)this.ring.random(n, rnd)).monic();
        GenPolynomial s = ((GenSolvablePolynomial)this.ring.random(n, rnd)).monic();
        while ((s = ((GenSolvablePolynomial)this.ring.random(n, rnd)).monic()).isZERO()) {
        }
        return new SolvableQuotient(this, r, s, false);
    }

    @Override
    public SolvableQuotient<C> parse(String s) {
        int i = s.indexOf("{");
        if (i >= 0) {
            s = s.substring(i + 1);
        }
        if ((i = s.lastIndexOf("}")) >= 0) {
            s = s.substring(0, i);
        }
        if ((i = s.indexOf("|")) < 0) {
            GenPolynomial n = this.ring.parse(s);
            return new SolvableQuotient(this, n);
        }
        String s1 = s.substring(0, i);
        String s2 = s.substring(i + 1);
        GenPolynomial n = this.ring.parse(s1);
        GenPolynomial d = this.ring.parse(s2);
        return new SolvableQuotient(this, n, d);
    }

    @Override
    public SolvableQuotient<C> parse(Reader r) {
        String s = StringUtil.nextPairedString(r, '{', '}');
        return this.parse(s);
    }
}

