/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.WordReduction;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.Overlap;
import edu.jas.poly.OverlapList;
import edu.jas.poly.Word;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class WordReductionAbstract<C extends RingElem<C>>
implements WordReduction<C> {
    private static final Logger logger = Logger.getLogger(WordReductionAbstract.class);

    @Override
    public List<GenWordPolynomial<C>> SPolynomials(GenWordPolynomial<C> Ap, GenWordPolynomial<C> Bp) {
        ArrayList<GenWordPolynomial<C>> sp = new ArrayList<GenWordPolynomial<C>>();
        if (Bp == null || Bp.isZERO()) {
            if (Ap == null) {
                sp.add(Bp);
                return sp;
            }
            sp.add((GenWordPolynomial<C>)Ap.ring.getZERO());
            return sp;
        }
        if (Ap == null || Ap.isZERO()) {
            sp.add((GenWordPolynomial<C>)Bp.ring.getZERO());
            return sp;
        }
        Map.Entry<Word, C> ma = Ap.leadingMonomial();
        Map.Entry<Word, C> mb = Bp.leadingMonomial();
        Word e = ma.getKey();
        Word f = mb.getKey();
        RingElem a = (RingElem)ma.getValue();
        RingElem b = (RingElem)mb.getValue();
        OverlapList oll = e.overlap(f);
        if (oll.ols.isEmpty()) {
            return sp;
        }
        for (Overlap ol : oll.ols) {
            GenWordPolynomial<RingElem> s = this.SPolynomial(ol, b, Ap, a, Bp);
            sp.add(s);
        }
        return sp;
    }

    @Override
    public GenWordPolynomial<C> SPolynomial(C a, Word l1, GenWordPolynomial<C> A, Word r1, C b, Word l2, GenWordPolynomial<C> B, Word r2) {
        RingElem one = (RingElem)A.ring.coFac.getONE();
        GenWordPolynomial<RingElem> s1 = A.multiply((RingElem)a, l1, one, r1);
        GenWordPolynomial<RingElem> s2 = B.multiply((RingElem)b, l2, one, r2);
        GenWordPolynomial<GenWordPolynomial<RingElem>> s = s1.subtract((RingElem)s2);
        return s;
    }

    public GenWordPolynomial<C> SPolynomial(Overlap ol, C a, GenWordPolynomial<C> A, C b, GenWordPolynomial<C> B) {
        RingElem one = (RingElem)A.ring.coFac.getONE();
        GenWordPolynomial<RingElem> s1 = A.multiply((RingElem)a, ol.l1, one, ol.r1);
        GenWordPolynomial<RingElem> s2 = B.multiply((RingElem)b, ol.l2, one, ol.r2);
        GenWordPolynomial<GenWordPolynomial<RingElem>> s = s1.subtract((RingElem)s2);
        return s;
    }

    @Override
    public List<GenWordPolynomial<C>> normalform(List<GenWordPolynomial<C>> Pp, List<GenWordPolynomial<C>> Ap) {
        if (Pp == null || Pp.isEmpty()) {
            return Ap;
        }
        if (Ap == null || Ap.isEmpty()) {
            return Ap;
        }
        ArrayList<GenWordPolynomial<C>> red = new ArrayList<GenWordPolynomial<C>>();
        for (GenWordPolynomial<C> A : Ap) {
            A = this.normalform(Pp, A);
            red.add(A);
        }
        return red;
    }

    @Override
    public boolean isTopReducible(List<GenWordPolynomial<C>> P, GenWordPolynomial<C> A) {
        if (P == null || P.isEmpty()) {
            return false;
        }
        if (A == null || A.isZERO()) {
            return false;
        }
        boolean mt = false;
        Word e = A.leadingWord();
        for (GenWordPolynomial<C> p : P) {
            mt = e.multipleOf(p.leadingWord());
            if (!mt) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isReducible(List<GenWordPolynomial<C>> Pp, GenWordPolynomial<C> Ap) {
        return !this.isNormalform(Pp, Ap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNormalform(List<GenWordPolynomial<C>> Pp, GenWordPolynomial<C> Ap) {
        int i;
        GenWordPolynomial[] P;
        int l;
        if (Pp == null || Pp.isEmpty()) {
            return true;
        }
        if (Ap == null || Ap.isZERO()) {
            return true;
        }
        List<GenWordPolynomial<C>> list = Pp;
        synchronized (list) {
            l = Pp.size();
            P = new GenWordPolynomial[l];
            for (int i2 = 0; i2 < Pp.size(); ++i2) {
                P[i2] = Pp.get(i2);
            }
        }
        Word[] htl = new Word[l];
        GenWordPolynomial[] p = new GenWordPolynomial[l];
        int j = 0;
        for (i = 0; i < l; ++i) {
            p[i] = P[i];
            Map.Entry m = p[i].leadingMonomial();
            if (m == null) continue;
            p[j] = p[i];
            htl[j] = m.getKey();
            ++j;
        }
        l = j;
        boolean mt = false;
        for (Word e : Ap.getMap().keySet()) {
            for (i = 0; i < l; ++i) {
                mt = e.multipleOf(htl[i]);
                if (!mt) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isNormalform(List<GenWordPolynomial<C>> Pp) {
        if (Pp == null || Pp.isEmpty()) {
            return true;
        }
        LinkedList<GenWordPolynomial<C>> P = new LinkedList<GenWordPolynomial<C>>(Pp);
        int s = P.size();
        for (int i = 0; i < s; ++i) {
            GenWordPolynomial Ap = (GenWordPolynomial)P.remove(i);
            if (!this.isNormalform(P, Ap)) {
                return false;
            }
            P.add(Ap);
        }
        return true;
    }

    @Override
    public List<GenWordPolynomial<C>> irreducibleSet(List<GenWordPolynomial<C>> Pp) {
        ArrayList<GenWordPolynomial<C>> P = new ArrayList<GenWordPolynomial<C>>();
        for (GenWordPolynomial<C> a : Pp) {
            if (a.length() == 0) continue;
            if ((a = a.monic()).isONE()) {
                P.clear();
                P.add(a);
                return P;
            }
            P.add(a);
        }
        int l = P.size();
        if (l <= 1) {
            return P;
        }
        int irr = 0;
        logger.debug((Object)"irr = ");
        while (irr != l) {
            GenWordPolynomial<C> a = P.remove(0);
            Word e = a.leadingWord();
            a = this.normalform(P, a);
            logger.debug((Object)String.valueOf(irr));
            if (a.length() == 0) {
                if (--l > 1) continue;
                return P;
            }
            Word f = a.leadingWord();
            if (f.signum() == 0) {
                P = new ArrayList();
                P.add(a.monic());
                return P;
            }
            if (e.equals(f)) {
                ++irr;
            } else {
                irr = 0;
                a = a.monic();
            }
            P.add(a);
        }
        return P;
    }

    @Override
    public boolean isReductionNF(List<GenWordPolynomial<C>> lrow, List<GenWordPolynomial<C>> rrow, List<GenWordPolynomial<C>> Pp, GenWordPolynomial<C> Ap, GenWordPolynomial<C> Np) {
        if (lrow == null && rrow == null && Pp == null) {
            if (Ap == null) {
                return Np == null;
            }
            return Ap.equals(Np);
        }
        if (lrow == null || rrow == null || Pp == null) {
            return false;
        }
        if (lrow.size() != Pp.size() || rrow.size() != Pp.size()) {
            return false;
        }
        GenWordPolynomial<GenWordPolynomial<Object>> t = Np;
        for (int m = 0; m < Pp.size(); ++m) {
            GenWordPolynomial<C> rl = lrow.get(m);
            GenWordPolynomial<C> rr = rrow.get(m);
            GenWordPolynomial<GenWordPolynomial<C>> p = Pp.get(m);
            if (rl == null || rr == null || p == null) continue;
            t = t == null ? p.multiply(rl, rr) : t.sum((GenWordPolynomial<Object>)p.multiply(rl, rr));
        }
        if (t == null) {
            if (Ap == null) {
                return true;
            }
            return Ap.isZERO();
        }
        GenWordPolynomial<GenWordPolynomial<C>> r = t.subtract((GenWordPolynomial<Object>)Ap);
        boolean z = r.isZERO();
        if (!z) {
            logger.info((Object)("t = " + t));
            logger.info((Object)("a = " + Ap));
            logger.info((Object)("t-a = " + r));
        }
        return z;
    }
}

