/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.WordGroebnerBaseAbstract;
import edu.jas.gb.WordPair;
import edu.jas.gb.WordPairList;
import edu.jas.gb.WordReduction;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.GenWordPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.RingElem;
import java.util.List;
import org.apache.log4j.Logger;

public class WordGroebnerBaseSeq<C extends RingElem<C>>
extends WordGroebnerBaseAbstract<C> {
    private static final Logger logger = Logger.getLogger(WordGroebnerBaseSeq.class);
    private final boolean debug = logger.isDebugEnabled();

    public WordGroebnerBaseSeq() {
    }

    public WordGroebnerBaseSeq(WordReduction<C> red) {
        super(red);
    }

    public WordGroebnerBaseSeq(WordReduction<C> red, WordPairList<C> pl) {
        super(red, pl);
    }

    @Override
    public List<GenWordPolynomial<C>> GB(List<GenWordPolynomial<C>> F2) {
        List<GenWordPolynomial<C>> G = this.normalizeZerosOnes(F2);
        if ((G = PolyUtil.wordMonic(G)).size() <= 1) {
            return G;
        }
        GenWordPolynomialRing ring = G.get((int)0).ring;
        if (!ring.coFac.isField()) {
            throw new IllegalArgumentException("coefficients not from a field");
        }
        WordPairList<C> pairlist = this.strategy.create(ring);
        pairlist.put(G);
        logger.info((Object)("start " + pairlist));
        while (pairlist.hasNext()) {
            List S;
            WordPair pair = pairlist.removeNext();
            if (pair == null) continue;
            GenWordPolynomial pi = pair.pi;
            GenWordPolynomial pj = pair.pj;
            if (this.debug) {
                logger.debug((Object)("pi    = " + pi));
                logger.debug((Object)("pj    = " + pj));
            }
            if ((S = this.red.SPolynomials(pi, pj)).isEmpty()) continue;
            for (GenWordPolynomial s : S) {
                if (s.isZERO()) continue;
                if (this.debug) {
                    logger.debug((Object)("ht(S) = " + s.leadingWord()));
                }
                GenWordPolynomial<C> H = this.red.normalform(G, s);
                if (this.debug) {
                    logger.info((Object)("ht(H) = " + H.monic()));
                }
                if (H.isZERO()) continue;
                H = H.monic();
                if (this.debug) {
                    logger.info((Object)("ht(H) = " + H.leadingWord()));
                }
                if (H.isONE()) {
                    G.clear();
                    G.add(H);
                    return G;
                }
                if (this.debug) {
                    logger.info((Object)("H = " + H));
                }
                if (H.length() <= 0) continue;
                G.add(H);
                pairlist.put(H);
            }
        }
        logger.debug((Object)("#sequential list = " + G.size()));
        G = this.minimalGB(G);
        logger.info((Object)("" + pairlist));
        return G;
    }
}

