/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.OrderedWordPairlist;
import edu.jas.gb.WordGroebnerBase;
import edu.jas.gb.WordPairList;
import edu.jas.gb.WordReduction;
import edu.jas.gb.WordReductionSeq;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class WordGroebnerBaseAbstract<C extends RingElem<C>>
implements WordGroebnerBase<C> {
    private static final Logger logger = Logger.getLogger(WordGroebnerBaseAbstract.class);
    private final boolean debug = logger.isDebugEnabled();
    public final WordReduction<C> red;
    public final WordPairList<C> strategy;

    public WordGroebnerBaseAbstract() {
        this(new WordReductionSeq());
    }

    public WordGroebnerBaseAbstract(WordReduction<C> red) {
        this(red, new OrderedWordPairlist());
    }

    public WordGroebnerBaseAbstract(WordReduction<C> red, WordPairList<C> pl) {
        this.red = red;
        this.strategy = pl;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public List<GenWordPolynomial<C>> normalizeZerosOnes(List<GenWordPolynomial<C>> A) {
        ArrayList<GenWordPolynomial<C>> N2 = new ArrayList<GenWordPolynomial<C>>(A.size());
        if (A == null || A.isEmpty()) {
            return N2;
        }
        for (GenWordPolynomial<C> p : A) {
            if (p == null || p.isZERO()) continue;
            if (p.isUnit()) {
                N2.clear();
                N2.add((GenWordPolynomial<C>)p.ring.getONE());
                return N2;
            }
            N2.add((GenWordPolynomial<C>)p.abs());
        }
        return N2;
    }

    @Override
    public boolean isGB(List<GenWordPolynomial<C>> F2) {
        if (F2 == null || F2.isEmpty()) {
            return true;
        }
        for (int i = 0; i < F2.size(); ++i) {
            GenWordPolynomial<C> pi = F2.get(i);
            for (int j = i + 1; j < F2.size(); ++j) {
                GenWordPolynomial<C> pj = F2.get(j);
                List<GenWordPolynomial<C>> S = this.red.SPolynomials(pi, pj);
                if (S.isEmpty()) continue;
                for (GenWordPolynomial<C> s : S) {
                    GenWordPolynomial<C> h = this.red.normalform(F2, s);
                    if (h.isZERO()) continue;
                    logger.info((Object)("no GB: pi = " + pi + ", pj = " + pj));
                    logger.info((Object)("s  = " + s + ", h = " + h));
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public abstract List<GenWordPolynomial<C>> GB(List<GenWordPolynomial<C>> var1);

    @Override
    public List<GenWordPolynomial<C>> minimalGB(List<GenWordPolynomial<C>> Gp) {
        GenWordPolynomial<C> a;
        if (Gp == null || Gp.size() <= 1) {
            return Gp;
        }
        ArrayList<GenWordPolynomial<C>> G = new ArrayList<GenWordPolynomial<C>>(Gp.size());
        for (GenWordPolynomial<C> a2 : Gp) {
            if (a2 == null || a2.isZERO()) continue;
            G.add(a2);
        }
        if (G.size() <= 1) {
            return G;
        }
        ArrayList F2 = new ArrayList(G.size());
        while (G.size() > 0) {
            a = (GenWordPolynomial<C>)G.remove(0);
            if (this.red.isTopReducible(G, a) || this.red.isTopReducible(F2, a)) {
                if (!this.debug) continue;
                System.out.println("dropped " + a);
                ArrayList<GenWordPolynomial<C>> ff = new ArrayList<GenWordPolynomial<C>>(G);
                ff.addAll(F2);
                if ((a = this.red.normalform(ff, a)).isZERO()) continue;
                System.out.println("error, nf(a) " + a);
                continue;
            }
            F2.add(a);
        }
        G = F2;
        if (G.size() <= 1) {
            return G;
        }
        Collections.reverse(G);
        int len = G.size();
        if (this.debug) {
            System.out.println("#G " + len);
            for (GenWordPolynomial genWordPolynomial : G) {
                System.out.println("aa = " + genWordPolynomial.length() + ", lt = " + genWordPolynomial.getMap().keySet());
            }
        }
        for (int i = 0; i < len; ++i) {
            a = (GenWordPolynomial)G.remove(0);
            if (this.debug) {
                System.out.println("doing " + a.length() + ", lt = " + a.leadingWord());
            }
            a = this.red.normalform(G, a);
            G.add(a);
        }
        return G;
    }

    public boolean isMinimalGB(List<GenWordPolynomial<C>> Gp) {
        if (Gp == null || Gp.size() == 0) {
            return true;
        }
        for (GenWordPolynomial<C> a : Gp) {
            if (a != null && !a.isZERO()) continue;
            if (this.debug) {
                logger.debug((Object)("zero polynomial " + a));
            }
            return false;
        }
        ArrayList G = new ArrayList<GenWordPolynomial<C>>(Gp);
        ArrayList F2 = new ArrayList(G.size());
        while (G.size() > 0) {
            GenWordPolynomial a = (GenWordPolynomial)G.remove(0);
            if (this.red.isTopReducible(G, a) || this.red.isTopReducible(F2, a)) {
                if (this.debug) {
                    logger.debug((Object)("top reducible polynomial " + a));
                }
                return false;
            }
            F2.add(a);
        }
        G = F2;
        if (G.size() <= 1) {
            return true;
        }
        int len = G.size();
        for (int i = 0; i < len; ++i) {
            GenWordPolynomial a = (GenWordPolynomial)G.remove(0);
            if (!this.red.isNormalform(G, a)) {
                if (this.debug) {
                    logger.debug((Object)("reducible polynomial " + a));
                }
                return false;
            }
            G.add(a);
        }
        return true;
    }

    public void terminate() {
        logger.info((Object)"terminate not implemented");
    }

    public int cancel() {
        logger.info((Object)"cancel not implemented");
        return 0;
    }
}

