/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.gb.SolvableExtendedGB;
import edu.jas.gb.SolvableGroebnerBaseAbstract;
import edu.jas.gb.SolvableReduction;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class SolvableGroebnerBaseSeq<C extends RingElem<C>>
extends SolvableGroebnerBaseAbstract<C> {
    private static final Logger logger = Logger.getLogger(SolvableGroebnerBaseSeq.class);
    private final boolean debug = logger.isDebugEnabled();

    public SolvableGroebnerBaseSeq() {
    }

    public SolvableGroebnerBaseSeq(SolvableReduction<C> sred, PairList<C> pl) {
        super(sred, pl);
    }

    @Override
    public List<GenSolvablePolynomial<C>> leftGB(int modv, List<GenSolvablePolynomial<C>> F2) {
        List<GenSolvablePolynomial<C>> G = new ArrayList<GenSolvablePolynomial<C>>();
        if (F2 == null) {
            return G;
        }
        PairList pairlist = null;
        int l = F2.size();
        for (GenSolvablePolynomial<C> genSolvablePolynomial : F2) {
            if (genSolvablePolynomial.length() > 0) {
                GenPolynomial genPolynomial = genSolvablePolynomial.monic();
                if (genPolynomial.isONE()) {
                    G.clear();
                    G.add((GenSolvablePolynomial<C>)genPolynomial);
                    return G;
                }
                G.add((GenSolvablePolynomial<C>)genPolynomial);
                if (pairlist == null) {
                    pairlist = this.strategy.create(modv, ((GenSolvablePolynomial)genPolynomial).ring);
                }
                pairlist.put(genPolynomial);
                continue;
            }
            --l;
        }
        if (l <= 1) {
            return G;
        }
        while (pairlist.hasNext()) {
            GenPolynomial H;
            GenSolvablePolynomial S;
            Pair pair = pairlist.removeNext();
            if (pair == null) continue;
            GenSolvablePolynomial pi = (GenSolvablePolynomial)pair.pi;
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)pair.pj;
            if (this.debug) {
                logger.info((Object)("pi    = " + pi));
                logger.info((Object)("pj    = " + genSolvablePolynomial));
            }
            if ((S = this.sred.leftSPolynomial(pi, genSolvablePolynomial)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (this.debug) {
                logger.info((Object)("ht(S) = " + S.leadingExpVector()));
            }
            if ((H = this.sred.leftNormalform(G, S)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (this.debug) {
                logger.info((Object)("ht(H) = " + H.leadingExpVector()));
            }
            if ((H = ((GenSolvablePolynomial)H).monic()).isONE()) {
                G.clear();
                G.add((GenSolvablePolynomial<C>)H);
                return G;
            }
            if (this.debug) {
                logger.info((Object)("H = " + H));
            }
            if (H.length() <= 0) continue;
            ++l;
            G.add((GenSolvablePolynomial<C>)H);
            pairlist.put(H);
        }
        logger.debug((Object)("#sequential list = " + G.size()));
        G = this.leftMinimalGB(G);
        logger.info((Object)("" + pairlist));
        return G;
    }

    @Override
    public SolvableExtendedGB<C> extLeftGB(int modv, List<GenSolvablePolynomial<C>> F2) {
        GenPolynomial H;
        if (F2 == null || F2.isEmpty()) {
            throw new IllegalArgumentException("null or empty F not allowed");
        }
        List G = new ArrayList();
        ArrayList F2G = new ArrayList();
        List<List<GenSolvablePolynomial<C>>> G2F = new ArrayList<List<GenSolvablePolynomial<C>>>();
        PairList<C> pairlist = null;
        boolean oneInGB = false;
        int len = F2.size();
        List<GenSolvablePolynomial<Object>> row = null;
        ArrayList rows = null;
        ArrayList rowh = null;
        GenSolvablePolynomialRing ring = null;
        int nzlen = 0;
        for (GenSolvablePolynomial<C> f : F2) {
            if (f.length() > 0) {
                ++nzlen;
            }
            if (ring != null) continue;
            ring = f.ring;
        }
        GenPolynomial mone = ring.getONE();
        int k = 0;
        ListIterator<GenSolvablePolynomial<C>> it = F2.listIterator();
        while (it.hasNext()) {
            GenSolvablePolynomial<C> p = it.next();
            if (p.length() > 0) {
                row = new ArrayList(nzlen);
                for (int j = 0; j < nzlen; ++j) {
                    row.add(null);
                }
                row.set(k, (GenSolvablePolynomial<Object>)mone);
                ++k;
                if (p.isUnit()) {
                    G.clear();
                    G.add(p);
                    G2F.clear();
                    G2F.add(row);
                    oneInGB = true;
                    break;
                }
                G.add(p);
                G2F.add(row);
                if (pairlist == null) {
                    pairlist = this.strategy.create(modv, p.ring);
                }
                pairlist.put(p);
                continue;
            }
            --len;
        }
        if (len <= 1 || oneInGB) {
            for (GenSolvablePolynomial<C> f : F2) {
                row = new ArrayList(G.size());
                for (int j = 0; j < G.size(); ++j) {
                    row.add(null);
                }
                GenSolvablePolynomial H2 = this.sred.leftNormalform(row, G, f);
                if (!H2.isZERO()) {
                    logger.error((Object)("nonzero H = " + H2));
                }
                F2G.add(row);
            }
            SolvableExtendedGB<C> exgb = new SolvableExtendedGB<C>(F2, G, F2G, G2F);
            return exgb;
        }
        while (pairlist.hasNext() && !oneInGB) {
            int m;
            Pair pair = pairlist.removeNext();
            if (pair == null) continue;
            int i = pair.i;
            int j = pair.j;
            GenSolvablePolynomial pi = (GenSolvablePolynomial)pair.pi;
            GenSolvablePolynomial pj = (GenSolvablePolynomial)pair.pj;
            if (this.debug) {
                logger.info((Object)("i, pi    = " + i + ", " + pi));
                logger.info((Object)("j, pj    = " + j + ", " + pj));
            }
            rows = new ArrayList(G.size());
            for (m = 0; m < G.size(); ++m) {
                rows.add(null);
            }
            GenSolvablePolynomial S = this.sred.leftSPolynomial(rows, i, pi, j, pj);
            if (this.debug) {
                logger.debug((Object)("is reduction S = " + this.sred.isLeftReductionNF(rows, G, ring.getZERO(), S)));
            }
            if (S.isZERO()) {
                pair.setZero();
                continue;
            }
            if (this.debug) {
                logger.debug((Object)("ht(S) = " + S.leadingExpVector()));
            }
            rowh = new ArrayList(G.size());
            for (m = 0; m < G.size(); ++m) {
                rowh.add(null);
            }
            H = this.sred.leftNormalform(rowh, G, S);
            if (this.debug) {
                logger.debug((Object)("is reduction H = " + this.sred.isLeftReductionNF(rowh, G, S, H)));
            }
            if (H.isZERO()) {
                pair.setZero();
                continue;
            }
            if (this.debug) {
                logger.debug((Object)("ht(H) = " + H.leadingExpVector()));
            }
            row = new ArrayList(G.size() + 1);
            for (m = 0; m < G.size(); ++m) {
                GenSolvablePolynomial y;
                GenSolvablePolynomial x = (GenSolvablePolynomial)rows.get(m);
                if (x != null) {
                    x = (GenSolvablePolynomial)x.negate();
                }
                if ((y = (GenSolvablePolynomial)rowh.get(m)) != null) {
                    y = (GenSolvablePolynomial)y.negate();
                }
                x = x == null ? y : (GenSolvablePolynomial)x.sum(y);
                row.add(x);
            }
            if (this.debug) {
                logger.debug((Object)("is reduction 0+sum(row,G) == H : " + this.sred.isLeftReductionNF(row, G, H, ring.getZERO())));
            }
            row.add(null);
            Object c = H.leadingBaseCoefficient();
            c = (RingElem)c.inverse();
            H = ((GenSolvablePolynomial)H).multiply((RingElem)c);
            row = PolynomialList.castToSolvableList(this.blas.scalarProduct(((GenSolvablePolynomial)mone).multiply((RingElem)c), PolynomialList.castToList(row)));
            row.set(G.size(), (GenSolvablePolynomial<Object>)mone);
            if (H.isONE()) {
                G.add(H);
                G2F.add(row);
                oneInGB = true;
                break;
            }
            if (this.debug) {
                logger.debug((Object)("H = " + H));
            }
            G.add(H);
            pairlist.put(H);
            G2F.add(row);
        }
        if (this.debug) {
            SolvableExtendedGB<C> exgb = new SolvableExtendedGB<C>(F2, G, F2G, G2F);
            logger.info((Object)("exgb unnorm = " + exgb));
        }
        G2F = this.normalizeMatrix(F2.size(), G2F);
        if (this.debug) {
            SolvableExtendedGB<C> exgb = new SolvableExtendedGB<C>(F2, G, F2G, G2F);
            logger.info((Object)("exgb nonmin = " + exgb));
            boolean t2 = this.isLeftReductionMatrix(exgb);
            logger.debug((Object)("exgb t2 = " + t2));
        }
        SolvableExtendedGB exgb = this.minimalSolvableExtendedGB(F2.size(), G, G2F);
        G = exgb.G;
        G2F = exgb.G2F;
        logger.debug((Object)("#sequential list = " + G.size()));
        logger.info((Object)("" + pairlist));
        for (GenSolvablePolynomial<C> f : F2) {
            row = new ArrayList(G.size());
            for (int m = 0; m < G.size(); ++m) {
                row.add(null);
            }
            H = this.sred.leftNormalform(row, G, f);
            if (!H.isZERO()) {
                logger.error((Object)("nonzero H = " + H));
            }
            F2G.add(row);
        }
        return new SolvableExtendedGB<C>(F2, G, F2G, G2F);
    }

    @Override
    public List<GenSolvablePolynomial<C>> twosidedGB(int modv, List<GenSolvablePolynomial<C>> Fp) {
        GenSolvablePolynomial x;
        GenPolynomial p;
        if (Fp == null || Fp.size() == 0) {
            return new ArrayList<GenSolvablePolynomial<C>>();
        }
        GenSolvablePolynomialRing fac = Fp.get((int)0).ring;
        List X = fac.univariateList(modv);
        ArrayList F2 = new ArrayList(Fp.size() * (1 + X.size()));
        F2.addAll(Fp);
        for (int i = 0; i < Fp.size(); ++i) {
            p = Fp.get(i);
            for (int j = 0; j < X.size(); ++j) {
                x = X.get(j);
                GenSolvablePolynomial q = ((GenSolvablePolynomial)p).multiply(x);
                if ((q = this.sred.leftNormalform(F2, q)).isZERO()) continue;
                F2.add(q);
            }
        }
        List<GenSolvablePolynomial<C>> G = new ArrayList<GenSolvablePolynomial<C>>();
        PairList pairlist = null;
        int l = F2.size();
        ListIterator it = F2.listIterator();
        while (it.hasNext()) {
            p = (GenSolvablePolynomial)it.next();
            if (p.length() > 0) {
                if ((p = ((GenSolvablePolynomial)p).monic()).isONE()) {
                    G.clear();
                    G.add((GenSolvablePolynomial<C>)p);
                    return G;
                }
                G.add((GenSolvablePolynomial<C>)p);
                if (pairlist == null) {
                    pairlist = this.strategy.create(modv, ((GenSolvablePolynomial)p).ring);
                    if (!((GenSolvablePolynomial)p).ring.coFac.isField()) {
                        logger.warn((Object)("coefficients not from a field " + ((GenSolvablePolynomial)p).ring.coFac));
                    }
                }
                pairlist.put(p);
                continue;
            }
            --l;
        }
        if (l <= 1) {
            return G;
        }
        while (pairlist.hasNext()) {
            GenPolynomial H;
            GenSolvablePolynomial S;
            Pair pair = pairlist.removeNext();
            if (pair == null) continue;
            GenSolvablePolynomial pi = (GenSolvablePolynomial)pair.pi;
            GenSolvablePolynomial pj = (GenSolvablePolynomial)pair.pj;
            if (this.debug) {
                logger.debug((Object)("pi    = " + pi));
                logger.debug((Object)("pj    = " + pj));
            }
            if ((S = this.sred.leftSPolynomial(pi, pj)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (this.debug) {
                logger.debug((Object)("ht(S) = " + S.leadingExpVector()));
            }
            if ((H = this.sred.leftNormalform(G, S)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (this.debug) {
                logger.debug((Object)("ht(H) = " + H.leadingExpVector()));
            }
            if ((H = ((GenSolvablePolynomial)H).monic()).isONE()) {
                G.clear();
                G.add((GenSolvablePolynomial<C>)H);
                return G;
            }
            if (this.debug) {
                logger.debug((Object)("H = " + H));
            }
            if (H.length() <= 0) continue;
            ++l;
            G.add((GenSolvablePolynomial<C>)H);
            pairlist.put(H);
            for (int j = 0; j < X.size(); ++j) {
                ++l;
                x = X.get(j);
                p = ((GenSolvablePolynomial)H).multiply(x);
                if ((p = this.sred.leftNormalform(G, p)).isZERO()) continue;
                if ((p = ((GenSolvablePolynomial)p).monic()).isONE()) {
                    G.clear();
                    G.add((GenSolvablePolynomial<C>)p);
                    return G;
                }
                G.add((GenSolvablePolynomial<C>)p);
                pairlist.put(p);
            }
        }
        logger.debug((Object)("#sequential list = " + G.size()));
        G = this.leftMinimalGB(G);
        logger.info((Object)("" + pairlist));
        return G;
    }

    public List<List<GenSolvablePolynomial<C>>> normalizeMatrix(int flen, List<List<GenSolvablePolynomial<C>>> M) {
        if (M == null) {
            return M;
        }
        if (M.size() == 0) {
            return M;
        }
        ArrayList<List<GenSolvablePolynomial<Object>>> N2 = new ArrayList<List<GenSolvablePolynomial<Object>>>();
        ArrayList<List<GenSolvablePolynomial<C>>> K = new ArrayList<List<GenSolvablePolynomial<C>>>();
        int len = M.get(M.size() - 1).size();
        for (List<GenSolvablePolynomial<C>> row : M) {
            ArrayList<GenSolvablePolynomial<C>> arrayList = new ArrayList<GenSolvablePolynomial<C>>(row);
            for (int i = row.size(); i < len; ++i) {
                arrayList.add(null);
            }
            N2.add(arrayList);
        }
        int k = flen;
        for (int i = 0; i < N2.size(); ++i) {
            List list = (List)N2.get(i);
            if (this.debug) {
                logger.info((Object)("row = " + list));
            }
            K.add(list);
            if (i < flen) continue;
            for (int j = i + 1; j < N2.size(); ++j) {
                GenSolvablePolynomial a;
                List nrow = (List)N2.get(j);
                if (k >= nrow.size() || (a = (GenSolvablePolynomial)nrow.get(k)) == null || a.isZERO()) continue;
                List yrow = this.blas.scalarProduct(a, PolynomialList.castToList(list));
                yrow = this.blas.vectorAdd(yrow, PolynomialList.castToList(nrow));
                List xrow = PolynomialList.castToSolvableList(yrow);
                N2.set(j, xrow);
            }
            ++k;
        }
        N2.clear();
        for (List list : K) {
            ArrayList tr = new ArrayList();
            for (int i = 0; i < flen; ++i) {
                tr.add(list.get(i));
            }
            N2.add(tr);
        }
        K = N2;
        return K;
    }

    @Override
    public boolean isLeftReductionMatrix(SolvableExtendedGB<C> exgb) {
        if (exgb == null) {
            return true;
        }
        return this.isLeftReductionMatrix(exgb.F, exgb.G, exgb.F2G, exgb.G2F);
    }

    public SolvableExtendedGB<C> minimalSolvableExtendedGB(int flen, List<GenSolvablePolynomial<C>> Gp, List<List<GenSolvablePolynomial<C>>> M) {
        List<GenSolvablePolynomial<Object>> row;
        if (Gp == null) {
            return null;
        }
        if (Gp.size() <= 1) {
            return new SolvableExtendedGB<C>(null, Gp, null, M);
        }
        ArrayList<GenSolvablePolynomial<C>> G = new ArrayList<GenSolvablePolynomial<C>>(Gp);
        ArrayList F2 = new ArrayList(Gp.size());
        ArrayList<ArrayList<GenSolvablePolynomial<C>>> Mg = new ArrayList<ArrayList<GenSolvablePolynomial<C>>>(M.size());
        ArrayList Mf = new ArrayList(M.size());
        for (List<GenSolvablePolynomial<C>> r : M) {
            row = new ArrayList<GenSolvablePolynomial<C>>(r);
            Mg.add((ArrayList<GenSolvablePolynomial<C>>)row);
        }
        row = null;
        ArrayList<Integer> ix = new ArrayList<Integer>();
        ArrayList<Integer> jx = new ArrayList<Integer>();
        int k = 0;
        while (G.size() > 0) {
            ExpVector f;
            GenSolvablePolynomial p;
            GenSolvablePolynomial a = (GenSolvablePolynomial)G.remove(0);
            ExpVector e = a.leadingExpVector();
            ListIterator it = G.listIterator();
            boolean mt = false;
            while (it.hasNext() && !mt) {
                p = (GenSolvablePolynomial)it.next();
                f = p.leadingExpVector();
                mt = e.multipleOf(f);
            }
            it = F2.listIterator();
            while (it.hasNext() && !mt) {
                p = (GenSolvablePolynomial)it.next();
                f = p.leadingExpVector();
                mt = e.multipleOf(f);
            }
            if (!mt) {
                F2.add(a);
                ix.add(k);
            } else {
                jx.add(k);
            }
            ++k;
        }
        if (this.debug) {
            logger.debug((Object)("ix, #M, jx = " + ix + ", " + Mg.size() + ", " + jx));
        }
        int fix = -1;
        for (int i = 0; i < ix.size(); ++i) {
            int u = (Integer)ix.get(i);
            if (u >= flen && fix == -1) {
                fix = Mf.size();
            }
            if (u < 0) continue;
            row = (List)Mg.get(u);
            Mf.add(row);
        }
        if (F2.size() <= 1 || fix == -1) {
            return new SolvableExtendedGB(null, F2, null, Mf);
        }
        return new SolvableExtendedGB(null, F2, null, Mf);
    }
}

