/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.LeftSolvableReducer;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.PairList;
import edu.jas.gb.SolvableExtendedGB;
import edu.jas.gb.SolvableGroebnerBaseAbstract;
import edu.jas.gb.SolvableMiReducer;
import edu.jas.gb.SolvableReduction;
import edu.jas.gb.SolvableReductionPar;
import edu.jas.gb.TwosidedSolvableReducer;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.structure.RingElem;
import edu.jas.util.Terminator;
import edu.jas.util.ThreadPool;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class SolvableGroebnerBaseParallel<C extends RingElem<C>>
extends SolvableGroebnerBaseAbstract<C> {
    private static final Logger logger = Logger.getLogger(SolvableGroebnerBaseParallel.class);
    protected final int threads;
    protected final transient ThreadPool pool;

    public SolvableGroebnerBaseParallel() {
        this(2);
    }

    public SolvableGroebnerBaseParallel(int threads) {
        this(threads, new ThreadPool(threads));
    }

    public SolvableGroebnerBaseParallel(int threads, ThreadPool pool) {
        this(threads, pool, new SolvableReductionPar());
    }

    public SolvableGroebnerBaseParallel(int threads, SolvableReduction<C> sred) {
        this(threads, new ThreadPool(threads), sred);
    }

    public SolvableGroebnerBaseParallel(int threads, PairList<C> pl) {
        this(threads, new ThreadPool(threads), new SolvableReductionPar(), pl);
    }

    public SolvableGroebnerBaseParallel(int threads, SolvableReduction<C> sred, PairList<C> pl) {
        this(threads, new ThreadPool(threads), sred, pl);
    }

    public SolvableGroebnerBaseParallel(int threads, ThreadPool pool, SolvableReduction<C> sred) {
        this(threads, pool, sred, new OrderedPairlist());
    }

    public SolvableGroebnerBaseParallel(int threads, ThreadPool pool, SolvableReduction<C> sred, PairList<C> pl) {
        super(sred, pl);
        if (!(sred instanceof SolvableReductionPar)) {
            logger.warn((Object)"parallel GB should use parallel aware reduction");
        }
        if (threads < 1) {
            threads = 1;
        }
        this.threads = threads;
        this.pool = pool;
    }

    @Override
    public void terminate() {
        if (this.pool == null) {
            return;
        }
        this.pool.terminate();
    }

    @Override
    public List<GenSolvablePolynomial<C>> leftGB(int modv, List<GenSolvablePolynomial<C>> F2) {
        List<GenSolvablePolynomial<C>> G = new ArrayList<GenSolvablePolynomial<C>>();
        if (F2 == null) {
            return G;
        }
        PairList pairlist = null;
        int l = F2.size();
        ListIterator<GenSolvablePolynomial<C>> it = F2.listIterator();
        while (it.hasNext()) {
            GenPolynomial p = it.next();
            if (p.length() > 0) {
                if ((p = ((GenSolvablePolynomial)p).monic()).isONE()) {
                    G.clear();
                    G.add((GenSolvablePolynomial<C>)p);
                    return G;
                }
                G.add((GenSolvablePolynomial<C>)p);
                if (pairlist == null) {
                    pairlist = this.strategy.create(modv, ((GenSolvablePolynomial)p).ring);
                    if (!((GenSolvablePolynomial)p).ring.coFac.isField()) {
                        throw new IllegalArgumentException("coefficients not from a field");
                    }
                }
                pairlist.put(p);
                continue;
            }
            --l;
        }
        if (l <= 1) {
            return G;
        }
        Terminator fin = new Terminator(this.threads);
        for (int i = 0; i < this.threads; ++i) {
            LeftSolvableReducer<C> R = new LeftSolvableReducer<C>(fin, G, pairlist);
            this.pool.addJob(R);
        }
        fin.waitDone();
        logger.debug((Object)("#parallel list = " + G.size()));
        G = this.leftMinimalGB(G);
        logger.info((Object)("" + pairlist));
        return G;
    }

    @Override
    public List<GenSolvablePolynomial<C>> leftMinimalGB(List<GenSolvablePolynomial<C>> Fp) {
        GenSolvablePolynomial<C> a;
        ArrayList<GenSolvablePolynomial<C>> G = new ArrayList<GenSolvablePolynomial<C>>(Fp.size());
        ListIterator<GenSolvablePolynomial<Object>> it = Fp.listIterator();
        while (it.hasNext()) {
            a = it.next();
            if (a.length() == 0) continue;
            G.add(a);
        }
        if (G.size() <= 1) {
            return G;
        }
        ArrayList<GenSolvablePolynomial<C>> F2 = new ArrayList<GenSolvablePolynomial<C>>(G.size());
        while (G.size() > 0) {
            ExpVector f;
            GenSolvablePolynomial<Object> p;
            a = G.remove(0);
            ExpVector e = a.leadingExpVector();
            it = G.listIterator();
            boolean mt = false;
            while (it.hasNext() && !mt) {
                p = it.next();
                f = p.leadingExpVector();
                mt = e.multipleOf(f);
            }
            it = F2.listIterator();
            while (it.hasNext() && !mt) {
                p = it.next();
                f = p.leadingExpVector();
                mt = e.multipleOf(f);
            }
            if (mt) continue;
            F2.add(a);
        }
        G = F2;
        if (G.size() <= 1) {
            return G;
        }
        SolvableMiReducer[] mirs = new SolvableMiReducer[G.size()];
        int i = 0;
        F2 = new ArrayList(G.size());
        while (G.size() > 0) {
            a = G.remove(0);
            ArrayList R = new ArrayList(G.size() + F2.size());
            R.addAll(G);
            R.addAll(F2);
            mirs[i] = new SolvableMiReducer(R, a);
            this.pool.addJob(mirs[i]);
            ++i;
            F2.add(a);
        }
        G = F2;
        F2 = new ArrayList(G.size());
        for (i = 0; i < mirs.length; ++i) {
            a = mirs[i].getNF();
            F2.add(a);
        }
        return F2;
    }

    @Override
    public SolvableExtendedGB<C> extLeftGB(int modv, List<GenSolvablePolynomial<C>> F2) {
        throw new UnsupportedOperationException("parallel extLeftGB not implemented");
    }

    @Override
    public List<GenSolvablePolynomial<C>> twosidedGB(int modv, List<GenSolvablePolynomial<C>> Fp) {
        GenPolynomial p;
        if (Fp == null || Fp.size() == 0) {
            return new ArrayList<GenSolvablePolynomial<C>>();
        }
        GenSolvablePolynomialRing fac = Fp.get((int)0).ring;
        List X = fac.univariateList(modv);
        ArrayList F2 = new ArrayList(Fp.size() * (1 + X.size()));
        F2.addAll(Fp);
        for (int i = 0; i < Fp.size(); ++i) {
            p = Fp.get(i);
            for (int j = 0; j < X.size(); ++j) {
                GenSolvablePolynomial x = X.get(j);
                GenSolvablePolynomial q = ((GenSolvablePolynomial)p).multiply(x);
                if ((q = this.sred.leftNormalform(F2, q)).isZERO()) continue;
                F2.add(q);
            }
        }
        List<GenSolvablePolynomial<C>> G = new ArrayList<GenSolvablePolynomial<C>>();
        PairList pairlist = null;
        int l = F2.size();
        ListIterator it = F2.listIterator();
        while (it.hasNext()) {
            p = (GenSolvablePolynomial)it.next();
            if (p.length() > 0) {
                if ((p = ((GenSolvablePolynomial)p).monic()).isONE()) {
                    G.clear();
                    G.add((GenSolvablePolynomial<C>)p);
                    return G;
                }
                G.add((GenSolvablePolynomial<C>)p);
                if (pairlist == null) {
                    pairlist = this.strategy.create(modv, ((GenSolvablePolynomial)p).ring);
                    if (!((GenSolvablePolynomial)p).ring.coFac.isField()) {
                        throw new IllegalArgumentException("coefficients not from a field");
                    }
                }
                pairlist.put(p);
                continue;
            }
            --l;
        }
        if (l <= 1) {
            return G;
        }
        Terminator fin = new Terminator(this.threads);
        for (int i = 0; i < this.threads; ++i) {
            TwosidedSolvableReducer R = new TwosidedSolvableReducer(fin, X, G, pairlist);
            this.pool.addJob(R);
        }
        fin.waitDone();
        logger.debug((Object)("#parallel list = " + G.size()));
        G = this.leftMinimalGB(G);
        logger.info((Object)("" + pairlist));
        return G;
    }
}

