/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.PairList;
import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionSeq;
import edu.jas.gb.SolvableExtendedGB;
import edu.jas.gb.SolvableGroebnerBase;
import edu.jas.gb.SolvableReduction;
import edu.jas.gb.SolvableReductionSeq;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.vector.BasicLinAlg;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public abstract class SolvableGroebnerBaseAbstract<C extends RingElem<C>>
implements SolvableGroebnerBase<C> {
    private static final Logger logger = Logger.getLogger(SolvableGroebnerBaseAbstract.class);
    private final boolean debug = logger.isDebugEnabled();
    public SolvableReduction<C> sred;
    public final Reduction<C> red = new ReductionSeq();
    public final PairList<C> strategy;
    protected final BasicLinAlg<GenPolynomial<C>> blas;
    public final GroebnerBaseAbstract<C> cbb;

    public SolvableGroebnerBaseAbstract() {
        this(new SolvableReductionSeq());
    }

    public SolvableGroebnerBaseAbstract(SolvableReduction<C> sred) {
        this(sred, new OrderedPairlist());
    }

    public SolvableGroebnerBaseAbstract(SolvableReduction<C> sred, PairList<C> pl) {
        this.sred = sred;
        this.strategy = pl;
        this.blas = new BasicLinAlg();
        this.cbb = new GroebnerBaseSeq();
    }

    @Override
    public boolean isLeftGB(List<GenSolvablePolynomial<C>> F2) {
        return this.isLeftGB(0, F2, true);
    }

    public boolean isLeftGB(List<GenSolvablePolynomial<C>> F2, boolean b) {
        return this.isLeftGB(0, F2, b);
    }

    @Override
    public boolean isLeftGB(int modv, List<GenSolvablePolynomial<C>> F2) {
        return this.isLeftGB(modv, F2, true);
    }

    public boolean isLeftGB(int modv, List<GenSolvablePolynomial<C>> F2, boolean b) {
        if (b) {
            return this.isLeftGBsimple(modv, F2);
        }
        return this.isLeftGBidem(modv, F2);
    }

    public boolean isLeftGBsimple(int modv, List<GenSolvablePolynomial<C>> F2) {
        for (int i = 0; i < F2.size(); ++i) {
            GenSolvablePolynomial<C> pi = F2.get(i);
            for (int j = i + 1; j < F2.size(); ++j) {
                GenSolvablePolynomial<C> h;
                GenSolvablePolynomial<C> s;
                GenSolvablePolynomial<C> pj = F2.get(j);
                if (!this.red.moduleCriterion(modv, pi, pj) || (s = this.sred.leftSPolynomial(pi, pj)).isZERO() || (h = this.sred.leftNormalform(F2, s)).isZERO()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLeftGBidem(int modv, List<GenSolvablePolynomial<C>> F2) {
        if (F2 == null || F2.isEmpty()) {
            return true;
        }
        GenSolvablePolynomialRing pring = F2.get((int)0).ring;
        PolynomialList Fp = new PolynomialList(pring, F2);
        List<GenSolvablePolynomial<C>> G = this.leftGB(modv, F2);
        PolynomialList Gp = new PolynomialList(pring, G);
        return Fp.compareTo(Gp) == 0;
    }

    @Override
    public boolean isTwosidedGB(List<GenSolvablePolynomial<C>> Fp) {
        return this.isTwosidedGB(0, Fp);
    }

    @Override
    public boolean isTwosidedGB(int modv, List<GenSolvablePolynomial<C>> Fp) {
        int j;
        int i;
        if (Fp == null || Fp.size() == 0) {
            return true;
        }
        GenSolvablePolynomialRing fac = Fp.get((int)0).ring;
        List X = fac.univariateList(modv);
        ArrayList F2 = new ArrayList(Fp.size() * (1 + X.size()));
        F2.addAll(Fp);
        for (i = 0; i < Fp.size(); ++i) {
            GenSolvablePolynomial<Object> p = Fp.get(i);
            for (j = 0; j < X.size(); ++j) {
                GenSolvablePolynomial x = X.get(j);
                p = p.multiply((Object)x);
                if ((p = this.sred.leftNormalform(F2, p)).isZERO()) continue;
                F2.add(p);
            }
        }
        for (i = 0; i < F2.size(); ++i) {
            GenSolvablePolynomial pi = (GenSolvablePolynomial)F2.get(i);
            for (j = i + 1; j < F2.size(); ++j) {
                GenSolvablePolynomial<C> h;
                GenSolvablePolynomial<C> s;
                GenSolvablePolynomial pj = (GenSolvablePolynomial)F2.get(j);
                if (!this.red.moduleCriterion(modv, pi, pj) || (s = this.sred.leftSPolynomial(pi, pj)).isZERO() || (h = this.sred.leftNormalform(F2, s)).isZERO()) continue;
                logger.info((Object)("is not TwosidedGB: " + h));
                return false;
            }
        }
        return true;
    }

    public boolean isTwosidedGBidem(List<GenSolvablePolynomial<C>> F2) {
        return this.isTwosidedGBidem(0, F2);
    }

    public boolean isTwosidedGBidem(int modv, List<GenSolvablePolynomial<C>> F2) {
        if (F2 == null || F2.isEmpty()) {
            return true;
        }
        GenSolvablePolynomialRing pring = F2.get((int)0).ring;
        PolynomialList Fp = new PolynomialList(pring, F2);
        List<GenSolvablePolynomial<C>> G = this.twosidedGB(modv, F2);
        PolynomialList Gp = new PolynomialList(pring, G);
        return Fp.compareTo(Gp) == 0;
    }

    @Override
    public boolean isRightGB(List<GenSolvablePolynomial<C>> F2) {
        return this.isRightGB(0, F2);
    }

    @Override
    public boolean isRightGB(int modv, List<GenSolvablePolynomial<C>> F2) {
        for (int i = 0; i < F2.size(); ++i) {
            GenSolvablePolynomial<C> pi = F2.get(i);
            for (int j = i + 1; j < F2.size(); ++j) {
                GenSolvablePolynomial<C> h;
                GenSolvablePolynomial<C> s;
                GenSolvablePolynomial<C> pj = F2.get(j);
                if (!this.red.moduleCriterion(modv, pi, pj) || (s = this.sred.rightSPolynomial(pi, pj)).isZERO() || (h = this.sred.rightNormalform(F2, s)).isZERO()) continue;
                logger.info((Object)("isRightGB non zero h = " + h + " :: " + h.ring));
                logger.info((Object)("p" + i + " = " + pi + ", p" + j + " = " + pj));
                return false;
            }
        }
        return true;
    }

    public boolean isRightGBidem(List<GenSolvablePolynomial<C>> F2) {
        return this.isRightGBidem(0, F2);
    }

    public boolean isRightGBidem(int modv, List<GenSolvablePolynomial<C>> F2) {
        if (F2 == null || F2.isEmpty()) {
            return true;
        }
        GenSolvablePolynomialRing pring = F2.get((int)0).ring;
        PolynomialList Fp = new PolynomialList(pring, F2);
        List<GenSolvablePolynomial<C>> G = this.rightGB(modv, F2);
        PolynomialList Gp = new PolynomialList(pring, G);
        return Fp.compareTo(Gp) == 0;
    }

    @Override
    public List<GenSolvablePolynomial<C>> leftGB(List<GenSolvablePolynomial<C>> F2) {
        return this.leftGB(0, F2);
    }

    @Override
    public SolvableExtendedGB<C> extLeftGB(List<GenSolvablePolynomial<C>> F2) {
        return this.extLeftGB(0, F2);
    }

    @Override
    public List<GenSolvablePolynomial<C>> leftMinimalGB(List<GenSolvablePolynomial<C>> Gp) {
        GenSolvablePolynomial<C> a;
        ArrayList<GenSolvablePolynomial<C>> G = new ArrayList<GenSolvablePolynomial<C>>();
        ListIterator<GenSolvablePolynomial<C>> it = Gp.listIterator();
        for (GenSolvablePolynomial<C> a2 : Gp) {
            if (a2.length() == 0) continue;
            G.add(a2);
        }
        if (G.size() <= 1) {
            return G;
        }
        ArrayList<GenSolvablePolynomial<C>> F2 = new ArrayList<GenSolvablePolynomial<C>>();
        while (G.size() > 0) {
            ExpVector f;
            GenSolvablePolynomial<C> p;
            a = G.remove(0);
            ExpVector e = a.leadingExpVector();
            it = G.listIterator();
            boolean mt = false;
            while (it.hasNext() && !mt) {
                p = it.next();
                f = p.leadingExpVector();
                mt = e.multipleOf(f);
            }
            it = F2.listIterator();
            while (it.hasNext() && !mt) {
                p = it.next();
                f = p.leadingExpVector();
                mt = e.multipleOf(f);
            }
            if (mt) continue;
            F2.add(a);
        }
        G = F2;
        if (G.size() <= 1) {
            return G;
        }
        F2 = new ArrayList();
        while (G.size() > 0) {
            a = G.remove(0);
            a = this.sred.leftNormalform(G, a);
            a = this.sred.leftNormalform(F2, a);
            F2.add(a);
        }
        return F2;
    }

    @Override
    public List<GenSolvablePolynomial<C>> twosidedGB(List<GenSolvablePolynomial<C>> Fp) {
        return this.twosidedGB(0, Fp);
    }

    @Override
    public List<GenSolvablePolynomial<C>> rightGB(List<GenSolvablePolynomial<C>> F2) {
        return this.rightGB(0, F2);
    }

    @Override
    public List<GenSolvablePolynomial<C>> rightGB(int modv, List<GenSolvablePolynomial<C>> F2) {
        GenSolvablePolynomial q;
        GenPolynomialRing ring = null;
        for (GenSolvablePolynomial<C> p : F2) {
            if (p == null) continue;
            ring = p.ring;
            break;
        }
        if (ring == null) {
            return F2;
        }
        GenPolynomialRing rring = ring.reverse(true);
        ArrayList rF = new ArrayList(F2.size());
        for (GenSolvablePolynomial<C> p : F2) {
            if (p == null) continue;
            q = (GenSolvablePolynomial)p.reverse(rring);
            rF.add(q);
        }
        if (this.debug) {
            PolynomialList pl = new PolynomialList(rring, rF);
            logger.info((Object)("reversed problem = " + pl.toScript()));
        }
        List rG = this.leftGB(modv, rF);
        if (this.debug) {
            long t = System.currentTimeMillis();
            boolean isit = this.isLeftGB(rG);
            t = System.currentTimeMillis() - t;
            logger.info((Object)("is left GB = " + isit + ", in " + t + " milliseconds"));
        }
        ring = ((GenSolvablePolynomialRing)rring).reverse(true);
        ArrayList<GenSolvablePolynomial<C>> G = new ArrayList<GenSolvablePolynomial<C>>(rG.size());
        for (GenSolvablePolynomial p : rG) {
            if (p == null) continue;
            q = (GenSolvablePolynomial)p.reverse(ring);
            G.add(q);
        }
        if (this.debug) {
            long t = System.currentTimeMillis();
            boolean isit = this.isRightGB(G);
            t = System.currentTimeMillis() - t;
            logger.info((Object)("is right GB = " + isit + ", in " + t + " milliseconds"));
        }
        return G;
    }

    @Override
    public boolean isLeftReductionMatrix(SolvableExtendedGB<C> exgb) {
        if (exgb == null) {
            return true;
        }
        return this.isLeftReductionMatrix(exgb.F, exgb.G, exgb.F2G, exgb.G2F);
    }

    @Override
    public boolean isLeftReductionMatrix(List<GenSolvablePolynomial<C>> F2, List<GenSolvablePolynomial<C>> G, List<List<GenSolvablePolynomial<C>>> Mf, List<List<GenSolvablePolynomial<C>>> Mg) {
        boolean t;
        int k = 0;
        for (List<GenSolvablePolynomial<C>> row : Mg) {
            t = this.sred.isLeftReductionNF(row, F2, G.get(k), null);
            if (!t) {
                System.out.println("row = " + row);
                System.out.println("F   = " + F2);
                System.out.println("Gk  = " + G.get(k));
                logger.info((Object)("F isLeftReductionMatrix s, k = " + F2.size() + ", " + k));
                return false;
            }
            ++k;
        }
        k = 0;
        for (List<GenSolvablePolynomial<C>> row : Mf) {
            t = this.sred.isLeftReductionNF(row, G, F2.get(k), null);
            if (!t) {
                logger.error((Object)("G isLeftReductionMatrix s, k = " + G.size() + ", " + k));
                return false;
            }
            ++k;
        }
        return true;
    }

    public int commonZeroTest(List<GenSolvablePolynomial<C>> A) {
        List<GenPolynomial<C>> cA = PolynomialList.castToList(A);
        return this.cbb.commonZeroTest(cA);
    }

    public List<Long> univariateDegrees(List<GenSolvablePolynomial<C>> A) {
        List<GenPolynomial<C>> cA = PolynomialList.castToList(A);
        return this.cbb.univariateDegrees(cA);
    }

    public GenSolvablePolynomial<C> constructUnivariate(int i, List<GenSolvablePolynomial<C>> G) {
        List ls;
        if (G == null || G.size() == 0) {
            throw new IllegalArgumentException("G may not be null or empty");
        }
        List<Long> ud = this.univariateDegrees(G);
        if (ud.size() <= i) {
            throw new IllegalArgumentException("ideal(G) not zero dimensional " + ud);
        }
        int ll = 0;
        Long di = ud.get(i);
        if (di == null) {
            throw new IllegalArgumentException("ideal(G) not zero dimensional");
        }
        ll = (int)di.longValue();
        long vsdim = 1L;
        for (Long d : ud) {
            if (d == null) continue;
            vsdim *= d.longValue();
        }
        logger.info((Object)("univariate construction, deg = " + ll + ", vsdim = " + vsdim));
        GenSolvablePolynomialRing pfac = G.get((int)0).ring;
        RingFactory cfac = pfac.coFac;
        GenPolynomialRing cpfac = new GenPolynomialRing(cfac, ll, new TermOrder(2));
        GenSolvablePolynomialRing rfac = new GenSolvablePolynomialRing(cpfac, pfac);
        GenSolvablePolynomial P = rfac.getZERO();
        for (int k = 0; k < ll; ++k) {
            GenPolynomial Pp = rfac.univariate(i, k);
            GenPolynomial cp = cpfac.univariate(cpfac.nvar - 1 - k);
            Pp = ((GenSolvablePolynomial)Pp).multiply((RingElem)cp);
            P = (GenSolvablePolynomial)P.sum(Pp);
        }
        if (this.debug) {
            logger.info((Object)("univariate construction, P = " + P));
            logger.info((Object)("univariate construction, deg_*(G) = " + ud));
        }
        GroebnerBaseSeq bbc = new GroebnerBaseSeq();
        int z = -1;
        do {
            GenPolynomial Pp = rfac.univariate(i, ll);
            GenPolynomial cp = cpfac.univariate(cpfac.nvar - 1 - ll);
            Pp = ((GenSolvablePolynomial)Pp).multiply((RingElem)cp);
            P = (GenSolvablePolynomial)P.sum(Pp);
            GenPolynomial X = pfac.univariate(i, ll);
            GenSolvablePolynomial<C> XP = this.sred.leftNormalform(G, (GenSolvablePolynomial<C>)X);
            GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial>> XPp = PolyUtil.toRecursive(rfac, XP);
            GenSolvablePolynomial XPs = (GenSolvablePolynomial)XPp.sum(P);
            ls = new ArrayList(XPs.getMap().values());
            z = bbc.commonZeroTest(ls = this.red.irreducibleSet(ls));
            if (z == 0) continue;
            if ((long)(++ll) > vsdim) {
                logger.info((Object)("univariate construction, P = " + P));
                logger.info((Object)("univariate construction, nf(P) = " + XP));
                logger.info((Object)("G = " + G));
                throw new ArithmeticException("univariate polynomial degree greater than vector space dimansion");
            }
            cpfac = cpfac.extend(1);
            rfac = new GenSolvablePolynomialRing(cpfac, pfac);
            P = PolyUtil.extendCoefficients(rfac, P, 0, 0L);
            XPp = PolyUtil.extendCoefficients(rfac, XPp, 0, 1L);
            P = (GenSolvablePolynomial)P.sum(XPp);
        } while (z != 0);
        String var = pfac.getVars()[pfac.nvar - 1 - i];
        GenSolvablePolynomialRing ufac = new GenSolvablePolynomialRing(cfac, 1, new TermOrder(2), new String[]{var});
        GenPolynomial pol = ufac.univariate(0, ll);
        for (GenPolynomial pc : ls) {
            int[] v;
            ExpVector e = pc.leadingExpVector();
            if (e == null || (v = e.dependencyOnVariables()) == null || v.length == 0) continue;
            int vi = v[0];
            Object tc = pc.trailingBaseCoefficient();
            tc = (RingElem)tc.negate();
            GenPolynomial pi = ufac.univariate(0, ll - 1 - vi);
            pi = ((GenSolvablePolynomial)pi).multiply((RingElem)tc);
            pol = (GenSolvablePolynomial)pol.sum(pi);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("univariate construction, pol = " + pol));
        }
        return pol;
    }

    public List<GenSolvablePolynomial<C>> constructUnivariate(List<GenSolvablePolynomial<C>> G) {
        ArrayList<GenSolvablePolynomial<C>> univs = new ArrayList<GenSolvablePolynomial<C>>();
        if (G == null || G.isEmpty()) {
            return univs;
        }
        for (int i = G.get((int)0).ring.nvar - 1; i >= 0; --i) {
            GenSolvablePolynomial<C> u = this.constructUnivariate(i, G);
            univs.add(u);
        }
        return univs;
    }

    public void terminate() {
        logger.info((Object)"terminate not implemented");
    }

    public int cancel() {
        logger.info((Object)"cancel not implemented");
        return 0;
    }
}

