/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.Reduction;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class ReductionAbstract<C extends RingElem<C>>
implements Reduction<C> {
    private static final Logger logger = Logger.getLogger(ReductionAbstract.class);
    private final boolean debug = logger.isDebugEnabled();

    @Override
    public GenPolynomial<C> SPolynomial(GenPolynomial<C> A, GenPolynomial<C> B) {
        if (B == null || B.isZERO()) {
            if (A == null) {
                return B;
            }
            return A.ring.getZERO();
        }
        if (A == null || A.isZERO()) {
            return B.ring.getZERO();
        }
        if (this.debug && !A.ring.equals(B.ring)) {
            logger.error((Object)("rings not equal " + A.ring + ", " + B.ring));
        }
        Map.Entry<ExpVector, C> ma = A.leadingMonomial();
        Map.Entry<ExpVector, C> mb = B.leadingMonomial();
        ExpVector e = ma.getKey();
        ExpVector f = mb.getKey();
        ExpVector g = e.lcm(f);
        ExpVector e1 = g.subtract(e);
        ExpVector f1 = g.subtract(f);
        RingElem a = (RingElem)ma.getValue();
        RingElem b = (RingElem)mb.getValue();
        GenPolynomial<RingElem> Cp = A.scaleSubtractMultiple(b, e1, a, f1, B);
        return Cp;
    }

    @Override
    public GenPolynomial<C> SPolynomial(List<GenPolynomial<C>> S, int i, GenPolynomial<C> A, int j, GenPolynomial<C> B) {
        if (this.debug) {
            if (B == null || B.isZERO()) {
                throw new ArithmeticException("Spol B is zero");
            }
            if (A == null || A.isZERO()) {
                throw new ArithmeticException("Spol A is zero");
            }
            if (!A.ring.equals(B.ring)) {
                logger.error((Object)("rings not equal " + A.ring + ", " + B.ring));
            }
        }
        Map.Entry<ExpVector, C> ma = A.leadingMonomial();
        Map.Entry<ExpVector, C> mb = B.leadingMonomial();
        ExpVector e = ma.getKey();
        ExpVector f = mb.getKey();
        ExpVector g = e.lcm(f);
        ExpVector e1 = g.subtract(e);
        ExpVector f1 = g.subtract(f);
        RingElem a = (RingElem)ma.getValue();
        RingElem b = (RingElem)mb.getValue();
        GenPolynomial<RingElem> Cp = A.scaleSubtractMultiple(b, e1, a, f1, B);
        AbelianGroupElem zero = A.ring.getZERO();
        GenPolynomial<RingElem> As = ((GenPolynomial)zero).sum((RingElem)b.negate(), e1);
        GenPolynomial<RingElem> Bs = ((GenPolynomial)zero).sum(a, f1);
        S.set(i, As);
        S.set(j, Bs);
        return Cp;
    }

    @Override
    public boolean moduleCriterion(int modv, GenPolynomial<C> A, GenPolynomial<C> B) {
        if (modv == 0) {
            return true;
        }
        ExpVector ei = A.leadingExpVector();
        ExpVector ej = B.leadingExpVector();
        return this.moduleCriterion(modv, ei, ej);
    }

    @Override
    public boolean moduleCriterion(int modv, ExpVector ei, ExpVector ej) {
        if (modv == 0) {
            return true;
        }
        return ei.invLexCompareTo(ej, 0, modv) == 0;
    }

    @Override
    public boolean criterion4(GenPolynomial<C> A, GenPolynomial<C> B, ExpVector e) {
        if (logger.isInfoEnabled()) {
            if (!A.ring.equals(B.ring)) {
                logger.error((Object)("rings not equal " + A.ring + ", " + B.ring));
            }
            if (!A.ring.isCommutative()) {
                logger.error((Object)"GBCriterion4 not applicabable to non-commutative polynomials");
                return true;
            }
        }
        ExpVector ei = A.leadingExpVector();
        ExpVector ej = B.leadingExpVector();
        return this.criterion4(ei, ej, e);
    }

    @Override
    public boolean criterion4(ExpVector ei, ExpVector ej, ExpVector e) {
        ExpVector g = ei.sum(ej);
        ExpVector h = g.subtract(e);
        int s = h.signum();
        return s != 0;
    }

    @Override
    public boolean criterion4(GenPolynomial<C> A, GenPolynomial<C> B) {
        if (!(!logger.isInfoEnabled() || A.ring.isCommutative() && B.ring.isCommutative())) {
            logger.error((Object)"GBCriterion4 not applicabable to non-commutative polynomials");
            return true;
        }
        ExpVector ei = A.leadingExpVector();
        ExpVector ej = B.leadingExpVector();
        ExpVector e = ei.lcm(ej);
        return this.criterion4(ei, ej, e);
    }

    @Override
    public List<GenPolynomial<C>> normalform(List<GenPolynomial<C>> Pp, List<GenPolynomial<C>> Ap) {
        if (Pp == null || Pp.isEmpty()) {
            return Ap;
        }
        if (Ap == null || Ap.isEmpty()) {
            return Ap;
        }
        ArrayList<GenPolynomial<C>> red = new ArrayList<GenPolynomial<C>>();
        for (GenPolynomial<C> A : Ap) {
            A = this.normalform(Pp, A);
            red.add(A);
        }
        return red;
    }

    @Override
    public boolean isTopReducible(List<GenPolynomial<C>> P, GenPolynomial<C> A) {
        if (P == null || P.isEmpty()) {
            return false;
        }
        if (A == null || A.isZERO()) {
            return false;
        }
        boolean mt = false;
        ExpVector e = A.leadingExpVector();
        for (GenPolynomial<C> p : P) {
            mt = e.multipleOf(p.leadingExpVector());
            if (!mt) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isReducible(List<GenPolynomial<C>> Pp, GenPolynomial<C> Ap) {
        return !this.isNormalform(Pp, Ap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNormalform(List<GenPolynomial<C>> Pp, GenPolynomial<C> Ap) {
        int i;
        GenPolynomial[] P;
        int l;
        if (Pp == null || Pp.isEmpty()) {
            return true;
        }
        if (Ap == null || Ap.isZERO()) {
            return true;
        }
        List<GenPolynomial<C>> list = Pp;
        synchronized (list) {
            l = Pp.size();
            P = new GenPolynomial[l];
            for (int i2 = 0; i2 < Pp.size(); ++i2) {
                P[i2] = Pp.get(i2);
            }
        }
        ExpVector[] htl = new ExpVector[l];
        GenPolynomial[] p = new GenPolynomial[l];
        int j = 0;
        for (i = 0; i < l; ++i) {
            p[i] = P[i];
            Map.Entry m = p[i].leadingMonomial();
            if (m == null) continue;
            p[j] = p[i];
            htl[j] = m.getKey();
            ++j;
        }
        l = j;
        boolean mt = false;
        for (ExpVector e : Ap.getMap().keySet()) {
            for (i = 0; i < l; ++i) {
                mt = e.multipleOf(htl[i]);
                if (!mt) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isNormalform(List<GenPolynomial<C>> Pp) {
        if (Pp == null || Pp.isEmpty()) {
            return true;
        }
        LinkedList<GenPolynomial<C>> P = new LinkedList<GenPolynomial<C>>(Pp);
        int s = P.size();
        for (int i = 0; i < s; ++i) {
            GenPolynomial Ap = (GenPolynomial)P.remove(i);
            if (!this.isNormalform(P, Ap)) {
                return false;
            }
            P.add(Ap);
        }
        return true;
    }

    @Override
    public List<GenPolynomial<C>> irreducibleSet(List<GenPolynomial<C>> Pp) {
        ArrayList<GenPolynomial<C>> P = new ArrayList<GenPolynomial<C>>();
        for (GenPolynomial<C> a : Pp) {
            if (a.length() == 0) continue;
            if ((a = a.monic()).isONE()) {
                P.clear();
                P.add(a);
                return P;
            }
            P.add(a);
        }
        int l = P.size();
        if (l <= 1) {
            return P;
        }
        int irr = 0;
        logger.debug((Object)"irr = ");
        while (irr != l) {
            GenPolynomial<C> a = P.remove(0);
            ExpVector e = a.leadingExpVector();
            a = this.normalform(P, a);
            logger.debug((Object)String.valueOf(irr));
            if (a.length() == 0) {
                if (--l > 1) continue;
                return P;
            }
            ExpVector f = a.leadingExpVector();
            if (f.signum() == 0) {
                P = new ArrayList();
                P.add(a.monic());
                return P;
            }
            if (e.equals(f)) {
                ++irr;
            } else {
                irr = 0;
                a = a.monic();
            }
            P.add(a);
        }
        return P;
    }

    @Override
    public boolean isReductionNF(List<GenPolynomial<C>> row, List<GenPolynomial<C>> Pp, GenPolynomial<C> Ap, GenPolynomial<C> Np) {
        GenPolynomial<Object> r;
        if (row == null && Pp == null) {
            if (Ap == null) {
                return Np == null;
            }
            return Ap.equals(Np);
        }
        if (row == null || Pp == null) {
            return false;
        }
        if (row.size() != Pp.size()) {
            return false;
        }
        GenPolynomial<GenPolynomial<Object>> t = Np;
        for (int m = 0; m < Pp.size(); ++m) {
            r = row.get(m);
            GenPolynomial<C> p = Pp.get(m);
            if (r == null || p == null) continue;
            t = t == null ? r.multiply((Object)p) : t.sum((GenPolynomial<Object>)r.multiply((Object)p));
        }
        if (t == null) {
            if (Ap == null) {
                return true;
            }
            return Ap.isZERO();
        }
        r = t.subtract((GenPolynomial<Object>)Ap);
        boolean z = r.isZERO();
        if (!z) {
            logger.info((Object)("t = " + t));
            logger.info((Object)("a = " + Ap));
            logger.info((Object)("t-a = " + r));
        }
        return z;
    }
}

