/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.WordPair;
import edu.jas.gb.WordPairList;
import edu.jas.gb.WordReduction;
import edu.jas.gb.WordReductionSeq;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.GenWordPolynomialRing;
import edu.jas.poly.Word;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class OrderedWordPairlist<C extends RingElem<C>>
implements WordPairList<C> {
    protected final List<GenWordPolynomial<C>> P;
    protected final SortedMap<Word, LinkedList<WordPair<C>>> pairlist;
    protected final List<BitSet> red;
    protected final GenWordPolynomialRing<C> ring;
    protected final WordReduction<C> reduction;
    protected boolean oneInGB = false;
    protected int putCount;
    protected int remCount;
    private static final Logger logger = Logger.getLogger(OrderedWordPairlist.class);

    public OrderedWordPairlist() {
        this.ring = null;
        this.P = null;
        this.pairlist = null;
        this.red = null;
        this.reduction = null;
        this.putCount = 0;
        this.remCount = 0;
    }

    public OrderedWordPairlist(GenWordPolynomialRing<C> r) {
        this.ring = r;
        this.P = new ArrayList<GenWordPolynomial<C>>();
        this.pairlist = new TreeMap<Word, LinkedList<WordPair<C>>>(this.ring.alphabet.getAscendComparator());
        this.red = new ArrayList<BitSet>();
        this.putCount = 0;
        this.remCount = 0;
        this.reduction = new WordReductionSeq();
    }

    @Override
    public WordPairList<C> create(GenWordPolynomialRing<C> r) {
        return new OrderedWordPairlist<C>(r);
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer(this.getClass().getSimpleName() + "(");
        s.append("#put=" + this.putCount);
        s.append(", #rem=" + this.remCount);
        if (this.pairlist != null && this.pairlist.size() != 0) {
            s.append(", size=" + this.pairlist.size());
        }
        s.append(")");
        return s.toString();
    }

    @Override
    public synchronized int put(GenWordPolynomial<C> p) {
        ++this.putCount;
        if (this.oneInGB) {
            return this.P.size() - 1;
        }
        Word e = p.leadingWord();
        int l = this.P.size();
        for (int j = 0; j < l; ++j) {
            GenWordPolynomial<C> pj = this.P.get(j);
            Word f = pj.leadingWord();
            Word g = f.lcm(e);
            if (g == null) continue;
            WordPair<C> pair = new WordPair<C>(pj, p, j, l);
            LinkedList<WordPair<C>> xl = (LinkedList<WordPair<C>>)this.pairlist.get(g);
            if (xl == null) {
                xl = new LinkedList<WordPair<C>>();
            }
            xl.addFirst(pair);
            this.pairlist.put(g, xl);
        }
        this.P.add(p);
        BitSet redi = new BitSet();
        redi.set(0, l);
        this.red.add(redi);
        return this.P.size() - 1;
    }

    @Override
    public int put(List<GenWordPolynomial<C>> F2) {
        int i = 0;
        for (GenWordPolynomial<C> p : F2) {
            i = this.put(p);
        }
        return i;
    }

    @Override
    public synchronized WordPair<C> removeNext() {
        if (this.oneInGB) {
            return null;
        }
        Iterator<Map.Entry<Word, LinkedList<WordPair<C>>>> ip = this.pairlist.entrySet().iterator();
        WordPair<C> pair = null;
        boolean c = false;
        while (!c && ip.hasNext()) {
            Map.Entry<Word, LinkedList<WordPair<C>>> me = ip.next();
            Word g = me.getKey();
            LinkedList<WordPair<C>> xl = me.getValue();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("g  = " + g));
            }
            pair = null;
            while (!c && xl.size() > 0) {
                pair = xl.removeFirst();
                int i = pair.i;
                int j = pair.j;
                c = this.criterion3(i, j, g);
                this.red.get(j).clear(i);
            }
            if (xl.size() != 0) continue;
            ip.remove();
        }
        if (!c) {
            pair = null;
        } else {
            ++this.remCount;
        }
        return pair;
    }

    @Override
    public synchronized boolean hasNext() {
        return this.pairlist.size() > 0;
    }

    @Override
    public List<GenWordPolynomial<C>> getList() {
        return this.P;
    }

    @Override
    public synchronized int putCount() {
        return this.putCount;
    }

    @Override
    public synchronized int remCount() {
        return this.remCount;
    }

    public synchronized int putOne(GenWordPolynomial<C> one) {
        if (one == null) {
            return this.P.size() - 1;
        }
        if (!one.isONE()) {
            return this.P.size() - 1;
        }
        return this.putOne();
    }

    @Override
    public synchronized int putOne() {
        ++this.putCount;
        this.oneInGB = true;
        this.pairlist.clear();
        this.P.clear();
        this.P.add((GenWordPolynomial<C>)this.ring.getONE());
        this.red.clear();
        return this.P.size() - 1;
    }

    public boolean criterion3(int i, int j, Word eij) {
        boolean s = this.red.get(j).get(i);
        if (!s) {
            logger.warn((Object)("c3.s false for " + j + " " + i));
            return s;
        }
        for (int k = 0; k < this.P.size(); ++k) {
            GenWordPolynomial<C> A;
            Word ek;
            boolean m;
            if (i == k || j == k || !(m = eij.multipleOf(ek = (A = this.P.get(k)).leadingWord()))) continue;
            if (k < i) {
                s = this.red.get(i).get(k) || this.red.get(j).get(k);
            } else if (i < k && k < j) {
                s = this.red.get(k).get(i) || this.red.get(j).get(k);
            } else if (j < k) {
                boolean bl = s = this.red.get(k).get(i) || this.red.get(k).get(j);
            }
            if (s) continue;
            return s;
        }
        return true;
    }
}

