/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionSeq;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class OrderedPairlist<C extends RingElem<C>>
implements PairList<C> {
    protected final List<GenPolynomial<C>> P;
    protected final SortedMap<ExpVector, LinkedList<Pair<C>>> pairlist;
    protected final List<BitSet> red;
    protected final GenPolynomialRing<C> ring;
    protected final Reduction<C> reduction;
    protected boolean oneInGB = false;
    protected boolean useCriterion4 = true;
    protected int putCount;
    protected int remCount;
    protected final int moduleVars;
    private static final Logger logger = Logger.getLogger(OrderedPairlist.class);

    public OrderedPairlist() {
        this.moduleVars = 0;
        this.ring = null;
        this.P = null;
        this.pairlist = null;
        this.red = null;
        this.reduction = null;
        this.putCount = 0;
        this.remCount = 0;
    }

    public OrderedPairlist(GenPolynomialRing<C> r) {
        this(0, r);
    }

    public OrderedPairlist(int m, GenPolynomialRing<C> r) {
        this.moduleVars = m;
        this.ring = r;
        this.P = new ArrayList<GenPolynomial<C>>();
        this.pairlist = new TreeMap<ExpVector, LinkedList<Pair<C>>>(this.ring.tord.getAscendComparator());
        this.red = new ArrayList<BitSet>();
        this.putCount = 0;
        this.remCount = 0;
        if (!this.ring.isCommutative()) {
            this.useCriterion4 = false;
        }
        this.reduction = new ReductionSeq();
    }

    @Override
    public PairList<C> create(GenPolynomialRing<C> r) {
        return new OrderedPairlist<C>(r);
    }

    @Override
    public PairList<C> create(int m, GenPolynomialRing<C> r) {
        return new OrderedPairlist<C>(m, r);
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer(this.getClass().getSimpleName() + "(");
        s.append("#put=" + this.putCount);
        s.append(", #rem=" + this.remCount);
        if (this.pairlist != null && this.pairlist.size() != 0) {
            s.append(", size=" + this.pairlist.size());
        }
        s.append(")");
        return s.toString();
    }

    @Override
    public synchronized int put(GenPolynomial<C> p) {
        ++this.putCount;
        if (this.oneInGB) {
            return this.P.size() - 1;
        }
        ExpVector e = p.leadingExpVector();
        int l = this.P.size();
        for (int j = 0; j < l; ++j) {
            GenPolynomial<C> pj = this.P.get(j);
            ExpVector f = pj.leadingExpVector();
            if (this.moduleVars > 0 && !this.reduction.moduleCriterion(this.moduleVars, e, f)) continue;
            ExpVector g = e.lcm(f);
            Pair<C> pair = new Pair<C>(pj, p, j, l);
            LinkedList<Pair<C>> xl = (LinkedList<Pair<C>>)this.pairlist.get(g);
            if (xl == null) {
                xl = new LinkedList<Pair<C>>();
            }
            xl.addFirst(pair);
            this.pairlist.put(g, xl);
        }
        this.P.add(p);
        BitSet redi = new BitSet();
        redi.set(0, l);
        this.red.add(redi);
        return this.P.size() - 1;
    }

    @Override
    public int put(List<GenPolynomial<C>> F2) {
        int i = 0;
        for (GenPolynomial<C> p : F2) {
            i = this.put(p);
        }
        return i;
    }

    @Override
    public synchronized Pair<C> removeNext() {
        if (this.oneInGB) {
            return null;
        }
        Iterator<Map.Entry<ExpVector, LinkedList<Pair<C>>>> ip = this.pairlist.entrySet().iterator();
        Pair<C> pair = null;
        boolean c = false;
        while (!c && ip.hasNext()) {
            Map.Entry<ExpVector, LinkedList<Pair<C>>> me = ip.next();
            ExpVector g = me.getKey();
            LinkedList<Pair<C>> xl = me.getValue();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("g  = " + g));
            }
            pair = null;
            while (!c && xl.size() > 0) {
                pair = xl.removeFirst();
                int i = pair.i;
                int j = pair.j;
                c = this.useCriterion4 ? this.reduction.criterion4(pair.pi, pair.pj, g) : true;
                if (c) {
                    c = this.criterion3(i, j, g);
                }
                this.red.get(j).clear(i);
            }
            if (xl.size() != 0) continue;
            ip.remove();
        }
        if (!c) {
            pair = null;
        } else {
            pair.maxIndex(this.P.size() - 1);
            ++this.remCount;
            if (logger.isDebugEnabled()) {
                logger.info((Object)("pair(" + pair.j + "," + pair.i + ")"));
            }
        }
        return pair;
    }

    @Override
    public synchronized boolean hasNext() {
        return this.pairlist.size() > 0;
    }

    @Override
    public List<GenPolynomial<C>> getList() {
        return this.P;
    }

    @Override
    public int size() {
        return this.P.size();
    }

    @Override
    public synchronized int putCount() {
        return this.putCount;
    }

    @Override
    public synchronized int remCount() {
        return this.remCount;
    }

    public synchronized int putOne(GenPolynomial<C> one) {
        if (one == null) {
            return this.P.size() - 1;
        }
        if (!one.isONE()) {
            return this.P.size() - 1;
        }
        return this.putOne();
    }

    @Override
    public synchronized int putOne() {
        ++this.putCount;
        this.oneInGB = true;
        this.pairlist.clear();
        this.P.clear();
        this.P.add((GenPolynomial<C>)this.ring.getONE());
        this.red.clear();
        logger.info((Object)("outOne " + this.toString()));
        return this.P.size() - 1;
    }

    @Override
    public boolean criterion3(int i, int j, ExpVector eij) {
        boolean s = this.red.get(j).get(i);
        if (!s) {
            logger.warn((Object)("c3.s false for " + j + " " + i));
            return s;
        }
        for (int k = 0; k < this.P.size(); ++k) {
            GenPolynomial<C> A;
            ExpVector ek;
            boolean m;
            if (i == k || j == k || !(m = eij.multipleOf(ek = (A = this.P.get(k)).leadingExpVector()))) continue;
            if (k < i) {
                s = this.red.get(i).get(k) || this.red.get(j).get(k);
            } else if (i < k && k < j) {
                s = this.red.get(k).get(i) || this.red.get(j).get(k);
            } else if (j < k) {
                boolean bl = s = this.red.get(k).get(i) || this.red.get(k).get(j);
            }
            if (s) continue;
            return s;
        }
        return true;
    }
}

