/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.ExtendedGB;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.gb.Reduction;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class GroebnerBaseSeq<C extends RingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = Logger.getLogger(GroebnerBaseSeq.class);
    private final boolean debug = logger.isDebugEnabled();

    public GroebnerBaseSeq() {
    }

    public GroebnerBaseSeq(Reduction<C> red) {
        super(red);
    }

    public GroebnerBaseSeq(PairList<C> pl) {
        super(pl);
    }

    public GroebnerBaseSeq(Reduction<C> red, PairList<C> pl) {
        super(red, pl);
    }

    @Override
    public List<GenPolynomial<C>> GB(int modv, List<GenPolynomial<C>> F2) {
        List<GenPolynomial<C>> G = this.normalizeZerosOnes(F2);
        if ((G = PolyUtil.monic(G)).size() <= 1) {
            return G;
        }
        GenPolynomialRing ring = G.get((int)0).ring;
        if (!ring.coFac.isField()) {
            throw new IllegalArgumentException("coefficients not from a field");
        }
        PairList<C> pairlist = this.strategy.create(modv, ring);
        pairlist.put(G);
        logger.info((Object)("start " + pairlist));
        while (pairlist.hasNext()) {
            GenPolynomial S;
            Pair pair = pairlist.removeNext();
            if (pair == null) continue;
            GenPolynomial pi = pair.pi;
            GenPolynomial pj = pair.pj;
            if (this.debug) {
                logger.debug((Object)("pi    = " + pi));
                logger.debug((Object)("pj    = " + pj));
            }
            if ((S = this.red.SPolynomial(pi, pj)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (this.debug) {
                logger.debug((Object)("ht(S) = " + S.leadingExpVector()));
            }
            GenPolynomial<C> H = this.red.normalform(G, S);
            if (this.debug) {
                logger.info((Object)("ht(H) = " + H.monic()));
            }
            if (H.isZERO()) {
                pair.setZero();
                continue;
            }
            H = H.monic();
            if (this.debug) {
                logger.info((Object)("ht(H) = " + H.leadingExpVector()));
            }
            if ((H = H.monic()).isONE()) {
                G.clear();
                G.add(H);
                pairlist.putOne();
                logger.info((Object)("end " + pairlist));
                return G;
            }
            if (this.debug) {
                logger.info((Object)("H = " + H));
            }
            if (H.length() <= 0) continue;
            G.add(H);
            pairlist.put(H);
        }
        logger.debug((Object)("#sequential list = " + G.size()));
        G = this.minimalGB(G);
        logger.info((Object)("end " + pairlist));
        return G;
    }

    @Override
    public ExtendedGB<C> extGB(int modv, List<GenPolynomial<C>> F2) {
        GenPolynomial H;
        if (F2 == null || F2.isEmpty()) {
            throw new IllegalArgumentException("null or empty F not allowed");
        }
        List G = new ArrayList();
        ArrayList F2G = new ArrayList();
        List G2F = new ArrayList();
        PairList<C> pairlist = null;
        boolean oneInGB = false;
        int len = F2.size();
        List<GenPolynomial<Object>> row = null;
        ArrayList rows = null;
        ArrayList rowh = null;
        GenPolynomialRing ring = null;
        int nzlen = 0;
        for (GenPolynomial<C> f : F2) {
            if (f.length() > 0) {
                ++nzlen;
            }
            if (ring != null) continue;
            ring = f.ring;
        }
        MonoidElem mone = ring.getONE();
        int k = 0;
        ListIterator<GenPolynomial<C>> it = F2.listIterator();
        while (it.hasNext()) {
            GenPolynomial<C> p = it.next();
            if (p.length() > 0) {
                row = new ArrayList(nzlen);
                for (int j = 0; j < nzlen; ++j) {
                    row.add(null);
                }
                row.set(k, (GenPolynomial<Object>)mone);
                ++k;
                if (p.isUnit()) {
                    G.clear();
                    G.add(p);
                    G2F.clear();
                    G2F.add(row);
                    oneInGB = true;
                    break;
                }
                G.add(p);
                G2F.add(row);
                if (pairlist == null) {
                    pairlist = this.strategy.create(modv, p.ring);
                    if (!p.ring.coFac.isField()) {
                        throw new RuntimeException("coefficients not from a field");
                    }
                }
                pairlist.put(p);
                continue;
            }
            --len;
        }
        if (len <= 1 || oneInGB) {
            for (GenPolynomial<C> f : F2) {
                row = new ArrayList(G.size());
                for (int j = 0; j < G.size(); ++j) {
                    row.add(null);
                }
                GenPolynomial H2 = this.red.normalform(row, G, f);
                if (!H2.isZERO()) {
                    logger.error((Object)("nonzero H = " + H2));
                }
                F2G.add(row);
            }
            ExtendedGB<C> exgb = new ExtendedGB<C>(F2, G, F2G, G2F);
            return exgb;
        }
        while (pairlist.hasNext() && !oneInGB) {
            int m;
            Pair pair = pairlist.removeNext();
            if (pair == null) continue;
            int i = pair.i;
            int j = pair.j;
            GenPolynomial pi = pair.pi;
            GenPolynomial pj = pair.pj;
            if (this.debug) {
                logger.info((Object)("i, pi    = " + i + ", " + pi));
                logger.info((Object)("j, pj    = " + j + ", " + pj));
            }
            rows = new ArrayList(G.size());
            for (m = 0; m < G.size(); ++m) {
                rows.add(null);
            }
            GenPolynomial S = this.red.SPolynomial(rows, i, pi, j, pj);
            if (this.debug) {
                logger.debug((Object)("is reduction S = " + this.red.isReductionNF(rows, G, ring.getZERO(), S)));
            }
            if (S.isZERO()) continue;
            if (this.debug) {
                logger.debug((Object)("ht(S) = " + S.leadingExpVector()));
            }
            rowh = new ArrayList(G.size());
            for (m = 0; m < G.size(); ++m) {
                rowh.add(null);
            }
            H = this.red.normalform(rowh, G, S);
            if (this.debug) {
                logger.debug((Object)("is reduction H = " + this.red.isReductionNF(rowh, G, S, H)));
            }
            if (H.isZERO()) continue;
            if (this.debug) {
                logger.debug((Object)("ht(H) = " + H.leadingExpVector()));
            }
            row = new ArrayList(G.size() + 1);
            for (m = 0; m < G.size(); ++m) {
                AbelianGroupElem y;
                AbelianGroupElem<GenPolynomial<GenPolynomial>> x = (GenPolynomial)rows.get(m);
                if (x != null) {
                    x = ((GenPolynomial)x).negate();
                }
                if ((y = (GenPolynomial)rowh.get(m)) != null) {
                    y = y.negate();
                }
                x = x == null ? y : ((GenPolynomial)x).sum(y);
                row.add((GenPolynomial<Object>)x);
            }
            if (this.debug) {
                logger.debug((Object)("is reduction 0+sum(row,G) == H : " + this.red.isReductionNF(row, G, H, ring.getZERO())));
            }
            row.add(null);
            Object c = H.leadingBaseCoefficient();
            c = (RingElem)c.inverse();
            H = H.multiply(c);
            row = this.blas.scalarProduct(((GenPolynomial)mone).multiply(c), row);
            row.set(G.size(), (GenPolynomial<Object>)mone);
            if (H.isONE()) {
                G.add(H);
                G2F.add(row);
                oneInGB = true;
                break;
            }
            if (this.debug) {
                logger.debug((Object)("H = " + H));
            }
            G.add(H);
            pairlist.put(H);
            G2F.add(row);
        }
        if (this.debug) {
            ExtendedGB<C> exgb = new ExtendedGB<C>(F2, G, F2G, G2F);
            logger.info((Object)("exgb unnorm = " + exgb));
        }
        G2F = this.normalizeMatrix(F2.size(), G2F);
        if (this.debug) {
            ExtendedGB<C> exgb = new ExtendedGB<C>(F2, G, F2G, G2F);
            logger.info((Object)("exgb nonmin = " + exgb));
            boolean t2 = this.isReductionMatrix(exgb);
            logger.info((Object)("exgb t2 = " + t2));
        }
        ExtendedGB exgb = this.minimalExtendedGB(F2.size(), G, G2F);
        G = exgb.G;
        G2F = exgb.G2F;
        logger.debug((Object)("#sequential list = " + G.size()));
        logger.info((Object)("" + pairlist));
        for (GenPolynomial<C> f : F2) {
            row = new ArrayList(G.size());
            for (int m = 0; m < G.size(); ++m) {
                row.add(null);
            }
            H = this.red.normalform(row, G, f);
            if (!H.isZERO()) {
                logger.error((Object)("nonzero H = " + H));
            }
            F2G.add(row);
        }
        exgb = new ExtendedGB<C>(F2, G, F2G, G2F);
        if (this.debug) {
            logger.info((Object)("exgb nonmin = " + exgb));
            boolean t2 = this.isReductionMatrix(exgb);
            logger.info((Object)("exgb t2 = " + t2));
        }
        return exgb;
    }
}

