/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.ExtendedGB;
import edu.jas.gb.GroebnerBase;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.PairList;
import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionSeq;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.vector.BasicLinAlg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public abstract class GroebnerBaseAbstract<C extends RingElem<C>>
implements GroebnerBase<C> {
    private static final Logger logger = Logger.getLogger(GroebnerBaseAbstract.class);
    private final boolean debug = logger.isDebugEnabled();
    public final Reduction<C> red;
    public final PairList<C> strategy;
    public final BasicLinAlg<GenPolynomial<C>> blas;

    public GroebnerBaseAbstract() {
        this(new ReductionSeq());
    }

    public GroebnerBaseAbstract(Reduction<C> red) {
        this(red, new OrderedPairlist());
    }

    public GroebnerBaseAbstract(PairList<C> pl) {
        this(new ReductionSeq(), pl);
    }

    public GroebnerBaseAbstract(Reduction<C> red, PairList<C> pl) {
        if (red == null) {
            red = new ReductionSeq();
        }
        this.red = red;
        if (pl == null) {
            pl = new OrderedPairlist();
        }
        this.strategy = pl;
        this.blas = new BasicLinAlg();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public List<GenPolynomial<C>> normalizeZerosOnes(List<GenPolynomial<C>> A) {
        ArrayList<GenPolynomial<C>> N2 = new ArrayList<GenPolynomial<C>>(A.size());
        if (A == null || A.isEmpty()) {
            return N2;
        }
        for (GenPolynomial<C> p : A) {
            if (p == null || p.isZERO()) continue;
            if (p.isUnit()) {
                N2.clear();
                N2.add((GenPolynomial<C>)p.ring.getONE());
                return N2;
            }
            N2.add((GenPolynomial<C>)p.abs());
        }
        return N2;
    }

    @Override
    public boolean isGB(List<GenPolynomial<C>> F2) {
        return this.isGB(0, F2);
    }

    @Override
    public boolean isGB(int modv, List<GenPolynomial<C>> F2) {
        return this.isGB(modv, F2, true);
    }

    public boolean isGB(List<GenPolynomial<C>> F2, boolean b) {
        return this.isGB(0, F2, b);
    }

    public boolean isGB(int modv, List<GenPolynomial<C>> F2, boolean b) {
        if (b) {
            return this.isGBsimple(modv, F2);
        }
        return this.isGBidem(modv, F2);
    }

    public boolean isGBsimple(int modv, List<GenPolynomial<C>> F2) {
        if (F2 == null || F2.isEmpty()) {
            return true;
        }
        for (int i = 0; i < F2.size(); ++i) {
            GenPolynomial<C> pi = F2.get(i);
            ExpVector ei = pi.leadingExpVector();
            for (int j = i + 1; j < F2.size(); ++j) {
                GenPolynomial<C> h;
                GenPolynomial<C> s;
                ExpVector eij;
                GenPolynomial<C> pj = F2.get(j);
                ExpVector ej = pj.leadingExpVector();
                if (!this.red.moduleCriterion(modv, ei, ej) || !this.red.criterion4(ei, ej, eij = ei.lcm(ej)) || !this.criterion3(i, j, eij, F2) || (s = this.red.SPolynomial(pi, pj)).isZERO() || (h = this.red.normalform(F2, s)).isZERO()) continue;
                logger.info((Object)("no GB: pi = " + pi + ", pj = " + pj));
                logger.info((Object)("s  = " + s + ", h = " + h));
                return false;
            }
        }
        return true;
    }

    boolean criterion3(int i, int j, ExpVector eij, List<GenPolynomial<C>> P) {
        assert (i < j);
        for (int k = 0; k < i; ++k) {
            GenPolynomial<C> A = P.get(k);
            ExpVector ek = A.leadingExpVector();
            if (!eij.multipleOf(ek)) continue;
            return false;
        }
        return true;
    }

    public boolean isGBidem(int modv, List<GenPolynomial<C>> F2) {
        if (F2 == null || F2.isEmpty()) {
            return true;
        }
        GenPolynomialRing pring = F2.get((int)0).ring;
        PolynomialList Fp = new PolynomialList(pring, F2);
        List<GenPolynomial<C>> G = this.GB(modv, F2);
        PolynomialList Gp = new PolynomialList(pring, G);
        return Fp.compareTo(Gp) == 0;
    }

    public int commonZeroTest(List<GenPolynomial<C>> F2) {
        if (F2 == null || F2.isEmpty()) {
            return 1;
        }
        GenPolynomialRing pfac = F2.get((int)0).ring;
        if (pfac.nvar <= 0) {
            return -1;
        }
        HashSet<Integer> v = new HashSet<Integer>();
        for (GenPolynomial<C> p : F2) {
            int[] u;
            if (p.isZERO()) continue;
            if (p.isConstant()) {
                return -1;
            }
            ExpVector e = p.leadingExpVector();
            if (e == null || (u = e.dependencyOnVariables()) == null || u.length != 1) continue;
            v.add(u[0]);
        }
        if (pfac.nvar == v.size()) {
            return 0;
        }
        return 1;
    }

    @Override
    public List<GenPolynomial<C>> GB(List<GenPolynomial<C>> F2) {
        return this.GB(0, F2);
    }

    @Override
    public ExtendedGB<C> extGB(List<GenPolynomial<C>> F2) {
        return this.extGB(0, F2);
    }

    @Override
    public ExtendedGB<C> extGB(int modv, List<GenPolynomial<C>> F2) {
        throw new UnsupportedOperationException("extGB not implemented in " + this.getClass().getSimpleName());
    }

    @Override
    public List<GenPolynomial<C>> minimalGB(List<GenPolynomial<C>> Gp) {
        GenPolynomial<C> a;
        if (Gp == null || Gp.size() <= 1) {
            return Gp;
        }
        ArrayList<GenPolynomial<C>> G = new ArrayList<GenPolynomial<C>>(Gp.size());
        for (GenPolynomial<C> a2 : Gp) {
            if (a2 == null || a2.isZERO()) continue;
            G.add(a2);
        }
        if (G.size() <= 1) {
            return G;
        }
        ArrayList F2 = new ArrayList(G.size());
        while (G.size() > 0) {
            a = (GenPolynomial<C>)G.remove(0);
            if (this.red.isTopReducible(G, a) || this.red.isTopReducible(F2, a)) {
                if (!this.debug) continue;
                System.out.println("dropped " + a);
                ArrayList<GenPolynomial<C>> ff = new ArrayList<GenPolynomial<C>>(G);
                ff.addAll(F2);
                if ((a = this.red.normalform(ff, a)).isZERO()) continue;
                System.out.println("error, nf(a) " + a);
                continue;
            }
            F2.add(a);
        }
        G = F2;
        if (G.size() <= 1) {
            return G;
        }
        Collections.reverse(G);
        int len = G.size();
        if (this.debug) {
            System.out.println("#G " + len);
            for (GenPolynomial genPolynomial : G) {
                System.out.println("aa = " + genPolynomial.length() + ", lt = " + genPolynomial.getMap().keySet());
            }
        }
        for (int i = 0; i < len; ++i) {
            a = (GenPolynomial)G.remove(0);
            if (this.debug) {
                System.out.println("doing " + a.length() + ", lt = " + a.leadingExpVector());
            }
            a = this.red.normalform(G, a);
            G.add(a);
        }
        return G;
    }

    public boolean isMinimalGB(List<GenPolynomial<C>> Gp) {
        if (Gp == null || Gp.size() == 0) {
            return true;
        }
        for (GenPolynomial<C> a : Gp) {
            if (a != null && !a.isZERO()) continue;
            if (this.debug) {
                logger.debug((Object)("zero polynomial " + a));
            }
            return false;
        }
        ArrayList G = new ArrayList<GenPolynomial<C>>(Gp);
        ArrayList F2 = new ArrayList(G.size());
        while (G.size() > 0) {
            GenPolynomial a = (GenPolynomial)G.remove(0);
            if (this.red.isTopReducible(G, a) || this.red.isTopReducible(F2, a)) {
                if (this.debug) {
                    logger.debug((Object)("top reducible polynomial " + a));
                }
                return false;
            }
            F2.add(a);
        }
        G = F2;
        if (G.size() <= 1) {
            return true;
        }
        int len = G.size();
        for (int i = 0; i < len; ++i) {
            GenPolynomial a = (GenPolynomial)G.remove(0);
            if (!this.red.isNormalform(G, a)) {
                if (this.debug) {
                    logger.debug((Object)("reducible polynomial " + a));
                }
                return false;
            }
            G.add(a);
        }
        return true;
    }

    @Override
    public boolean isReductionMatrix(ExtendedGB<C> exgb) {
        if (exgb == null) {
            return true;
        }
        return this.isReductionMatrix(exgb.F, exgb.G, exgb.F2G, exgb.G2F);
    }

    @Override
    public boolean isReductionMatrix(List<GenPolynomial<C>> F2, List<GenPolynomial<C>> G, List<List<GenPolynomial<C>>> Mf, List<List<GenPolynomial<C>>> Mg) {
        boolean t;
        int k = 0;
        for (List<GenPolynomial<C>> row : Mg) {
            t = this.red.isReductionNF(row, F2, G.get(k), null);
            if (!t) {
                logger.error((Object)("F isReductionMatrix s, k = " + F2.size() + ", " + k));
                return false;
            }
            ++k;
        }
        k = 0;
        for (List<GenPolynomial<C>> row : Mf) {
            t = this.red.isReductionNF(row, G, F2.get(k), null);
            if (!t) {
                logger.error((Object)("G isReductionMatrix s, k = " + G.size() + ", " + k));
                return false;
            }
            ++k;
        }
        return true;
    }

    public List<List<GenPolynomial<C>>> normalizeMatrix(int flen, List<List<GenPolynomial<C>>> M) {
        if (M == null) {
            return M;
        }
        if (M.size() == 0) {
            return M;
        }
        ArrayList<List<GenPolynomial<Object>>> N2 = new ArrayList<List<GenPolynomial<Object>>>();
        ArrayList<List<GenPolynomial<C>>> K = new ArrayList<List<GenPolynomial<C>>>();
        int len = M.get(M.size() - 1).size();
        for (List<GenPolynomial<C>> row : M) {
            ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(row);
            for (int i = row.size(); i < len; ++i) {
                arrayList.add(null);
            }
            N2.add(arrayList);
        }
        int k = flen;
        for (int i = 0; i < N2.size(); ++i) {
            List list = (List)N2.get(i);
            if (this.debug) {
                logger.info((Object)("row = " + list));
            }
            K.add(list);
            if (i < flen) continue;
            for (int j = i + 1; j < N2.size(); ++j) {
                GenPolynomial a;
                List nrow = (List)N2.get(j);
                if (k >= nrow.size() || (a = (GenPolynomial)nrow.get(k)) == null || a.isZERO()) continue;
                List<GenPolynomial> xrow = this.blas.scalarProduct(a, list);
                xrow = this.blas.vectorAdd(xrow, nrow);
                N2.set(j, xrow);
            }
            ++k;
        }
        N2.clear();
        for (List list : K) {
            ArrayList tr = new ArrayList();
            for (int i = 0; i < flen; ++i) {
                tr.add(list.get(i));
            }
            N2.add(tr);
        }
        K = N2;
        return K;
    }

    public ExtendedGB<C> minimalExtendedGB(int flen, List<GenPolynomial<C>> Gp, List<List<GenPolynomial<C>>> M) {
        List<GenPolynomial<Object>> row;
        if (Gp == null) {
            return null;
        }
        if (Gp.size() <= 1) {
            return new ExtendedGB<C>(null, Gp, null, M);
        }
        ArrayList<GenPolynomial<C>> G = new ArrayList<GenPolynomial<C>>(Gp);
        ArrayList F2 = new ArrayList(Gp.size());
        ArrayList<ArrayList<GenPolynomial<C>>> Mg = new ArrayList<ArrayList<GenPolynomial<C>>>(M.size());
        ArrayList Mf = new ArrayList(M.size());
        for (List<GenPolynomial<C>> r : M) {
            row = new ArrayList<GenPolynomial<C>>(r);
            Mg.add((ArrayList<GenPolynomial<C>>)row);
        }
        row = null;
        ArrayList<Integer> ix = new ArrayList<Integer>();
        ArrayList<Integer> jx = new ArrayList<Integer>();
        int k = 0;
        while (G.size() > 0) {
            ExpVector f;
            GenPolynomial p;
            GenPolynomial a = (GenPolynomial)G.remove(0);
            ExpVector e = a.leadingExpVector();
            ListIterator it = G.listIterator();
            boolean mt = false;
            while (it.hasNext() && !mt) {
                p = (GenPolynomial)it.next();
                f = p.leadingExpVector();
                mt = e.multipleOf(f);
            }
            it = F2.listIterator();
            while (it.hasNext() && !mt) {
                p = (GenPolynomial)it.next();
                f = p.leadingExpVector();
                mt = e.multipleOf(f);
            }
            if (!mt) {
                F2.add(a);
                ix.add(k);
            } else {
                jx.add(k);
            }
            ++k;
        }
        if (this.debug) {
            logger.debug((Object)("ix, #M, jx = " + ix + ", " + Mg.size() + ", " + jx));
        }
        int fix = -1;
        for (int i = 0; i < ix.size(); ++i) {
            int u = (Integer)ix.get(i);
            if (u >= flen && fix == -1) {
                fix = Mf.size();
            }
            if (u < 0) continue;
            row = (List)Mg.get(u);
            Mf.add(row);
        }
        if (F2.size() <= 1 || fix == -1) {
            return new ExtendedGB(null, F2, null, Mf);
        }
        return new ExtendedGB(null, F2, null, Mf);
    }

    public List<Long> univariateDegrees(List<GenPolynomial<C>> A) {
        ArrayList<Long> ud = new ArrayList<Long>();
        if (A == null || A.size() == 0) {
            return ud;
        }
        GenPolynomialRing pfac = A.get((int)0).ring;
        if (pfac.nvar <= 0) {
            return ud;
        }
        TreeMap<Integer, Long> v = new TreeMap<Integer, Long>();
        for (GenPolynomial<C> p : A) {
            Long d;
            int[] u;
            ExpVector e = p.leadingExpVector();
            if (e == null || (u = e.dependencyOnVariables()) == null || u.length != 1 || (d = (Long)v.get(u[0])) != null) continue;
            v.put(u[0], e.getVal(u[0]));
        }
        for (int i = 0; i < pfac.nvar; ++i) {
            Long d = (Long)v.get(i);
            ud.add(d);
        }
        return ud;
    }

    public GenPolynomial<C> constructUnivariate(int i, List<GenPolynomial<C>> G) {
        List ls;
        if (G == null || G.size() == 0) {
            throw new IllegalArgumentException("G may not be null or empty");
        }
        List<Long> ud = this.univariateDegrees(G);
        if (ud.size() <= i) {
            throw new IllegalArgumentException("ideal(G) not zero dimensional " + ud);
        }
        int ll = 0;
        Long di = ud.get(i);
        if (di == null) {
            throw new IllegalArgumentException("ideal(G) not zero dimensional");
        }
        ll = (int)di.longValue();
        long vsdim = 1L;
        for (Long d : ud) {
            if (d == null) continue;
            vsdim *= d.longValue();
        }
        logger.info((Object)("univariate construction, deg = " + ll + ", vsdim = " + vsdim));
        GenPolynomialRing pfac = G.get((int)0).ring;
        RingFactory cfac = pfac.coFac;
        String var = pfac.getVars()[pfac.nvar - 1 - i];
        GenPolynomialRing ufac = new GenPolynomialRing(cfac, 1, new TermOrder(2), new String[]{var});
        GenPolynomialRing cpfac = new GenPolynomialRing(cfac, ll, new TermOrder(2));
        GenPolynomialRing rfac = new GenPolynomialRing(cpfac, pfac);
        GenPolynomial P = rfac.getZERO();
        for (int k = 0; k < ll; ++k) {
            GenPolynomial Pp = rfac.univariate(i, k);
            GenPolynomial cp = cpfac.univariate(cpfac.nvar - 1 - k);
            Pp = Pp.multiply(cp);
            P = P.sum(Pp);
        }
        if (this.debug) {
            logger.info((Object)("univariate construction, P = " + P));
            logger.info((Object)("univariate construction, deg_*(G) = " + ud));
        }
        int z = -1;
        do {
            GenPolynomial Pp = rfac.univariate(i, ll);
            GenPolynomial cp = cpfac.univariate(cpfac.nvar - 1 - ll);
            Pp = Pp.multiply(cp);
            P = P.sum(Pp);
            GenPolynomial X = pfac.univariate(i, ll);
            GenPolynomial<C> XP = this.red.normalform(G, X);
            GenPolynomial XPp = PolyUtil.toRecursive(rfac, XP);
            GenPolynomial XPs = XPp.sum(P);
            ls = new ArrayList(XPs.getMap().values());
            z = this.commonZeroTest(ls = this.red.irreducibleSet(ls));
            if (z == 0) continue;
            if ((long)(++ll) > vsdim) {
                logger.info((Object)("univariate construction, P = " + P));
                logger.info((Object)("univariate construction, nf(P) = " + XP));
                logger.info((Object)("G = " + G));
                throw new ArithmeticException("univariate polynomial degree greater than vector space dimansion");
            }
            cpfac = cpfac.extend(1);
            rfac = new GenPolynomialRing(cpfac, pfac);
            P = PolyUtil.extendCoefficients(rfac, P, 0, 0L);
            XPp = PolyUtil.extendCoefficients(rfac, XPp, 0, 1L);
            P = P.sum(XPp);
        } while (z != 0);
        GenPolynomial pol = ufac.univariate(0, ll);
        for (GenPolynomial pc : ls) {
            int[] v;
            ExpVector e = pc.leadingExpVector();
            if (e == null || (v = e.dependencyOnVariables()) == null || v.length == 0) continue;
            int vi = v[0];
            Object lc = pc.leadingBaseCoefficient();
            Object tc = pc.trailingBaseCoefficient();
            tc = (RingElem)tc.negate();
            if (!lc.isONE()) {
                tc = (RingElem)tc.divide(lc);
            }
            GenPolynomial<Object> pi = ufac.univariate(0, ll - 1 - vi);
            pi = pi.multiply(tc);
            pol = pol.sum(pi);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("univariate construction, pol = " + pol));
        }
        return pol;
    }

    public void terminate() {
        logger.info((Object)"terminate not implemented");
    }

    public int cancel() {
        logger.info((Object)"cancel not implemented");
        return 0;
    }
}

