/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.kern.ComputerThreads;
import edu.jas.kern.PreemptingException;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.GcdRingElem;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;

public class GBProxy<C extends GcdRingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = Logger.getLogger(GBProxy.class);
    private final boolean debug = logger.isDebugEnabled();
    public final GroebnerBaseAbstract<C> e1;
    public final GroebnerBaseAbstract<C> e2;
    protected transient ExecutorService pool;

    public GBProxy(GroebnerBaseAbstract<C> e1, GroebnerBaseAbstract<C> e2) {
        this.e1 = e1;
        this.e2 = e2;
        this.pool = ComputerThreads.getPool();
    }

    @Override
    public String toString() {
        return "GBProxy[ " + this.e1.toString() + ", " + this.e2.toString() + " ]";
    }

    @Override
    public void terminate() {
        this.e1.terminate();
        this.e2.terminate();
    }

    @Override
    public int cancel() {
        int s = this.e1.cancel();
        return s += this.e2.cancel();
    }

    @Override
    public List<GenPolynomial<C>> GB(final int modv, final List<GenPolynomial<C>> F2) {
        if (F2 == null || F2.isEmpty()) {
            return F2;
        }
        List G = null;
        ArrayList cs = new ArrayList(2);
        cs.add(new Callable<List<GenPolynomial<C>>>(){

            @Override
            public List<GenPolynomial<C>> call() {
                try {
                    List G = GBProxy.this.e1.GB(modv, F2);
                    if (GBProxy.this.debug) {
                        logger.info((Object)("GBProxy done e1 " + GBProxy.this.e1.getClass().getName()));
                    }
                    return G;
                }
                catch (PreemptingException e) {
                    throw new RuntimeException("GBProxy e1 preempted " + e);
                }
                catch (Exception e) {
                    logger.info((Object)("GBProxy e1 " + e));
                    logger.info((Object)("Exception GBProxy F = " + F2));
                    throw new RuntimeException("GBProxy e1 " + e);
                }
            }
        });
        cs.add(new Callable<List<GenPolynomial<C>>>(){

            @Override
            public List<GenPolynomial<C>> call() {
                try {
                    List G = GBProxy.this.e2.GB(modv, F2);
                    if (GBProxy.this.debug) {
                        logger.info((Object)("GBProxy done e2 " + GBProxy.this.e2.getClass().getName()));
                    }
                    return G;
                }
                catch (PreemptingException e) {
                    throw new RuntimeException("GBProxy e2 preempted " + e);
                }
                catch (Exception e) {
                    logger.info((Object)("GBProxy e2 " + e));
                    logger.info((Object)("Exception GBProxy F = " + F2));
                    throw new RuntimeException("GBProxy e2 " + e);
                }
            }
        });
        try {
            G = (List)this.pool.invokeAny(cs);
        }
        catch (InterruptedException ignored) {
            logger.info((Object)("InterruptedException " + ignored));
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            logger.info((Object)("ExecutionException " + e));
            Thread.currentThread().interrupt();
        }
        return G;
    }
}

