/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.DReduction;
import edu.jas.gb.DReductionSeq;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.OrderedDPairlist;
import edu.jas.gb.Pair;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.RingElem;
import java.util.List;
import org.apache.log4j.Logger;

public class DGroebnerBaseSeq<C extends RingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = Logger.getLogger(DGroebnerBaseSeq.class);
    private final boolean debug = logger.isDebugEnabled();
    protected DReduction<C> dred;

    public DGroebnerBaseSeq() {
        this(new DReductionSeq());
    }

    public DGroebnerBaseSeq(DReduction<C> dred) {
        super(dred);
        this.dred = dred;
        assert (this.dred == this.red);
    }

    @Override
    public boolean isGB(int modv, List<GenPolynomial<C>> F2) {
        for (int i = 0; i < F2.size(); ++i) {
            GenPolynomial<C> pi = F2.get(i);
            for (int j = i + 1; j < F2.size(); ++j) {
                GenPolynomial<C> pj = F2.get(j);
                if (!this.red.moduleCriterion(modv, pi, pj)) continue;
                GenPolynomial<C> d = this.dred.GPolynomial(pi, pj);
                if (!d.isZERO()) {
                    d = this.red.normalform(F2, d);
                }
                if (!d.isZERO()) {
                    System.out.println("d-pol(" + i + "," + j + ") != 0: " + d);
                    return false;
                }
                if (!this.red.criterion4(pi, pj)) continue;
                GenPolynomial<C> s = this.red.SPolynomial(pi, pj);
                if (!s.isZERO()) {
                    s = this.red.normalform(F2, s);
                }
                if (s.isZERO()) continue;
                System.out.println("s-pol(" + i + "," + j + ") != 0: " + s);
                return false;
            }
        }
        return true;
    }

    @Override
    public List<GenPolynomial<C>> GB(int modv, List<GenPolynomial<C>> F2) {
        List<GenPolynomial<C>> G = this.normalizeZerosOnes(F2);
        if (G.size() <= 1) {
            return G;
        }
        GenPolynomialRing ring = G.get((int)0).ring;
        OrderedDPairlist<C> pairlist = new OrderedDPairlist<C>(modv, ring);
        pairlist.put(G);
        while (pairlist.hasNext()) {
            GenPolynomial<C> H;
            GenPolynomial<C> D2;
            Pair pair = pairlist.removeNext();
            if (pair == null) continue;
            GenPolynomial pi = pair.pi;
            GenPolynomial pj = pair.pj;
            if (this.debug) {
                logger.debug((Object)("pi    = " + pi));
                logger.debug((Object)("pj    = " + pj));
            }
            if (!(D2 = this.dred.GPolynomial(pi, pj)).isZERO() && !this.red.isTopReducible(G, D2)) {
                H = this.red.normalform(G, D2);
                if (H.isONE()) {
                    G.clear();
                    G.add(H);
                    return G;
                }
                if (!H.isZERO()) {
                    logger.info((Object)("Dred = " + H));
                    G.add(H);
                    pairlist.put(H);
                }
            }
            if (!pair.getUseCriterion3() || !pair.getUseCriterion4()) continue;
            GenPolynomial S = this.red.SPolynomial(pi, pj);
            if (S.isZERO()) {
                pair.setZero();
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ht(S) = " + S.leadingExpVector()));
            }
            if ((H = this.red.normalform(G, S)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ht(H) = " + H.leadingExpVector()));
            }
            if (H.isONE()) {
                G.clear();
                G.add(H);
                return G;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("H = " + H));
            }
            if (H.isZERO()) continue;
            logger.info((Object)("Sred = " + H));
            G.add(H);
            pairlist.put(H);
        }
        logger.debug((Object)("#sequential list = " + G.size()));
        G = this.minimalGB(G);
        logger.info((Object)("" + pairlist));
        return G;
    }
}

