/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.fd;

import edu.jas.fd.FDUtil;
import edu.jas.fd.GreatestCommonDivisorAbstract;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import org.apache.log4j.Logger;

public class GreatestCommonDivisorSimple<C extends GcdRingElem<C>>
extends GreatestCommonDivisorAbstract<C> {
    private static final Logger logger = Logger.getLogger(GreatestCommonDivisorSimple.class);
    private final boolean debug = true;

    @Override
    public GenSolvablePolynomial<C> leftBaseGcd(GenSolvablePolynomial<C> P, GenSolvablePolynomial<C> S) {
        GcdRingElem c;
        GenSolvablePolynomial q;
        GenPolynomial r;
        if (S == null || S.isZERO()) {
            return P;
        }
        if (P == null || P.isZERO()) {
            return S;
        }
        if (P.ring.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " no univariate polynomial");
        }
        boolean field = P.ring.coFac.isField();
        long e = P.degree(0);
        long f = S.degree(0);
        if (f > e) {
            r = P;
            q = S;
            long g = f;
            f = e;
            e = g;
        } else {
            q = P;
            r = S;
        }
        logger.debug((Object)("degrees: e = " + e + ", f = " + f));
        if (field) {
            r = r.monic();
            q = q.monic();
            c = (GcdRingElem)P.ring.getONECoefficient();
        } else {
            r = (GenSolvablePolynomial)r.abs();
            q = (GenSolvablePolynomial)q.abs();
            Object a = this.rightBaseContent(r);
            Object b = this.rightBaseContent(q);
            r = this.divide(r, a);
            q = this.divide(q, b);
            c = this.gcd(a, b);
        }
        if (r.isONE()) {
            return r.multiply(c);
        }
        if (q.isONE()) {
            return q.multiply(c);
        }
        while (!r.isZERO()) {
            GenSolvablePolynomial x = FDUtil.leftBaseSparsePseudoRemainder(q, r);
            q = r;
            if (field) {
                r = x.monic();
                continue;
            }
            r = x;
        }
        q = this.leftBasePrimitivePart(q);
        return (GenSolvablePolynomial)q.multiply(c).abs();
    }

    @Override
    public GenSolvablePolynomial<C> rightBaseGcd(GenSolvablePolynomial<C> P, GenSolvablePolynomial<C> S) {
        GcdRingElem c;
        GenSolvablePolynomial<GcdRingElem> q;
        GenPolynomial r;
        if (S == null || S.isZERO()) {
            return P;
        }
        if (P == null || P.isZERO()) {
            return S;
        }
        if (P.ring.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " no univariate polynomial");
        }
        boolean field = P.ring.coFac.isField();
        long e = P.degree(0);
        long f = S.degree(0);
        if (f > e) {
            r = P;
            q = S;
            long g = f;
            f = e;
            e = g;
        } else {
            q = P;
            r = S;
        }
        logger.debug((Object)("degrees: e = " + e + ", f = " + f));
        if (field) {
            r = r.monic();
            q = q.monic();
            c = (GcdRingElem)P.ring.getONECoefficient();
        } else {
            r = (GenSolvablePolynomial)r.abs();
            q = (GenSolvablePolynomial<GcdRingElem>)q.abs();
            Object a = this.leftBaseContent(r);
            Object b = this.leftBaseContent(q);
            r = this.divide(r, a);
            q = this.divide(q, b);
            c = this.gcd(a, b);
        }
        if (r.isONE()) {
            return r.multiply(c);
        }
        if (q.isONE()) {
            return q.multiply((RingElem)c);
        }
        while (!r.isZERO()) {
            GenSolvablePolynomial x = FDUtil.rightBaseSparsePseudoRemainder(q, r);
            q = r;
            if (field) {
                r = x.monic();
                continue;
            }
            r = x;
        }
        q = this.rightBasePrimitivePart(q);
        return (GenSolvablePolynomial)q.multiplyLeft(c).abs();
    }

    @Override
    public GenSolvablePolynomial<GenPolynomial<C>> leftRecursiveUnivariateGcd(GenSolvablePolynomial<GenPolynomial<C>> P, GenSolvablePolynomial<GenPolynomial<C>> S) {
        GenSolvablePolynomial<GenPolynomial<GenPolynomial>> q;
        GenSolvablePolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>> r;
        if (S == null || S.isZERO()) {
            return P;
        }
        if (P == null || P.isZERO()) {
            return S;
        }
        if (P.ring.nvar > 1) {
            throw new IllegalArgumentException("no univariate polynomial");
        }
        boolean field = ((GenPolynomial)P.leadingBaseCoefficient()).ring.coFac.isField();
        long e = P.degree(0);
        long f = S.degree(0);
        if (f > e) {
            r = P;
            q = S;
            long g = f;
            f = e;
            e = g;
        } else if (f < e) {
            q = P;
            r = S;
        } else if (((GenPolynomial)P.leadingBaseCoefficient()).degree() > ((GenPolynomial)S.leadingBaseCoefficient()).degree()) {
            q = P;
            r = S;
        } else {
            r = P;
            q = S;
        }
        logger.debug((Object)("degrees: e = " + e + ", f = " + f));
        if (field) {
            r = PolyUtil.monic(r);
            q = PolyUtil.monic(q);
        } else {
            r = (GenSolvablePolynomial)r.abs();
            q = (GenSolvablePolynomial)q.abs();
        }
        GenSolvablePolynomial a = this.rightRecursiveContent(r);
        GenSolvablePolynomial rs = FDUtil.recursiveDivideRightEval(r, a);
        logger.info((Object)("recCont a = " + a + ", r = " + r));
        logger.info((Object)("recCont r/a = " + rs + ", r%a = " + r.subtract(rs.multiply((RingElem)a))));
        if (!r.equals(rs.multiply((RingElem)a)) && !rs.multiplyLeft(a).equals(r)) {
            System.out.println("recGcd, r         = " + r);
            System.out.println("recGcd, cont(r)   = " + a);
            System.out.println("recGcd, pp(r)     = " + rs);
            System.out.println("recGcd, pp(r)c(r) = " + rs.multiply((RingElem)a));
            System.out.println("recGcd, c(r)pp(r) = " + rs.multiplyLeft(a));
            throw new RuntimeException("recGcd, pp: not divisible");
        }
        r = rs;
        GenSolvablePolynomial b = this.rightRecursiveContent(q);
        GenSolvablePolynomial qs = FDUtil.recursiveDivideRightEval(q, b);
        logger.info((Object)("recCont b = " + b + ", q = " + q));
        logger.info((Object)("recCont q/b = " + qs + ", q%b = " + q.subtract(qs.multiply((RingElem)b))));
        if (!q.equals(qs.multiply((RingElem)b)) && !qs.multiplyLeft(b).equals(q)) {
            System.out.println("recGcd, q         = " + q);
            System.out.println("recGcd, cont(q)   = " + b);
            System.out.println("recGcd, pp(q)     = " + qs);
            System.out.println("recGcd, pp(q)c(q) = " + qs.multiply((RingElem)b));
            System.out.println("recGcd, c(q)pp(q) = " + qs.multiplyLeft(b));
            throw new RuntimeException("recGcd, pp: not divisible");
        }
        q = qs;
        logger.info((Object)("Gcd(content).ring = " + a.ring.toScript() + ", a = " + a + ", b = " + b));
        GenSolvablePolynomial c = this.rightGcd(a, b);
        logger.info((Object)("Gcd(contents) c = " + c + ", a = " + a + ", b = " + b));
        if (r.isONE()) {
            return r.multiply((RingElem)c);
        }
        if (q.isONE()) {
            return q.multiply((RingElem)c);
        }
        rs = r;
        qs = q;
        logger.info((Object)("r.ring = " + r.ring.toScript()));
        logger.info((Object)("gcd-loop, start: q = " + q + ", r = " + r));
        while (!r.isZERO()) {
            GenSolvablePolynomial x = FDUtil.recursiveSparsePseudoRemainder(q, r);
            q = r;
            r = field ? PolyUtil.monic(x) : x;
            logger.info((Object)("gcd-loop, rem: q = " + q + ", r = " + r));
        }
        logger.info((Object)("gcd(div) = " + q + ", rs = " + rs + ", qs = " + qs));
        GenSolvablePolynomial rp = FDUtil.recursiveSparsePseudoRemainder(rs, q);
        GenSolvablePolynomial<GenPolynomial<Object>> qp = FDUtil.recursiveSparsePseudoRemainder(qs, q);
        if (!qp.isZERO() || !rp.isZERO()) {
            logger.info((Object)("gcd(div): rem(r,g) = " + rp + ", rem(q,g) = " + qp));
            rp = FDUtil.recursivePseudoQuotient(rs, q);
            qp = FDUtil.recursivePseudoQuotient(qs, q);
            logger.info((Object)("gcd(div): r/g = " + rp + ", q/g = " + qp));
            throw new RuntimeException("recGcd, div: not divisible");
        }
        qp = q;
        if (!qp.equals(q = this.leftRecursivePrimitivePart(q))) {
            logger.info((Object)("gcd(pp) = " + q + ", qp = " + qp));
        }
        q = (GenSolvablePolynomial)q.multiply((RingElem)c).abs();
        return q;
    }

    @Override
    public GenSolvablePolynomial<GenPolynomial<C>> rightRecursiveUnivariateGcd(GenSolvablePolynomial<GenPolynomial<C>> P, GenSolvablePolynomial<GenPolynomial<C>> S) {
        GenSolvablePolynomial q;
        GenSolvablePolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>> r;
        if (S == null || S.isZERO()) {
            return P;
        }
        if (P == null || P.isZERO()) {
            return S;
        }
        if (P.ring.nvar > 1) {
            throw new IllegalArgumentException("no univariate polynomial");
        }
        boolean field = ((GenPolynomial)P.leadingBaseCoefficient()).ring.coFac.isField();
        long e = P.degree(0);
        long f = S.degree(0);
        if (f > e) {
            r = P;
            q = S;
            long g = f;
            f = e;
            e = g;
        } else if (f < e) {
            q = P;
            r = S;
        } else if (((GenPolynomial)P.leadingBaseCoefficient()).degree() > ((GenPolynomial)S.leadingBaseCoefficient()).degree()) {
            q = P;
            r = S;
        } else {
            r = P;
            q = S;
        }
        logger.debug((Object)("RI-degrees: e = " + e + ", f = " + f));
        if (field) {
            r = PolyUtil.monic(r);
            q = PolyUtil.monic(q);
        } else {
            r = (GenSolvablePolynomial)r.abs();
            q = (GenSolvablePolynomial)q.abs();
        }
        GenSolvablePolynomial a = this.leftRecursiveContent(r);
        GenSolvablePolynomial rs = FDUtil.recursiveDivide(r, a);
        logger.info((Object)("RI-recCont a = " + a + ", r = " + r));
        logger.info((Object)("RI-recCont r/a = " + r + ", r%a = " + r.subtract(rs.multiplyLeft(a))));
        if (!r.equals(rs.multiplyLeft(a))) {
            System.out.println("RI-recGcd, r         = " + r);
            System.out.println("RI-recGcd, cont(r)   = " + a);
            System.out.println("RI-recGcd, pp(r)     = " + rs);
            System.out.println("RI-recGcd, pp(r)c(r) = " + rs.multiplyLeft(a));
            throw new RuntimeException("RI-recGcd, pp: not divisible");
        }
        r = rs;
        GenSolvablePolynomial b = this.leftRecursiveContent(q);
        GenSolvablePolynomial qs = FDUtil.recursiveDivide(q, b);
        logger.info((Object)("RI-recCont b = " + b + ", q = " + q));
        logger.info((Object)("RI-recCont q/b = " + qs + ", q%b = " + q.subtract(qs.multiplyLeft(b))));
        if (!q.equals(qs.multiplyLeft(b))) {
            System.out.println("RI-recGcd, q         = " + q);
            System.out.println("RI-recGcd, cont(q)   = " + b);
            System.out.println("RI-recGcd, pp(q)     = " + qs);
            System.out.println("RI-recGcd, pp(q)c(q) = " + qs.multiplyLeft(b));
            throw new RuntimeException("RI-recGcd, pp: not divisible");
        }
        q = qs;
        GenSolvablePolynomial c = this.leftGcd(a, b);
        logger.info((Object)("RI-Gcd(contents) c = " + c + ", a = " + a + ", b = " + b));
        if (r.isONE()) {
            return r.multiplyLeft(c);
        }
        if (q.isONE()) {
            return q.multiplyLeft(c);
        }
        rs = r;
        qs = q;
        logger.info((Object)("RI-r.ring = " + r.ring.toScript()));
        logger.info((Object)("RI-gcd-loop, start: q = " + q + ", r = " + r));
        while (!r.isZERO()) {
            GenSolvablePolynomial x = FDUtil.recursiveRightSparsePseudoRemainder(q, r);
            q = r;
            r = field ? PolyUtil.monic(x) : x;
            logger.info((Object)("RI-gcd-loop, rem: q = " + q + ", r = " + r));
        }
        logger.info((Object)("RI-gcd(div) = " + q + ", rs = " + rs + ", qs = " + qs));
        GenSolvablePolynomial rp = FDUtil.recursiveRightSparsePseudoRemainder(rs, q);
        GenSolvablePolynomial<GenPolynomial<Object>> qp = FDUtil.recursiveRightSparsePseudoRemainder(qs, q);
        if (!qp.isZERO() || !rp.isZERO()) {
            logger.info((Object)("RI-gcd(div): rem(r,g) = " + rp + ", rem(q,g) = " + qp));
            rp = FDUtil.recursivePseudoQuotient(rs, q);
            qp = FDUtil.recursivePseudoQuotient(qs, q);
            logger.info((Object)("RI-gcd(div): r/g = " + rp + ", q/g = " + qp));
            throw new RuntimeException("recGcd, div: not divisible");
        }
        qp = q;
        if (!qp.equals(q = this.rightRecursivePrimitivePart(q))) {
            logger.info((Object)("RI-gcd(pp) = " + q + ", qp = " + qp));
        }
        q = (GenSolvablePolynomial)q.multiplyLeft(c).abs();
        return q;
    }
}

