/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.fd;

import edu.jas.fd.GreatestCommonDivisorPrimitive;
import edu.jas.fd.GreatestCommonDivisorSimple;
import edu.jas.gbmod.SolvableQuotient;
import edu.jas.gbmod.SolvableQuotientRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public class FDUtil {
    private static final Logger logger = Logger.getLogger(FDUtil.class);
    private static boolean debug = logger.isDebugEnabled();

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C> leftBaseSparsePseudoRemainder(GenSolvablePolynomial<C> P, GenSolvablePolynomial<C> S) {
        ExpVector f;
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(P.toString() + " division by zero " + S);
        }
        if (P.isZERO()) {
            return P;
        }
        if (S.isConstant()) {
            return P.ring.getZERO();
        }
        if (P instanceof RecSolvablePolynomial) {
            RecSolvablePolynomial Pr = (RecSolvablePolynomial)P;
            if (!Pr.ring.coeffTable.isEmpty()) {
                throw new UnsupportedOperationException("RecSolvablePolynomial with twisted coeffs not supported");
            }
        }
        GreatestCommonDivisorSimple fd = new GreatestCommonDivisorSimple();
        ExpVector e = S.leadingExpVector();
        GenSolvablePolynomial<Object> r = P;
        while (!r.isZERO() && (f = r.leadingExpVector()).multipleOf(e)) {
            GcdRingElem a = (GcdRingElem)r.leadingBaseCoefficient();
            f = f.subtract(e);
            GenSolvablePolynomial<ExpVector> h = S.multiplyLeft(f);
            GcdRingElem c = (GcdRingElem)h.leadingBaseCoefficient();
            GcdRingElem[] oc = fd.leftOreCond(a, c);
            GcdRingElem ga = oc[0];
            GcdRingElem gc = oc[1];
            r = r.multiplyLeft(ga);
            h = h.multiplyLeft((ExpVector)((Object)gc));
            r = (GenSolvablePolynomial)r.subtract((Object)h);
        }
        return r;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C> rightBaseSparsePseudoRemainder(GenSolvablePolynomial<C> P, GenSolvablePolynomial<C> S) {
        ExpVector f;
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(P.toString() + " division by zero " + S);
        }
        if (P.isZERO()) {
            return P;
        }
        if (S.isConstant()) {
            return P.ring.getZERO();
        }
        if (P instanceof RecSolvablePolynomial) {
            RecSolvablePolynomial Pr = (RecSolvablePolynomial)P;
            if (!Pr.ring.coeffTable.isEmpty()) {
                throw new UnsupportedOperationException("RecSolvablePolynomial with twisted coeffs not supported");
            }
        }
        GreatestCommonDivisorSimple fd = new GreatestCommonDivisorSimple();
        ExpVector e = S.leadingExpVector();
        GenPolynomial r = P;
        while (!r.isZERO() && (f = r.leadingExpVector()).multipleOf(e)) {
            f = f.subtract(e);
            GenPolynomial h = S.multiply(f);
            GcdRingElem a = (GcdRingElem)r.leadingBaseCoefficient();
            GcdRingElem c = (GcdRingElem)h.leadingBaseCoefficient();
            GcdRingElem[] oc = fd.rightOreCond(a, c);
            GcdRingElem ga = oc[0];
            GcdRingElem gc = oc[1];
            r = ((GenSolvablePolynomial)r).multiply(ga);
            h = ((GenSolvablePolynomial)h).multiply(gc);
            r = (GenSolvablePolynomial)r.subtract(h);
        }
        return r;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C> leftBasePseudoQuotient(GenSolvablePolynomial<C> P, GenSolvablePolynomial<C> S) {
        return FDUtil.leftBasePseudoQuotientRemainder(P, S)[0];
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C>[] leftBasePseudoQuotientRemainder(GenSolvablePolynomial<C> P, GenSolvablePolynomial<C> S) {
        ExpVector f;
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(P.toString() + " division by zero " + S);
        }
        GenSolvablePolynomial[] ret = new GenSolvablePolynomial[]{null, null};
        if (P.isZERO() || S.isONE()) {
            ret[0] = P;
            ret[1] = S.ring.getZERO();
            return ret;
        }
        if (P instanceof RecSolvablePolynomial) {
            RecSolvablePolynomial Pr = (RecSolvablePolynomial)P;
            if (!Pr.ring.coeffTable.isEmpty()) {
                throw new UnsupportedOperationException("RecSolvablePolynomial with twisted coeffs not supported");
            }
        }
        GreatestCommonDivisorSimple fd = new GreatestCommonDivisorSimple();
        ExpVector e = S.leadingExpVector();
        GenSolvablePolynomial<Object> r = P;
        GenSolvablePolynomial q = ((GenSolvablePolynomial)S.ring.getZERO()).copy();
        while (!r.isZERO() && (f = r.leadingExpVector()).multipleOf(e)) {
            GcdRingElem a = (GcdRingElem)r.leadingBaseCoefficient();
            f = f.subtract(e);
            GenSolvablePolynomial<ExpVector> h = S.multiplyLeft(f);
            GcdRingElem c = (GcdRingElem)h.leadingBaseCoefficient();
            GcdRingElem[] oc = fd.leftOreCond(a, c);
            GcdRingElem ga = oc[0];
            GcdRingElem gc = oc[1];
            r = r.multiplyLeft(ga);
            h = h.multiplyLeft((ExpVector)((Object)gc));
            q = q.multiplyLeft(ga);
            q = (GenSolvablePolynomial)q.sum((GcdRingElem)gc, f);
            r = (GenSolvablePolynomial)r.subtract((Object)h);
        }
        ret[0] = q;
        ret[1] = r;
        return ret;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursiveSparsePseudoRemainder(GenSolvablePolynomial<GenPolynomial<C>> P, GenSolvablePolynomial<GenPolynomial<C>> S) {
        ExpVector f;
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(P + " division by zero " + S);
        }
        if (P == null || P.isZERO()) {
            return P;
        }
        GreatestCommonDivisorSimple fd = new GreatestCommonDivisorSimple();
        ExpVector e = S.leadingExpVector();
        GenSolvablePolynomial r = P;
        while (!r.isZERO() && (f = r.leadingExpVector()).multipleOf(e)) {
            GenSolvablePolynomial a = (GenSolvablePolynomial)r.leadingBaseCoefficient();
            f = f.subtract(e);
            GenSolvablePolynomial<AbelianGroupElem<ExpVector>> h = S.multiplyLeft((GenPolynomial<ExpVector>)((Object)f));
            GenSolvablePolynomial d = (GenSolvablePolynomial)h.leadingBaseCoefficient();
            GenSolvablePolynomial<C>[] oc = fd.leftOreCond(a, d);
            GenSolvablePolynomial ga = oc[0];
            GenSolvablePolynomial gd = oc[1];
            r = r.multiplyLeft(ga);
            h = h.multiplyLeft((AbelianGroupElem<ExpVector>)((ExpVector)((Object)gd)));
            r = (GenSolvablePolynomial)r.subtract(h);
        }
        return r;
    }

    public static <C extends GcdRingElem<C>> boolean isRecursivePseudoQuotientRemainder(GenSolvablePolynomial<GenPolynomial<C>> P, GenSolvablePolynomial<GenPolynomial<C>> S, GenSolvablePolynomial<GenPolynomial<C>> q, GenSolvablePolynomial<GenPolynomial<C>> r) {
        GenSolvablePolynomial Rb;
        GenSolvablePolynomial rhs = (GenSolvablePolynomial)q.multiply((GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>>>>>)S).sum(r);
        GenSolvablePolynomial lhs = P;
        GenPolynomial ldcf = (GenPolynomial)S.leadingBaseCoefficient();
        long d = P.degree(0) - S.degree(0) + 1L;
        d = d > 0L ? d : -d + 2L;
        for (long i = 0L; i <= d; ++i) {
            if (lhs.equals(rhs)) {
                return true;
            }
            lhs = lhs.multiply((RingElem)ldcf);
        }
        GenPolynomial Pp = P;
        rhs = q.multiply((GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>>>>>)S);
        for (long i = 0L; i <= d; ++i) {
            lhs = (GenSolvablePolynomial)Pp.subtract(r);
            if (lhs.equals(rhs)) {
                return true;
            }
            Pp = Pp.multiply((RingElem)ldcf);
        }
        GreatestCommonDivisorSimple fd = new GreatestCommonDivisorSimple();
        GenSolvablePolynomial a = (GenSolvablePolynomial)P.leadingBaseCoefficient();
        rhs = (GenSolvablePolynomial)q.multiply((GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>>>>>)S).sum(r);
        GenSolvablePolynomial b = (GenSolvablePolynomial)rhs.leadingBaseCoefficient();
        GenSolvablePolynomial<C>[] oc = fd.leftOreCond(a, b);
        GenSolvablePolynomial ga = oc[0];
        GenSolvablePolynomial gb = oc[1];
        GenSolvablePolynomial Pa = P.multiplyLeft(ga);
        GenSolvablePolynomial D2 = (GenSolvablePolynomial)Pa.subtract(Rb = rhs.multiplyLeft(gb));
        if (D2.isZERO()) {
            return true;
        }
        if (debug) {
            logger.info((Object)("not QR: D = " + D2));
        }
        return false;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursivePseudoQuotient(GenSolvablePolynomial<GenPolynomial<C>> P, GenSolvablePolynomial<GenPolynomial<C>> S) {
        return FDUtil.recursivePseudoQuotientRemainder(P, S)[0];
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>>[] recursivePseudoQuotientRemainder(GenSolvablePolynomial<GenPolynomial<C>> P, GenSolvablePolynomial<GenPolynomial<C>> S) {
        ExpVector f;
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(P + " division by zero " + S);
        }
        GenSolvablePolynomial[] ret = new GenSolvablePolynomial[2];
        if (P == null || P.isZERO()) {
            ret[0] = S.ring.getZERO();
            ret[1] = S.ring.getZERO();
            return ret;
        }
        if (S.isONE()) {
            ret[0] = P;
            ret[1] = S.ring.getZERO();
            return ret;
        }
        GreatestCommonDivisorSimple fd = new GreatestCommonDivisorSimple();
        ExpVector e = S.leadingExpVector();
        GenSolvablePolynomial r = P;
        GenSolvablePolynomial q = ((GenSolvablePolynomial)S.ring.getZERO()).copy();
        while (!r.isZERO() && (f = r.leadingExpVector()).multipleOf(e)) {
            f = f.subtract(e);
            GenSolvablePolynomial<AbelianGroupElem<ExpVector>> h = S.multiplyLeft((GenPolynomial<ExpVector>)((Object)f));
            GenSolvablePolynomial a = (GenSolvablePolynomial)r.leadingBaseCoefficient();
            GenSolvablePolynomial d = (GenSolvablePolynomial)h.leadingBaseCoefficient();
            GenSolvablePolynomial<C>[] oc = fd.leftOreCond(a, d);
            GenSolvablePolynomial ga = oc[0];
            GenSolvablePolynomial gd = oc[1];
            r = r.multiplyLeft(ga);
            h = h.multiplyLeft((AbelianGroupElem<ExpVector>)((ExpVector)((Object)gd)));
            q = q.multiplyLeft(ga);
            q = (GenSolvablePolynomial)q.sum(gd, f);
            r = (GenSolvablePolynomial)r.subtract(h);
        }
        ret[0] = q;
        ret[1] = r;
        return ret;
    }

    public static <C extends GcdRingElem<C>> boolean isRecursiveRightPseudoQuotientRemainder(GenSolvablePolynomial<GenPolynomial<C>> P, GenSolvablePolynomial<GenPolynomial<C>> S, GenSolvablePolynomial<GenPolynomial<C>> q, GenSolvablePolynomial<GenPolynomial<C>> r) {
        GenSolvablePolynomial<GenPolynomial<C>> Rb;
        GenSolvablePolynomial rhs = (GenSolvablePolynomial)S.multiply((GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>>>>>)q).sum(r);
        GenSolvablePolynomial lhs = P;
        GenPolynomial ldcf = (GenPolynomial)S.leadingBaseCoefficient();
        long d = P.degree(0) - S.degree(0) + 1L;
        d = d > 0L ? d : -d + 2L;
        for (long i = 0L; i <= d; ++i) {
            if (lhs.equals(rhs)) {
                return true;
            }
            lhs = lhs.multiply((RingElem)ldcf);
        }
        GenPolynomial Pp = P;
        rhs = S.multiply((GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>>>>>)q);
        for (long i = 0L; i <= d; ++i) {
            lhs = (GenSolvablePolynomial)Pp.subtract((GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>)r);
            if (lhs.equals(rhs)) {
                return true;
            }
            Pp = Pp.multiply((RingElem)ldcf);
        }
        GreatestCommonDivisorSimple fd = new GreatestCommonDivisorSimple();
        GenSolvablePolynomial<GenPolynomial<C>> pr = P.rightRecursivePolynomial();
        GenSolvablePolynomial a = (GenSolvablePolynomial)pr.leadingBaseCoefficient();
        rhs = (GenSolvablePolynomial)S.multiply((GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>>>>>)q).sum(r);
        GenSolvablePolynomial<GenPolynomial<C>> rr = rhs.rightRecursivePolynomial();
        GenSolvablePolynomial b = (GenSolvablePolynomial)rr.leadingBaseCoefficient();
        GenSolvablePolynomial<C>[] oc = fd.rightOreCond(a, b);
        GenSolvablePolynomial ga = oc[0];
        GenSolvablePolynomial gb = oc[1];
        GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>> Pa = FDUtil.multiplyRightRecursivePolynomial(pr, ga);
        GenSolvablePolynomial D2 = (GenSolvablePolynomial)Pa.subtract((GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>)(Rb = FDUtil.multiplyRightRecursivePolynomial(rr, gb)));
        if (D2.isZERO()) {
            return true;
        }
        System.out.println("Pa = " + Pa);
        System.out.println("Rb = " + Rb);
        logger.info((Object)("not right QR: Pa-Rb = " + D2));
        return false;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursiveRightPseudoQuotient(GenSolvablePolynomial<GenPolynomial<C>> P, GenSolvablePolynomial<GenPolynomial<C>> S) {
        return FDUtil.recursiveRightPseudoQuotientRemainder(P, S)[0];
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursiveRightSparsePseudoRemainder(GenSolvablePolynomial<GenPolynomial<C>> P, GenSolvablePolynomial<GenPolynomial<C>> S) {
        return FDUtil.recursiveRightPseudoQuotientRemainder(P, S)[1];
    }

    public static <C extends RingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursiveRightSparsePseudoRemainderOld(GenSolvablePolynomial<GenPolynomial<C>> P, GenSolvablePolynomial<GenPolynomial<C>> S) {
        ExpVector f;
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(P + " division by zero " + S);
        }
        if (P == null || P.isZERO()) {
            return P;
        }
        if (S.isConstant()) {
            return P.ring.getZERO();
        }
        ExpVector e = S.leadingExpVector();
        GenPolynomial r = P;
        while (!r.isZERO() && (f = r.leadingExpVector()).multipleOf(e)) {
            f = f.subtract(e);
            GenPolynomial h = S.multiply(f);
            GenPolynomial d = (GenPolynomial)h.leadingBaseCoefficient();
            GenPolynomial a = (GenPolynomial)r.leadingBaseCoefficient();
            r = ((GenSolvablePolynomial)r).multiply((RingElem)d);
            h = ((GenSolvablePolynomial)h).multiply((RingElem)a);
            r = (GenSolvablePolynomial)r.subtract(h);
        }
        return r;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>>[] recursiveRightPseudoQuotientRemainder(GenSolvablePolynomial<GenPolynomial<C>> P, GenSolvablePolynomial<GenPolynomial<C>> S) {
        GenSolvablePolynomial q;
        ExpVector f;
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(P + " division by zero " + S);
        }
        GenSolvablePolynomial[] ret = new GenSolvablePolynomial[2];
        if (P == null || P.isZERO()) {
            ret[0] = S.ring.getZERO();
            ret[1] = S.ring.getZERO();
            return ret;
        }
        if (S.isONE()) {
            ret[0] = P;
            ret[1] = S.ring.getZERO();
            return ret;
        }
        GreatestCommonDivisorSimple fd = new GreatestCommonDivisorSimple();
        ExpVector e = S.leadingExpVector();
        GenSolvablePolynomial r = P;
        GenSolvablePolynomial qr = ((GenSolvablePolynomial)S.ring.getZERO()).copy();
        while (!r.isZERO() && (f = r.leadingExpVector()).multipleOf(e)) {
            f = f.subtract(e);
            GenSolvablePolynomial<GenPolynomial<C>> h = S.multiply(f);
            GenSolvablePolynomial<GenPolynomial<C>> hr = h.rightRecursivePolynomial();
            GenSolvablePolynomial<GenPolynomial<C>> rr = r.rightRecursivePolynomial();
            GenSolvablePolynomial a = (GenSolvablePolynomial)rr.leadingBaseCoefficient();
            GenSolvablePolynomial d = (GenSolvablePolynomial)hr.leadingBaseCoefficient();
            GenSolvablePolynomial<C>[] oc = fd.rightOreCond(a, d);
            GenSolvablePolynomial ga = oc[0];
            GenSolvablePolynomial gd = oc[1];
            rr = FDUtil.multiplyRightRecursivePolynomial(rr, ga);
            hr = FDUtil.multiplyRightRecursivePolynomial(hr, gd);
            h = hr.evalAsRightRecursivePolynomial();
            r = rr.evalAsRightRecursivePolynomial();
            r = (GenSolvablePolynomial)r.subtract(h);
            qr = FDUtil.multiplyRightRecursivePolynomial(qr, ga);
            qr = (GenSolvablePolynomial)qr.sum(gd, f);
        }
        ret[0] = q = qr.evalAsRightRecursivePolynomial();
        ret[1] = r;
        return ret;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursiveDivideRightEval(GenSolvablePolynomial<GenPolynomial<C>> P, GenSolvablePolynomial<C> s) {
        if (s.isONE()) {
            return P;
        }
        GenSolvablePolynomial<GenPolynomial<C>> Pr = P.rightRecursivePolynomial();
        GenSolvablePolynomial<GenPolynomial<C>> Qr = FDUtil.recursiveDivide(Pr, s);
        GenSolvablePolynomial<GenPolynomial<C>> Q = Qr.evalAsRightRecursivePolynomial();
        if (debug && !((GenSolvablePolynomial)Q.multiply((RingElem)s)).equals(P)) {
            System.out.println("rDivREval: P   = " + P + ", right(P) = " + Pr);
            System.out.println("rDivREval: Q   = " + Q + ", right(Q) = " + Qr);
            System.out.println("rDivREval: Q*s = " + Q.multiply((RingElem)s) + ", s = " + s);
            throw new RuntimeException("rDivREval: Q*s != P");
        }
        return Q;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursiveDivide(GenSolvablePolynomial<GenPolynomial<C>> P, GenSolvablePolynomial<C> s) {
        if (s == null || s.isZERO()) {
            throw new ArithmeticException("division by zero " + P + ", " + s);
        }
        if (P.isZERO()) {
            return P;
        }
        if (s.isONE()) {
            return P;
        }
        GenPolynomial p = ((GenSolvablePolynomial)P.ring.getZERO()).copy();
        for (Map.Entry m1 : P.getMap().entrySet()) {
            GenSolvablePolynomial c1 = (GenSolvablePolynomial)m1.getValue();
            ExpVector e1 = m1.getKey();
            GenSolvablePolynomial<C>[] QR = FDUtil.leftBasePseudoQuotientRemainder(c1, s);
            GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>> c = QR[0];
            if (debug && !QR[1].isZERO()) {
                System.out.println("rDiv, P   = " + P);
                System.out.println("rDiv, c1  = " + c1);
                System.out.println("rDiv, s   = " + s);
                System.out.println("rDiv, c   = " + c + ", r = " + QR[1]);
                System.out.println("rDiv, c*s = " + c.multiply(s));
                System.out.println("rDiv, s*c = " + s.multiply(c));
                throw new RuntimeException("something is wrong: rem = " + QR[1]);
            }
            if (!c.isZERO()) {
                p.doPutToMap(e1, c);
                continue;
            }
            System.out.println("rDiv, P  = " + P);
            System.out.println("rDiv, c1 = " + c1);
            System.out.println("rDiv, s  = " + s);
            System.out.println("rDiv, c  = " + c);
            throw new RuntimeException("something is wrong: c is zero");
        }
        return p;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursiveDivideRightPolynomial(GenSolvablePolynomial<GenPolynomial<C>> P, GenSolvablePolynomial<C> s) {
        if (s == null || s.isZERO()) {
            throw new ArithmeticException("division by zero " + P + ", " + s);
        }
        if (P.isZERO()) {
            return P;
        }
        if (s.isONE()) {
            return P;
        }
        GenPolynomial p = ((GenSolvablePolynomial)P.ring.getZERO()).copy();
        GenSolvablePolynomial<GenPolynomial<C>> Pr = P.rightRecursivePolynomial();
        logger.info((Object)("P = " + P + ", right(P) = " + Pr + ", left(s) = " + s));
        for (Map.Entry m1 : Pr.getMap().entrySet()) {
            GenSolvablePolynomial c1 = (GenSolvablePolynomial)m1.getValue();
            ExpVector e1 = m1.getKey();
            GenSolvablePolynomial<C> c = FDUtil.divideRightPolynomial(c1, s);
            if (c.isZERO()) continue;
            p.doPutToMap(e1, c);
        }
        GenSolvablePolynomial<GenPolynomial<C>> pl = ((GenSolvablePolynomial)p).evalAsRightRecursivePolynomial();
        logger.info((Object)("pl = " + pl + ", p = " + p));
        return pl;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C> divideRightPolynomial(GenSolvablePolynomial<C> P, GenSolvablePolynomial<C> s) {
        if (s == null || s.isZERO()) {
            throw new ArithmeticException("division by zero " + P + ", " + s);
        }
        if (P.isZERO()) {
            return P;
        }
        if (s.isONE()) {
            return P;
        }
        GenSolvablePolynomialRing pfac = P.ring;
        if (pfac.nvar <= 1) {
            GenSolvablePolynomial<C>[] QR1 = FDUtil.leftBasePseudoQuotientRemainder(P, s);
            GenSolvablePolynomial<C> q = QR1[0];
            if (debug && !QR1[1].isZERO()) {
                System.out.println("rDivPol, P = " + P);
                System.out.println("rDivPol, s = " + s);
                throw new RuntimeException("non zero remainder, q = " + q + ", r = " + QR1[1]);
            }
            return q;
        }
        GenPolynomialRing rfac = pfac.recursive(1);
        GenSolvablePolynomial pr = (GenSolvablePolynomial)PolyUtil.recursive(rfac, P);
        GenSolvablePolynomial sr = (GenSolvablePolynomial)PolyUtil.recursive(rfac, s);
        GenSolvablePolynomial<GenPolynomial<C>>[] QR = FDUtil.recursiveRightPseudoQuotientRemainder(pr, sr);
        GenSolvablePolynomial<GenPolynomial<C>> qr = QR[0];
        GenSolvablePolynomial<GenPolynomial<C>> rr = QR[1];
        if (debug && !rr.isZERO()) {
            System.out.println("rDivPol, pr = " + pr);
            System.out.println("rDivPol, sr = " + sr);
            throw new RuntimeException("non zero remainder, q = " + qr + ", r = " + rr);
        }
        GenSolvablePolynomial q = (GenSolvablePolynomial)PolyUtil.distribute(pfac, qr);
        return q;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursiveRightDivide(GenSolvablePolynomial<GenPolynomial<C>> P, GenSolvablePolynomial<C> s) {
        if (s == null || s.isZERO()) {
            throw new ArithmeticException("division by zero " + P + ", " + s);
        }
        if (P.isZERO()) {
            return P;
        }
        if (s.isONE()) {
            return P;
        }
        if (!(P instanceof RecSolvablePolynomial)) {
            // empty if block
        }
        RecSolvablePolynomialRing rfac = (RecSolvablePolynomialRing)P.ring;
        if (rfac.coeffTable.isEmpty()) {
            // empty if block
        }
        GenSolvablePolynomial onep = rfac.getONE();
        ExpVector zero = rfac.evzero;
        GenSolvablePolynomial q = rfac.getZERO();
        RecSolvablePolynomial p = (RecSolvablePolynomial)P;
        while (!p.isZERO()) {
            ExpVector f = p.leadingExpVector();
            GenSolvablePolynomial a = (GenSolvablePolynomial)p.leadingBaseCoefficient();
            GenSolvablePolynomial<C>[] QR = FDUtil.leftBasePseudoQuotientRemainder(a, s);
            if (!(!debug || QR[1].isZERO() && a.remainder(s).isZERO())) {
                logger.info((Object)("no exact division, rem = " + a.remainder(s) + ", r =" + QR[1]));
                throw new RuntimeException("no exact division: r = " + QR[1]);
            }
            GenSolvablePolynomial<C> c = QR[0];
            if (c.isZERO()) {
                System.out.println("rDiv, P  = " + P);
                System.out.println("rDiv, a  = " + a);
                System.out.println("rDiv, s  = " + s);
                System.out.println("rDiv, c  = " + c);
                throw new RuntimeException("something is wrong: c is zero");
            }
            RecSolvablePolynomial<C> r = ((RecSolvablePolynomial)onep).multiply(c, f, s, zero);
            p = (RecSolvablePolynomial)p.subtract(r);
            q = (RecSolvablePolynomial)q.sum(c, f);
        }
        return q;
    }

    public static <C extends RingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> multiplyRightRecursivePolynomial(GenSolvablePolynomial<GenPolynomial<C>> P, GenPolynomial<C> b) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomial Cp = ((GenSolvablePolynomial)P.ring.getZERO()).copy();
        if (b == null || b.isZERO()) {
            return Cp;
        }
        SortedMap Am = P.getMap();
        for (Map.Entry y : Am.entrySet()) {
            ExpVector e = (ExpVector)y.getKey();
            GenPolynomial a = (GenPolynomial)y.getValue();
            GenPolynomial<GenPolynomial<C>> c = a.multiply(b);
            if (c.isZERO()) continue;
            Cp.doPutToMap(e, c);
        }
        return Cp;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> integralFromQuotientCoefficients(GenSolvablePolynomialRing<GenPolynomial<C>> fac, GenSolvablePolynomial<SolvableQuotient<C>> A) {
        GenPolynomial B = ((GenSolvablePolynomial)fac.getZERO()).copy();
        if (A == null || A.isZERO()) {
            return B;
        }
        GenSolvablePolynomial<Object> c = null;
        GreatestCommonDivisorPrimitive fd = new GreatestCommonDivisorPrimitive();
        int s = 0;
        SortedMap Am = A.getMap();
        for (SolvableQuotient solvableQuotient : Am.values()) {
            GenSolvablePolynomial x = solvableQuotient.den;
            if (c == null) {
                c = x;
                s = x.signum();
                continue;
            }
            GenSolvablePolynomial d = fd.leftGcd(c, x);
            GenSolvablePolynomial z = (GenSolvablePolynomial)x.divide(d);
            c = z.multiply(c);
        }
        if (s < 0) {
            c = (GenSolvablePolynomial)c.negate();
        }
        for (Map.Entry entry : Am.entrySet()) {
            ExpVector e = (ExpVector)entry.getKey();
            SolvableQuotient a = (SolvableQuotient)entry.getValue();
            GenPolynomial b = c.divide(a.den);
            GenPolynomial p = ((GenPolynomial)a.num).multiply(b);
            B.doPutToMap(e, p);
        }
        return B;
    }

    public static <C extends GcdRingElem<C>> List<GenSolvablePolynomial<GenPolynomial<C>>> integralFromQuotientCoefficients(GenSolvablePolynomialRing<GenPolynomial<C>> fac, Collection<GenSolvablePolynomial<SolvableQuotient<C>>> L) {
        if (L == null) {
            return null;
        }
        ArrayList<GenSolvablePolynomial<GenPolynomial<C>>> list = new ArrayList<GenSolvablePolynomial<GenPolynomial<C>>>(L.size());
        for (GenSolvablePolynomial<SolvableQuotient<C>> p : L) {
            list.add(FDUtil.integralFromQuotientCoefficients(fac, p));
        }
        return list;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<SolvableQuotient<C>> quotientFromIntegralCoefficients(GenSolvablePolynomialRing<SolvableQuotient<C>> fac, GenSolvablePolynomial<GenPolynomial<C>> A) {
        GenPolynomial B = ((GenSolvablePolynomial)fac.getZERO()).copy();
        if (A == null || A.isZERO()) {
            return B;
        }
        RingFactory cfac = fac.coFac;
        SolvableQuotientRing qfac = (SolvableQuotientRing)cfac;
        for (Map.Entry y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            GenSolvablePolynomial a = (GenSolvablePolynomial)y.getValue();
            SolvableQuotient p = new SolvableQuotient(qfac, a);
            if (p.isZERO()) continue;
            B.doPutToMap(e, p);
        }
        return B;
    }

    public static <C extends GcdRingElem<C>> List<GenSolvablePolynomial<SolvableQuotient<C>>> quotientFromIntegralCoefficients(GenSolvablePolynomialRing<SolvableQuotient<C>> fac, Collection<GenSolvablePolynomial<GenPolynomial<C>>> L) {
        if (L == null) {
            return null;
        }
        ArrayList<GenSolvablePolynomial<SolvableQuotient<C>>> list = new ArrayList<GenSolvablePolynomial<SolvableQuotient<C>>>(L.size());
        for (GenSolvablePolynomial<GenPolynomial<C>> p : L) {
            list.add(FDUtil.quotientFromIntegralCoefficients(fac, p));
        }
        return list;
    }
}

