/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.Product;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class ProductRing<C extends RingElem<C>>
implements RingFactory<Product<C>> {
    private static final Logger logger = Logger.getLogger(ProductRing.class);
    protected int nCopies;
    protected final RingFactory<C> ring;
    protected final List<RingFactory<C>> ringList;
    protected static final Random random = new Random();

    public ProductRing(RingFactory<C> r, int n) {
        this.ring = r;
        this.nCopies = n;
        this.ringList = null;
    }

    public ProductRing(List<RingFactory<C>> l) {
        this.ringList = l;
        this.ring = null;
        this.nCopies = 0;
    }

    public RingFactory<C> getFactory(int i) {
        if (this.nCopies != 0) {
            if (0 <= i && i < this.nCopies) {
                return this.ring;
            }
            logger.info((Object)("index: " + i));
            throw new IllegalArgumentException("index out of bound " + this);
        }
        return this.ringList.get(i);
    }

    public synchronized void addFactory(RingFactory<C> rf) {
        if (this.nCopies != 0) {
            if (this.ring.equals(rf)) {
                ++this.nCopies;
            }
            throw new IllegalArgumentException("wrong RingFactory: " + rf);
        }
        this.ringList.add(rf);
    }

    public boolean containsFactory(RingFactory<C> rf) {
        if (this.nCopies != 0) {
            return this.ring.equals(rf);
        }
        return this.ringList.contains(rf);
    }

    @Override
    public boolean isFinite() {
        if (this.nCopies != 0) {
            return this.ring.isFinite();
        }
        for (RingFactory<C> f : this.ringList) {
            boolean b = f.isFinite();
            if (b) continue;
            return false;
        }
        return true;
    }

    @Override
    public Product<C> copy(Product<C> c) {
        return new Product(c.ring, c.val, c.isunit);
    }

    @Override
    public Product<C> getZERO() {
        return new Product(this);
    }

    @Override
    public Product<C> getONE() {
        TreeMap elem = new TreeMap();
        if (this.nCopies != 0) {
            for (int i = 0; i < this.nCopies; ++i) {
                elem.put(i, this.ring.getONE());
            }
        } else {
            int i = 0;
            for (RingFactory<C> f : this.ringList) {
                elem.put(i, f.getONE());
                ++i;
            }
        }
        return new Product(this, elem, 1);
    }

    @Override
    public List<Product<C>> generators() {
        ArrayList<Product<C>> gens = new ArrayList<Product<C>>();
        int n = this.nCopies;
        if (n == 0) {
            n = this.ringList.size();
        }
        for (int i = 0; i < n; ++i) {
            RingFactory<C> f = this.getFactory(i);
            List rgens = f.generators();
            for (RingElem c : rgens) {
                TreeMap<Integer, RingElem> elem = new TreeMap<Integer, RingElem>();
                elem.put(i, c);
                Product g = new Product(this, elem);
                gens.add(g);
            }
        }
        return gens;
    }

    public Product<C> getAtomic(int i) {
        if (i < 0 || i >= this.length()) {
            throw new IllegalArgumentException("index out of bounds " + i);
        }
        TreeMap elem = new TreeMap();
        if (this.nCopies != 0) {
            elem.put(i, this.ring.getONE());
        } else {
            RingFactory<C> f = this.ringList.get(i);
            elem.put(i, f.getONE());
        }
        return new Product(this, elem, 1);
    }

    public int length() {
        if (this.nCopies != 0) {
            return this.nCopies;
        }
        return this.ringList.size();
    }

    @Override
    public boolean isCommutative() {
        if (this.nCopies != 0) {
            return this.ring.isCommutative();
        }
        for (RingFactory<C> f : this.ringList) {
            if (f.isCommutative()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAssociative() {
        if (this.nCopies != 0) {
            return this.ring.isAssociative();
        }
        for (RingFactory<C> f : this.ringList) {
            if (f.isAssociative()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isField() {
        if (this.nCopies != 0) {
            if (this.nCopies == 1) {
                return this.ring.isField();
            }
        } else if (this.ringList.size() == 1) {
            return this.ringList.get(0).isField();
        }
        return false;
    }

    public boolean onlyFields() {
        if (this.nCopies != 0) {
            return this.ring.isField();
        }
        for (RingFactory<C> f : this.ringList) {
            if (f.isField()) continue;
            return false;
        }
        return true;
    }

    @Override
    public BigInteger characteristic() {
        if (this.nCopies != 0) {
            return this.ring.characteristic();
        }
        BigInteger c = null;
        for (RingFactory<C> f : this.ringList) {
            if (c == null) {
                c = f.characteristic();
                continue;
            }
            BigInteger d = f.characteristic();
            if (c.compareTo(d) <= 0) continue;
            c = d;
        }
        return c;
    }

    @Override
    public Product<C> fromInteger(BigInteger a) {
        TreeMap elem = new TreeMap();
        if (this.nCopies != 0) {
            RingElem c = (RingElem)this.ring.fromInteger(a);
            for (int i = 0; i < this.nCopies; ++i) {
                elem.put(i, c);
            }
        } else {
            int i = 0;
            for (RingFactory<C> f : this.ringList) {
                elem.put(i, f.fromInteger(a));
                ++i;
            }
        }
        return new Product(this, elem);
    }

    @Override
    public Product<C> fromInteger(long a) {
        return this.fromInteger(new BigInteger("" + a));
    }

    public String toString() {
        if (this.nCopies != 0) {
            String cf = this.ring.toString();
            if (cf.matches("[0-9].*")) {
                cf = this.ring.getClass().getSimpleName();
            }
            return "ProductRing[ " + cf + "^" + this.nCopies + " ]";
        }
        StringBuffer sb = new StringBuffer("ProductRing[ ");
        int i = 0;
        for (RingFactory<C> f : this.ringList) {
            String cf;
            if (i != 0) {
                sb.append(", ");
            }
            if ((cf = f.toString()).matches("[0-9].*")) {
                cf = f.getClass().getSimpleName();
            }
            sb.append(cf);
            ++i;
        }
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public String toScript() {
        StringBuffer s = new StringBuffer("RR( [ ");
        for (int i = 0; i < this.length(); ++i) {
            if (i > 0) {
                s.append(", ");
            }
            RingFactory<C> v = this.getFactory(i);
            String f = null;
            try {
                f = ((RingElem)((Object)v)).toScriptFactory();
            }
            catch (Exception e) {
                f = v.toScript();
            }
            s.append(f);
        }
        s.append(" ] )");
        return s.toString();
    }

    public boolean equals(Object b) {
        if (b == null) {
            return false;
        }
        if (!(b instanceof ProductRing)) {
            return false;
        }
        ProductRing a = (ProductRing)b;
        if (this.nCopies != 0) {
            if (this.nCopies != a.nCopies || !this.ring.equals(a.ring)) {
                return false;
            }
        } else {
            if (this.ringList.size() != a.ringList.size()) {
                return false;
            }
            int i = 0;
            for (RingFactory<C> f : this.ringList) {
                if (!f.equals(a.ringList.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        if (this.nCopies != 0) {
            h = this.ring.hashCode();
            h = 37 * h + this.nCopies;
        } else {
            for (RingFactory<C> f : this.ringList) {
                h = 37 * h + f.hashCode();
            }
        }
        return h;
    }

    @Override
    public Product<C> random(int n) {
        return this.random(n, 0.5f);
    }

    public Product<C> random(int n, float q) {
        return this.random(n, q, random);
    }

    @Override
    public Product<C> random(int n, Random rnd) {
        return this.random(n, 0.5f, random);
    }

    public Product<C> random(int n, float q, Random rnd) {
        TreeMap<Integer, RingElem> elem = new TreeMap<Integer, RingElem>();
        if (this.nCopies != 0) {
            for (int i = 0; i < this.nCopies; ++i) {
                RingElem r;
                float d = rnd.nextFloat();
                if (!(d < q) || (r = (RingElem)this.ring.random(n, rnd)).isZERO()) continue;
                elem.put(i, r);
            }
        } else {
            int i = 0;
            for (RingFactory<C> f : this.ringList) {
                RingElem r;
                float d = rnd.nextFloat();
                if (d < q && !(r = (RingElem)f.random(n, rnd)).isZERO()) {
                    elem.put(i, r);
                }
                ++i;
            }
        }
        return new Product(this, elem);
    }

    @Override
    public Product<C> parse(String s) {
        StringReader sr = new StringReader(s);
        return this.parse(sr);
    }

    @Override
    public Product<C> parse(Reader r) {
        TreeMap elem = new TreeMap();
        if (this.nCopies != 0) {
            for (int i = 0; i < this.nCopies; ++i) {
                elem.put(i, this.ring.parse(r));
            }
        } else {
            int i = 0;
            for (RingFactory<C> f : this.ringList) {
                elem.put(i, f.parse(r));
                ++i;
            }
        }
        return new Product(this, elem);
    }
}

