/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigInteger;

public class Combinatoric {
    public static BigInteger binCoeffInduction(BigInteger A, long n, long k) {
        BigInteger np = new BigInteger(n - k);
        BigInteger kp = new BigInteger(k + 1L);
        BigInteger B = A.multiply(np).divide(kp);
        return B;
    }

    public static BigInteger binCoeff(int n, int k) {
        BigInteger A = BigInteger.ONE;
        int kp = k < n - k ? k : n - k;
        for (int j = 0; j < kp; ++j) {
            A = Combinatoric.binCoeffInduction(A, n, j);
        }
        return A;
    }

    public static BigInteger binCoeffSum(int n, int k) {
        BigInteger S = BigInteger.ONE;
        BigInteger B = BigInteger.ONE;
        for (int j = 0; j < k; ++j) {
            B = Combinatoric.binCoeffInduction(B, n, j);
            S = S.sum(B);
        }
        return S;
    }

    public static BigInteger factorial(long n) {
        if (n <= 1L) {
            return BigInteger.ONE;
        }
        BigInteger f = BigInteger.ONE;
        if (n >= Integer.MAX_VALUE) {
            throw new UnsupportedOperationException(n + " >= Integer.MAX_VALUE = " + Integer.MAX_VALUE);
        }
        int i = 2;
        while ((long)i <= n) {
            f = f.multiply(new BigInteger(i));
            ++i;
        }
        return f;
    }
}

