/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRationalIterator;
import edu.jas.arith.BigRationalUniqueIterator;
import edu.jas.arith.Rational;
import edu.jas.kern.Scripting;
import edu.jas.kern.StringUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.Power;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public final class BigRational
implements GcdRingElem<BigRational>,
RingFactory<BigRational>,
Rational,
Iterable<BigRational> {
    public final java.math.BigInteger num;
    public final java.math.BigInteger den;
    public static final BigRational ZERO = new BigRational(java.math.BigInteger.ZERO);
    public static final BigRational ONE = new BigRational(java.math.BigInteger.ONE);
    private static final Random random = new Random();
    private boolean nonNegative = true;
    private boolean duplicates = true;

    protected BigRational(java.math.BigInteger n, java.math.BigInteger d) {
        this.num = n;
        this.den = d;
    }

    public BigRational(java.math.BigInteger n) {
        this.num = n;
        this.den = java.math.BigInteger.ONE;
    }

    public BigRational(BigInteger n) {
        this(n.getVal());
    }

    public BigRational(BigInteger n, BigInteger d) {
        java.math.BigInteger nu = n.getVal();
        java.math.BigInteger de = d.getVal();
        BigRational r = BigRational.RNRED(nu, de);
        this.num = r.num;
        this.den = r.den;
    }

    public BigRational(long n, long d) {
        java.math.BigInteger nu = java.math.BigInteger.valueOf(n);
        java.math.BigInteger de = java.math.BigInteger.valueOf(d);
        BigRational r = BigRational.RNRED(nu, de);
        this.num = r.num;
        this.den = r.den;
    }

    public BigRational(long n) {
        this.num = java.math.BigInteger.valueOf(n);
        this.den = java.math.BigInteger.ONE;
    }

    public BigRational() {
        this.num = java.math.BigInteger.ZERO;
        this.den = java.math.BigInteger.ONE;
    }

    public BigRational(String s) throws NumberFormatException {
        if (s == null) {
            this.num = java.math.BigInteger.ZERO;
            this.den = java.math.BigInteger.ONE;
            return;
        }
        if (s.length() == 0) {
            this.num = java.math.BigInteger.ZERO;
            this.den = java.math.BigInteger.ONE;
            return;
        }
        int i = (s = s.trim()).indexOf(47);
        if (i < 0) {
            i = s.indexOf(46);
            if (i < 0) {
                this.num = new java.math.BigInteger(s);
                this.den = java.math.BigInteger.ONE;
                return;
            }
        } else {
            java.math.BigInteger n = new java.math.BigInteger(s.substring(0, i));
            java.math.BigInteger d = new java.math.BigInteger(s.substring(i + 1, s.length()));
            BigRational r = BigRational.RNRED(n, d);
            this.num = r.num;
            this.den = r.den;
            return;
        }
        java.math.BigInteger n = s.charAt(0) == '-' ? new java.math.BigInteger(s.substring(1, i)) : new java.math.BigInteger(s.substring(0, i));
        BigRational r = new BigRational(n);
        java.math.BigInteger d = new java.math.BigInteger(s.substring(i + 1, s.length()));
        int j = s.length() - i - 1;
        BigRational z = new BigRational(1L, 10L);
        z = Power.positivePower(z, j);
        BigRational f = new BigRational(d);
        f = f.multiply(z);
        r = r.sum(f);
        this.num = s.charAt(0) == '-' ? r.num.negate() : r.num;
        this.den = r.den;
    }

    public BigRational factory() {
        return this;
    }

    @Override
    public List<BigRational> generators() {
        ArrayList<BigRational> g = new ArrayList<BigRational>(1);
        g.add(this.getONE());
        return g;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public BigRational copy() {
        return new BigRational(this.num, this.den);
    }

    @Override
    public BigRational copy(BigRational c) {
        return new BigRational(c.num, c.den);
    }

    @Override
    public BigRational getRational() {
        return this;
    }

    public java.math.BigInteger numerator() {
        return this.num;
    }

    public java.math.BigInteger denominator() {
        return this.den;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(this.num);
        if (!this.den.equals(java.math.BigInteger.ONE)) {
            s.append("/").append(this.den);
        }
        return s.toString();
    }

    public String toString(int n) {
        MathContext mc = new MathContext(n);
        BigDecimal d = new BigDecimal(this, mc);
        return d.toString();
    }

    public double doubleValue() {
        BigDecimal d = new BigDecimal(this, MathContext.DECIMAL64);
        return d.doubleValue();
    }

    @Override
    public String toScript() {
        StringBuffer s = new StringBuffer();
        if (this.den.equals(java.math.BigInteger.ONE)) {
            s.append(this.num.toString());
            return s.toString();
        }
        switch (Scripting.getLang()) {
            case Python: {
                s.append("(");
                s.append(this.num.toString());
                s.append(",");
                s.append(this.den.toString());
                s.append(")");
                break;
            }
            default: {
                s.append(this.num.toString());
                s.append("/");
                s.append(this.den.toString());
            }
        }
        return s.toString();
    }

    @Override
    public String toScriptFactory() {
        return "QQ()";
    }

    @Override
    public BigRational getZERO() {
        return ZERO;
    }

    @Override
    public BigRational getONE() {
        return ONE;
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public boolean isAssociative() {
        return true;
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public java.math.BigInteger characteristic() {
        return java.math.BigInteger.ZERO;
    }

    @Override
    public BigRational fromInteger(java.math.BigInteger a) {
        return new BigRational(a);
    }

    public BigRational fromInteger(BigInteger a) {
        return new BigRational(a);
    }

    public static BigRational valueOf(java.math.BigInteger a) {
        return new BigRational(a);
    }

    @Override
    public BigRational fromInteger(long a) {
        return new BigRational(a);
    }

    public static BigRational valueOf(long a) {
        return new BigRational(a);
    }

    @Override
    public boolean isZERO() {
        return this.num.equals(java.math.BigInteger.ZERO);
    }

    @Override
    public boolean isONE() {
        return this.num.equals(this.den);
    }

    @Override
    public boolean isUnit() {
        return !this.isZERO();
    }

    @Override
    public boolean equals(Object b) {
        if (!(b instanceof BigRational)) {
            return false;
        }
        BigRational br = (BigRational)b;
        return this.num.equals(br.num) && this.den.equals(br.den);
    }

    @Override
    public int hashCode() {
        return 37 * this.num.hashCode() + this.den.hashCode();
    }

    public static BigRational RNRED(java.math.BigInteger n, java.math.BigInteger d) {
        java.math.BigInteger den;
        java.math.BigInteger num;
        if (n.equals(java.math.BigInteger.ZERO)) {
            java.math.BigInteger num2 = n;
            java.math.BigInteger den2 = java.math.BigInteger.ONE;
            return new BigRational(num2, den2);
        }
        if (n.equals(d)) {
            java.math.BigInteger num3 = java.math.BigInteger.ONE;
            java.math.BigInteger den3 = java.math.BigInteger.ONE;
            return new BigRational(num3, den3);
        }
        java.math.BigInteger c = n.gcd(d);
        if (c.equals(java.math.BigInteger.ONE)) {
            num = n;
            den = d;
        } else {
            num = n.divide(c);
            den = d.divide(c);
        }
        if (den.signum() < 0) {
            num = num.negate();
            den = den.negate();
        }
        return new BigRational(num, den);
    }

    public static BigRational reduction(java.math.BigInteger n, java.math.BigInteger d) {
        return BigRational.RNRED(n, d);
    }

    @Override
    public BigRational abs() {
        if (this.signum() >= 0) {
            return this;
        }
        return this.negate();
    }

    public static BigRational RNABS(BigRational R) {
        if (R == null) {
            return null;
        }
        return R.abs();
    }

    @Override
    public int compareTo(BigRational S) {
        int SL;
        if (this.equals(ZERO)) {
            return -S.signum();
        }
        if (S.equals(ZERO)) {
            return this.signum();
        }
        java.math.BigInteger R1 = this.num;
        java.math.BigInteger R2 = this.den;
        java.math.BigInteger S1 = S.num;
        java.math.BigInteger S2 = S.den;
        int RL = R1.signum();
        int J1Y = RL - (SL = S1.signum());
        int TL = J1Y / 2;
        if (TL != 0) {
            return TL;
        }
        java.math.BigInteger J3Y = R1.multiply(S2);
        java.math.BigInteger J2Y = R2.multiply(S1);
        TL = J3Y.compareTo(J2Y);
        return TL;
    }

    public static int RNCOMP(BigRational R, BigRational S) {
        if (R == null) {
            return Integer.MAX_VALUE;
        }
        return R.compareTo(S);
    }

    public static java.math.BigInteger RNDEN(BigRational R) {
        if (R == null) {
            return null;
        }
        return R.den;
    }

    @Override
    public BigRational subtract(BigRational S) {
        return this.sum(S.negate());
    }

    public static BigRational RNDIF(BigRational R, BigRational S) {
        if (R == null) {
            return S.negate();
        }
        return R.subtract(S);
    }

    public static void RNDWR(BigRational R, int NL) {
        MathContext mc = new MathContext(NL);
        BigDecimal d = new BigDecimal(R, mc);
        System.out.print(d.toString());
    }

    public static BigRational RNINT(java.math.BigInteger A) {
        return new BigRational(A);
    }

    @Override
    public BigRational inverse() {
        java.math.BigInteger S2;
        java.math.BigInteger S1;
        java.math.BigInteger R1 = this.num;
        java.math.BigInteger R2 = this.den;
        if (R1.signum() >= 0) {
            S1 = R2;
            S2 = R1;
        } else {
            S1 = R2.negate();
            S2 = R1.negate();
        }
        return new BigRational(S1, S2);
    }

    public static BigRational RNINV(BigRational R) {
        if (R == null) {
            return null;
        }
        return R.inverse();
    }

    @Override
    public BigRational negate() {
        java.math.BigInteger n = this.num.negate();
        return new BigRational(n, this.den);
    }

    public static BigRational RNNEG(BigRational R) {
        if (R == null) {
            return null;
        }
        return R.negate();
    }

    public static java.math.BigInteger RNNUM(BigRational R) {
        if (R == null) {
            return null;
        }
        return R.num;
    }

    @Override
    public BigRational multiply(BigRational S) {
        java.math.BigInteger D1 = null;
        java.math.BigInteger D2 = null;
        java.math.BigInteger R1 = null;
        java.math.BigInteger R2 = null;
        java.math.BigInteger RB1 = null;
        java.math.BigInteger RB2 = null;
        java.math.BigInteger S1 = null;
        java.math.BigInteger S2 = null;
        java.math.BigInteger SB1 = null;
        java.math.BigInteger SB2 = null;
        if (this.equals(ZERO) || S.equals(ZERO)) {
            BigRational T = ZERO;
            return T;
        }
        R1 = this.num;
        R2 = this.den;
        S1 = S.num;
        S2 = S.den;
        if (R2.equals(java.math.BigInteger.ONE) && S2.equals(java.math.BigInteger.ONE)) {
            java.math.BigInteger T1 = R1.multiply(S1);
            BigRational T = new BigRational(T1, java.math.BigInteger.ONE);
            return T;
        }
        if (R2.equals(java.math.BigInteger.ONE)) {
            D1 = R1.gcd(S2);
            RB1 = R1.divide(D1);
            SB2 = S2.divide(D1);
            java.math.BigInteger T1 = RB1.multiply(S1);
            BigRational T = new BigRational(T1, SB2);
            return T;
        }
        if (S2.equals(java.math.BigInteger.ONE)) {
            D2 = S1.gcd(R2);
            SB1 = S1.divide(D2);
            RB2 = R2.divide(D2);
            java.math.BigInteger T1 = SB1.multiply(R1);
            BigRational T = new BigRational(T1, RB2);
            return T;
        }
        D1 = R1.gcd(S2);
        RB1 = R1.divide(D1);
        SB2 = S2.divide(D1);
        D2 = S1.gcd(R2);
        SB1 = S1.divide(D2);
        RB2 = R2.divide(D2);
        java.math.BigInteger T1 = RB1.multiply(SB1);
        java.math.BigInteger T2 = RB2.multiply(SB2);
        BigRational T = new BigRational(T1, T2);
        return T;
    }

    public static BigRational RNPROD(BigRational R, BigRational S) {
        if (R == null) {
            return R;
        }
        return R.multiply(S);
    }

    @Override
    public BigRational divide(BigRational S) {
        return this.multiply(S.inverse());
    }

    public static BigRational RNQ(BigRational R, BigRational S) {
        if (R == null) {
            return R;
        }
        return R.divide(S);
    }

    @Override
    public BigRational remainder(BigRational S) {
        if (S.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        return ZERO;
    }

    public BigRational[] quotientRemainder(BigRational S) {
        return new BigRational[]{this.divide(S), ZERO};
    }

    @Override
    public BigRational random(int n) {
        return this.random(n, random);
    }

    @Override
    public BigRational random(int n, Random rnd) {
        java.math.BigInteger A = new java.math.BigInteger(n, rnd);
        if (rnd.nextBoolean()) {
            A = A.negate();
        }
        java.math.BigInteger B = new java.math.BigInteger(n, rnd);
        B = B.add(java.math.BigInteger.ONE);
        return BigRational.RNRED(A, B);
    }

    public static BigRational RNRAND(int NL) {
        return ONE.random(NL, random);
    }

    @Override
    public int signum() {
        return this.num.signum();
    }

    public static int RNSIGN(BigRational R) {
        if (R == null) {
            return 0;
        }
        return R.signum();
    }

    @Override
    public BigRational sum(BigRational S) {
        java.math.BigInteger E2;
        java.math.BigInteger J2Y;
        java.math.BigInteger D2 = null;
        java.math.BigInteger R1 = null;
        java.math.BigInteger R2 = null;
        java.math.BigInteger RB2 = null;
        java.math.BigInteger S1 = null;
        java.math.BigInteger S2 = null;
        java.math.BigInteger SB2 = null;
        if (this.equals(ZERO)) {
            BigRational T = S;
            return T;
        }
        if (S.equals(ZERO)) {
            BigRational T = this;
            return T;
        }
        R1 = this.num;
        R2 = this.den;
        S1 = S.num;
        S2 = S.den;
        if (R2.equals(java.math.BigInteger.ONE) && S2.equals(java.math.BigInteger.ONE)) {
            java.math.BigInteger T1 = R1.add(S1);
            BigRational T = new BigRational(T1, java.math.BigInteger.ONE);
            return T;
        }
        if (R2.equals(java.math.BigInteger.ONE)) {
            java.math.BigInteger T1 = R1.multiply(S2);
            T1 = T1.add(S1);
            BigRational T = new BigRational(T1, S2);
            return T;
        }
        if (S2.equals(java.math.BigInteger.ONE)) {
            java.math.BigInteger T1 = R2.multiply(S1);
            T1 = T1.add(R1);
            BigRational T = new BigRational(T1, R2);
            return T;
        }
        D2 = R2.equals(S2) ? R2 : R2.gcd(S2);
        RB2 = R2.divide(D2);
        SB2 = S2.divide(D2);
        java.math.BigInteger J1Y = R1.multiply(SB2);
        java.math.BigInteger T1 = J1Y.add(J2Y = RB2.multiply(S1));
        if (T1.equals(java.math.BigInteger.ZERO)) {
            BigRational T = ZERO;
            return T;
        }
        if (!D2.equals(java.math.BigInteger.ONE) && !(E2 = T1.gcd(D2)).equals(java.math.BigInteger.ONE)) {
            T1 = T1.divide(E2);
            R2 = R2.divide(E2);
        }
        java.math.BigInteger T2 = R2.multiply(SB2);
        BigRational T = new BigRational(T1, T2);
        return T;
    }

    public static BigRational RNSUM(BigRational R, BigRational S) {
        if (R == null) {
            return S;
        }
        return R.sum(S);
    }

    @Override
    public BigRational parse(String s) {
        return new BigRational(s);
    }

    @Override
    public BigRational parse(Reader r) {
        return this.parse(StringUtil.nextString(r));
    }

    @Override
    public BigRational gcd(BigRational S) {
        if (S == null || S.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S;
        }
        return ONE;
    }

    public BigRational[] egcd(BigRational S) {
        BigRational[] ret = new BigRational[]{null, null, null};
        if (S == null || S.isZERO()) {
            ret[0] = this;
            return ret;
        }
        if (this.isZERO()) {
            ret[0] = S;
            return ret;
        }
        BigRational half = new BigRational(1L, 2L);
        ret[0] = ONE;
        ret[1] = this.inverse().multiply(half);
        ret[2] = S.inverse().multiply(half);
        return ret;
    }

    public void setAllIterator() {
        this.nonNegative = false;
    }

    public void setNonNegativeIterator() {
        this.nonNegative = true;
    }

    public void setNoDuplicatesIterator() {
        this.duplicates = false;
    }

    public void setDuplicatesIterator() {
        this.duplicates = true;
    }

    @Override
    public Iterator<BigRational> iterator() {
        if (this.duplicates) {
            return new BigRationalIterator(this.nonNegative);
        }
        return new BigRationalUniqueIterator(new BigRationalIterator(this.nonNegative));
    }

    public Iterator<BigRational> uniqueIterator() {
        return new BigRationalUniqueIterator(new BigRationalIterator(this.nonNegative));
    }
}

