/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.SolvableIdeal;
import edu.jas.application.SolvableResidue;
import edu.jas.gb.SolvableGroebnerBaseAbstract;
import edu.jas.gb.SolvableGroebnerBaseSeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class SolvableResidueRing<C extends GcdRingElem<C>>
implements RingFactory<SolvableResidue<C>> {
    private static final Logger logger = Logger.getLogger(SolvableResidueRing.class);
    protected final SolvableGroebnerBaseAbstract<C> bb;
    public final SolvableIdeal<C> ideal;
    public final GenSolvablePolynomialRing<C> ring;
    protected int isField = -1;

    public SolvableResidueRing(SolvableIdeal<C> i) {
        this(i, false);
    }

    public SolvableResidueRing(SolvableIdeal<C> i, boolean isMaximal) {
        this.ideal = i.GB();
        this.ring = this.ideal.getRing();
        this.bb = new SolvableGroebnerBaseSeq();
        if (isMaximal) {
            this.isField = 1;
            return;
        }
        if (this.ideal.isONE()) {
            logger.warn((Object)"ideal is one, so all residues are 0");
        }
    }

    @Override
    public boolean isFinite() {
        return this.ideal.commonZeroTest() <= 0 && this.ring.coFac.isFinite();
    }

    @Override
    public SolvableResidue<C> copy(SolvableResidue<C> c) {
        if (c == null) {
            return this.getZERO();
        }
        SolvableResidue r = new SolvableResidue(this, c.val);
        return r;
    }

    @Override
    public SolvableResidue<C> getZERO() {
        return new SolvableResidue(this, this.ring.getZERO());
    }

    @Override
    public SolvableResidue<C> getONE() {
        SolvableResidue one = new SolvableResidue(this, this.ring.getONE());
        if (one.isZERO()) {
            logger.warn((Object)"ideal is one, so all residues are 0");
        }
        return one;
    }

    @Override
    public List<SolvableResidue<C>> generators() {
        List pgens = this.ring.generators();
        ArrayList<SolvableResidue<C>> gens = new ArrayList<SolvableResidue<C>>(pgens.size());
        for (GenPolynomial p : pgens) {
            GenSolvablePolynomial s = (GenSolvablePolynomial)p;
            SolvableResidue r = new SolvableResidue(this, s);
            if (r.isZERO() || !r.isONE() && r.val.isConstant()) continue;
            gens.add(r);
        }
        return gens;
    }

    @Override
    public boolean isCommutative() {
        return this.ring.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.ring.isAssociative();
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        if (this.ideal.isMaximal()) {
            this.isField = 1;
            return true;
        }
        return false;
    }

    @Override
    public BigInteger characteristic() {
        return this.ring.characteristic();
    }

    @Override
    public SolvableResidue<C> fromInteger(BigInteger a) {
        return new SolvableResidue(this, this.ring.fromInteger(a));
    }

    @Override
    public SolvableResidue<C> fromInteger(long a) {
        return new SolvableResidue(this, this.ring.fromInteger(a));
    }

    public String toString() {
        return "SolvableResidueRing[ " + this.ideal.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "SRC(" + this.ideal.list.toScript() + ")";
    }

    public boolean equals(Object b) {
        if (!(b instanceof SolvableResidueRing)) {
            return false;
        }
        SolvableResidueRing a = null;
        try {
            a = (SolvableResidueRing)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        if (!this.ring.equals(a.ring)) {
            return false;
        }
        return this.ideal.equals(a.ideal);
    }

    public int hashCode() {
        int h = this.ideal.hashCode();
        return h;
    }

    @Override
    public SolvableResidue<C> random(int n) {
        GenPolynomial x = ((GenSolvablePolynomial)this.ring.random(n)).monic();
        return new SolvableResidue(this, x);
    }

    public SolvableResidue<C> random(int k, int l, int d, float q) {
        GenPolynomial x = ((GenSolvablePolynomial)this.ring.random(k, l, d, q)).monic();
        return new SolvableResidue(this, x);
    }

    @Override
    public SolvableResidue<C> random(int n, Random rnd) {
        GenPolynomial x = ((GenSolvablePolynomial)this.ring.random(n, rnd)).monic();
        return new SolvableResidue(this, x);
    }

    @Override
    public SolvableResidue<C> parse(String s) {
        GenPolynomial x = this.ring.parse(s);
        return new SolvableResidue(this, x);
    }

    @Override
    public SolvableResidue<C> parse(Reader r) {
        GenPolynomial x = this.ring.parse(r);
        return new SolvableResidue(this, x);
    }
}

