/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.SolvableResidueRing;
import edu.jas.kern.PrettyPrint;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.RingElem;
import java.util.ArrayList;

public class SolvableResidue<C extends GcdRingElem<C>>
implements GcdRingElem<SolvableResidue<C>> {
    public final SolvableResidueRing<C> ring;
    public final GenSolvablePolynomial<C> val;
    protected int isunit = -1;

    public SolvableResidue(SolvableResidueRing<C> r) {
        this(r, (GenSolvablePolynomial<C>)r.ring.getZERO(), 0);
    }

    public SolvableResidue(SolvableResidueRing<C> r, GenSolvablePolynomial<C> a) {
        this(r, a, -1);
    }

    public SolvableResidue(SolvableResidueRing<C> r, GenSolvablePolynomial<C> a, int u) {
        this.ring = r;
        this.val = this.ring.ideal.normalform(a);
        if (u == 0 || u == 1) {
            this.isunit = u;
            return;
        }
        if (this.val.isZERO()) {
            this.isunit = 0;
            return;
        }
        if (this.ring.isField()) {
            this.isunit = 1;
            return;
        }
        if (this.val.isUnit()) {
            this.isunit = 1;
        }
        this.isunit = -1;
    }

    @Override
    public SolvableResidueRing<C> factory() {
        return this.ring;
    }

    @Override
    public SolvableResidue<C> copy() {
        return new SolvableResidue<C>(this.ring, this.val, this.isunit);
    }

    @Override
    public boolean isZERO() {
        return this.val.isZERO();
    }

    @Override
    public boolean isONE() {
        return this.val.isONE();
    }

    @Override
    public boolean isUnit() {
        if (this.isunit > 0) {
            return true;
        }
        if (this.isunit == 0) {
            return false;
        }
        boolean u = this.ring.ideal.isUnit(this.val);
        this.isunit = u ? 1 : 0;
        return this.isunit > 0;
    }

    public boolean isConstant() {
        return this.val.isConstant();
    }

    public String toString() {
        if (PrettyPrint.isTrue()) {
            return this.val.toString(this.ring.ring.getVars());
        }
        return "SolvableResidue[ " + this.val.toString() + " mod " + this.ring.toString() + " ]";
    }

    @Override
    public String toScript() {
        return this.val.toScript();
    }

    @Override
    public String toScriptFactory() {
        return ((SolvableResidueRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(SolvableResidue<C> b) {
        GenSolvablePolynomial<C> v = b.val;
        if (!this.ring.equals(b.ring)) {
            v = this.ring.ideal.normalform(v);
        }
        return this.val.compareTo(v);
    }

    @Override
    public boolean equals(Object b) {
        if (!(b instanceof SolvableResidue)) {
            return false;
        }
        SolvableResidue a = null;
        try {
            a = (SolvableResidue)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        return this.compareTo(a) == 0;
    }

    @Override
    public int hashCode() {
        int h = this.ring.hashCode();
        h = 37 * h + this.val.hashCode();
        return h;
    }

    @Override
    public SolvableResidue<C> abs() {
        return new SolvableResidue<C>(this.ring, (GenSolvablePolynomial)this.val.abs(), this.isunit);
    }

    @Override
    public SolvableResidue<C> sum(SolvableResidue<C> S) {
        return new SolvableResidue<C>(this.ring, (GenSolvablePolynomial)this.val.sum(S.val));
    }

    @Override
    public SolvableResidue<C> negate() {
        return new SolvableResidue<C>(this.ring, (GenSolvablePolynomial)this.val.negate(), this.isunit);
    }

    @Override
    public int signum() {
        return this.val.signum();
    }

    @Override
    public SolvableResidue<C> subtract(SolvableResidue<C> S) {
        return new SolvableResidue<C>(this.ring, (GenSolvablePolynomial)this.val.subtract(S.val));
    }

    @Override
    public SolvableResidue<C> divide(SolvableResidue<C> S) {
        if (this.ring.isField()) {
            return this.multiply((C)S.inverse());
        }
        try {
            return this.multiply((C)S.inverse());
        }
        catch (NotInvertibleException ignored) {
            System.out.println("catch: " + ignored);
            ArrayList Q = new ArrayList(1);
            Q.add(this.ring.ring.getZERO());
            ArrayList V = new ArrayList(1);
            V.add(S.val);
            GenSolvablePolynomial x = this.ring.bb.sred.leftNormalform(Q, V, this.val);
            GenSolvablePolynomial y = (GenSolvablePolynomial)Q.get(0);
            System.out.println("SolvableResidue val = " + this.val + ", div = " + S.val + ", quotient = " + y + ", remainder = " + x);
            return new SolvableResidue<C>(this.ring, y);
        }
    }

    @Override
    public SolvableResidue<C> inverse() {
        GenSolvablePolynomial<GenSolvablePolynomial<C>> x = this.ring.ideal.inverse(this.val);
        SolvableResidue<SolvableResidue> xp = new SolvableResidue<SolvableResidue>(this.ring, x, 1);
        if (xp.isZERO()) {
            throw new NotInvertibleException("(" + x + ") * (" + this.val + ") = " + x.multiply(this.val) + " = 0 mod " + this.ring.ideal);
        }
        if (!xp.multiply(this).isONE()) {
            throw new NotInvertibleException("(" + x + ") * (" + this.val + ") = " + x.multiply(this.val) + " != 1 mod " + this.ring.ideal);
        }
        return xp;
    }

    @Override
    public SolvableResidue<C> remainder(SolvableResidue<C> S) {
        ArrayList V = new ArrayList(1);
        V.add(S.val);
        GenSolvablePolynomial x = this.ring.bb.sred.leftNormalform(V, this.val);
        return new SolvableResidue<C>(this.ring, x);
    }

    @Override
    public SolvableResidue<C> multiply(SolvableResidue<C> S) {
        GenSolvablePolynomial<GenSolvablePolynomial<C>> x = this.val.multiply(S.val);
        int i = -1;
        if (this.isunit == 1 && S.isunit == 1) {
            i = 1;
        } else if (this.isunit == 0 || S.isunit == 0) {
            i = 0;
        }
        return new SolvableResidue<GenSolvablePolynomial<C>>(this.ring, x, i);
    }

    @Override
    public SolvableResidue<C> multiply(GenSolvablePolynomial<C> S) {
        GenSolvablePolynomial<GenSolvablePolynomial<C>> x = this.val.multiply(S);
        int i = -1;
        if (this.isunit == 1 && S.isUnit()) {
            i = 1;
        } else if (this.isunit == 0 || !S.isUnit()) {
            i = 0;
        }
        return new SolvableResidue<GenSolvablePolynomial<C>>(this.ring, x, i);
    }

    @Override
    public SolvableResidue<C> multiply(C s) {
        GenPolynomial x = this.val.multiply((RingElem)s);
        int i = -1;
        if (this.isunit == 1 && s.isUnit()) {
            i = 1;
        } else if (this.isunit == 0 || !s.isUnit()) {
            i = 0;
        }
        return new SolvableResidue<C>(this.ring, x, i);
    }

    @Override
    public SolvableResidue<C> multiply(ExpVector e) {
        GenPolynomial x = this.val.multiply(e);
        int i = -1;
        if (this.isunit == 1 && e.isZERO()) {
            i = 1;
        } else if (this.isunit == 0 || !e.isZERO()) {
            i = 0;
        }
        return new SolvableResidue<C>(this.ring, x, i);
    }

    public SolvableResidue<C> monic() {
        return new SolvableResidue<C>(this.ring, this.val.monic(), this.isunit);
    }

    @Override
    public SolvableResidue<C> gcd(SolvableResidue<C> b) {
        throw new UnsupportedOperationException("gcd not implemented");
    }

    public SolvableResidue<C>[] egcd(SolvableResidue<C> b) {
        throw new UnsupportedOperationException("egcd not implemented");
    }
}

