/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigQuaternion;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLongRing;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.QuotientRing;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.apache.log4j.Logger;

public class RingFactoryTokenizer {
    private static final Logger logger = Logger.getLogger(RingFactoryTokenizer.class);
    private final boolean debug = logger.isDebugEnabled();
    private String[] vars = null;
    private int nvars = 1;
    private TermOrder tord;
    private RelationTable table;
    private final StreamTokenizer tok;
    private final Reader reader;
    private RingFactory fac;
    private coeffType parsedCoeff = coeffType.BigRat;
    private GenPolynomialRing pfac;
    private polyType parsedPoly = polyType.PolBigRat;
    private GenSolvablePolynomialRing spfac;

    public RingFactoryTokenizer() {
        this(new BufferedReader(new InputStreamReader(System.in, Charset.forName("UTF8"))));
    }

    public RingFactoryTokenizer(GenPolynomialRing rf, Reader r) {
        this(r);
        if (rf == null) {
            return;
        }
        if (rf instanceof GenSolvablePolynomialRing) {
            this.pfac = rf;
            this.spfac = (GenSolvablePolynomialRing)rf;
        } else {
            this.pfac = rf;
            this.spfac = null;
        }
        this.fac = rf.coFac;
        this.vars = rf.getVars();
        if (this.vars != null) {
            this.nvars = this.vars.length;
        }
        this.tord = rf.tord;
        this.table = this.spfac != null ? this.spfac.table : null;
    }

    public RingFactoryTokenizer(Reader r) {
        this.tord = new TermOrder();
        this.fac = new BigRational(1L);
        this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
        this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
        this.reader = r;
        this.tok = new StreamTokenizer(r);
        this.tok.resetSyntax();
        this.tok.eolIsSignificant(false);
        this.tok.wordChars(48, 57);
        this.tok.wordChars(97, 122);
        this.tok.wordChars(65, 90);
        this.tok.wordChars(95, 95);
        this.tok.wordChars(47, 47);
        this.tok.wordChars(160, 255);
        this.tok.whitespaceChars(0, 32);
        this.tok.commentChar(35);
        this.tok.quoteChar(34);
        this.tok.quoteChar(39);
    }

    public void initFactory(RingFactory rf, coeffType ct) {
        this.fac = rf;
        this.parsedCoeff = ct;
        switch (ct) {
            case BigRat: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigRat;
                break;
            }
            case BigInt: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigInt;
                break;
            }
            case ModInt: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolModInt;
                break;
            }
            case BigC: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigC;
                break;
            }
            case BigQ: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigQ;
                break;
            }
            case BigD: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigD;
                break;
            }
            case RatFunc: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolRatFunc;
                break;
            }
            case ModFunc: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolModFunc;
                break;
            }
            case IntFunc: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolIntFunc;
                break;
            }
            default: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigRat;
            }
        }
    }

    public void initSolvableFactory(RingFactory rf, coeffType ct) {
        this.fac = rf;
        this.parsedCoeff = ct;
        switch (ct) {
            case BigRat: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigRat;
                break;
            }
            case BigInt: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigInt;
                break;
            }
            case ModInt: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolModInt;
                break;
            }
            case BigC: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigC;
                break;
            }
            case BigQ: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigQ;
                break;
            }
            case BigD: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigD;
                break;
            }
            case RatFunc: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolRatFunc;
                break;
            }
            case ModFunc: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolModFunc;
                break;
            }
            case IntFunc: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolIntFunc;
                break;
            }
            default: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigRat;
            }
        }
    }

    public String nextComment() throws IOException {
        StringBuffer c = new StringBuffer();
        if (this.debug) {
            logger.debug((Object)("comment: " + this.tok));
        }
        int tt = this.tok.nextToken();
        if (this.debug) {
            logger.debug((Object)("comment: " + this.tok));
        }
        if (tt == 40) {
            tt = this.tok.nextToken();
            if (this.debug) {
                logger.debug((Object)("comment: " + this.tok));
            }
            if (tt == 42) {
                if (this.debug) {
                    logger.debug((Object)"comment: ");
                }
                while (true) {
                    if ((tt = this.tok.nextToken()) == 42) {
                        tt = this.tok.nextToken();
                        if (tt == 41) {
                            return c.toString();
                        }
                        this.tok.pushBack();
                    }
                    c.append(this.tok.sval);
                }
            }
            this.tok.pushBack();
            if (this.debug) {
                logger.debug((Object)("comment: " + this.tok));
            }
        }
        this.tok.pushBack();
        if (this.debug) {
            logger.debug((Object)("comment: " + this.tok));
        }
        return c.toString();
    }

    public String[] nextVariableList() throws IOException {
        ArrayList<String> l = new ArrayList<String>();
        int tt = this.tok.nextToken();
        if (tt == 40 || tt == 123) {
            logger.debug((Object)"variable list");
            tt = this.tok.nextToken();
            while (tt != -1 && tt != 41 && tt != 125) {
                if (tt == -3) {
                    l.add(this.tok.sval);
                }
                tt = this.tok.nextToken();
            }
        } else {
            this.tok.pushBack();
        }
        Object[] ol = l.toArray();
        String[] v = new String[ol.length];
        for (int i = 0; i < v.length; ++i) {
            v[i] = (String)ol[i];
        }
        return v;
    }

    public RingFactory nextCoefficientRing() throws IOException {
        RingFactory<BigRational> coeff = null;
        coeffType ct = null;
        int tt = this.tok.nextToken();
        if (this.tok.sval != null) {
            if (this.tok.sval.equalsIgnoreCase("Q")) {
                coeff = new BigRational(0L);
                ct = coeffType.BigRat;
            } else if (this.tok.sval.equalsIgnoreCase("Rat")) {
                coeff = new BigRational(0L);
                ct = coeffType.BigRat;
            } else if (this.tok.sval.equalsIgnoreCase("D")) {
                coeff = new BigDecimal(0L);
                ct = coeffType.BigD;
            } else if (this.tok.sval.equalsIgnoreCase("Z")) {
                coeff = new BigInteger(0L);
                ct = coeffType.BigInt;
            } else if (this.tok.sval.equalsIgnoreCase("Int")) {
                coeff = new BigInteger(0L);
                ct = coeffType.BigInt;
            } else if (this.tok.sval.equalsIgnoreCase("C")) {
                coeff = new BigComplex(0L);
                ct = coeffType.BigC;
            } else if (this.tok.sval.equalsIgnoreCase("Complex")) {
                coeff = new BigComplex(0L);
                ct = coeffType.BigC;
            } else if (this.tok.sval.equalsIgnoreCase("Quat")) {
                coeff = new BigQuaternion(0L);
                ct = coeffType.BigQ;
            } else if (this.tok.sval.equalsIgnoreCase("Mod")) {
                tt = this.tok.nextToken();
                boolean openb = false;
                if (tt == 91) {
                    openb = true;
                    tt = this.tok.nextToken();
                }
                if (this.tok.sval != null && this.tok.sval.length() > 0) {
                    if (this.digit(this.tok.sval.charAt(0))) {
                        BigInteger mo = new BigInteger(this.tok.sval);
                        BigInteger lm = new BigInteger(ModLongRing.MAX_LONG);
                        coeff = mo.compareTo(lm) < 0 ? new ModLongRing(mo.getVal()) : new ModIntegerRing(mo.getVal());
                        System.out.println("coeff = " + coeff + " :: " + coeff.getClass());
                        ct = coeffType.ModInt;
                    } else {
                        this.tok.pushBack();
                    }
                } else {
                    this.tok.pushBack();
                }
                if (tt == 93 && openb) {
                    tt = this.tok.nextToken();
                }
            } else if (this.tok.sval.equalsIgnoreCase("RatFunc")) {
                String[] rfv = this.nextVariableList();
                int vr = rfv.length;
                BigInteger bi = new BigInteger();
                TermOrder to = new TermOrder(2);
                GenPolynomialRing<BigInteger> pcf = new GenPolynomialRing<BigInteger>(bi, vr, to, rfv);
                coeff = new QuotientRing<BigInteger>(pcf);
                ct = coeffType.RatFunc;
            } else if (this.tok.sval.equalsIgnoreCase("ModFunc")) {
                tt = this.tok.nextToken();
                ModIntegerRing mi = new ModIntegerRing("19");
                if (this.tok.sval != null && this.tok.sval.length() > 0) {
                    if (this.digit(this.tok.sval.charAt(0))) {
                        mi = new ModIntegerRing(this.tok.sval);
                    } else {
                        this.tok.pushBack();
                    }
                } else {
                    this.tok.pushBack();
                }
                String[] rfv = this.nextVariableList();
                int vr = rfv.length;
                TermOrder to = new TermOrder(2);
                GenPolynomialRing<ModInteger> pcf = new GenPolynomialRing<ModInteger>(mi, vr, to, rfv);
                coeff = new QuotientRing<ModInteger>(pcf);
                ct = coeffType.ModFunc;
            } else if (this.tok.sval.equalsIgnoreCase("IntFunc")) {
                String[] rfv = this.nextVariableList();
                int vr = rfv.length;
                BigRational bi = new BigRational();
                TermOrder to = new TermOrder(2);
                GenPolynomialRing<BigRational> pcf = new GenPolynomialRing<BigRational>(bi, vr, to, rfv);
                coeff = pcf;
                ct = coeffType.IntFunc;
            } else if (this.tok.sval.equalsIgnoreCase("AN")) {
                tt = this.tok.nextToken();
                if (tt == 91) {
                    tt = this.tok.nextToken();
                    Iterable<ModInteger> tcfac = new ModIntegerRing("19");
                    if (this.tok.sval != null && this.tok.sval.length() > 0) {
                        if (this.digit(this.tok.sval.charAt(0))) {
                            tcfac = new ModIntegerRing(this.tok.sval);
                        } else {
                            tcfac = new BigRational();
                            this.tok.pushBack();
                        }
                    } else {
                        tcfac = new BigRational();
                        this.tok.pushBack();
                    }
                    String[] anv = this.nextVariableList();
                    int vs = anv.length;
                    if (vs != 1) {
                        logger.error((Object)"AlgebraicNumber only for univariate polynomials");
                    }
                    String[] ovars = this.vars;
                    this.vars = anv;
                    GenPolynomialRing tpfac = this.pfac;
                    RingFactory tfac = this.fac;
                    this.fac = tcfac;
                    this.pfac = tcfac instanceof ModIntegerRing ? new GenPolynomialRing<ModInteger>((RingFactory<ModInteger>)((Object)tcfac), vs, new TermOrder(), anv) : new GenPolynomialRing<ModInteger>((RingFactory<ModInteger>)((Object)tcfac), vs, new TermOrder(), anv);
                    if (this.debug) {
                        logger.debug((Object)("pfac = " + this.pfac));
                    }
                    GenPolynomialTokenizer ptok = new GenPolynomialTokenizer(this.pfac, this.reader);
                    GenPolynomial mod = ptok.nextPolynomial();
                    ptok = null;
                    if (this.debug) {
                        logger.debug((Object)("mod = " + mod));
                    }
                    this.pfac = tpfac;
                    this.fac = tfac;
                    this.vars = ovars;
                    if (tcfac instanceof ModIntegerRing) {
                        GenPolynomial gfmod = mod;
                        coeff = new AlgebraicNumberRing(gfmod);
                        ct = coeffType.ANmod;
                    } else {
                        GenPolynomial anmod = mod;
                        coeff = new AlgebraicNumberRing(anmod);
                        ct = coeffType.ANrat;
                    }
                    if (this.debug) {
                        logger.debug((Object)("coeff = " + coeff));
                    }
                    if ((tt = this.tok.nextToken()) != 93) {
                        this.tok.pushBack();
                    }
                } else {
                    this.tok.pushBack();
                }
            }
        }
        if (coeff == null) {
            this.tok.pushBack();
            coeff = new BigRational();
            ct = coeffType.BigRat;
        }
        this.parsedCoeff = ct;
        return coeff;
    }

    public long[] nextWeightList() throws IOException {
        ArrayList<Long> l = new ArrayList<Long>();
        long[] w = null;
        int tt = this.tok.nextToken();
        if (tt == 40) {
            logger.debug((Object)"weight list");
            tt = this.tok.nextToken();
            while (tt != -1 && tt != 41) {
                char first;
                if (this.tok.sval != null && this.digit(first = this.tok.sval.charAt(0))) {
                    long e = Long.parseLong(this.tok.sval);
                    l.add(e);
                }
                tt = this.tok.nextToken();
            }
        } else {
            this.tok.pushBack();
        }
        Object[] ol = l.toArray();
        w = new long[ol.length];
        for (int i = 0; i < w.length; ++i) {
            w[i] = (Long)ol[ol.length - i - 1];
        }
        return w;
    }

    public long[][] nextWeightArray() throws IOException {
        ArrayList<long[]> l = new ArrayList<long[]>();
        int tt = this.tok.nextToken();
        if (tt == 40) {
            logger.debug((Object)"weight array");
            tt = this.tok.nextToken();
            while (tt != -1 && tt != 41) {
                char first;
                long[] e;
                if (tt == 40) {
                    this.tok.pushBack();
                    e = this.nextWeightList();
                    l.add(e);
                } else if (this.tok.sval != null && this.digit(first = this.tok.sval.charAt(0))) {
                    this.tok.pushBack();
                    this.tok.pushBack();
                    e = this.nextWeightList();
                    l.add(e);
                    break;
                }
                tt = this.tok.nextToken();
            }
        } else {
            this.tok.pushBack();
        }
        Object[] ol = l.toArray();
        long[][] w = new long[ol.length][];
        for (int i = 0; i < w.length; ++i) {
            w[i] = (long[])ol[i];
        }
        return w;
    }

    public int nextSplitIndex() throws IOException {
        int e = -1;
        int e0 = -1;
        int tt = this.tok.nextToken();
        if (tt == 124) {
            if (this.debug) {
                logger.debug((Object)"split index");
            }
            if ((tt = this.tok.nextToken()) == -1) {
                return e;
            }
            if (this.tok.sval != null) {
                char first = this.tok.sval.charAt(0);
                if (this.digit(first)) {
                    e = Integer.parseInt(this.tok.sval);
                }
                if ((tt = this.tok.nextToken()) != 124) {
                    this.tok.pushBack();
                }
            }
        } else if (tt == 91) {
            if (this.debug) {
                logger.debug((Object)"split index");
            }
            if ((tt = this.tok.nextToken()) == -1) {
                return e;
            }
            if (this.tok.sval != null) {
                char first = this.tok.sval.charAt(0);
                if (this.digit(first)) {
                    e0 = Integer.parseInt(this.tok.sval);
                }
                if ((tt = this.tok.nextToken()) == 44) {
                    tt = this.tok.nextToken();
                    if (tt == -1) {
                        return e0;
                    }
                    if (this.tok.sval != null && this.digit(first = this.tok.sval.charAt(0))) {
                        e = Integer.parseInt(this.tok.sval);
                    }
                    if (tt != 93) {
                        this.tok.pushBack();
                    }
                }
            }
        } else {
            this.tok.pushBack();
        }
        return e;
    }

    public TermOrder nextTermOrder() throws IOException {
        int s;
        int evord = 4;
        int tt = this.tok.nextToken();
        if (tt != -1) {
            if (tt == -3) {
                if (this.tok.sval != null) {
                    if (this.tok.sval.equalsIgnoreCase("L")) {
                        evord = 2;
                    } else if (this.tok.sval.equalsIgnoreCase("IL")) {
                        evord = 2;
                    } else if (this.tok.sval.equalsIgnoreCase("INVLEX")) {
                        evord = 2;
                    } else if (this.tok.sval.equalsIgnoreCase("LEX")) {
                        evord = 1;
                    } else if (this.tok.sval.equalsIgnoreCase("G")) {
                        evord = 4;
                    } else if (this.tok.sval.equalsIgnoreCase("IG")) {
                        evord = 4;
                    } else if (this.tok.sval.equalsIgnoreCase("IGRLEX")) {
                        evord = 4;
                    } else if (this.tok.sval.equalsIgnoreCase("GRLEX")) {
                        evord = 3;
                    } else if (this.tok.sval.equalsIgnoreCase("W")) {
                        long[][] w = this.nextWeightArray();
                        return new TermOrder(w);
                    }
                }
            } else {
                this.tok.pushBack();
            }
        }
        if ((s = this.nextSplitIndex()) <= 0) {
            return new TermOrder(evord);
        }
        return new TermOrder(evord, evord, this.nvars, s);
    }

    public void nextRelationTable() throws IOException {
        if (this.spfac == null) {
            return;
        }
        RelationTable table = this.spfac.table;
        List<GenPolynomial> rels = null;
        int tt = this.tok.nextToken();
        if (this.debug) {
            logger.debug((Object)("start relation table: " + tt));
        }
        if (this.tok.sval != null && this.tok.sval.equalsIgnoreCase("RelationTable")) {
            GenPolynomialTokenizer ptok = new GenPolynomialTokenizer(this.pfac, this.reader);
            rels = ptok.nextPolynomialList();
            ptok = null;
        }
        if (rels == null) {
            this.tok.pushBack();
            return;
        }
        Iterator it = rels.iterator();
        while (it.hasNext()) {
            GenPolynomial p = (GenPolynomial)it.next();
            ExpVector e = p.leadingExpVector();
            if (!it.hasNext()) continue;
            p = (GenPolynomial)it.next();
            ExpVector f = p.leadingExpVector();
            if (!it.hasNext()) continue;
            p = (GenPolynomial)it.next();
            GenSolvablePolynomial sp = new GenSolvablePolynomial(this.spfac);
            sp.doPutToMap(p.getMap());
            table.update(e, f, sp);
        }
        if (this.debug) {
            logger.info((Object)("table = " + table));
        }
    }

    public GenPolynomialRing nextPolynomialRing() throws IOException {
        RingFactory coeff = this.nextCoefficientRing();
        logger.info((Object)("coeff = " + coeff));
        this.vars = this.nextVariableList();
        logger.info((Object)("vars = " + Arrays.toString(this.vars)));
        if (this.vars != null) {
            this.nvars = this.vars.length;
        }
        this.tord = this.nextTermOrder();
        logger.info((Object)("tord = " + this.tord));
        this.initFactory(coeff, this.parsedCoeff);
        return this.pfac;
    }

    public GenSolvablePolynomialRing nextSolvablePolynomialRing() throws IOException {
        RingFactory coeff = this.nextCoefficientRing();
        logger.info((Object)("coeff = " + coeff));
        this.vars = this.nextVariableList();
        logger.info((Object)("vars = " + Arrays.toString(this.vars)));
        if (this.vars != null) {
            this.nvars = this.vars.length;
        }
        this.tord = this.nextTermOrder();
        logger.info((Object)("tord = " + this.tord));
        this.initFactory(coeff, this.parsedCoeff);
        this.initSolvableFactory(coeff, this.parsedCoeff);
        this.nextRelationTable();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("table = " + this.table + ", tok = " + this.tok));
        }
        return this.spfac;
    }

    private boolean digit(char x) {
        return '0' <= x && x <= '9';
    }

    public void nextComma() throws IOException {
        if (this.tok.ttype == 44) {
            int tt = this.tok.nextToken();
            if (this.debug) {
                logger.debug((Object)("after comma: " + tt));
            }
        }
    }

    public static String[] variableList(String s) {
        String[] vl = null;
        if (s == null) {
            return vl;
        }
        String st = s.trim();
        if (st.length() == 0) {
            return new String[0];
        }
        if (st.charAt(0) == '(') {
            st = st.substring(1);
        }
        if (st.charAt(st.length() - 1) == ')') {
            st = st.substring(0, st.length() - 1);
        }
        st = st.replaceAll(",", " ");
        ArrayList<String> sl = new ArrayList<String>();
        Scanner sc = new Scanner(st);
        while (sc.hasNext()) {
            String sn = sc.next();
            sl.add(sn);
        }
        sc.close();
        vl = new String[sl.size()];
        int i = 0;
        Iterator i$ = sl.iterator();
        while (i$.hasNext()) {
            String si;
            vl[i] = si = (String)i$.next();
            ++i;
        }
        return vl;
    }

    private static enum polyType {
        PolBigRat,
        PolBigInt,
        PolModInt,
        PolBigC,
        PolBigD,
        PolBigQ,
        PolANrat,
        PolANmod,
        PolRatFunc,
        PolModFunc,
        PolIntFunc;

    }

    private static enum coeffType {
        BigRat,
        BigInt,
        ModInt,
        BigC,
        BigQ,
        BigD,
        ANrat,
        ANmod,
        RatFunc,
        ModFunc,
        IntFunc;

    }
}

