/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Ideal;
import edu.jas.application.Residue;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisor;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class ResidueRing<C extends GcdRingElem<C>>
implements RingFactory<Residue<C>> {
    private static final Logger logger = Logger.getLogger(ResidueRing.class);
    protected final GreatestCommonDivisor<C> engine;
    public final Ideal<C> ideal;
    public final GenPolynomialRing<C> ring;
    protected int isField = -1;

    public ResidueRing(Ideal<C> i) {
        this(i, false);
    }

    public ResidueRing(Ideal<C> i, boolean isMaximal) {
        this.ideal = i.GB();
        this.ring = this.ideal.list.ring;
        this.engine = GCDFactory.getProxy(this.ring.coFac);
        if (isMaximal) {
            this.isField = 1;
            return;
        }
        if (this.ideal.isONE()) {
            logger.warn((Object)"ideal is one, so all residues are 0");
        }
    }

    @Override
    public boolean isFinite() {
        return this.ideal.commonZeroTest() <= 0 && this.ring.coFac.isFinite();
    }

    @Override
    public Residue<C> copy(Residue<C> c) {
        if (c == null) {
            return this.getZERO();
        }
        Residue r = new Residue(this, c.val);
        return r;
    }

    @Override
    public Residue<C> getZERO() {
        return new Residue(this, this.ring.getZERO());
    }

    @Override
    public Residue<C> getONE() {
        Residue one = new Residue(this, this.ring.getONE());
        if (one.isZERO()) {
            logger.warn((Object)"ideal is one, so all residues are 0");
        }
        return one;
    }

    @Override
    public List<Residue<C>> generators() {
        List<GenPolynomial<C>> pgens = this.ring.generators();
        ArrayList<Residue<C>> gens = new ArrayList<Residue<C>>(pgens.size());
        for (GenPolynomial<C> p : pgens) {
            Residue<C> r = new Residue<C>(this, p);
            if (r.isZERO() || !r.isONE() && r.val.isConstant()) continue;
            gens.add(r);
        }
        return gens;
    }

    @Override
    public boolean isCommutative() {
        return this.ring.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.ring.isAssociative();
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        if (this.ideal.isMaximal()) {
            this.isField = 1;
            return true;
        }
        return false;
    }

    @Override
    public BigInteger characteristic() {
        return this.ring.characteristic();
    }

    @Override
    public Residue<C> fromInteger(BigInteger a) {
        return new Residue(this, this.ring.fromInteger(a));
    }

    @Override
    public Residue<C> fromInteger(long a) {
        return new Residue(this, this.ring.fromInteger(a));
    }

    public String toString() {
        return "ResidueRing[ " + this.ideal.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "RC(" + this.ideal.list.toScript() + ")";
    }

    public boolean equals(Object b) {
        if (!(b instanceof ResidueRing)) {
            return false;
        }
        ResidueRing a = null;
        try {
            a = (ResidueRing)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        if (!this.ring.equals(a.ring)) {
            return false;
        }
        return this.ideal.equals(a.ideal);
    }

    public int hashCode() {
        int h = this.ideal.hashCode();
        return h;
    }

    @Override
    public Residue<C> random(int n) {
        GenPolynomial x = ((GenPolynomial)this.ring.random(n)).monic();
        return new Residue(this, x);
    }

    public Residue<C> random(int k, int l, int d, float q) {
        GenPolynomial<C> x = this.ring.random(k, l, d, q).monic();
        return new Residue<C>(this, x);
    }

    @Override
    public Residue<C> random(int n, Random rnd) {
        GenPolynomial x = ((GenPolynomial)this.ring.random(n, rnd)).monic();
        return new Residue(this, x);
    }

    @Override
    public Residue<C> parse(String s) {
        Element x = this.ring.parse(s);
        return new Residue(this, x);
    }

    @Override
    public Residue<C> parse(Reader r) {
        Element x = this.ring.parse(r);
        return new Residue(this, x);
    }
}

