/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Ideal;
import edu.jas.application.IdealWithUniv;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.Rational;
import edu.jas.poly.GenPolynomial;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.structure.GcdRingElem;
import java.util.ArrayList;
import java.util.List;

public class IdealWithRealAlgebraicRoots<D extends GcdRingElem<D> & Rational>
extends IdealWithUniv<D> {
    public final List<List<RealAlgebraicNumber<D>>> ran;
    protected List<List<BigDecimal>> droots = null;

    protected IdealWithRealAlgebraicRoots() {
        throw new IllegalArgumentException("do not use this constructor");
    }

    public IdealWithRealAlgebraicRoots(Ideal<D> id, List<GenPolynomial<D>> up, List<List<RealAlgebraicNumber<D>>> rr) {
        super(id, up);
        this.ran = rr;
    }

    public IdealWithRealAlgebraicRoots(IdealWithUniv<D> iu, List<List<RealAlgebraicNumber<D>>> rr) {
        super(iu.ideal, iu.upolys);
        this.ran = rr;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString() + "\nreal roots:\n");
        sb.append("[");
        boolean f1 = true;
        for (List<RealAlgebraicNumber<D>> list : this.ran) {
            if (!f1) {
                sb.append(", ");
            } else {
                f1 = false;
            }
            sb.append("[");
            boolean f2 = true;
            for (RealAlgebraicNumber<D> rr : list) {
                if (!f2) {
                    sb.append(", ");
                } else {
                    f2 = false;
                }
                sb.append(rr.ring.toScript());
            }
            sb.append("]");
        }
        sb.append("]");
        if (this.droots != null) {
            sb.append("\ndecimal real root approximation:\n");
            for (List<GcdRingElem<RealAlgebraicNumber<Object>>> list : this.droots) {
                sb.append(list.toString());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public String toScript() {
        return super.toScript() + ",  " + this.ran.toString();
    }

    public synchronized List<List<BigDecimal>> decimalApproximation() {
        if (this.droots != null) {
            return this.droots;
        }
        ArrayList<List<BigDecimal>> rroots = new ArrayList<List<BigDecimal>>();
        for (List<RealAlgebraicNumber<D>> rri : this.ran) {
            ArrayList<BigDecimal> r = new ArrayList<BigDecimal>();
            for (RealAlgebraicNumber<D> rr : rri) {
                BigDecimal d = new BigDecimal(rr.magnitude());
                r.add(d);
            }
            rroots.add(r);
        }
        this.droots = rroots;
        return rroots;
    }

    public void doDecimalApproximation() {
        List<List<BigDecimal>> unused = this.decimalApproximation();
        if (unused.isEmpty()) {
            System.out.println("unused is empty");
        }
    }
}

