/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Dimension;
import edu.jas.application.FactorFactory;
import edu.jas.application.IdealWithUniv;
import edu.jas.application.PrimaryComponent;
import edu.jas.gb.ExtendedGB;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.Reduction;
import edu.jas.gbmod.SyzygyAbstract;
import edu.jas.gbufd.GBFactory;
import edu.jas.gbufd.GroebnerBasePartial;
import edu.jas.gbufd.PolyGBUtil;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.OptimizedPolynomialList;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import edu.jas.poly.TermOrderOptimization;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.Power;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.PolyUfdUtil;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public class Ideal<C extends GcdRingElem<C>>
implements Comparable<Ideal<C>>,
Serializable {
    private static final Logger logger = Logger.getLogger(Ideal.class);
    private final boolean debug = logger.isDebugEnabled();
    protected PolynomialList<C> list;
    protected boolean isGB;
    protected boolean testGB;
    protected boolean isTopt;
    protected final GroebnerBaseAbstract<C> bb;
    protected final Reduction<C> red;
    protected final SquarefreeAbstract<C> engine;

    public Ideal(GenPolynomialRing<C> ring) {
        this(ring, new ArrayList<GenPolynomial<C>>());
    }

    public Ideal(GenPolynomialRing<C> ring, List<GenPolynomial<C>> F2) {
        this(new PolynomialList<C>(ring, F2));
    }

    public Ideal(GenPolynomialRing<C> ring, List<GenPolynomial<C>> F2, boolean gb) {
        this(new PolynomialList<C>(ring, F2), gb);
    }

    public Ideal(GenPolynomialRing<C> ring, List<GenPolynomial<C>> F2, boolean gb, boolean topt) {
        this(new PolynomialList<C>(ring, F2), gb, topt);
    }

    public Ideal(PolynomialList<C> list) {
        this(list, false);
    }

    public Ideal(PolynomialList<C> list, GroebnerBaseAbstract<C> bb, Reduction<C> red) {
        this(list, false, bb, red);
    }

    public Ideal(PolynomialList<C> list, boolean gb) {
        this(list, gb, GBFactory.getImplementation(list.ring.coFac));
    }

    public Ideal(PolynomialList<C> list, boolean gb, boolean topt) {
        this(list, gb, topt, GBFactory.getImplementation(list.ring.coFac));
    }

    public Ideal(PolynomialList<C> list, boolean gb, GroebnerBaseAbstract<C> bb, Reduction<C> red) {
        this(list, gb, false, bb, red);
    }

    public Ideal(PolynomialList<C> list, boolean gb, GroebnerBaseAbstract<C> bb) {
        this(list, gb, false, bb, bb.red);
    }

    public Ideal(PolynomialList<C> list, boolean gb, boolean topt, GroebnerBaseAbstract<C> bb) {
        this(list, gb, topt, bb, bb.red);
    }

    public Ideal(PolynomialList<C> list, boolean gb, boolean topt, GroebnerBaseAbstract<C> bb, Reduction<C> red) {
        if (list == null || list.list == null) {
            throw new IllegalArgumentException("list and list.list may not be null");
        }
        this.list = list;
        this.isGB = gb;
        this.isTopt = topt;
        this.testGB = gb;
        this.bb = bb;
        this.red = red;
        this.engine = SquarefreeFactory.getImplementation(list.ring.coFac);
    }

    public Ideal<C> copy() {
        return new Ideal<C>(this.list.copy(), this.isGB, this.isTopt, this.bb, this.red);
    }

    public List<GenPolynomial<C>> getList() {
        return this.list.list;
    }

    public GenPolynomialRing<C> getRing() {
        return this.list.ring;
    }

    public Ideal<C> getZERO() {
        ArrayList z = new ArrayList(0);
        PolynomialList<C> pl = new PolynomialList<C>(this.getRing(), z);
        return new Ideal<C>(pl, true, this.isTopt, this.bb, this.red);
    }

    public Ideal<C> getONE() {
        ArrayList one = new ArrayList(1);
        one.add(this.list.ring.getONE());
        PolynomialList<C> pl = new PolynomialList<C>(this.getRing(), one);
        return new Ideal<C>(pl, true, this.isTopt, this.bb, this.red);
    }

    public String toString() {
        return this.list.toString();
    }

    public String toScript() {
        return this.list.toScript();
    }

    public boolean equals(Object b) {
        if (!(b instanceof Ideal)) {
            logger.warn((Object)"equals no Ideal");
            return false;
        }
        Ideal B = null;
        try {
            B = (Ideal)b;
        }
        catch (ClassCastException ignored) {
            return false;
        }
        return this.contains(B) && B.contains(this);
    }

    @Override
    public int compareTo(Ideal<C> L) {
        return this.list.compareTo(L.list);
    }

    public int hashCode() {
        int h = this.list.hashCode();
        if (this.isGB) {
            h <<= 1;
        }
        if (this.testGB) {
            ++h;
        }
        return h;
    }

    public boolean isZERO() {
        return this.list.isZERO();
    }

    public boolean isONE() {
        return this.list.isONE();
    }

    public void doToptimize() {
        if (this.isTopt) {
            return;
        }
        this.list = TermOrderOptimization.optimizeTermOrder(this.list);
        this.isTopt = true;
        if (this.isGB) {
            this.isGB = false;
            this.doGB();
        }
    }

    public boolean isGB() {
        if (this.testGB) {
            return this.isGB;
        }
        logger.warn((Object)"isGB computing");
        this.isGB = this.bb.isGB(this.getList());
        this.testGB = true;
        return this.isGB;
    }

    public void doGB() {
        if (this.isGB && this.testGB) {
            return;
        }
        List<GenPolynomial<C>> G = this.getList();
        logger.info((Object)("GB computing = " + G));
        G = this.bb.GB(G);
        if (this.isTopt) {
            List<Integer> perm = ((OptimizedPolynomialList)this.list).perm;
            this.list = new OptimizedPolynomialList<C>(perm, this.getRing(), G);
        } else {
            this.list = new PolynomialList<C>(this.getRing(), G);
        }
        this.isGB = true;
        this.testGB = true;
    }

    public Ideal<C> GB() {
        if (this.isGB) {
            return this;
        }
        this.doGB();
        return this;
    }

    public boolean contains(Ideal<C> B) {
        if (B == null || B.isZERO()) {
            return true;
        }
        return this.contains(B.getList());
    }

    public boolean contains(GenPolynomial<C> b) {
        GenPolynomial<C> z;
        if (b == null || b.isZERO()) {
            return true;
        }
        if (this.isONE()) {
            return true;
        }
        if (this.isZERO()) {
            return false;
        }
        if (!this.isGB) {
            this.doGB();
        }
        return (z = this.red.normalform(this.getList(), b)) == null || z.isZERO();
    }

    public boolean contains(List<GenPolynomial<C>> B) {
        if (B == null || B.size() == 0) {
            return true;
        }
        if (this.isONE()) {
            return true;
        }
        if (!this.isGB) {
            this.doGB();
        }
        for (GenPolynomial<C> b : B) {
            GenPolynomial<C> z;
            if (b == null || (z = this.red.normalform(this.getList(), b)).isZERO()) continue;
            return false;
        }
        return true;
    }

    public Ideal<C> sum(Ideal<C> B) {
        if (B == null || B.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return B;
        }
        int s = this.getList().size() + B.getList().size();
        ArrayList<GenPolynomial<C>> c = new ArrayList<GenPolynomial<C>>(s);
        c.addAll(this.getList());
        c.addAll(B.getList());
        Ideal<C> I2 = new Ideal<C>(this.getRing(), c, false);
        if (this.isGB && B.isGB) {
            I2.doGB();
        }
        return I2;
    }

    public Ideal<C> sum(GenPolynomial<C> b) {
        if (b == null || b.isZERO()) {
            return this;
        }
        int s = this.getList().size() + 1;
        ArrayList<GenPolynomial<C>> c = new ArrayList<GenPolynomial<C>>(s);
        c.addAll(this.getList());
        c.add(b);
        Ideal<C> I2 = new Ideal<C>(this.getRing(), c, false);
        if (this.isGB) {
            I2.doGB();
        }
        return I2;
    }

    public Ideal<C> sum(List<GenPolynomial<C>> L) {
        if (L == null || L.isEmpty()) {
            return this;
        }
        int s = this.getList().size() + L.size();
        ArrayList<GenPolynomial<C>> c = new ArrayList<GenPolynomial<C>>(s);
        c.addAll(this.getList());
        c.addAll(L);
        Ideal<C> I2 = new Ideal<C>(this.getRing(), c, false);
        if (this.isGB) {
            I2.doGB();
        }
        return I2;
    }

    public Ideal<C> product(Ideal<C> B) {
        if (B == null || B.isZERO()) {
            return B;
        }
        if (this.isZERO()) {
            return this;
        }
        int s = this.getList().size() * B.getList().size();
        ArrayList<GenPolynomial<C>> c = new ArrayList<GenPolynomial<C>>(s);
        for (GenPolynomial<GenPolynomial<C>> genPolynomial : this.getList()) {
            for (GenPolynomial<Object> q : B.getList()) {
                q = genPolynomial.multiply(q);
                c.add(q);
            }
        }
        Ideal<C> I2 = new Ideal<C>(this.getRing(), c, false);
        if (this.isGB && B.isGB) {
            I2.doGB();
        }
        return I2;
    }

    public Ideal<C> product(GenPolynomial<C> b) {
        if (b == null || b.isZERO()) {
            return this.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        ArrayList<GenPolynomial<C>> c = new ArrayList<GenPolynomial<C>>(this.getList().size());
        for (GenPolynomial<GenPolynomial<C>> genPolynomial : this.getList()) {
            GenPolynomial<GenPolynomial<C>> q = genPolynomial.multiply(b);
            c.add(q);
        }
        Ideal<C> I2 = new Ideal<C>(this.getRing(), c, false);
        if (this.isGB) {
            I2.doGB();
        }
        return I2;
    }

    public Ideal<C> intersect(List<Ideal<C>> Bl) {
        if (Bl == null || Bl.size() == 0) {
            return this.getZERO();
        }
        Ideal<C> I2 = null;
        for (Ideal<C> B : Bl) {
            if (I2 == null) {
                I2 = B;
                continue;
            }
            if (I2.isONE()) {
                return I2;
            }
            I2 = I2.intersect(B);
        }
        return I2;
    }

    public Ideal<C> intersect(Ideal<C> B) {
        if (B == null || B.isZERO()) {
            return B;
        }
        if (this.isZERO()) {
            return this;
        }
        List<GenPolynomial<C>> c = PolyGBUtil.intersect(this.getRing(), this.getList(), B.getList());
        Ideal<C> I2 = new Ideal<C>(this.getRing(), c, true);
        return I2;
    }

    public Ideal<C> intersect(GenPolynomialRing<C> R) {
        if (R == null) {
            throw new IllegalArgumentException("R may not be null");
        }
        List<GenPolynomial<C>> H = PolyUtil.intersect(R, this.getList());
        return new Ideal<C>(R, H, this.isGB, this.isTopt);
    }

    public Ideal<C> eliminate(GenPolynomialRing<C> R) {
        if (R == null) {
            throw new IllegalArgumentException("R may not be null");
        }
        if (this.list.ring.equals(R)) {
            return this;
        }
        String[] ename = R.getVars();
        Ideal<C> I2 = this.eliminate(ename);
        return I2.intersect(R);
    }

    public Ideal<C> eliminate(String ... ename) {
        if (ename == null) {
            throw new IllegalArgumentException("ename may not be null");
        }
        Object[] aname = this.getRing().getVars();
        if (aname == null) {
            throw new IllegalArgumentException("aname may not be null");
        }
        GroebnerBasePartial<C> bbp = new GroebnerBasePartial<C>(this.bb, null);
        String[] rname = GroebnerBasePartial.remainingVars((String[])aname, ename);
        OptimizedPolynomialList<C> Pl = null;
        if (rname.length == 0) {
            if (Arrays.equals(aname, ename)) {
                return this;
            }
            Pl = bbp.partialGB(this.getList(), ename);
        } else {
            Pl = bbp.elimPartialGB(this.getList(), rname, ename);
        }
        if (this.debug) {
            logger.debug((Object)("elimination GB = " + Pl));
        }
        Ideal<C> I2 = new Ideal<C>(Pl, true);
        return I2;
    }

    public Ideal<C> quotient(GenPolynomial<C> h) {
        if (h == null) {
            return this;
        }
        if (h.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        ArrayList<GenPolynomial<C>> H = new ArrayList<GenPolynomial<C>>(1);
        H.add(h);
        Ideal<C> Hi = new Ideal<C>(this.getRing(), H, true);
        Ideal<C> I2 = this.intersect(Hi);
        ArrayList<GenPolynomial<C>> Q = new ArrayList<GenPolynomial<C>>(I2.getList().size());
        for (GenPolynomial<C> q : I2.getList()) {
            q = q.divide(h);
            Q.add(q);
        }
        return new Ideal<C>(this.getRing(), Q, true);
    }

    public Ideal<C> quotient(Ideal<C> H) {
        if (H == null) {
            return this;
        }
        if (H.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        Ideal<C> Q = null;
        for (GenPolynomial<C> h : H.getList()) {
            Ideal<C> Hi = this.quotient(h);
            if (Q == null) {
                Q = Hi;
                continue;
            }
            Q = Q.intersect(Hi);
        }
        return Q;
    }

    public Ideal<C> infiniteQuotientRab(GenPolynomial<C> h) {
        if (h == null || h.isZERO()) {
            return this.getONE();
        }
        if (h.isONE()) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        Ideal<C> I2 = this.GB();
        List<GenPolynomial<C>> a = I2.getList();
        ArrayList c = new ArrayList(a.size() + 1);
        GenPolynomialRing<C> tfac = this.getRing().extend(1);
        for (GenPolynomial<C> p : a) {
            p = p.extend(tfac, 0, 0L);
            c.add(p);
        }
        GenPolynomial<MonoidElem> q = h.extend(tfac, 0, 1L);
        MonoidElem r = tfac.getONE();
        GenPolynomial<MonoidElem> hs = q.subtract(r);
        c.add(hs);
        logger.warn((Object)"infiniteQuotientRab computing GB ");
        List<GenPolynomial<C>> g = this.bb.GB(c);
        if (this.debug) {
            logger.info((Object)("infiniteQuotientRab    = " + tfac + ", c = " + c));
            logger.info((Object)("infiniteQuotientRab GB = " + g));
        }
        Ideal<C> E2 = new Ideal<C>(tfac, g, true);
        Ideal<C> Is = E2.intersect(this.getRing());
        return Is;
    }

    public int infiniteQuotientExponent(GenPolynomial<C> h, Ideal<C> Q) {
        int s = 0;
        if (h == null) {
            return s;
        }
        if (h.isZERO() || h.isONE()) {
            return s;
        }
        if (this.isZERO() || this.isONE()) {
            return s;
        }
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> p = this.getRing().getONE();
        for (GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>> genPolynomial : Q.getList()) {
            if (this.contains(genPolynomial)) continue;
            GenPolynomial<MonoidElem> qp = genPolynomial.multiply(p);
            while (!this.contains(qp)) {
                p = p.multiply((GenPolynomial<GenPolynomial<C>>)h);
                ++s;
                qp = genPolynomial.multiply(p);
            }
        }
        return s;
    }

    public Ideal<C> infiniteQuotient(GenPolynomial<C> h) {
        if (h == null) {
            return this;
        }
        if (h.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        int s = 0;
        Ideal<C> I2 = this.GB();
        GenPolynomial<C> hs = h;
        Ideal<C> Is = I2;
        boolean eq = false;
        while (!eq) {
            Is = I2.quotient(hs);
            Is = Is.GB();
            logger.info((Object)("infiniteQuotient s = " + s));
            eq = Is.contains(I2);
            if (eq) continue;
            I2 = Is;
            ++s;
        }
        return Is;
    }

    public boolean isRadicalMember(GenPolynomial<C> h) {
        if (h == null) {
            return true;
        }
        if (h.isZERO()) {
            return true;
        }
        if (this.isZERO()) {
            return true;
        }
        Ideal<C> x = this.infiniteQuotientRab(h);
        if (this.debug) {
            logger.debug((Object)("infiniteQuotientRab = " + x));
        }
        return x.isONE();
    }

    public Ideal<C> infiniteQuotientOld(GenPolynomial<C> h) {
        if (h == null) {
            return this;
        }
        if (h.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        int s = 0;
        Ideal<C> I2 = this.GB();
        GenPolynomial<GenPolynomial<C>> hs = h;
        boolean eq = false;
        while (!eq) {
            Ideal<C> Is = I2.quotient(hs);
            Is = Is.GB();
            logger.debug((Object)("infiniteQuotient s = " + s));
            eq = Is.contains(I2);
            if (eq) continue;
            I2 = Is;
            ++s;
            hs = hs.multiply((GenPolynomial<C>)h);
        }
        return I2;
    }

    public Ideal<C> infiniteQuotient(Ideal<C> H) {
        if (H == null) {
            return this;
        }
        if (H.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        Ideal<C> Q = null;
        for (GenPolynomial<C> h : H.getList()) {
            Ideal<C> Hi = this.infiniteQuotient(h);
            if (Q == null) {
                Q = Hi;
                continue;
            }
            Q = Q.intersect(Hi);
        }
        return Q;
    }

    public Ideal<C> infiniteQuotientRab(Ideal<C> H) {
        if (H == null) {
            return this;
        }
        if (H.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        Ideal<C> Q = null;
        for (GenPolynomial<C> h : H.getList()) {
            Ideal<C> Hi = this.infiniteQuotientRab(h);
            if (Q == null) {
                Q = Hi;
                continue;
            }
            Q = Q.intersect(Hi);
        }
        return Q;
    }

    public Ideal<C> power(int d) {
        if (d <= 0) {
            return this.getONE();
        }
        if (this.isZERO() || this.isONE()) {
            return this;
        }
        Ideal<C> c = this;
        for (int i = 1; i < d; ++i) {
            c = c.product(this);
        }
        return c;
    }

    public GenPolynomial<C> normalform(GenPolynomial<C> h) {
        if (h == null) {
            return h;
        }
        if (h.isZERO()) {
            return h;
        }
        if (this.isZERO()) {
            return h;
        }
        GenPolynomial<C> r = this.red.normalform(this.list.list, h);
        return r;
    }

    public List<GenPolynomial<C>> normalform(List<GenPolynomial<C>> L) {
        if (L == null) {
            return L;
        }
        if (L.size() == 0) {
            return L;
        }
        if (this.isZERO()) {
            return L;
        }
        ArrayList<GenPolynomial<C>> M = new ArrayList<GenPolynomial<C>>(L.size());
        for (GenPolynomial<C> h : L) {
            GenPolynomial<C> r = this.normalform(h);
            if (r == null || r.isZERO()) continue;
            M.add(r);
        }
        return M;
    }

    public Ideal<C> annihilator(GenPolynomial<C> h) {
        if (h == null || h.isZERO()) {
            return this.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        this.doGB();
        ArrayList F2 = new ArrayList(1 + this.getList().size());
        F2.add(h);
        F2.addAll(this.getList());
        SyzygyAbstract syz = new SyzygyAbstract();
        List S = syz.zeroRelationsArbitrary(F2);
        ArrayList<GenPolynomial<C>> gen = new ArrayList<GenPolynomial<C>>(S.size());
        for (List rel : S) {
            GenPolynomial p;
            if (rel == null || rel.isEmpty() || (p = rel.get(0)) == null || p.isZERO()) continue;
            gen.add(p);
        }
        Ideal<C> ann = new Ideal<C>(this.getRing(), gen);
        return ann;
    }

    public boolean isAnnihilator(GenPolynomial<C> h, Ideal<C> A) {
        Ideal<C> B = A.product(h);
        return this.contains(B);
    }

    public Ideal<C> annihilator(Ideal<C> H) {
        if (H == null || H.isZERO()) {
            return this.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        Ideal<C> ann = null;
        for (GenPolynomial<C> h : H.getList()) {
            Ideal<C> Hi = this.annihilator(h);
            if (ann == null) {
                ann = Hi;
                continue;
            }
            ann = ann.intersect(Hi);
        }
        return ann;
    }

    public boolean isAnnihilator(Ideal<C> H, Ideal<C> A) {
        Ideal<C> B = A.product(H);
        return this.contains(B);
    }

    public GenPolynomial<C> inverse(GenPolynomial<C> h) {
        if (h == null || h.isZERO()) {
            throw new NotInvertibleException("zero not invertible");
        }
        if (this.isZERO()) {
            throw new NotInvertibleException("zero ideal");
        }
        if (h.isUnit()) {
            return h.inverse();
        }
        this.doGB();
        ArrayList F2 = new ArrayList(1 + this.list.list.size());
        F2.add(h);
        F2.addAll(this.list.list);
        ExtendedGB<C> x = this.bb.extGB(F2);
        List G = x.G;
        GenPolynomial one = null;
        int i = -1;
        for (GenPolynomial p : G) {
            ++i;
            if (p == null || !p.isUnit()) continue;
            one = p;
            break;
        }
        if (one == null) {
            throw new NotInvertibleException(" h = " + h);
        }
        List row = x.G2F.get(i);
        GenPolynomial<RingElem<GenPolynomial<C>>> g = row.get(0);
        if (g == null || g.isZERO()) {
            throw new NotInvertibleException(" h = " + h);
        }
        GenPolynomial<GenPolynomial<C>> f = g.multiply(h);
        GenPolynomial<GenPolynomial<C>> k = this.red.normalform(this.list.list, f);
        if (!k.isONE()) {
            GcdRingElem lbc = (GcdRingElem)((Object)k.leadingBaseCoefficient());
            lbc = (GcdRingElem)lbc.inverse();
            g = g.multiply(lbc);
        }
        if (this.debug) {
            f = g.multiply(h);
            k = this.red.normalform(this.list.list, f);
            logger.debug((Object)("inv k = " + k));
            if (!k.isUnit()) {
                throw new NotInvertibleException(" k = " + k);
            }
        }
        return g;
    }

    public boolean isUnit(GenPolynomial<C> h) {
        if (h == null || h.isZERO()) {
            return false;
        }
        if (this.isZERO()) {
            return false;
        }
        ArrayList F2 = new ArrayList(1 + this.list.list.size());
        F2.add(h);
        F2.addAll(this.list.list);
        List<GenPolynomial<C>> G = this.bb.GB(F2);
        for (GenPolynomial<C> p : G) {
            if (p == null || !p.isUnit()) continue;
            return true;
        }
        return false;
    }

    public Ideal<C> squarefree() {
        if (this.isZERO()) {
            return this;
        }
        Ideal<C> R = this;
        Ideal<C> Rp = null;
        while (true) {
            List<GenPolynomial<C>> li = R.getList();
            ArrayList<GenPolynomial<C>> ri = new ArrayList<GenPolynomial<C>>(li);
            for (GenPolynomial<C> h : li) {
                GenPolynomial<C> r = this.engine.squarefreePart(h);
                ri.add(r);
            }
            Rp = new Ideal<C>(R.getRing(), ri, false);
            Rp.doGB();
            if (R.equals(Rp)) break;
            R = Rp;
        }
        return R;
    }

    public int commonZeroTest() {
        if (this.isZERO()) {
            return 1;
        }
        if (!this.isGB) {
            this.doGB();
        }
        if (this.isONE()) {
            return -1;
        }
        return this.bb.commonZeroTest(this.getList());
    }

    public boolean isMaximal() {
        if (this.commonZeroTest() != 0) {
            return false;
        }
        for (Long d : this.univariateDegrees()) {
            if (d <= 1L) continue;
            return false;
        }
        return true;
    }

    public List<Long> univariateDegrees() {
        ArrayList<Long> ud = new ArrayList<Long>();
        if (this.isZERO()) {
            return ud;
        }
        if (!this.isGB) {
            this.doGB();
        }
        if (this.isONE()) {
            return ud;
        }
        return this.bb.univariateDegrees(this.getList());
    }

    public Dimension dimension() {
        int t = this.commonZeroTest();
        Set<Integer> S = new HashSet<Integer>();
        Set<Set<Integer>> M = new HashSet<Set<Integer>>();
        if (t <= 0) {
            return new Dimension(t, S, M, this.list.ring.getVars());
        }
        int d = 0;
        HashSet<Integer> U = new HashSet<Integer>();
        for (int i = 0; i < this.list.ring.nvar; ++i) {
            U.add(i);
        }
        M = this.dimension(S, U, M);
        for (Set<Integer> m : M) {
            int dp = m.size();
            if (dp <= d) continue;
            d = dp;
            S = m;
        }
        return new Dimension(d, S, M, this.list.ring.getVars());
    }

    protected Set<Set<Integer>> dimension(Set<Integer> S, Set<Integer> U, Set<Set<Integer>> M) {
        Set<Set<Integer>> MP = M;
        HashSet<Integer> UP = new HashSet<Integer>(U);
        for (Integer j : U) {
            UP.remove(j);
            HashSet<Integer> SP = new HashSet<Integer>(S);
            SP.add(j);
            if (this.containsHT(SP, this.getList())) continue;
            MP = this.dimension(SP, UP, MP);
        }
        boolean contained = false;
        for (Set<Integer> m : MP) {
            if (!m.containsAll(S)) continue;
            contained = true;
            break;
        }
        if (!contained) {
            MP.add(S);
        }
        return MP;
    }

    protected boolean containsHT(Set<Integer> H, List<GenPolynomial<C>> G) {
        HashSet<Integer> S = null;
        for (GenPolynomial<C> p : G) {
            int[] v;
            ExpVector e;
            if (p == null || (e = p.leadingExpVector()) == null || (v = e.dependencyOnVariables()) == null) continue;
            if (S == null) {
                S = new HashSet<Integer>(H.size());
                int r = e.length() - 1;
                for (Integer i : H) {
                    S.add(r - i);
                }
            }
            if (!this.contains(v, S)) continue;
            return true;
        }
        return false;
    }

    protected boolean contains(int[] v, Set<Integer> H) {
        for (int i = 0; i < v.length; ++i) {
            if (H.contains(v[i])) continue;
            return false;
        }
        return true;
    }

    public List<GenPolynomial<C>> constructUnivariate() {
        ArrayList<GenPolynomial<C>> univs = new ArrayList<GenPolynomial<C>>();
        for (int i = this.list.ring.nvar - 1; i >= 0; --i) {
            GenPolynomial<C> u = this.constructUnivariate(i);
            univs.add(u);
        }
        return univs;
    }

    public GenPolynomial<C> constructUnivariate(int i) {
        this.doGB();
        return this.bb.constructUnivariate(i, this.getList());
    }

    public List<IdealWithUniv<C>> zeroDimRadicalDecomposition() {
        ArrayList<IdealWithUniv<C>> dec = new ArrayList<IdealWithUniv<C>>();
        if (this.isZERO()) {
            return dec;
        }
        IdealWithUniv iwu = new IdealWithUniv(this, new ArrayList());
        dec.add(iwu);
        if (this.isONE()) {
            return dec;
        }
        if (this.list.ring.coFac.characteristic().signum() > 0 && !this.list.ring.coFac.isFinite()) {
            logger.warn((Object)("must use prime decomposition for char p and infinite coefficient rings, found " + this.list.ring.coFac.toScript()));
            return this.zeroDimPrimeDecomposition();
        }
        for (int i = this.list.ring.nvar - 1; i >= 0; --i) {
            ArrayList part = new ArrayList();
            for (IdealWithUniv idealWithUniv : dec) {
                GenPolynomial u = idealWithUniv.ideal.constructUnivariate(i);
                SortedMap<GenPolynomial<C>, Long> facs = this.engine.baseSquarefreeFactors(u);
                if (facs == null || facs.size() == 0 || facs.size() == 1 && (Long)facs.get(facs.firstKey()) == 1L) {
                    ArrayList iup = new ArrayList();
                    iup.addAll(idealWithUniv.upolys);
                    iup.add(u);
                    IdealWithUniv Ipu = new IdealWithUniv(idealWithUniv.ideal, iup);
                    part.add(Ipu);
                    continue;
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("squarefree facs = " + facs));
                }
                GenPolynomialRing mfac = idealWithUniv.ideal.list.ring;
                int j = mfac.nvar - 1 - i;
                for (GenPolynomial p : facs.keySet()) {
                    GenPolynomial<C> pm = p.extendUnivariate(mfac, j);
                    Ideal Ip = idealWithUniv.ideal.sum(pm);
                    ArrayList iup = new ArrayList();
                    iup.addAll(idealWithUniv.upolys);
                    iup.add(p);
                    IdealWithUniv Ipu = new IdealWithUniv(Ip, iup);
                    if (this.debug) {
                        logger.info((Object)("ideal with squarefree facs = " + Ipu));
                    }
                    part.add(Ipu);
                }
            }
            dec = part;
        }
        return dec;
    }

    public boolean isZeroDimRadical() {
        if (this.isZERO()) {
            return false;
        }
        if (this.isONE()) {
            return false;
        }
        if (this.list.ring.coFac.characteristic().signum() > 0 && !this.list.ring.coFac.isFinite()) {
            logger.warn((Object)("radical only for char 0 or finite coefficient rings, but found " + this.list.ring.coFac.toScript()));
        }
        for (int i = this.list.ring.nvar - 1; i >= 0; --i) {
            GenPolynomial<C> u = this.constructUnivariate(i);
            boolean t = this.engine.isSquarefree(u);
            if (t) continue;
            System.out.println("not squarefree " + this.engine.squarefreePart(u) + ", " + u);
            return false;
        }
        return true;
    }

    public List<IdealWithUniv<C>> zeroDimDecomposition() {
        ArrayList<IdealWithUniv<C>> dec = new ArrayList<IdealWithUniv<C>>();
        if (this.isZERO()) {
            return dec;
        }
        IdealWithUniv iwu = new IdealWithUniv(this, new ArrayList());
        dec.add(iwu);
        if (this.isONE()) {
            return dec;
        }
        FactorAbstract ufd = FactorFactory.getImplementation(this.list.ring.coFac);
        for (int i = this.list.ring.nvar - 1; i >= 0; --i) {
            ArrayList part = new ArrayList();
            for (IdealWithUniv idealWithUniv : dec) {
                GenPolynomial u = idealWithUniv.ideal.constructUnivariate(i);
                SortedMap facs = ufd.baseFactors(u);
                if (facs.size() == 0 || facs.size() == 1 && (Long)facs.get(facs.firstKey()) == 1L) {
                    ArrayList iup = new ArrayList();
                    iup.addAll(idealWithUniv.upolys);
                    iup.add(u);
                    IdealWithUniv Ipu = new IdealWithUniv(idealWithUniv.ideal, iup);
                    part.add(Ipu);
                    continue;
                }
                if (this.debug) {
                    logger.info((Object)("irreducible facs = " + facs));
                }
                GenPolynomialRing mfac = idealWithUniv.ideal.list.ring;
                int j = mfac.nvar - 1 - i;
                for (GenPolynomial p : facs.keySet()) {
                    GenPolynomial pm = p.extendUnivariate(mfac, j);
                    Ideal Ip = idealWithUniv.ideal.sum(pm);
                    ArrayList iup = new ArrayList();
                    iup.addAll(idealWithUniv.upolys);
                    iup.add(p);
                    IdealWithUniv Ipu = new IdealWithUniv(Ip, iup);
                    part.add(Ipu);
                }
            }
            dec = part;
        }
        return dec;
    }

    public List<IdealWithUniv<C>> zeroDimDecompositionExtension(List<GenPolynomial<C>> upol, List<GenPolynomial<C>> og) {
        int i;
        GenPolynomial<C> u;
        if (upol == null || upol.size() + 1 != this.list.ring.nvar) {
            throw new IllegalArgumentException("univariate polynomial list not correct " + upol);
        }
        ArrayList<IdealWithUniv<C>> dec = new ArrayList<IdealWithUniv<C>>();
        if (this.isZERO()) {
            return dec;
        }
        IdealWithUniv<C> iwu = new IdealWithUniv<C>(this, upol);
        if (this.isONE()) {
            dec.add(iwu);
            return dec;
        }
        FactorAbstract<C> ufd = FactorFactory.getImplementation(this.list.ring.coFac);
        SortedMap facs = ufd.baseFactors(u = this.constructUnivariate(i = this.list.ring.nvar - 1));
        if (facs.size() == 1 && (Long)facs.get(facs.firstKey()) == 1L) {
            ArrayList iup = new ArrayList();
            iup.add(u);
            iup.addAll(upol);
            IdealWithUniv Ipu = new IdealWithUniv(this, iup, og);
            dec.add(Ipu);
            return dec;
        }
        logger.info((Object)("irreducible facs = " + facs));
        GenPolynomialRing mfac = this.list.ring;
        int j = mfac.nvar - 1 - i;
        for (GenPolynomial p : facs.keySet()) {
            GenPolynomial pm = p.extendUnivariate(mfac, j);
            Ideal Ip = this.sum(pm);
            ArrayList iup = new ArrayList();
            iup.add(p);
            iup.addAll(upol);
            IdealWithUniv Ipu = new IdealWithUniv(Ip, iup, og);
            dec.add(Ipu);
        }
        return dec;
    }

    public boolean isZeroDimDecomposition(List<IdealWithUniv<C>> L) {
        if (L == null || L.size() == 0) {
            return this.isZERO();
        }
        GenPolynomialRing ofac = this.list.ring;
        int r = ofac.nvar;
        int rp = L.get((int)0).ideal.list.ring.nvar;
        int d = rp - r;
        Ideal Id = this;
        if (d > 0) {
            GenPolynomialRing nfac = ofac.extendLower(d);
            ArrayList<GenPolynomial<C>> elist = new ArrayList<GenPolynomial<C>>(this.list.list.size());
            for (GenPolynomial p : this.getList()) {
                GenPolynomial<C> q = p.extendLower(nfac, 0, 0L);
                elist.add(q);
            }
            Id = new Ideal(nfac, elist, this.isGB, this.isTopt);
        }
        for (IdealWithUniv<C> I2 : L) {
            boolean t = I2.ideal.contains(Id);
            if (t) continue;
            System.out.println("not contained " + this + " in " + I2.ideal);
            return false;
        }
        for (IdealWithUniv<C> I2 : L) {
            GenPolynomialRing mfac = I2.ideal.list.ring;
            int i = 0;
            for (GenPolynomial p : I2.upolys) {
                GenPolynomial pm = p.extendUnivariate(mfac, i++);
                boolean t = I2.ideal.contains(pm);
                if (t) continue;
                System.out.println("not contained " + pm + " in " + I2.ideal);
                return false;
            }
        }
        return true;
    }

    public IdealWithUniv<C> normalPositionFor(int i, int j, List<GenPolynomial<C>> og) {
        GenPolynomialRing ofac = this.list.ring;
        if (ofac.tord.getEvord() != 2) {
            throw new IllegalArgumentException("invalid term order for normalPosition " + ofac.tord);
        }
        if (ofac.characteristic().signum() == 0) {
            return this.normalPositionForChar0(i, j, og);
        }
        return this.normalPositionForCharP(i, j, og);
    }

    IdealWithUniv<C> normalPositionForChar0(int i, int j, List<GenPolynomial<C>> og) {
        GenPolynomial<GenPolynomial<GenPolynomial<Element>>> zp;
        Ideal<GenPolynomial<GenPolynomial<Element>>> Ip;
        GenPolynomialRing ofac = this.list.ring;
        GenPolynomialRing nfac = ofac.extendLower(1);
        ArrayList<GenPolynomial<C>> elist = new ArrayList<GenPolynomial<C>>(this.list.list.size() + 1);
        for (GenPolynomial p : this.getList()) {
            GenPolynomial<C> q = p.extendLower(nfac, 0, 0L);
            elist.add(q);
        }
        ArrayList ogen = new ArrayList();
        if (og != null && og.size() > 0) {
            for (GenPolynomial p : og) {
                GenPolynomial<C> q = p.extendLower(nfac, 0, 0L);
                ogen.add(q);
            }
        }
        Ideal<GenPolynomial<GenPolynomial<Element>>> I2 = new Ideal<GenPolynomial<GenPolynomial<Element>>>(nfac, elist, true);
        int ip = this.list.ring.nvar - 1 - i;
        int jp = this.list.ring.nvar - 1 - j;
        GenPolynomial<Element> xi = nfac.univariate(ip);
        GenPolynomial<GenPolynomial<Element>> xj = nfac.univariate(jp);
        GenPolynomial<GenPolynomial<GenPolynomial<Element>>> z = nfac.univariate(nfac.nvar - 1);
        int t = 0;
        do {
            zp = z.subtract(xj.subtract(xi.multiply(nfac.fromInteger(--t))));
            zp = zp.monic();
            Ip = I2.sum(zp);
            if (-t % 5 != 0) continue;
            logger.info((Object)("normal position, t = " + t));
        } while (!Ip.isNormalPositionFor(i + 1, j + 1));
        if (this.debug) {
            logger.info((Object)("normal position = " + Ip));
        }
        ogen.add(zp);
        IdealWithUniv<GenPolynomial<GenPolynomial<Element>>> Ips = new IdealWithUniv<GenPolynomial<GenPolynomial<Element>>>(Ip, null, ogen);
        return Ips;
    }

    IdealWithUniv<C> normalPositionForCharP(int i, int j, List<GenPolynomial<C>> og) {
        GenPolynomial<GenPolynomial<GenPolynomial<Element>>> zp;
        Ideal<GenPolynomial<GenPolynomial<Element>>> Ip;
        GenPolynomialRing ofac = this.list.ring;
        GenPolynomialRing nfac = ofac.extendLower(1);
        ArrayList<GenPolynomial<C>> elist = new ArrayList<GenPolynomial<C>>(this.list.list.size() + 1);
        for (GenPolynomial p : this.getList()) {
            GenPolynomial<C> q = p.extendLower(nfac, 0, 0L);
            elist.add(q);
        }
        ArrayList ogen = new ArrayList();
        if (og != null && og.size() > 0) {
            for (GenPolynomial p : og) {
                GenPolynomial<C> q = p.extendLower(nfac, 0, 0L);
                ogen.add(q);
            }
        }
        Ideal<GenPolynomial<GenPolynomial<Element>>> I2 = new Ideal<GenPolynomial<GenPolynomial<Element>>>(nfac, elist, true);
        int ip = this.list.ring.nvar - 1 - i;
        int jp = this.list.ring.nvar - 1 - j;
        GenPolynomial<Element> xi = nfac.univariate(ip);
        GenPolynomial<GenPolynomial<Element>> xj = nfac.univariate(jp);
        GenPolynomial<GenPolynomial<GenPolynomial<Element>>> z = nfac.univariate(nfac.nvar - 1);
        AlgebraicNumberRing afac = null;
        Iterator aiter = null;
        int t = 0;
        do {
            Element tn;
            --t;
            if (afac == null) {
                tn = nfac.fromInteger(t);
                if (((GenPolynomial)tn).isZERO()) {
                    RingFactory fac = nfac.coFac;
                    while (!(fac instanceof AlgebraicNumberRing)) {
                        RingFactory pfac;
                        if (fac instanceof GenPolynomialRing) {
                            pfac = (GenPolynomialRing)fac;
                            fac = pfac.coFac;
                            continue;
                        }
                        if (fac instanceof QuotientRing) {
                            pfac = (QuotientRing)fac;
                            fac = ((QuotientRing)pfac).ring.coFac;
                            continue;
                        }
                        throw new ArithmeticException("field elements exhausted, need algebraic extension of base ring");
                    }
                    afac = (AlgebraicNumberRing)fac;
                    logger.info((Object)("afac = " + afac.toScript()));
                    aiter = afac.iterator();
                    AlgebraicNumber an = aiter.next();
                    for (int kk = 0; kk < afac.characteristic().intValue(); ++kk) {
                        an = aiter.next();
                    }
                    tn = nfac.parse(an.toString());
                }
            } else {
                if (!aiter.hasNext()) {
                    throw new ArithmeticException("field elements exhausted, normal position not reachable: !aiter.hasNext(): " + t);
                }
                AlgebraicNumber an = (AlgebraicNumber)aiter.next();
                tn = nfac.parse(an.toString());
            }
            if (((GenPolynomial)tn).isZERO()) {
                throw new ArithmeticException("field elements exhausted, normal position not reachable: tn == 0: " + t);
            }
            zp = z.subtract(xj.subtract(xi.multiply(tn)));
            zp = zp.monic();
            Ip = I2.sum(zp);
            if (-t % 4 != 0) continue;
            logger.info((Object)("normal position, t = " + t));
            logger.info((Object)("normal position, GB = " + Ip));
            if (t >= -550) continue;
            throw new ArithmeticException("normal position not reached in " + t + " steps");
        } while (!Ip.isNormalPositionFor(i + 1, j + 1));
        if (this.debug) {
            logger.info((Object)("normal position = " + Ip));
        }
        ogen.add(zp);
        IdealWithUniv<GenPolynomial<GenPolynomial<Element>>> Ips = new IdealWithUniv<GenPolynomial<GenPolynomial<Element>>>(Ip, null, ogen);
        return Ips;
    }

    public boolean isNormalPositionFor(int i, int j) {
        int ip = this.list.ring.nvar - 1 - i;
        int jp = this.list.ring.nvar - 1 - j;
        boolean iOK = false;
        boolean jOK = false;
        for (GenPolynomial<C> p : this.getList()) {
            ExpVector e = p.leadingExpVector();
            int[] dov = e.dependencyOnVariables();
            if (dov.length == 0) {
                throw new IllegalArgumentException("ideal dimension is not zero");
            }
            if (dov[0] == ip) {
                if (e.totalDeg() != 1L) {
                    return false;
                }
                iOK = true;
            } else if (dov[0] == jp) {
                if (e.totalDeg() != 1L) {
                    return false;
                }
                jOK = true;
            }
            if (!iOK || !jOK) continue;
            return true;
        }
        return iOK && jOK;
    }

    public int[] normalPositionIndex2Vars() {
        int[] np = null;
        int i = -1;
        int j = -1;
        for (GenPolynomial<C> p : this.getList()) {
            ExpVector e = p.leadingExpVector();
            int[] dov = e.dependencyOnVariables();
            if (dov.length == 0) {
                throw new IllegalArgumentException("ideal dimension is not zero " + p);
            }
            if (dov.length >= 2) {
                i = dov[0];
                j = dov[1];
                break;
            }
            int n = dov[0];
            GenPolynomial<C> q = p.reductum();
            e = q.degreeVector();
            dov = e.dependencyOnVariables();
            int k = Arrays.binarySearch(dov, n);
            int len = 2;
            if (k >= 0) {
                len = 3;
            }
            if (dov.length < len) continue;
            switch (k) {
                case 0: {
                    i = dov[1];
                    j = dov[2];
                    break;
                }
                case 1: {
                    i = dov[0];
                    j = dov[2];
                    break;
                }
                case 2: {
                    i = dov[0];
                    j = dov[1];
                    break;
                }
                default: {
                    i = dov[0];
                    j = dov[1];
                    break;
                }
            }
            break;
        }
        if (i < 0 || j < 0) {
            return np;
        }
        i = this.list.ring.nvar - 1 - i;
        j = this.list.ring.nvar - 1 - j;
        np = new int[]{j, i};
        logger.info((Object)("normalPositionIndex2Vars, np = " + Arrays.toString(np)));
        return np;
    }

    public int[] normalPositionIndexUnivars() {
        ExpVector e;
        int[] np = null;
        int i = -1;
        int j = -1;
        for (GenPolynomial<C> p : this.getList()) {
            e = p.degreeVector();
            int[] dov = e.dependencyOnVariables();
            long t = e.totalDeg();
            if (dov.length == 0) {
                throw new IllegalArgumentException("ideal dimension is not zero");
            }
            if (dov.length == 1 && t >= 2L) {
                if (i == -1) {
                    i = dov[0];
                } else if (j == -1 && i > (j = dov[0])) {
                    int x = i;
                    i = j;
                    j = x;
                }
            }
            if (i < 0 || j < 0) continue;
            break;
        }
        if (i < 0 || j < 0) {
            for (GenPolynomial<C> p : this.getList()) {
                e = p.leadingExpVector();
                long t = e.totalDeg();
                if (t >= 2L) {
                    e = p.degreeVector();
                    int[] dov = e.dependencyOnVariables();
                    if (dov.length == 0) {
                        throw new IllegalArgumentException("ideal dimension is not zero");
                    }
                    if (dov.length >= 2) {
                        i = dov[0];
                        j = dov[1];
                    }
                }
                if (i < 0 || j < 0) continue;
                break;
            }
        }
        if (i < 0 || j < 0) {
            return np;
        }
        i = this.list.ring.nvar - 1 - i;
        j = this.list.ring.nvar - 1 - j;
        np = new int[]{j, i};
        logger.info((Object)("normalPositionIndexUnivars, np = " + Arrays.toString(np)));
        return np;
    }

    public List<IdealWithUniv<C>> zeroDimRootDecomposition() {
        List<IdealWithUniv<C>> dec = this.zeroDimDecomposition();
        if (this.isZERO()) {
            return dec;
        }
        if (this.isONE()) {
            return dec;
        }
        ArrayList<IdealWithUniv<C>> rdec = new ArrayList<IdealWithUniv<C>>();
        while (dec.size() > 0) {
            IdealWithUniv<C> id = dec.remove(0);
            int[] ri = id.ideal.normalPositionIndex2Vars();
            if (ri == null || ri.length != 2) {
                rdec.add(id);
                continue;
            }
            IdealWithUniv I2 = id.ideal.normalPositionFor(ri[0], ri[1], id.others);
            List rd = I2.ideal.zeroDimDecompositionExtension(id.upolys, I2.others);
            dec.addAll(rd);
        }
        return rdec;
    }

    public List<IdealWithUniv<C>> zeroDimPrimeDecomposition() {
        List<IdealWithUniv<C>> pdec = this.zeroDimPrimeDecompositionFE();
        ArrayList<IdealWithUniv<C>> dec = new ArrayList<IdealWithUniv<C>>();
        if (pdec.size() == 1) {
            IdealWithUniv<C> Ip = pdec.get(0);
            int s = Ip.upolys.size() - this.getRing().nvar;
            List upol = Ip.upolys.subList(s, Ip.upolys.size());
            Ip = new IdealWithUniv(this, upol);
            dec.add(Ip);
            return dec;
        }
        for (IdealWithUniv<C> Ip : pdec) {
            if (Ip.ideal.getRing().nvar == this.getRing().nvar) {
                dec.add(Ip);
                continue;
            }
            Ideal<C> Id = Ip.ideal;
            if (Ip.others != null) {
                ArrayList<GenPolynomial<C>> pp = new ArrayList<GenPolynomial<C>>();
                pp.addAll(Id.getList());
                pp.addAll(Ip.others);
                Id = new Ideal(Id.getRing(), pp);
            }
            Ideal Is = Id.eliminate(this.getRing());
            int s = Ip.upolys.size() - this.getRing().nvar;
            List upol = Ip.upolys.subList(s, Ip.upolys.size());
            IdealWithUniv Iu = new IdealWithUniv(Is, upol);
            dec.add(Iu);
        }
        return dec;
    }

    public List<IdealWithUniv<C>> zeroDimPrimeDecompositionFE() {
        List<IdealWithUniv<C>> dec = this.zeroDimRootDecomposition();
        if (this.isZERO()) {
            return dec;
        }
        if (this.isONE()) {
            return dec;
        }
        ArrayList<IdealWithUniv<C>> rdec = new ArrayList<IdealWithUniv<C>>();
        while (dec.size() > 0) {
            IdealWithUniv<C> id = dec.remove(0);
            int[] ri = id.ideal.normalPositionIndexUnivars();
            if (ri == null || ri.length != 2) {
                rdec.add(id);
                continue;
            }
            IdealWithUniv I2 = id.ideal.normalPositionFor(ri[0], ri[1], id.others);
            List rd = I2.ideal.zeroDimDecompositionExtension(id.upolys, I2.others);
            dec.addAll(rd);
        }
        return rdec;
    }

    public Ideal<C> primaryIdeal(Ideal<C> P) {
        Ideal<C> As;
        boolean t;
        Ideal<C> Q;
        Ideal<C> Qs = P;
        int e = 0;
        do {
            Q = Qs;
            ++e;
        } while ((Qs = Q.product(P)).contains(this));
        do {
            if (t = (As = this.sum(Qs)).contains(Q)) continue;
            Q = Qs;
            ++e;
            Qs = Q.product(P);
        } while (!t);
        logger.info((Object)("exponent = " + e));
        return As;
    }

    public List<PrimaryComponent<C>> zeroDimPrimaryDecomposition() {
        List<IdealWithUniv<C>> pdec = this.zeroDimPrimeDecomposition();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("prim decomp = " + pdec));
        }
        return this.zeroDimPrimaryDecomposition(pdec);
    }

    public List<IdealWithUniv<C>> zeroDimElimination(List<IdealWithUniv<C>> pdec) {
        ArrayList<IdealWithUniv<C>> dec = new ArrayList<IdealWithUniv<C>>();
        if (this.isZERO()) {
            return dec;
        }
        if (this.isONE()) {
            dec.add(pdec.get(0));
            return dec;
        }
        ArrayList<IdealWithUniv<C>> qdec = new ArrayList<IdealWithUniv<C>>();
        for (IdealWithUniv<C> Ip : pdec) {
            GenPolynomial pm;
            List<GenPolynomial<C>> epol = new ArrayList<GenPolynomial<C>>();
            epol.addAll(Ip.ideal.getList());
            GenPolynomialRing mfac = Ip.ideal.list.ring;
            int j = 0;
            for (GenPolynomial p : Ip.upolys) {
                GenPolynomial pm2 = p.extendUnivariate(mfac, j++);
                if (j == 1) continue;
                epol.add(pm2);
            }
            if (Ip.others != null) {
                epol.addAll(Ip.others);
            }
            Ideal Ipp = new Ideal(mfac, epol);
            TermOrder to = null;
            if (mfac.tord.getEvord() != 4) {
                ArrayList<GenPolynomial<C>> epols = new ArrayList<GenPolynomial<C>>();
                to = new TermOrder(4);
                GenPolynomialRing<C> smfac = new GenPolynomialRing<C>(mfac.coFac, mfac.nvar, to, mfac.getVars());
                for (GenPolynomial<C> p : epol) {
                    pm = smfac.copy(p);
                    epols.add(pm.monic());
                }
                Ipp = new Ideal(smfac, epols);
            }
            epol = this.red.irreducibleSet(Ipp.getList());
            Ipp = new Ideal(Ipp.getRing(), epol);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("eliminate = " + Ipp));
            }
            Ideal Is = Ipp.eliminate(this.list.ring);
            if (to != null && !Is.list.ring.equals(this.list.ring)) {
                ArrayList<GenPolynomial<C>> epols = new ArrayList<GenPolynomial<C>>();
                for (GenPolynomial<C> p : Is.getList()) {
                    pm = this.list.ring.copy(p);
                    epols.add(pm);
                }
                Is = new Ideal(this.list.ring, epols);
            }
            int k = Ip.upolys.size() - this.list.ring.nvar;
            ArrayList up = new ArrayList();
            for (int i = 0; i < this.list.ring.nvar; ++i) {
                up.add(Ip.upolys.get(i + k));
            }
            IdealWithUniv Ie = new IdealWithUniv(Is, up);
            qdec.add(Ie);
        }
        return qdec;
    }

    public List<PrimaryComponent<C>> zeroDimPrimaryDecomposition(List<IdealWithUniv<C>> pdec) {
        ArrayList<PrimaryComponent<C>> dec = new ArrayList<PrimaryComponent<C>>();
        if (this.isZERO()) {
            return dec;
        }
        if (this.isONE()) {
            PrimaryComponent pc = new PrimaryComponent(pdec.get((int)0).ideal, pdec.get(0));
            dec.add(pc);
            return dec;
        }
        for (IdealWithUniv<C> Ip : pdec) {
            Ideal Qs = this.primaryIdeal(Ip.ideal);
            PrimaryComponent pc = new PrimaryComponent(Qs, Ip);
            dec.add(pc);
        }
        return dec;
    }

    public boolean isPrimaryDecomposition(List<PrimaryComponent<C>> L) {
        for (PrimaryComponent<C> I2 : L) {
            boolean t = I2.primary.contains(this);
            if (t) continue;
            System.out.println("not contained " + this + " in " + I2);
            return false;
        }
        Ideal isec = null;
        for (PrimaryComponent<C> I3 : L) {
            if (isec == null) {
                isec = I3.primary;
                continue;
            }
            isec = isec.intersect(I3.primary);
        }
        return this.contains(isec);
    }

    public IdealWithUniv<Quotient<C>> extension(String ... vars) {
        GenPolynomialRing<C> fac = this.getRing();
        GenPolynomialRing efac = new GenPolynomialRing(fac.coFac, vars.length, fac.tord, vars);
        IdealWithUniv ext = this.extension(efac);
        return ext;
    }

    public IdealWithUniv<Quotient<C>> extension(GenPolynomialRing<C> efac) {
        QuotientRing<C> qfac = new QuotientRing<C>(efac);
        IdealWithUniv<Quotient<C>> ext = this.extension(qfac);
        return ext;
    }

    public IdealWithUniv<Quotient<C>> extension(QuotientRing<C> qfac) {
        GenPolynomialRing<C> fac = this.getRing();
        GenPolynomialRing efac = qfac.ring;
        Object[] rvars = GroebnerBasePartial.remainingVars(fac.getVars(), efac.getVars());
        GroebnerBasePartial<C> bbp = new GroebnerBasePartial<C>();
        OptimizedPolynomialList pgb = bbp.elimPartialGB(this.getList(), (String[])rvars, efac.getVars());
        if (logger.isInfoEnabled()) {
            logger.info((Object)("rvars = " + Arrays.toString(rvars)));
            logger.info((Object)("partialGB = " + pgb));
        }
        GenPolynomialRing rfac = new GenPolynomialRing(efac, rvars.length, fac.tord, (String[])rvars);
        List plist = pgb.list;
        List rpgb = PolyUtil.recursive(rfac, plist);
        GenPolynomialRing qpfac = new GenPolynomialRing(qfac, rfac);
        List qpgb = PolyUfdUtil.quotientFromIntegralCoefficients(qpfac, rpgb);
        GreatestCommonDivisorAbstract ufd = GCDFactory.getImplementation(fac.coFac);
        GenPolynomial f = null;
        for (GenPolynomial p : rpgb) {
            if (f == null) {
                f = p.leadingBaseCoefficient();
                continue;
            }
            f = ufd.lcm(f, p.leadingBaseCoefficient());
        }
        GenPolynomial<Object> fp = ((GenPolynomial)rfac.getONE()).multiply(f);
        GenPolynomial fq = PolyUfdUtil.quotientFromIntegralCoefficients(qpfac, fp);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("extension f = " + f));
            logger.info((Object)("ext = " + qpgb));
        }
        ArrayList upols = new ArrayList(0);
        ArrayList opols = new ArrayList(1);
        opols.add(fq);
        qpgb = PolyUtil.monic(qpgb);
        Ideal ext = new Ideal(qpfac, qpgb);
        IdealWithUniv extu = new IdealWithUniv(ext, upols, opols);
        return extu;
    }

    public IdealWithUniv<C> permContraction(IdealWithUniv<Quotient<C>> eideal) {
        return Ideal.permutation(this.getRing(), Ideal.contraction(eideal));
    }

    public static <C extends GcdRingElem<C>> IdealWithUniv<C> contraction(IdealWithUniv<Quotient<C>> eid) {
        Ideal eideal = eid.ideal;
        List qgb = eideal.getList();
        QuotientRing qfac = (QuotientRing)eideal.getRing().coFac;
        GenPolynomialRing rfac = new GenPolynomialRing(qfac.ring, eideal.getRing());
        GenPolynomialRing dfac = qfac.ring.extend(eideal.getRing().getVars());
        TermOrder to = new TermOrder(qfac.ring.tord.getEvord());
        dfac = new GenPolynomialRing(dfac.coFac, dfac.nvar, to, dfac.getVars());
        List cgb = PolyUfdUtil.integralFromQuotientCoefficients(rfac, qgb);
        List dgb = PolyUtil.distribute(dfac, cgb);
        Ideal cont = new Ideal(dfac, dgb);
        ArrayList opols = new ArrayList();
        if (eid.others != null && eid.others.size() > 0) {
            List orpol = PolyUfdUtil.integralFromQuotientCoefficients(rfac, eid.others);
            List opol = PolyUtil.distribute(dfac, orpol);
            opols.addAll(opol);
        }
        ArrayList upols = new ArrayList(0);
        int i = 0;
        for (GenPolynomial p : eid.upolys) {
            GenPolynomial pm = p.extendUnivariate(eideal.getRing(), i++);
            GenPolynomial urpol = PolyUfdUtil.integralFromQuotientCoefficients(rfac, pm);
            GenPolynomial upol = PolyUtil.distribute(dfac, urpol);
            upols.add(upol);
        }
        GreatestCommonDivisorAbstract ufd = GCDFactory.getImplementation(qfac.ring.coFac);
        GenPolynomial f = null;
        for (GenPolynomial p : cgb) {
            if (f == null) {
                f = p.leadingBaseCoefficient();
                continue;
            }
            f = ufd.lcm(f, p.leadingBaseCoefficient());
        }
        GenPolynomial<Object> fp = ((GenPolynomial)rfac.getONE()).multiply(f);
        f = PolyUtil.distribute(dfac, fp);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("contraction f = " + f));
            logger.info((Object)("cont = " + cont));
        }
        opols.add(f);
        if (f.isONE()) {
            IdealWithUniv cf = new IdealWithUniv(cont, upols, opols);
            return cf;
        }
        Ideal Q = cont.infiniteQuotientRab(f);
        IdealWithUniv Qu = new IdealWithUniv(Q, upols, opols);
        return Qu;
    }

    public static <C extends GcdRingElem<C>> IdealWithUniv<C> permutation(GenPolynomialRing<C> oring, IdealWithUniv<C> Cont) {
        Object[] dvars;
        Ideal cont = Cont.ideal;
        GenPolynomialRing dfac = cont.getRing();
        Object[] ovars = oring.getVars();
        if (Arrays.equals(ovars, dvars = dfac.getVars())) {
            return Cont;
        }
        List<Integer> perm = GroebnerBasePartial.getPermutation((String[])dvars, (String[])ovars);
        GenPolynomialRing pfac = TermOrderOptimization.permutation(perm, cont.getRing());
        if (logger.isInfoEnabled()) {
            logger.info((Object)("pfac = " + pfac));
        }
        List ppolys = TermOrderOptimization.permutation(perm, pfac, cont.getList());
        cont = new Ideal(pfac, ppolys);
        if (logger.isDebugEnabled()) {
            logger.info((Object)("perm cont = " + cont));
        }
        List opolys = TermOrderOptimization.permutation(perm, pfac, Cont.others);
        List upolys = TermOrderOptimization.permutation(perm, pfac, Cont.upolys);
        IdealWithUniv Cu = new IdealWithUniv(cont, upolys, opolys);
        return Cu;
    }

    public Ideal<C> radical() {
        List<IdealWithUniv<C>> rdec = this.radicalDecomposition();
        ArrayList<Ideal<C>> dec = new ArrayList<Ideal<C>>(rdec.size());
        for (IdealWithUniv<C> ru : rdec) {
            dec.add(ru.ideal);
        }
        Ideal<C> R = this.intersect(dec);
        return R;
    }

    public List<IdealWithUniv<C>> radicalDecomposition() {
        int z = this.commonZeroTest();
        ArrayList<IdealWithUniv<C>> dec = new ArrayList();
        ArrayList ups = new ArrayList();
        if (z < 0) {
            IdealWithUniv id = new IdealWithUniv(this, ups);
            dec.add(id);
            return dec;
        }
        if (z == 0) {
            dec = this.zeroDimRadicalDecomposition();
            return dec;
        }
        if (this.isZERO()) {
            return dec;
        }
        if (this.list.ring.coFac.characteristic().signum() > 0 && !this.list.ring.coFac.isFinite()) {
            logger.warn((Object)("must use prime decomposition for char p and infinite coefficient rings, found " + this.list.ring.coFac.toScript()));
            return this.primeDecomposition();
        }
        Dimension dim = this.dimension();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("dimension = " + dim));
        }
        Set<Set<Integer>> M = dim.M;
        Set<Integer> min = null;
        for (Set<Integer> m : M) {
            if (min == null) {
                min = m;
                continue;
            }
            if (m.size() >= min.size()) continue;
            min = m;
        }
        int ms = min.size();
        Integer[] ia = new Integer[]{};
        int mx = min.toArray(ia)[ms - 1];
        for (Set<Integer> m : M) {
            int mxx;
            if (m.size() != ms || (mxx = m.toArray(ia)[ms - 1].intValue()) >= mx) continue;
            min = m;
            mx = mxx;
        }
        Object[] mvars = new String[min.size()];
        int j = 0;
        for (Integer i : min) {
            mvars[j++] = dim.v[i];
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("extension for variables = " + Arrays.toString(mvars) + ", indexes = " + min));
        }
        IdealWithUniv<Quotient<C>> Ext = this.extension((String[])mvars);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("extension = " + Ext));
        }
        List edec = Ext.ideal.zeroDimRadicalDecomposition();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("0-dim radical decomp = " + edec));
        }
        for (IdealWithUniv<Quotient<C>> idealWithUniv : edec) {
            IdealWithUniv<C> cont = this.permContraction(idealWithUniv);
            dec.add(cont);
        }
        IdealWithUniv<C> extcont = this.permContraction(Ext);
        List list = extcont.others;
        if (list.size() == 0) {
            return dec;
        }
        GenPolynomial fx = list.get(0);
        if (fx.isONE()) {
            return dec;
        }
        Ideal T = this.sum(fx);
        if (T.isONE()) {
            logger.info((Object)("1 in ideal for " + fx));
            return dec;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("radical decomp ext-cont fx = " + fx));
            logger.info((Object)("recursion radical decomp T = " + T));
        }
        List Tdec = T.radicalDecomposition();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("recursion radical decomp = " + Tdec));
        }
        dec.addAll(Tdec);
        return dec;
    }

    public List<IdealWithUniv<C>> decomposition() {
        int z = this.commonZeroTest();
        List<IdealWithUniv<C>> dec = new ArrayList<IdealWithUniv<C>>();
        if (z < 0) {
            return dec;
        }
        if (z == 0) {
            dec = this.zeroDimDecomposition();
            return dec;
        }
        if (this.isZERO()) {
            return dec;
        }
        Dimension dim = this.dimension();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("dimension = " + dim));
        }
        Set<Set<Integer>> M = dim.M;
        Set<Integer> min = null;
        for (Set<Integer> m : M) {
            if (min == null) {
                min = m;
                continue;
            }
            if (m.size() >= min.size()) continue;
            min = m;
        }
        Object[] mvars = new String[min.size()];
        int j = 0;
        for (Integer i : min) {
            mvars[j++] = dim.v[i];
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("extension for variables = " + Arrays.toString(mvars)));
        }
        IdealWithUniv<Quotient<C>> Ext = this.extension((String[])mvars);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("extension = " + Ext));
        }
        List edec = Ext.ideal.zeroDimDecomposition();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("0-dim irred decomp = " + edec));
        }
        for (IdealWithUniv<Quotient<C>> idealWithUniv : edec) {
            IdealWithUniv<C> cont = this.permContraction(idealWithUniv);
            dec.add(cont);
        }
        IdealWithUniv<C> extcont = this.permContraction(Ext);
        List list = extcont.others;
        if (list.size() == 0) {
            return dec;
        }
        GenPolynomial fx = list.get(0);
        if (fx.isONE()) {
            return dec;
        }
        Ideal T = this.sum(fx);
        if (T.isONE()) {
            logger.info((Object)("1 in ideal for " + fx));
            return dec;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("irred decomp ext-cont fx = " + fx));
            logger.info((Object)("recursion irred decomp T = " + T));
        }
        List Tdec = T.decomposition();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("recursion irred decomposition = " + Tdec));
        }
        dec.addAll(Tdec);
        return dec;
    }

    public List<IdealWithUniv<C>> primeDecomposition() {
        int z = this.commonZeroTest();
        List<IdealWithUniv<C>> dec = new ArrayList<IdealWithUniv<C>>();
        if (z < 0) {
            return dec;
        }
        if (z == 0) {
            dec = this.zeroDimPrimeDecomposition();
            return dec;
        }
        if (this.isZERO()) {
            return dec;
        }
        Dimension dim = this.dimension();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("dimension = " + dim));
        }
        Set<Set<Integer>> M = dim.M;
        Set<Integer> min = null;
        for (Set<Integer> m : M) {
            if (min == null) {
                min = m;
                continue;
            }
            if (m.size() >= min.size()) continue;
            min = m;
        }
        Object[] mvars = new String[min.size()];
        int j = 0;
        for (Integer i : min) {
            mvars[j++] = dim.v[i];
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("extension for variables = " + Arrays.toString(mvars)));
        }
        IdealWithUniv<Quotient<C>> Ext = this.extension((String[])mvars);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("extension = " + Ext));
        }
        List edec = Ext.ideal.zeroDimPrimeDecomposition();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("0-dim prime decomp = " + edec));
        }
        for (IdealWithUniv<Quotient<C>> idealWithUniv : edec) {
            IdealWithUniv<C> cont = this.permContraction(idealWithUniv);
            dec.add(cont);
        }
        IdealWithUniv<C> extcont = this.permContraction(Ext);
        List list = extcont.others;
        if (list.size() == 0) {
            return dec;
        }
        GenPolynomial fx = list.get(0);
        if (fx.isONE()) {
            return dec;
        }
        Ideal T = this.sum(fx);
        if (T.isONE()) {
            logger.info((Object)("1 in ideal for " + fx));
            return dec;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("prime decomp ext-cont fx = " + fx));
            logger.info((Object)("recursion prime decomp T = " + T));
        }
        List Tdec = T.primeDecomposition();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("recursion prime decomp = " + Tdec));
        }
        dec.addAll(Tdec);
        return dec;
    }

    public boolean isDecomposition(List<IdealWithUniv<C>> L) {
        if (L == null || L.size() == 0) {
            return this.isZERO();
        }
        GenPolynomialRing ofac = this.list.ring;
        int r = ofac.nvar;
        int rp = L.get((int)0).ideal.list.ring.nvar;
        int d = rp - r;
        Ideal Id = this;
        if (d > 0) {
            GenPolynomialRing nfac = ofac.extendLower(d);
            ArrayList<GenPolynomial<C>> elist = new ArrayList<GenPolynomial<C>>(this.list.list.size());
            for (GenPolynomial p : this.getList()) {
                GenPolynomial<C> q = p.extendLower(nfac, 0, 0L);
                elist.add(q);
            }
            Id = new Ideal(nfac, elist, this.isGB, this.isTopt);
        }
        for (IdealWithUniv<C> I2 : L) {
            boolean t = I2.ideal.contains(Id);
            if (t) continue;
            System.out.println("not contained " + this + " in " + I2.ideal);
            return false;
        }
        return true;
    }

    public List<PrimaryComponent<C>> primaryDecomposition() {
        Ideal T;
        List ql;
        int z = this.commonZeroTest();
        List<PrimaryComponent<C>> dec = new ArrayList<PrimaryComponent<C>>();
        if (z < 0) {
            return dec;
        }
        if (z == 0) {
            dec = this.zeroDimPrimaryDecomposition();
            return dec;
        }
        if (this.isZERO()) {
            return dec;
        }
        Dimension dim = this.dimension();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("dimension = " + dim));
        }
        Set<Set<Integer>> M = dim.M;
        Set<Integer> min = null;
        for (Set<Integer> m : M) {
            if (min == null) {
                min = m;
                continue;
            }
            if (m.size() >= min.size()) continue;
            min = m;
        }
        Object[] mvars = new String[min.size()];
        int j = 0;
        for (Integer i : min) {
            mvars[j++] = dim.v[i];
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("extension for variables = " + Arrays.toString(mvars)));
        }
        IdealWithUniv<Quotient<C>> Ext = this.extension((String[])mvars);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("extension = " + Ext));
        }
        List edec = Ext.ideal.zeroDimPrimaryDecomposition();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("0-dim primary decomp = " + edec));
        }
        ArrayList upq = new ArrayList();
        for (PrimaryComponent ep : edec) {
            IdealWithUniv<Quotient<C>> epu = new IdealWithUniv<Quotient<C>>(ep.primary, upq);
            IdealWithUniv<C> contq = this.permContraction(epu);
            IdealWithUniv<C> contp = this.permContraction(ep.prime);
            PrimaryComponent pc = new PrimaryComponent(contq.ideal, contp);
            dec.add(pc);
        }
        IdealWithUniv<C> extcont = this.permContraction(Ext);
        if (this.debug) {
            logger.info((Object)("cont(Ext) = " + extcont));
        }
        if ((ql = extcont.others).size() == 0) {
            return dec;
        }
        GenPolynomial fx = ql.get(0);
        if (fx.isONE()) {
            return dec;
        }
        int s = this.infiniteQuotientExponent(fx, extcont.ideal);
        if (s == 0) {
            logger.info((Object)"exponent is 0 ");
            return dec;
        }
        if (s > 1) {
            fx = Power.positivePower(fx, s);
        }
        if (this.debug) {
            logger.info((Object)("exponent fx = " + s + ", fx^s = " + fx));
        }
        if ((T = this.sum(fx)).isONE()) {
            logger.info((Object)("1 in ideal for " + fx));
            return dec;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("primmary decomp ext-cont fx = " + fx));
            logger.info((Object)("recursion primary decomp T = " + T));
        }
        List Tdec = T.primaryDecomposition();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("recursion primary decomp = " + Tdec));
        }
        dec.addAll(Tdec);
        return dec;
    }
}

