/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.FactorFactory;
import edu.jas.application.Ideal;
import edu.jas.application.IdealWithUniv;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.FactorAbsolute;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FactorAlgebraicPrim<C extends GcdRingElem<C>>
extends FactorAbsolute<AlgebraicNumber<C>> {
    private static final Logger logger = Logger.getLogger(FactorAlgebraicPrim.class);
    public final FactorAbstract<C> factorCoeff;

    protected FactorAlgebraicPrim() {
        throw new IllegalArgumentException("don't use this constructor");
    }

    public FactorAlgebraicPrim(AlgebraicNumberRing<C> fac) {
        this(fac, FactorFactory.getImplementation(fac.ring.coFac));
    }

    public FactorAlgebraicPrim(AlgebraicNumberRing<C> fac, FactorAbstract<C> factorCoeff) {
        super(fac);
        this.factorCoeff = factorCoeff;
    }

    @Override
    public List<GenPolynomial<AlgebraicNumber<C>>> baseFactorsSquarefree(GenPolynomial<AlgebraicNumber<C>> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        ArrayList<GenPolynomial<AlgebraicNumber<C>>> factors = new ArrayList<GenPolynomial<AlgebraicNumber<C>>>();
        if (P.isZERO()) {
            return factors;
        }
        if (P.isONE()) {
            factors.add(P);
            return factors;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        AlgebraicNumberRing afac = (AlgebraicNumberRing)pfac.coFac;
        AlgebraicNumber<C> ldcf = P.leadingBaseCoefficient();
        if (!ldcf.isONE()) {
            P = P.monic();
            factors.add(((GenPolynomial)pfac.getONE()).multiply(ldcf));
        }
        if (logger.isDebugEnabled()) {
            SquarefreeAbstract<AlgebraicNumber<C>> sqengine = SquarefreeFactory.getImplementation(afac);
            if (!sqengine.isSquarefree(P)) {
                throw new RuntimeException("P not squarefree: " + sqengine.squarefreeFactors(P));
            }
            GenPolynomial modu = afac.modul;
            if (!this.factorCoeff.isIrreducible(modu)) {
                throw new RuntimeException("modul not irreducible: " + this.factorCoeff.factors(modu));
            }
            System.out.println("P squarefree and modul irreducible via ideal decomposition");
        }
        GenPolynomial agen = afac.modul;
        GenPolynomialRing cfac = afac.ring;
        GenPolynomialRing rfac = new GenPolynomialRing(cfac, pfac);
        TermOrder to = new TermOrder(2);
        String[] vars = new String[]{cfac.getVars()[0], rfac.getVars()[0]};
        GenPolynomialRing dfac = new GenPolynomialRing(cfac.coFac, to, vars);
        GenPolynomial Ad = agen.extend(dfac, 0, 0L);
        GenPolynomial Pc = PolyUtil.fromAlgebraicCoefficients(rfac, P);
        GenPolynomial Pd = PolyUtil.distribute(dfac, Pc);
        ArrayList id = new ArrayList(2);
        id.add(Ad);
        id.add(Pd);
        Ideal I2 = new Ideal(dfac, id);
        List Iul = I2.zeroDimPrimeDecomposition();
        if (Iul.size() == 1) {
            factors.add(P);
            return factors;
        }
        GenPolynomial f = pfac.getONE();
        for (IdealWithUniv Iu : Iul) {
            List pl = Iu.ideal.getList();
            GenPolynomial ag = PolyUtil.selectWithVariable(pl, 1);
            GenPolynomial pg = PolyUtil.selectWithVariable(pl, 0);
            if (ag.equals(Ad)) {
                GenPolynomial pgr = PolyUtil.recursive(rfac, pg);
                GenPolynomial pga = PolyUtil.convertRecursiveToAlgebraicCoefficients(pfac, pgr);
                f = f.multiply(pga);
                factors.add(pga);
                continue;
            }
            logger.warn((Object)("algebraic number mismatch: ag = " + ag + ", expected Ad = " + Ad));
        }
        if (!(f = f.subtract(P)).isZERO()) {
            throw new RuntimeException("no factorization: " + f + ", factors = " + factors);
        }
        return factors;
    }
}

