/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.CPair;
import edu.jas.application.CReductionSeq;
import edu.jas.application.ColorPolynomial;
import edu.jas.application.ColoredSystem;
import edu.jas.application.Condition;
import edu.jas.application.GroebnerSystem;
import edu.jas.application.Ideal;
import edu.jas.application.OrderedCPairlist;
import edu.jas.application.PolyUtilApp;
import edu.jas.application.ResidueRing;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gbufd.GBFactory;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class ComprehensiveGroebnerBaseSeq<C extends GcdRingElem<C>> {
    private static final Logger logger = Logger.getLogger(ComprehensiveGroebnerBaseSeq.class);
    private static final boolean debug = logger.isDebugEnabled();
    protected final SquarefreeAbstract<C> engine;
    protected final CReductionSeq<C> cred;
    protected final RingFactory<C> cofac;

    public ComprehensiveGroebnerBaseSeq(RingFactory<C> rf) {
        this(new CReductionSeq<C>(rf), rf);
    }

    public ComprehensiveGroebnerBaseSeq(CReductionSeq<C> red, RingFactory<C> rf) {
        this.cred = red;
        this.cofac = rf;
        this.engine = SquarefreeFactory.getImplementation(rf);
    }

    public boolean isGB(List<GenPolynomial<GenPolynomial<C>>> F2) {
        return this.isGB(0, F2);
    }

    public boolean isGB(int modv, List<GenPolynomial<GenPolynomial<C>>> F2) {
        return this.isGBsubst(modv, F2);
    }

    public boolean isGBcol(List<GenPolynomial<GenPolynomial<C>>> F2) {
        return this.isGBcol(0, F2);
    }

    public boolean isGBcol(int modv, List<GenPolynomial<GenPolynomial<C>>> F2) {
        if (F2 == null || F2.size() == 0) {
            return true;
        }
        List<ColoredSystem<C>> CS = this.cred.determine(F2);
        return this.isGBsys(modv, CS);
    }

    public boolean isGBsys(List<ColoredSystem<C>> CS) {
        return this.isGBsys(0, CS);
    }

    public boolean isGBsys(int modv, List<ColoredSystem<C>> CS) {
        if (CS == null || CS.size() == 0) {
            return true;
        }
        for (ColoredSystem<C> cs : CS) {
            if (debug) {
                if (!cs.isDetermined()) {
                    System.out.println("not determined, cs = " + cs);
                    return false;
                }
                if (!cs.checkInvariant()) {
                    System.out.println("not invariant, cs = " + cs);
                    return false;
                }
            }
            Condition<C> cond = cs.condition;
            List S = cs.list;
            int k = S.size();
            for (int j = 0; j < k; ++j) {
                ColorPolynomial p = S.get(j);
                for (int l = j + 1; l < k; ++l) {
                    ColorPolynomial hp;
                    ColorPolynomial q = S.get(l);
                    ColorPolynomial<C> h = this.cred.SPolynomial(p, q);
                    h = this.cred.normalform(cond, S, h);
                    if (debug && !this.cred.isNormalform(S, h)) {
                        System.out.println("not normalform, h = " + h);
                        System.out.println("cs = " + cs);
                        return false;
                    }
                    if (h.isZERO() || (hp = cond.reDetermine(h)).isZERO()) continue;
                    System.out.println("p = " + p);
                    System.out.println("q = " + q);
                    System.out.println("not zero:   NF(spol(p,q))  = " + h);
                    System.out.println("redetermine(NF(spol(p,q))) = " + hp);
                    System.out.println("cs = " + cs);
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isGBsubst(List<GenPolynomial<GenPolynomial<C>>> F2) {
        return this.isGBsubst(0, F2);
    }

    public boolean isGBsubst(int modv, List<GenPolynomial<GenPolynomial<C>>> F2) {
        if (F2 == null || F2.size() == 0) {
            return true;
        }
        GenPolynomial<GenPolynomial<C>> f = F2.get(0);
        GenPolynomialRing cf = f.ring;
        List<ColoredSystem<C>> CS = this.cred.determine(F2);
        if (logger.isDebugEnabled()) {
            logger.info((Object)("determined polynomials =\n" + CS));
        }
        for (ColoredSystem<C> cs : CS) {
            Ideal id = cs.condition.zero;
            ResidueRing r = new ResidueRing(id);
            GenPolynomialRing rf = new GenPolynomialRing(r, cf);
            List list = PolyUtilApp.toResidue(rf, F2);
            GroebnerBaseAbstract bb = GBFactory.getImplementation(r);
            boolean t = bb.isGB(list);
            if (t) continue;
            System.out.println("test condition = " + cs.condition);
            System.out.println("no GB for residue coefficients = " + list);
            return false;
        }
        GenPolynomialRing ccf = (GenPolynomialRing)cf.coFac;
        int nv = ccf.nvar - 2;
        if (nv < 1) {
            nv = 1;
        }
        ArrayList il = new ArrayList();
        int i = 0;
        int j = 1;
        while (i < nv) {
            Element p;
            if (((GenPolynomial)(p = ccf.random(++j + 1))).isConstant() || ((GenPolynomial)p).isZERO()) continue;
            p = this.engine.squarefreePart(p);
            il.add(p);
            ++i;
        }
        logger.info((Object)("random ideal = " + il));
        Ideal id = new Ideal(ccf, il);
        ResidueRing r = new ResidueRing(id);
        GenPolynomialRing rf = new GenPolynomialRing(r, cf);
        List list = PolyUtilApp.toResidue(rf, F2);
        logger.info((Object)("random residue = " + r.ideal.getList()));
        GroebnerBaseAbstract bb = GBFactory.getImplementation(r);
        boolean t = bb.isGB(list);
        if (!t) {
            System.out.println("no GB for residue coefficients = " + list);
            return false;
        }
        return true;
    }

    public boolean isGBsys(GroebnerSystem<C> F2) {
        return this.isGBsys(0, F2.list);
    }

    public boolean isCGB(GroebnerSystem<C> F2) {
        return this.isGB(F2.getCGB());
    }

    public boolean isGB(GroebnerSystem<C> F2) {
        return this.isGBsys(0, F2.list) && this.isGB(F2.getCGB());
    }

    public GroebnerSystem<C> GBsys(List<GenPolynomial<GenPolynomial<C>>> F2) {
        ColoredSystem cs;
        if (F2 == null) {
            return null;
        }
        ArrayList CSp = new ArrayList();
        if (F2.size() == 0) {
            return new GroebnerSystem(CSp);
        }
        GenPolynomial<GenPolynomial<C>> f = F2.get(0);
        GenPolynomialRing fac = f.ring;
        List<ColoredSystem<C>> CS = this.cred.determine(F2);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("determined polynomials =\n" + CS));
        }
        List CSs = new ArrayList();
        for (ColoredSystem<C> cs2 : CS) {
            OrderedCPairlist pairlist = new OrderedCPairlist(fac);
            for (ColorPolynomial p : cs2.list) {
                pairlist.put(p);
            }
            ColoredSystem css = new ColoredSystem(cs2.condition, cs2.list, pairlist);
            CSs.add(css);
        }
        ArrayList CSb = new ArrayList();
        int si = 0;
        while (CSs.size() > 0) {
            cs = (ColoredSystem)CSs.get(0);
            logger.info((Object)("poped GBsys number    " + ++si + " with condition = " + cs.condition));
            logger.info((Object)("poped GBsys (remaining " + (CSs.size() - 1) + ") with pairlist  = " + cs.pairlist));
            if (!cs.isDetermined()) {
                cs = cs.reDetermine();
            }
            OrderedCPairlist pairlist = cs.pairlist;
            List G = cs.list;
            Condition cond = cs.condition;
            while (pairlist.hasNext()) {
                List ncs;
                ColorPolynomial<C> H;
                ColorPolynomial<C> S;
                CPair pair = pairlist.removeNext();
                if (pair == null) continue;
                ColorPolynomial pi = pair.pi;
                ColorPolynomial pj = pair.pj;
                if (debug) {
                    logger.info((Object)("pi    = " + pi));
                    logger.info((Object)("pj    = " + pj));
                }
                if ((S = this.cred.SPolynomial(pi, pj)).isZERO()) {
                    pair.setZero();
                    continue;
                }
                if (debug) {
                    logger.info((Object)("S = " + S));
                }
                if ((H = this.cred.normalform(cond, G, S)).isZERO()) {
                    pair.setZero();
                    continue;
                }
                if (debug) {
                    logger.info((Object)("ht(H) = " + H.leadingExpVector()));
                }
                H = H.abs();
                if (debug) {
                    logger.debug((Object)("H = " + H));
                }
                logger.info((Object)("H = " + H));
                if (H.isZERO() || (ncs = this.determineAddPairs(cs, H)).size() == 0) continue;
                cs = ncs.remove(0);
                pairlist = cs.pairlist;
                G = cs.list;
                cond = cs.condition;
                logger.info((Object)("replaced main branch = " + cond));
                logger.info((Object)("#new systems       = " + ncs.size()));
                int yi = CSs.size();
                for (ColoredSystem x : ncs) {
                    if (!x.isDetermined()) {
                        x = x.reDetermine();
                    }
                    CSs = x.addToList(CSs);
                }
                logger.info((Object)("#new systems added = " + (CSs.size() - yi)));
            }
            if (!cs.isDetermined()) {
                cs = cs.reDetermine();
            }
            CSb.add(cs);
            CSs.remove(0);
            logger.info((Object)("done with = " + cs.condition));
        }
        ArrayList CSh = new ArrayList();
        for (ColoredSystem x : CSb) {
            if (!x.isDetermined()) {
                x = x.reDetermine();
            }
            if (!(cs = this.minimalGB(x)).isDetermined()) {
                cs = cs.reDetermine();
            }
            CSh.add(cs);
            logger.info((Object)("#sequential done = " + x.condition));
            logger.info((Object)x.pairlist.toString());
        }
        CSb = new ArrayList(CSh);
        return new GroebnerSystem(CSb);
    }

    public List<ColoredSystem<C>> determineAddPairs(ColoredSystem<C> cs, ColorPolynomial<C> A) {
        List<ColoredSystem<C>> NCS = new ArrayList<ColoredSystem<C>>();
        if (A == null || A.isZERO()) {
            return NCS;
        }
        List S = cs.list;
        Condition cond = cs.condition;
        OrderedCPairlist pl = cs.pairlist;
        GenPolynomial<GenPolynomial<C>> Ap = A.getPolynomial();
        List<Condition<C>> cd = this.cred.caseDistinction(cond, Ap);
        logger.info((Object)("# cases = " + cd.size()));
        for (Condition<C> cnd : cd) {
            ColoredSystem<C> NS;
            block9: {
                OrderedCPairlist<C> PL;
                ArrayList Sp;
                ColorPolynomial<C> nz = cnd.reDetermine(A);
                if (nz.isZERO()) {
                    block8: {
                        logger.info((Object)("zero determined nz = " + nz));
                        Sp = new ArrayList(S);
                        PL = pl.copy();
                        NS = new ColoredSystem<C>(cnd, Sp, PL);
                        try {
                            if (NS.isDetermined()) break block8;
                            NS = NS.reDetermine();
                        }
                        catch (RuntimeException e) {
                            System.out.println("Contradiction in NS_0 = " + NS);
                            continue;
                        }
                    }
                    NCS = NS.addToList(NCS);
                    continue;
                }
                if (S.contains(nz)) {
                    System.out.println("*** S.contains(nz) ***");
                    continue;
                }
                logger.info((Object)("new determined nz = " + nz));
                Sp = new ArrayList(S);
                Sp.add(nz);
                PL = pl.copy();
                PL.put(nz);
                NS = new ColoredSystem<C>(cnd, Sp, PL);
                try {
                    if (NS.isDetermined()) break block9;
                    NS = NS.reDetermine();
                }
                catch (RuntimeException e) {
                    System.out.println("Contradiction in NS = " + NS);
                    continue;
                }
            }
            NCS = NS.addToList(NCS);
        }
        return NCS;
    }

    public List<GenPolynomial<GenPolynomial<C>>> GB(List<GenPolynomial<GenPolynomial<C>>> F2) {
        if (F2 == null) {
            return F2;
        }
        GroebnerSystem<C> gs = this.GBsys(F2);
        return gs.getCGB();
    }

    public ColoredSystem<C> minimalGB(ColoredSystem<C> cs) {
        ColorPolynomial<C> b;
        ColorPolynomial<C> a2;
        if (cs == null || cs.list == null || cs.list.size() <= 1) {
            return cs;
        }
        ArrayList G = new ArrayList(cs.list.size());
        for (ColorPolynomial<C> a2 : cs.list) {
            if (a2 == null || a2.isZERO()) continue;
            G.add(a2);
        }
        if (G.size() <= 1) {
            return new ColoredSystem(cs.condition, G, cs.pairlist);
        }
        Condition<C> cond = cs.condition;
        ArrayList F2 = new ArrayList(G.size());
        while (G.size() > 0) {
            b = a2 = (ColorPolynomial<C>)G.remove(0);
            if (this.cred.isTopReducible(G, a2) || this.cred.isTopReducible(F2, a2)) {
                if (!debug) continue;
                ArrayList ff = new ArrayList(G);
                ff.addAll(F2);
                a2 = this.cred.normalform(cond, ff, a2);
                try {
                    a2 = cond.reDetermine(a2);
                }
                catch (RuntimeException ignored) {
                    // empty catch block
                }
                if (a2.isZERO()) continue;
                logger.error((Object)("nf(a) != 0 " + b + ", " + a2));
                F2.add(b);
                continue;
            }
            F2.add(a2);
        }
        G = F2;
        if (G.size() <= 1) {
            return new ColoredSystem(cs.condition, G, cs.pairlist);
        }
        Collections.reverse(G);
        int len = G.size();
        for (int i = 0; i < len; ++i) {
            b = a2 = (ColorPolynomial)G.remove(0);
            ExpVector e = a2.red.leadingExpVector();
            a2 = this.cred.normalform(cond, G, a2);
            try {
                a2 = cond.reDetermine(a2);
            }
            catch (RuntimeException ignored) {
                // empty catch block
            }
            ExpVector f = a2.red.leadingExpVector();
            if (e.equals(f)) {
                G.add(a2);
                continue;
            }
            if (debug) {
                logger.error((Object)("nf(a) not determined " + b + ", " + a2));
            }
            G.add(b);
        }
        return new ColoredSystem(cs.condition, G, cs.pairlist);
    }
}

