/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.ColorPolynomial;
import edu.jas.application.Condition;
import edu.jas.application.OrderedCPairlist;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.GcdRingElem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class ColoredSystem<C extends GcdRingElem<C>> {
    private static final Logger logger = Logger.getLogger(ColoredSystem.class);
    private final boolean debug = logger.isDebugEnabled();
    public final Condition<C> condition;
    public final List<ColorPolynomial<C>> list;
    public final OrderedCPairlist<C> pairlist;

    public ColoredSystem(Condition<C> cond, List<ColorPolynomial<C>> S) {
        this(cond, S, null);
    }

    public ColoredSystem(Condition<C> cond, List<ColorPolynomial<C>> S, OrderedCPairlist<C> pl) {
        this.condition = cond;
        this.list = S;
        this.pairlist = pl;
    }

    public ColoredSystem<C> copy() {
        return new ColoredSystem<C>(this.condition, this.list, this.pairlist.copy());
    }

    public List<ColoredSystem<C>> addToList(List<ColoredSystem<C>> L) {
        ArrayList<ColoredSystem<C>> S = new ArrayList<ColoredSystem<C>>(L.size() + 1);
        boolean contained = false;
        for (ColoredSystem<C> x : L) {
            if (this.condition.equals(x.condition) && this.list.equals(x.list)) {
                logger.info((Object)("replaced system = " + x.condition));
                S.add(this);
                contained = true;
                continue;
            }
            S.add(x);
        }
        if (!contained) {
            S.add(this);
        }
        return S;
    }

    public String toString() {
        StringBuffer s = new StringBuffer("ColoredSystem: \n");
        if (this.list.size() > 0) {
            s.append("polynomial ring : " + this.list.get((int)0).green.ring + "\n");
        } else {
            s.append("parameter polynomial ring : " + this.condition.zero.getRing() + "\n");
        }
        s.append("conditions == 0 : " + this.getConditionZero() + "\n");
        s.append("conditions != 0 : " + this.getConditionNonZero() + "\n");
        if (this.debug) {
            s.append("green coefficients:\n" + this.getGreenCoefficients() + "\n");
            s.append("red coefficients:\n" + this.getRedCoefficients() + "\n");
        }
        s.append("colored polynomials:\n" + this.list + "\n");
        s.append("uncolored polynomials:\n" + this.getPolynomialList() + "\n");
        if (this.debug) {
            s.append("essential polynomials:\n" + this.getEssentialPolynomialList() + "\n");
        }
        if (this.pairlist != null) {
            s.append(this.pairlist.toString() + "\n");
        }
        return s.toString();
    }

    public boolean equals(Object c) {
        boolean t;
        ColoredSystem cs = null;
        try {
            cs = (ColoredSystem)c;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (cs == null) {
            return false;
        }
        boolean bl = t = this.condition.equals(cs.condition) && this.list.equals(cs.list);
        if (!t) {
            return t;
        }
        t = this.pairlist.equals(cs.pairlist);
        if (!t) {
            System.out.println("pairlists not equal " + this.pairlist + ", " + cs.pairlist);
        }
        return true;
    }

    public int hashCode() {
        int h = this.condition.hashCode();
        h <<= 17;
        return h += this.list.hashCode();
    }

    public List<GenPolynomial<C>> getConditionZero() {
        return this.condition.zero.getList();
    }

    public List<GenPolynomial<C>> getConditionNonZero() {
        return this.condition.nonZero.mset;
    }

    public List<GenPolynomial<C>> getRedCoefficients() {
        HashSet F2 = new HashSet();
        for (ColorPolynomial<C> s : this.list) {
            F2.addAll(s.red.getMap().values());
        }
        ArrayList<GenPolynomial<C>> M = new ArrayList<GenPolynomial<C>>(F2);
        return M;
    }

    public List<GenPolynomial<C>> getGreenCoefficients() {
        HashSet F2 = new HashSet();
        for (ColorPolynomial<C> s : this.list) {
            F2.addAll(s.green.getMap().values());
        }
        ArrayList<GenPolynomial<C>> M = new ArrayList<GenPolynomial<C>>(F2);
        return M;
    }

    public List<GenPolynomial<GenPolynomial<C>>> getPolynomialList() {
        ArrayList<GenPolynomial<GenPolynomial<C>>> F2 = new ArrayList<GenPolynomial<GenPolynomial<C>>>();
        for (ColorPolynomial<C> s : this.list) {
            F2.add(s.getPolynomial());
        }
        return F2;
    }

    public List<GenPolynomial<GenPolynomial<C>>> getEssentialPolynomialList() {
        ArrayList<GenPolynomial<GenPolynomial<C>>> F2 = new ArrayList<GenPolynomial<GenPolynomial<C>>>();
        for (ColorPolynomial<C> s : this.list) {
            F2.add(s.getEssentialPolynomial());
        }
        return F2;
    }

    public boolean checkInvariant() {
        if (!this.isDetermined()) {
            return false;
        }
        if (!this.condition.isDetermined(this.list)) {
            return false;
        }
        for (ColorPolynomial<C> s : this.list) {
            if (!s.checkInvariant()) {
                System.out.println("notInvariant " + s);
                System.out.println("condition:   " + this.condition);
                return false;
            }
            for (GenPolynomial g : s.green.getMap().values()) {
                if (this.condition.color(g) == Condition.Color.GREEN) continue;
                System.out.println("notGreen   " + g);
                System.out.println("condition: " + this.condition);
                System.out.println("colors:    " + s);
                return false;
            }
            for (GenPolynomial r : s.red.getMap().values()) {
                if (this.condition.color(r) == Condition.Color.RED) continue;
                System.out.println("notRed     " + r);
                System.out.println("condition: " + this.condition);
                System.out.println("colors:    " + s);
                return false;
            }
            for (GenPolynomial w : s.white.getMap().values()) {
                if (this.condition.color(w) == Condition.Color.WHITE) continue;
            }
        }
        return true;
    }

    public boolean isDetermined() {
        for (ColorPolynomial<C> s : this.list) {
            if (s.isZERO()) continue;
            if (!s.isDetermined()) {
                System.out.println("not simple determined " + s);
                System.out.println("condition:            " + this.condition);
                return false;
            }
            if (this.condition.isDetermined(s)) continue;
            return false;
        }
        return true;
    }

    public ColoredSystem<C> reDetermine() {
        if (this.condition == null || this.condition.zero.isONE()) {
            return this;
        }
        ArrayList<ColorPolynomial<C>> Sn = new ArrayList<ColorPolynomial<C>>(this.list.size());
        for (ColorPolynomial<C> c : this.list) {
            ColorPolynomial<C> a = this.condition.reDetermine(c);
            Sn.add(a);
        }
        return new ColoredSystem<C>(this.condition, Sn, this.pairlist);
    }
}

