/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.RealAlgebraicNumber;
import edu.jas.application.RealAlgebraicRing;
import edu.jas.arith.Rational;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.UnaryFunctor;

class CoeffToComplexReal<C extends GcdRingElem<C> & Rational>
implements UnaryFunctor<Complex<C>, Complex<RealAlgebraicNumber<C>>> {
    protected final ComplexRing<RealAlgebraicNumber<C>> cfac;
    final RealAlgebraicRing<C> afac;
    final GenPolynomialRing<C> pfac;

    public CoeffToComplexReal(ComplexRing<RealAlgebraicNumber<C>> fac) {
        if (fac == null) {
            throw new IllegalArgumentException("fac must not be null");
        }
        this.cfac = fac;
        this.afac = (RealAlgebraicRing)this.cfac.ring;
        this.pfac = this.afac.univs.ideal.getRing();
    }

    @Override
    public Complex<RealAlgebraicNumber<C>> eval(Complex<C> c) {
        if (c == null) {
            return this.cfac.getZERO();
        }
        GenPolynomial<C> pr = new GenPolynomial<C>(this.pfac, c.getRe());
        GenPolynomial<C> pi = new GenPolynomial<C>(this.pfac, c.getIm());
        RealAlgebraicNumber<C> re = new RealAlgebraicNumber<C>(this.afac, pr);
        RealAlgebraicNumber<C> im = new RealAlgebraicNumber<C>(this.afac, pi);
        return new Complex<RealAlgebraicNumber<C>>(this.cfac, re, im);
    }
}

