/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.math.frobenius;

import cc.redberry.core.math.frobenius.SolutionProvider;

abstract class SolutionProviderAbstract
implements SolutionProvider {
    private final SolutionProvider provider;
    final int position;
    final int[] coefficients;
    int[] currentSolution;
    int currentCounter = 0;
    int[] currentRemainder;

    SolutionProviderAbstract(SolutionProvider provider, int position, int[] coefficients) {
        this.provider = provider;
        this.position = position;
        this.coefficients = coefficients;
    }

    @Override
    public boolean tick() {
        this.currentSolution = (int[])this.provider.take();
        this.currentRemainder = this.provider.currentRemainders();
        this.currentCounter = 0;
        return this.currentSolution != null;
    }

    @Override
    public int[] currentRemainders() {
        int[] remainders = new int[this.coefficients.length];
        for (int i = 0; i < this.coefficients.length; ++i) {
            remainders[i] = this.currentRemainder[i] - this.coefficients[i] * (this.currentCounter - 1);
        }
        return remainders;
    }
}

