/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat.sync;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import net.apocalypselabs.symat.Debug;
import net.apocalypselabs.symat.Main;
import net.apocalypselabs.symat.PrefStorage;
import net.apocalypselabs.symat.sync.BackgroundSync;
import net.apocalypselabs.symat.sync.UserLogin;

public class Start
extends JPanel {
    private String email = "";
    private String password = "";
    private JInternalFrame parentComponent;
    private JButton haveSyncBtn;
    private JLabel jLabel2;
    private JButton newSyncBtn;

    public Start(JInternalFrame parent) {
        this.parentComponent = parent;
        this.initComponents();
        this.setVisible(true);
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.newSyncBtn = new JButton();
        this.haveSyncBtn = new JButton();
        this.setPreferredSize(new Dimension(400, 200));
        this.jLabel2.setFont(Main.ubuntuRegular.deriveFont(36.0f));
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("Sync");
        this.newSyncBtn.setText("Setup a new account");
        this.newSyncBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Start.this.newSyncBtnActionPerformed(evt);
            }
        });
        this.haveSyncBtn.setText("I already have Sync");
        this.haveSyncBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Start.this.haveSyncBtnActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -1, 400, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.haveSyncBtn, -2, 175, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.newSyncBtn, -2, 175, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 51, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.newSyncBtn, -2, 50, -2).addComponent(this.haveSyncBtn, -2, 50, -2)).addContainerGap(49, Short.MAX_VALUE)));
    }

    private void haveSyncBtnActionPerformed(ActionEvent evt) {
        this.getLogin(0);
    }

    private void newSyncBtnActionPerformed(ActionEvent evt) {
        this.getLogin(1);
    }

    private void getLogin(int mode) {
        UserLogin ul = new UserLogin(mode);
        JOptionPane.showMessageDialog(this, ul, "Sync " + (mode == 1 ? "Signup" : "Login"), -1);
        this.email = ul.getEmail();
        this.password = ul.getPassword();
        try {
            Debug.println("Signing in to Sync...");
            URL url = new URL("http://apis.symatapp.com/sync" + (mode == 1 ? "new" : "old") + ".php?" + "email=" + URLEncoder.encode(this.email, "UTF-8") + "&password=" + URLEncoder.encode(this.password, "UTF-8"));
            InputStream is = url.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String line = br.readLine();
            br.close();
            is.close();
            if (!line.contains("OK")) {
                JOptionPane.showMessageDialog(this, line, "Sync Error", 0);
            } else {
                PrefStorage.saveSetting("syncemail", this.email);
                PrefStorage.saveSetting("syncpassword", this.password);
                PrefStorage.save();
                new BackgroundSync().start();
                JOptionPane.showMessageDialog(this, "Account setup successful.  Your settings and plugins will now sync in the background.", "Sync", 1);
                this.parentComponent.dispose();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "An error occurred while syncing your account.", "Sync Error", 0);
        }
    }
}

