/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat.plugin;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import net.apocalypselabs.symat.CodeRunner;
import net.apocalypselabs.symat.Main;
import net.apocalypselabs.symat.plugin.Plugin;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.icon.ImageWrapperResizableIcon;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;

public class LoadPlugin {
    private Plugin p;

    public LoadPlugin(File f) throws FileNotFoundException, IOException, ClassNotFoundException, InvalidClassException {
        FileInputStream fin = new FileInputStream(f);
        ObjectInputStream ois = new ObjectInputStream(fin);
        this.p = (Plugin)ois.readObject();
        ois.close();
    }

    public LoadPlugin(String path) throws FileNotFoundException, IOException, ClassNotFoundException {
        this(new File(path));
    }

    private ResizableIcon getRibbonIcon() {
        try {
            ImageWrapperResizableIcon ico = ImageWrapperResizableIcon.getIcon((Image)this.p.getIcon().getImage(), (Dimension)new Dimension(100, 76));
            return ico;
        }
        catch (Exception ex) {
            return Main.getRibbonIcon("plugin");
        }
    }

    public JCommandButton getRibbonBtn() {
        JCommandButton b = new JCommandButton(this.p.getTitle().equals("") ? "Untitled" : this.p.getTitle(), this.getRibbonIcon());
        if (!this.p.getLongTitle().equals("")) {
            b.setActionRichTooltip(new RichTooltip(this.p.getLongTitle(), this.p.getDesc().equals("") ? "   " : this.p.getDesc()));
        }
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadPlugin.this.exec();
            }
        });
        b.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
        return b;
    }

    public JCommandToggleButton getGalleryBtn() {
        JCommandToggleButton b = new JCommandToggleButton(this.p.getTitle().equals("") ? "Untitled" : this.p.getTitle(), this.getRibbonIcon());
        if (!this.p.getLongTitle().equals("")) {
            b.setActionRichTooltip(new RichTooltip(this.p.getLongTitle(), this.p.getDesc().equals("") ? "   " : this.p.getDesc()));
        }
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadPlugin.this.exec();
            }
        });
        return b;
    }

    public void exec() {
        CodeRunner cr = new CodeRunner(this.p.getLang());
        cr.evalString(this.p.getScript());
    }

    public Plugin getPlugin() {
        return this.p;
    }
}

